from flask import Blueprint, render_template, Response
from werkzeug.utils import secure_filename
import sys

sys.path.append("..")
PROOT=""
from weblib import *
import struct
import datetime
import subprocess
import shutil

mbushub_blueprint = Blueprint('mbushub', __name__, url_prefix='/', template_folder='templates')

@mbushub_blueprint.route("/mbushub_portconf", methods=['GET',  'POST'])
def mbushub_portconf():
    slNum = int(request.args.get("SLNR"))

    protocols=0
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        mbl.close()
        protocols=licensearray[2].split(',')
    except:
        pass

    mbus2modbusLicense = protocols[3].strip()
    mbus2modbusLicense = True if mbus2modbusLicense == "MBus2Modbus" else False

    mbusHubVersion=""
    try:
        mbv=os.popen("/binary/mbushub.elf -V")
        mbusHubVersion=mbv.read()
        mbv.close()
    except:
        pass

    confHeader=""
    confPort=""
    if slNum == 0:
        confHeader = "Master Port Configuration"
        confPort="MasterPort"
    else:
        confHeader = "Slave port %d configuration"%slNum
        confPort="SlavePort%d"%slNum

    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2','MBMASTER':'M-Bus Master'}
    mPortDict={'UDP':{'ALL':[('MBUS','M-Bus')]},'TCP':{'ALL':[('MBUS','M-Bus')]},'SER':{'MBMASTER':[('MBUS','M-Bus')],'RS485':[('MBUS','M-Bus')],  'RS232':[('MBUS','M-Bus')]}}
    sPortDict={'UDP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'TCP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'MBSLAVE1':[('MBUS','M-Bus')],'MBSLAVE2':[('MBUS','M-Bus')]}}
    modDict={'0':"Big End, ABCD (0)",'1':"Little End DCBA (1)",'2':"Reg Swap CDAB (2)",'3':"Byte Swap BADC (3)"}
    cnf = Configs("config","mbushub")

    csvArray=glob.glob("/config/*.[cC][sS][vV]")
    csvArray.sort()
    for i in range(len(csvArray)):
        csvArray[i] = os.path.basename(csvArray[i])

    nslaves=4
    try:
        mbv=os.popen("/binary/mbushub.elf -a")
        licarray=mbv.read().split(',')
        mbv.close()
        nslaves = int(licarray[1])
    except:
        pass
    porttype    = cnf.getopt(confPort,'porttype')
    localip     = cnf.getopt(confPort,'localip')
    localport   = cnf.getopt(confPort,'localport')
    sercomport  = cnf.getopt(confPort,'sercomport')

    if slNum == 0:
        if porttype=='SER':
            plist=mPortDict[porttype][sercomport]
        else:
            plist=mPortDict[porttype][localip]
    else:
        if porttype=='SER':
            plist=sPortDict[porttype][sercomport]
        else:
            plist=sPortDict[porttype][localip]

    # M-Bus Loop Power
    loop1_on  = ""
    loop1_off = ""
    loop2_on  = ""
    loop2_off = ""
    loop3_on  = ""
    loop3_off = ""
    loop4_on  = ""
    loop4_off = ""
    rs485_failsafe_on=""
    rs485_failsafe_off=""

    try:
        if (getGPIO("pioA24") == 'On'):
            rs485_failsafe_on  = "checked"
        else:
            rs485_failsafe_off = "checked"
        if (getGPIO("pioA26") == 'On'):
            loop1_on  = "checked"
        else:
            loop1_off = "checked"
        if (getGPIO("pioA27") == 'On'):
            loop2_on  = "checked"
        else:
            loop2_off = "checked"
        if (getGPIO("pioA28") == 'On'):
            loop3_on  = "checked"
        else:
            loop3_off = "checked"
        if (getGPIO("pioA29") == 'On'):
            loop4_on  = "checked"
        else:
            loop4_off = "checked"
    except:
        pass


    logStatus = "Not Running"
    logfile_time = int(cnf.getopt('Debug','logfile_time'))
    log_days = ((logfile_time - int(time.time()))//86400)
    if logfile_time - int(time.time()) > 0:
        logStatus = "In %d days"% (log_days)
    mbusmaster_reset="NO"
    if os.path.isfile("/etc/cron_reset_mbusmaster"):
        mbusmaster_reset="YES"

    

    info = {
        'modDict' : modDict,
        'mbusmaster_reset' : mbusmaster_reset,
        'mbus2modbusLicense' : mbus2modbusLicense,
        'mbusHubVersion': mbusHubVersion,
        'cnf':cnf,
        'tab': 'B',
        'slNum': slNum,
        'nslaves': nslaves,
        'loop1_on': loop1_on,
        'loop1_off': loop1_off,
        'loop2_on': loop2_on,
        'loop2_off': loop2_off,
        'loop3_on': loop3_on,
        'loop3_off': loop3_off,
        'loop4_on': loop4_on,
        'loop4_off': loop4_off,
        'rs485_failsafe_on': rs485_failsafe_on,
        'rs485_failsafe_off': rs485_failsafe_off,
        'sPortDict': sPortDict,
        'mPortDict': mPortDict,
        'typeDict': typeDict,
        'portDict': portDict,
        'confPort': confPort,
        'confHeader': confHeader,
        'porttype': porttype,
        'localip': localip,
        'localport': localport,
        'remoteip': cnf.getopt(confPort,'remoteip'),
        'remoteport': cnf.getopt(confPort,'remoteport'),
        'reconnect' : cnf.getopt(confPort,'reconnect'),
        'sercomport': sercomport,
        'serbaudrate':cnf.getopt(confPort,'serbaudrate'),
        'serbits':cnf.getopt(confPort,'serbits'),
        'serparity':cnf.getopt(confPort,'serparity'),
        'serstopbit':cnf.getopt(confPort,'serstopbit'),
        'timeout':cnf.getopt(confPort,'timeout'),
        'protocol':cnf.getopt(confPort,'protocol'),
        'csvfile':cnf.getopt(confPort,'csvfile'),
        'csvArray':csvArray,
        'baudRateList':baudRateList,
        'bitList':bitList,
        'parityList':parityList,
        'stopBitList':stopBitList,
        'plist': plist,
        'logStatus'  : logStatus,
        'log_days'   : log_days
    }
    return render_template('mbushub_portconf.html', **info)

@mbushub_blueprint.route("/mbushub_setconf", methods=['GET', 'POST'])
def mbushub_setconf():
    cnf=Configs("config","mbushub")
    slnr=-99
    urlpart=""
    try:
        slnr=int(request.args.get("SLNR"))
    except:
        slnr=-99
    if slnr == 0:
        urlpart="mbushub_portconf?SLNR=%d"%slnr
        section='MasterPort'
        cnf.write_section(section)
        cnf.write_section(section+'.MBus')
        t = int(request.form['log_days'])
        cnf.write_section('Debug')
        if t > 0:
            cnf.conf['Debug']['logfile_time'] = "%d"%(int(time.time())+t*86400+30)
        else:
            cnf.conf['Debug']['logfile_time'] = "0"
    elif (slnr > 0 and slnr < 5):
        urlpart="mbushub_portconf?SLNR=%d"%slnr
        section = 'SlavePort%d'%slnr
        cnf.write_section(section)
        cnf.write_section(section+'.MbusAscii',"MBA_")
        cnf.write_section(section+'.ModBus',"MDB_")
    elif (slnr == -100):
        if request.form['periodicResetMenu'] == "YES":
            try: # The link may exist
                os.symlink("/default/cron_reset_mbusmaster","/etc/cron_reset_mbusmaster")
            except:
                pass
        else:
            try: # The link may not exist
                os.remove("/etc/cron_reset_mbusmaster")
            except:
                pass
        urlpart="mbushub_portconf?SLNR=0"
        setGPIO("pioA26",getParameter("loop1"))
        setGPIO("pioA27",getParameter("loop2"))
        setGPIO("pioA28",getParameter("loop3"))
        setGPIO("pioA29",getParameter("loop4"))
    if slnr > -101:
        cnf.save_config()
        subprocess.call(["/%s/etc/init.d/S94mbushub"%PROOT,"restart"])

    return render_template_string("""<HTML>\n<HEAD>\n
                <meta http-equiv=\"refresh\" content=\"2;url=/{{content}}\">
            </HEAD>\n<BODY>
                Setting MBusHub Configuration
            </BODY>\n</HTML>""",content=urlpart)

@mbushub_blueprint.route("/mbushub_logging", methods=['GET', 'POST'])
def logging():
    cnf=Configs("config","mbushub")
    logfile_time = int(cnf.getopt('Debug','logfile_time'))
    log_days = max(0,(( logfile_time - time.time())//86400))

    fname = "/tmp/mbushub"
    filename = fname+"_log.txt"
    if request.args.get("start"):
        if not os.path.exists(fname+".log"):
            with open("%s.log"%fname,'w') as f:
                f.write("")
            os.chmod("%s.log"%fname, 0o666)
            time.sleep(2)
        shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("clear") and log_days == 0:
        f=open("%s.log"%fname,'w+')
        f.close()
        f=open("%s_log.txt"%fname,'w+')
        f.close()
        os.chmod("%s.log"%fname, 0o666)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("show"):
        if os.path.exists("%s.log"%fname):
            shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
            os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("startup"):
        filename = fname+"_startup.log"

    logstring=""
    try:
        f=open(filename,'r')
        logstring=f.read()
        logstring.replace('\n','<br />')
        logstring = "\n"+logstring
        f.close()
    except:
        pass

    logfArray=glob.glob("/data/mbushub/*")
    for i in range(len(logfArray)):
        logfArray[i] = os.path.basename(logfArray[i])


    info = { 'pi900_type' : pi900_type,
             'logfArray': logfArray,
             'logstring'  : logstring,
             'log_days': int(log_days) }
    return render_template('mbushub_logging.html',  **info)


@mbushub_blueprint.route("/mbushub_restart")
def mbushub_restart():
    subprocess.call(["%s/etc/init.d/S94mbushub"%PROOT,"restart"])
    return render_template_string(
        """<html><head>
                <meta http-equiv=\"refresh\" content=\"1;url=/mbushub_portconf?SLNR=0\">
            </head></html>""")

@mbushub_blueprint.route("/mbushub_DownloadLogFile")
def mbushub_download_current_log():
    cstr = secure_filename(os.path.basename(request.args.get('FILE')))
    try:
        return send_file('/tmp/%s'%cstr, attachment_filename=cstr, mimetype='application/octet-stream', as_attachment=True)
    except:
        return 'File not found'


@mbushub_blueprint.route('/api/v1/mbushub/logs', methods=['GET','DELETE'])
def mbushub_historic_logs():
    if request.method == 'GET':
         try:
            filename = secure_filename(os.path.basename(request.args.get('FILE')))
            if filename in os.listdir('/data/mbushub/'):
                return send_file('/data/mbushub/%s'%filename, attachment_filename=filename, mimetype='application/octet-stream', as_attachment=True)
            else:
                return Response(status=400)
         except Exception:
             return Response(status=400)
    elif request.method == 'DELETE':
        try:
            filename = secure_filename(os.path.basename(request.args.get('FILE')))
            if filename in os.listdir('/data/mbushub/'): # only allow delete in /data/mbushub/ folder
                os.remove('/data/mbushub/%s'% filename)
                return Response(status=200)
            else:
                return Response(status=400)
        except Exception:
            return Response(status=400)
    else:
        return Response(status=405)

@mbushub_blueprint.route("/mbushub_manual")
def mbushub_manual():
    return render_template('mbushub_manual.html')
