#!/bin/sh

mkdir -p /binary
mkdir -p /default
mkdir -p /config
mkdir -p /data/mbushub
mkdir -p /var/www1

INSTDIR="/tmp/install/install_package/"
if [ -f "/data/install/install_package/install_arm.sh" ]
then
  INSTDIR="/data/install/install_package/"
fi

chown -R root:root ${INSTDIR}/*
chmod a+x ${INSTDIR}/binary/mbushub.elf
chmod a+x ${INSTDIR}/binary/reset_mbusmaster.sh
chmod a+x ${INSTDIR}/etc/init.d/S94mbushub
chmod a+x ${INSTDIR}/etc/init.d/S93mbushub_init
chmod a+rw ${INSTDIR}/config/*

cp ${INSTDIR}/binary/* /binary/
cp ${INSTDIR}/config/mbushub_default.ini /config/
cp -a ${INSTDIR}/etc  /
cp -a ${INSTDIR}/var/www1/*  /var/www1/
cp ${INSTDIR}/default/* /default

#Remove the old web interface, moved to mbushub/templates
rm -f /var/www1/templates/mbushub_logging.html
rm -f /var/www1/templates/mbushub_manual.html
rm -f /var/www1/templates/mbushub_masterport.html
rm -f /var/www1/templates/mbushub_portconf.html
rm -f /var/www1/templates/mbushub_slaveport.html

if [ ! -f /config/mbushub.ini ]
then
cp ${INSTDIR}/config/mbushub_default.ini /config/mbushub.ini
fi

if [ ! -f /config/mbushub_hw.ini ]
then
cp ${INSTDIR}/config/mbushub_hw.ini /config/
fi

if [ ! -f /config/mbushub_lic.ini ]
then
cp ${INSTDIR}/config/mbushub_lic.ini /config/
fi

# Update default files
rm -f /default/mbushub_hw.ini
cp -f ${INSTDIR}/config/mbushub_hw.ini /default/
rm -f /default/mbushub_default.ini
cp -f ${INSTDIR}/config/mbushub_default.ini /default/

sync

killall mbushub.elf
sleep 1
/binary/mbushub.elf >/dev/null 2>&1 &
