from flask import Blueprint, render_template
import sys
import string
from werkzeug.utils import secure_filename
sys.path.append("..")
from weblib import *
import subprocess
import shutil

mbusascii2mqtt_blueprint = Blueprint('mbusascii2mqtt', __name__, url_prefix='/', template_folder='templates')

@mbusascii2mqtt_blueprint.route("/mbusascii2mqtt_config")
def mbusascii2mqtt_config():
    cnf=Configs("config","mbusascii2mqtt")

    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2'}
    mPortDict={'UDP':{'ALL':[('MBUS','M-Bus')]},'TCP':{'ALL':[('MBUS','M-Bus')]},'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]}}
    sPortDict={'UDP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'TCP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'MBSLAVE1':[('MBUS','M-Bus')],'MBSLAVE2':[('MBUS','M-Bus')]}}
    mProtocolDict={'MBUS':'M-Bus'}
    brokerTypeList = ['Azure','MQTT']

    crtfArray=glob.glob("/config/ca-certificates/*.[cC][rR][tT]")
    for i in range(len(crtfArray)):
        crtfArray[i] = os.path.basename(crtfArray[i])#[24:] #Error when doing strip("/config/ca-certificates/")

    csvfArray=glob.glob("/config/*.[cC][sS][vV]")
    for i in range(len(csvfArray)):
        csvfArray[i] = os.path.basename(csvfArray[i])#[8:] #Error when doing strip("/config/")

    m2mversion=""
    try:
        mbv = os.popen("/binary/mbusascii2mqtt -v")
        m2mversion=mbv.read()
        mbv.close()
    except:
        pass

    m2mLicense=0
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        mbl.close()
        p=licensearray[2].split(',')[5]
        if len(p) > 3:
            m2mLicense=int(p.split('.')[1])
    except Exception as e:
        print("error2:"+str(e))

    numberOfMeters=0
    csvFile = ""
    try:
        csvFile = cnf.getopt('Main',  'MbusAsciiPort')
        filePath="/config/%s"%csvFile
        with open(filePath) as cf:
            for line in cf:
                if line.startswith("[Device]"):
                    numberOfMeters += 1
    except Exception as e:
        print("error3:"+str(e))

    info = {
        'm2mLicense' : m2mLicense,
        'numberOfMeters' : numberOfMeters,
        'baudRateList' : baudRateList,
        'bitList' : bitList,
        'parityList' : parityList,
        'stopBitList' : stopBitList,
        'ipLocalList' : ipLocalList,
        'typeDict' : typeDict,
        'portDict' : portDict,
        'mPortDict' : mPortDict,
        'sPortDict' : sPortDict,
        'mProtocolDict' : mProtocolDict,
        'yesno' : yesno,
        'brokerTypeList' : brokerTypeList,
        'crtfArray' : crtfArray,
        'csvfArray' : csvfArray,
        'm2mversion' : m2mversion,
        'read_period'      : cnf.getopt('Main','read_period'),
        'mqtt_broker_type' : cnf.getopt('Main','mqtt_broker_type'),
        'enable' : cnf.getopt('Main','enable'),
        'Atimeout'     : cnf.getopt('MbusAsciiPort','timeout'),
        'Aporttype'    : cnf.getopt('MbusAsciiPort','porttype'),
        'Aremoteip'    : cnf.getopt('MbusAsciiPort','remoteip'),
        'Aremoteport'  : cnf.getopt('MbusAsciiPort','remoteport'),
        'Asercomport'  : cnf.getopt('MbusAsciiPort','sercomport'),
        'Aserbaudrate' : cnf.getopt('MbusAsciiPort','serbaudrate'),
        'Aserbits'     : cnf.getopt('MbusAsciiPort','serbits'),
        'Aserparity'   : cnf.getopt('MbusAsciiPort','serparity'),
        'Aserstopbit'  : cnf.getopt('MbusAsciiPort','serstopbit'),
        'Acsvfile'     : cnf.getopt('MbusAsciiPort','csvfile'),
        'Qtimeout'     : cnf.getopt('MqttPort','timeout'),
        'Qhubaddress'  : cnf.getopt('MqttPort','hubaddress'),
        'Qhubport'     : cnf.getopt('MqttPort','hubport'),
        'Qsercomport'  : cnf.getopt('MqttPort','sercomport'),
        'Qserbaudrate' : cnf.getopt('MqttPort','serbaudrate'),
        'Qserbits'     : cnf.getopt('MqttPort','serbits'),
        'Qserparity'   : cnf.getopt('MqttPort','serparity'),
        'Qserstopbit'  : cnf.getopt('MqttPort','serstopbit'),
        'Qdeviceid'    : cnf.getopt('MqttPort','deviceid'),
        'Qusername'    : cnf.getopt('MqttPort','username'),
        'Qdevicekey'   : cnf.getopt('MqttPort','devicekey'),
        'Qtopic'       : cnf.getopt('MqttPort','topic'),
        'Qinsecure'    : cnf.getopt('MqttPort','insecure'),
        'Qcertificate' : cnf.getopt('MqttPort','certificate'),
        'Quse_tls'     : cnf.getopt('MqttPort','use_tls'),
        'Qmqtt_qos'    : cnf.getopt('MqttPort','mqtt_qos')
    }
    return render_template('mbusascii2mqtt.html', **info)

@mbusascii2mqtt_blueprint.route("/mbusascii2mqtt_setconf", methods=['GET','POST'])
def mbusascii2mqtt_SetConf():
    cnf=Configs("config","mbusascii2mqtt")

    cnf.write_section('Main')
    cnf.write_section('MbusAsciiPort','A')
    cnf.write_section('MqttPort','Q')
    cnf.save_config()

    subprocess.call(["/%s/etc/init.d/S98mbusascii2mqtt"%PROOT,"restart"])

    time.sleep(1)

    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/mbusascii2mqtt_config\">
        </HEAD>
        </HTML>""")

@mbusascii2mqtt_blueprint.route("/mbusascii2mqtt_log", methods=['GET','POST'])
def mbusascii2mqtt_log():
    fname = "/tmp/mbusascii2mqtt"
    filename = fname+"_log.txt"
    if request.args.get("start"):
        if not os.path.exists(fname+".log"):
            pytouch("%s.log"%fname)
            os.chmod("%s.log"%fname, 0o666)
            time.sleep(2)
        shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("clear"):
        f=open("%s.log"%fname,'w+')
        f.close()
        f=open("%s_log.txt"%fname,'w+')
        f.close()
        os.chmod("%s.log"%fname, 0o666)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("show"):
        if os.path.exists("%s.log"%fname):
            shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
            os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("startup"):
        filename = fname+"_startup.log"

    logstring=""
    try:
        f=open(filename,'r')
        logstring=f.read()
        logstring.replace('\n','<br />')
        logstring = "\n"+logstring
        f.close()
    except:
        pass
    info = { 'pi900_type' : pi900_type,
             'logstring'  : logstring}
    return render_template('mbusascii2mqtt_log.html', **info)

@mbusascii2mqtt_blueprint.route("/mbusascii2mqtt_uploadcrt",  methods=['GET', 'POST'])
def mbusascii2mqtt_UploadCRT():
    try:
        fileitem = request.files['certfile']
        if fileitem:
            filename = secure_filename(fileitem.filename)
            fileitem.save(os.path.join("/config/ca-certificates/", filename))
    except:
        pass

    return render_template_string("""\n<HTML><HEAD>
        <meta http-equiv=\"refresh\" content=\"0;url=/mbusascii2mqtt_config\">
        </HEAD></HTML>""")

@mbusascii2mqtt_blueprint.route("/mbusascii2mqtt_manual")
def mbusascii2mqtt_manual():
    return render_template('mbusascii2mqtt_manual.html')

