from flask import Blueprint, render_template
import sys, time
PROOT="" # In case it isn't defined in weblib, earlier versions.
sys.path.append("..")
from weblib import *
from werkzeug.utils import secure_filename
modbus2mbus_blueprint = Blueprint('modbus2mbus', __name__, url_prefix='/', template_folder='templates')
from modbus_testclient import *
import configparser
import serial
import subprocess
import shutil

@modbus2mbus_blueprint.route("/modbus2mbus_config")
def modbus2mbus_config():
    cnf=Configs("config","modbus2mbus")

    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    baudRateList1=['300','600','1200','2400','4800','9600','19200','38400','57600']
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2'}
    mPortDict={'UDP':{'ALL':[('MBUS','M-Bus')]},'TCP':{'ALL':[('MBUS','M-Bus')]},'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]}}
    sPortDict={'UDP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'TCP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'MBSLAVE1':[('MBUS','M-Bus')],'MBSLAVE2':[('MBUS','M-Bus')]}}
    mProtocolDict={'MBUS':'M-Bus'}

    xmlfArray=glob.glob("/config/*.[xX][mM][lL]")
    for i in range(len(xmlfArray)):
        xmlfArray[i] = xmlfArray[i][xmlfArray[i].rfind('/')+1:] #Error when doing strip("/config/")

    m2mversion=""
    try:
        mbv=os.popen("/binary/modbus2mbus -v")
        m2mversion=mbv.read()
        mbv.close()
    except:
        pass
        
    modbusLicense=""
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        mbl.close()
        protocols=licensearray[2].split(',')
        modbusLicense=protocols[11]
    except:
        pass

    number_of_modbusports = int(cnf.getoptdef('Main','number_of_modbusports', 0))
    if number_of_modbusports < 1:
        number_of_modbusports = 1
    if number_of_modbusports > 30:
        number_of_modbusports = 30

    MTtimeout=[]
    MTporttype=[]
    MTremoteip=[]
    MTremoteport=[]
    for n in range(0,number_of_modbusports):
        MTtimeout.append(cnf.getoptdef('ModbusPort%d'%n, 'timeout', 300))
        MTporttype.append(cnf.getoptdef('ModbusPort%d'%n, 'porttype', 'TCP'))
        MTremoteip.append(cnf.getoptdef('ModbusPort%d'%n, 'remoteip', '0.0.0.0'))
        MTremoteport.append(cnf.getoptdef('ModbusPort%d'%n, 'remoteport', 502))

    info = {
        'modbusLicense': modbusLicense, 
        'baudRateList' : baudRateList1,
        'bitList' : bitList,
        'parityList' : parityList,
        'stopBitList' : stopBitList,
        'ipLocalList' : ipLocalList,
        'typeDict' : typeDict,
        'portDict' : portDict,
        'mPortDict' : mPortDict,
        'sPortDict' : sPortDict,
        'mProtocolDict' : mProtocolDict,
        'yesno' : yesno,
        'xmlfArray' : xmlfArray,
        'm2mversion' : m2mversion,
        'filename'     : cnf.getopt('Main','filename'),
        'enable_leds'  : cnf.getopt('Main','enable_leds'),
        'M0porttype'    : cnf.getopt('ModbusPort0','porttype'),
        'M0localip'     : cnf.getopt('ModbusPort0','localip'),
        'M0localport'   : cnf.getopt('ModbusPort0','localport'),
        'M0sercomport'  : cnf.getopt('ModbusPort0','sercomport'),
        'M0serbaudrate' : cnf.getopt('ModbusPort0','serbaudrate'),
        'M0serbits'     : cnf.getopt('ModbusPort0','serbits'),
        #Mserparity   : cnf.getopt('ModbusPort','serparity')
        'M0serstopbit'  : cnf.getopt('ModbusPort0','serstopbit'),
        'Stimeout'     : cnf.getopt('MBusPort','timeout'),
        'Sporttype'    : cnf.getopt('MBusPort','porttype'),
        'Slocalip'     : cnf.getopt('MBusPort','localip'),
        'Slocalport'   : cnf.getopt('MBusPort','localport'),
        'Sremoteip'    : cnf.getopt('MBusPort','remoteip'),
        'Sremoteport'  : cnf.getopt('MBusPort','remoteport'),
        'Ssercomport'  : cnf.getopt('MBusPort','sercomport'),
        'Sserbaudrate' : cnf.getopt('MBusPort','serbaudrate'),
        'Sserbits'     : cnf.getopt('MBusPort','serbits'),
        'Sserparity'   : cnf.getopt('MBusPort','serparity'),
        'Sserstopbit'  : cnf.getopt('MBusPort','serstopbit'), 
        'number_of_modbusports' : number_of_modbusports, 
        'MTtimeout'     : MTtimeout, 
        'MTporttype'    : MTtimeout,
        'MTremoteip'    : MTremoteip, 
        'MTremoteport'  : MTremoteport
    }
    return render_template('modbus2mbus.html', **info)

@modbus2mbus_blueprint.route("/modbus2mbus_log", methods=['GET', 'POST'])
def modbus2mbus_log():
    fname = "/tmp/modbus2mbus"
    filename = fname+"_log.txt"
    if request.args.get("start"):
        if not os.path.exists(fname+".log"):
            pytouch("%s.log"%fname)
            os.chmod("%s.log"%fname, 0o666)
            time.sleep(2)
        shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("clear"):
        f=open("%s.log"%fname,'w+')
        f.close()
        f=open("%s_log.txt"%fname,'w+')
        f.close()
        os.chmod("%s.log"%fname, 0o666)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("show"):
        if os.path.exists("%s.log"%fname):
            shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
            os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("startup"):
        filename = fname+"_startup.log"

    logstring=""
    try:
        f=open(filename,'r')
        logstring=f.read()
        logstring.replace('\n','<br />')
        logstring = "\n"+logstring
        f.close()
    except:
        pass
    context = {'logstring': logstring}
    return render_template('modbus2mbus_log.html', **context)


@modbus2mbus_blueprint.route("/modbus2mbus_setconf", methods=['POST'])
def modbus2mbus_SetConf():
    cnf=Configs("config","modbus2mbus");
    number_of_modbusports = int(request.form['number_of_modbusports'])
    if number_of_modbusports < 1:
        number_of_modbusports = 1
    if number_of_modbusports > 30:
        number_of_modbusports = 30
    cnf.write_section('Main')
    cnf.write_section('MBusPort','S')
    cnf.write_section('ModbusPort0','M0') # ModbusPort0 has different default values from the others
    for i in range(1, number_of_modbusports):
        cnf.write_section1('ModbusPort%d'%i,'M%d'%i, 'ModbusPort1')
    cnf.save_config()

    subprocess.call(["/%s/etc/init.d/S96modbus2mbus"%PROOT,"restart"])
    time.sleep(1)

    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/modbus2mbus_config\">
        </HEAD>
    </HTML>""")
        
@modbus2mbus_blueprint.route("/modbus2mbus_showxmlfile")
def modbus2mbus_ShowXmlFile():
    fname=secure_filename(os.path.basename(request.args.get('FILE')))
    with open('/config/'+fname,'r') as f:
    #f=open('/config/Eurotherm.xml',encoding="latin-1")
        a=f.read()
        return render_template_string("""<HTML>
        <HEAD>
            <meta charset=\"UTF-8\">
        </HEAD>
        <BODY>
            <h1>Modbus2MBus Configuration file</h1>
            <h1>{{filename}}</h1>
            <pre><code>{{content}}</code></pre>
        </BODY>    
        </HTML>""",filename=fname, content=a.replace('<','&lt').replace('>','&gt').replace('\n','<br>'))

@modbus2mbus_blueprint.route("/modbus2mbus_manual")
def modbus2mbus_manual():
    return render_template('modbus2mbus_manual.html')

@modbus2mbus_blueprint.route("/modbus_reader")
def modbus_reader():
    if not os.path.isfile("/tmp/modbusreader_default.ini"):
        shutil.copyfile("/config/modbusreader_default.ini","/tmp/modbusreader_default.ini")
    cnf=Configs("tmp","modbusreader")

    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    baudRateList1=['300','600','1200','2400','4800','9600','19200','38400','57600']
    parityList1=[('N','No parity'),('O','Odd Parity'),('E','Even Parity')]
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2'}
    mPortDict={'UDP':{'ALL':[('MBUS','M-Bus')]},'TCP':{'ALL':[('MBUS','M-Bus')]},'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]}}

    errorCode = cnf.getopt('Main','errorcode')
    outputVisible = "visible"
    errorVisible  = "hidden"
    if errorCode != "":
        outputVisible = "hidden"
        errorVisible  = "visible"

    info = {
        'bitList' : bitList,
        'parityList' : parityList1,
        'baudRateList' : baudRateList1,
        'stopBitList' : stopBitList,
        'typeDict' : typeDict,
        'portDict' : portDict,
        'mPortDict' : mPortDict,
        'address'       : cnf.getopt('Main','address'),
        'register'      : cnf.getopt('Main','register'),
        'regnum'        : cnf.getopt('Main','regnum'),
        'function'      : cnf.getopt('Main','function'),
        'modbustype'    : cnf.getopt('Main','modbustype'),
        'M0porttype'    : cnf.getopt('ModbusPort','porttype'),
        'M0sercomport'  : cnf.getopt('ModbusPort','sercomport'),
        'M0serbaudrate' : cnf.getopt('ModbusPort','serbaudrate'),
        'M0serbits'     : cnf.getopt('ModbusPort','serbits'),
        'M0serparity'   : cnf.getopt('ModbusPort','serparity'),
        'M0serstopbit'  : cnf.getopt('ModbusPort','serstopbit'),
        'M0remoteip'    : cnf.getopt('ModbusPort','remoteip'),
        'M0remoteport'  : cnf.getopt('ModbusPort','remoteport'),
        'BigEndFloat'   : cnf.getopt('Main','bigendfloat'),
        'BigEndInt'     : cnf.getopt('Main','bigendint'),
        'BigEndUInt'    : cnf.getopt('Main','bigenduint'),
        'BigEndHex'     : cnf.getopt('Main','bigendhex'),
        'LittleEndFloat': cnf.getopt('Main','littleendfloat'),
        'LittleEndInt'  : cnf.getopt('Main','littleendint'),
        'LittleEndUInt' : cnf.getopt('Main','littleenduint'),
        'LittleEndHex'  : cnf.getopt('Main','littleendhex'),
        'ByteSwapFloat' : cnf.getopt('Main','byteswapfloat'),
        'ByteSwapInt'   : cnf.getopt('Main','byteswapint'),
        'ByteSwapUInt'  : cnf.getopt('Main','byteswapuint'),
        'ByteSwapHex'   : cnf.getopt('Main','byteswaphex'),
        'RegSwapFloat'  : cnf.getopt('Main','regswapfloat'),
        'RegSwapInt'    : cnf.getopt('Main','regswapint'),
        'RegSwapUInt'   : cnf.getopt('Main','regswapuint'),
        'RegSwapHex'    : cnf.getopt('Main','regswaphex'),
        'characterString' : cnf.getopt('Main','characterstring'),
        'errorCode'       : errorCode,
        'outputVisible'   : outputVisible,
        'errorVisible'    : errorVisible,
        'requestString'   : cnf.getopt('Main','request'),
        'responseString'  : cnf.getopt('Main','response'),
        'timeString'      : time.strftime("%Y-%m-%d %H:%M:%S")        
    }
    return render_template('modbus_reader.html', **info)

@modbus2mbus_blueprint.route("/read_modbus", methods=['POST'])
def read_modbus():
    parDict = {'N':serial.PARITY_NONE,'E':serial.PARITY_EVEN,'O':serial.PARITY_ODD}
    stopDict = {'1':serial.STOPBITS_ONE,'2':serial.STOPBITS_TWO}
    bitDict = {'5':serial.FIVEBITS,'6':serial.SIXBITS,'7':serial.SEVENBITS,'8':serial.EIGHTBITS}
    conf = configparser.RawConfigParser()
    pname = request.form['M0sercomport']
    port = None
    try:
        conf.read('/config/mbushub_hw.ini')
        port = conf.get("Main",pname)
        print(port)
    except: # the ethernet based Modbus will be useful even if this fails
        pass
    params = {}
    params['port'] = port
    params['baudrate'] = request.form['M0serbaudrate']
    params['ipaddress'] = request.form['M0remoteip']
    params['ipport'] = int(request.form['M0remoteport'])
    params['bytesize'] = bitDict[request.form['M0serbits']]
    params['parity']   = parDict[request.form['M0serparity']]
    params['stopbits'] = stopDict[request.form['M0serstopbit']]
    adress = int(request.form['address'])
    fcode  = int(request.form['function'])
    streg  = int(request.form['register'])
    nregs  = int(request.form['regnum'])
    devicetype = request.form['modbustype']
    porttype = request.form['M0porttype']
    #print("Run number %s"%sys.argv[5])
    mbs = modbus(porttype, devicetype, params, adress)
    cnf=Configs("tmp","modbusreader")
    cnf.write_section('Main') # ModbusPort0 has different default values from the others
    tf, errmsg = mbs.readFromDevice(fcode, streg, nregs)
    if (tf):
        tf, val = mbs.getValue(streg, nregs, "float","big")
        #print("BigEnd FloatVal = %s"%val )
        cnf.conf['Main']['bigendfloat'] = val
        tf, val = mbs.getValue(streg, nregs, "int","big")
        #print("BigEnd IntVal = %s"%val )
        cnf.conf['Main']['bigendint'] = val
        tf, val = mbs.getValue(streg, nregs, "uint","big")
        #print("BigEnd UIntVal = %s"%val )
        cnf.conf['Main']['bigenduint'] = val
        tf, val = mbs.getValue(streg, nregs, "hex","big")
        #print("Hex big = %s"%val )
        cnf.conf['Main']['bigendhex'] = val
        
        tf, val = mbs.getValue(streg, nregs, "float","little")
        #print("LittleEnd FloatVal = %s"%val )
        cnf.conf['Main']['littleendfloat'] = val
        tf, val = mbs.getValue(streg, nregs, "int","little")
        #print("LittleEnd IntVal = %s"%val )
        cnf.conf['Main']['littleendint'] = val
        tf, val = mbs.getValue(streg, nregs, "uint","little")
        #print("LittleEnd UIntVal = %s"%val )
        cnf.conf['Main']['littleenduint'] = val
        tf, val = mbs.getValue(streg, nregs, "hex","little")
        #print("Hex little = %s"%val )
        cnf.conf['Main']['littleendhex'] = val

        tf, val = mbs.getValue(streg, nregs, "float","regswap")
        #print("Regswap FloatVal = %s"%val )
        cnf.conf['Main']['byteswapfloat'] = val
        tf, val = mbs.getValue(streg, nregs, "int","regswap")
        #print("Regswap IntVal = %s"%val )
        cnf.conf['Main']['byteswapint'] = val
        tf, val = mbs.getValue(streg, nregs, "uint","regswap")
        #print("Regswap UIntVal = %s"%val )
        cnf.conf['Main']['byteswapuint'] = val
        tf, val = mbs.getValue(streg, nregs, "hex","regswap")
        #print("Hex regswap = %s"%val )
        cnf.conf['Main']['byteswaphex'] = val

        tf, val = mbs.getValue(streg, nregs, "float","byteswap")
        #print("Byteswap FloatVal = %s"%val )
        cnf.conf['Main']['regswapfloat'] = val
        tf, val = mbs.getValue(streg, nregs, "int","byteswap")
        #print("Byteswap IntVal = %s"%val )
        cnf.conf['Main']['regswapint'] = val
        tf, val = mbs.getValue(streg, nregs, "uint","byteswap")
        #print("Byteswap UIntVal = %s"%val )
        cnf.conf['Main']['regswapuint'] = val
        tf, val = mbs.getValue(streg, nregs, "hex","byteswap")
        #print("Hex byteswap = %s"%val )
        cnf.conf['Main']['regswaphex'] = val
        
        val = mbs.getString(streg, nregs)
        #print("String = %s"%val )
        cnf.conf['Main']['characterString'] = val
        
        cnf.conf['Main']['errorcode'] = ""
                
        cnf.conf['Main']['response'] = mbs.getResponse()
        cnf.conf['Main']['request'] = mbs.getRequest()
        
    else:
        cnf.conf['Main']['errorcode'] = errmsg
        cnf.conf['Main']['response'] = mbs.getResponse()
        cnf.conf['Main']['request'] = mbs.getRequest()
        
    cnf.write_section('ModbusPort','M0') # ModbusPort0 has different default values from the others    
    cnf.save_config()
    return modbus_reader()
