#!/usr/bin/python
# -*- coding: utf-8 -*-;
#kate: space-indent on; indent-width 4; mixedindent off; indent-mode python

"""
ToDo:
This program should find all nodes in the /tmp/meterlist.csv and read the meterlists from them.
"""
import socket, struct
import sys,time, csv,  os
from operator import itemgetter
from weblib import *

def calcBcc(arr):
    bcc=0
    for i in range(len(arr)):
        bcc += arr[i]
    return bcc&0xFF

def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def printhex(data):
    tstr = ""
    for j in range(len(data)):
        if j%16 == 0 and j != 0:
            tstr += "\n"
        tstr += "%02X "%data[j]
    print(tstr)

def setFabricationAndStatus(meter, wireless_list):
    max_time=24*60 # One day

    rssi = -129
    foundInAPreviousNode = False

    print("meter",meter)
    assert(meter[8] == "R")

    for r1 in wireless_list:
        if meter[0:4] == r1[0:4]:
            fabrication_number = r1[5]
            timestamp = r1[11]
            meter_rssi = int(r1[10])
            duration = int(r1[9])

            if duration <= max_time and meter_rssi > rssi:
                meter[7] = "20"
                meter[5] = fabrication_number # Fabrication number
                foundInAPreviousNode = True
                rssi = meter_rssi
                print("r1 %s"%r1)
                meter[5] = fabrication_number # Fabrication number
                meter[11] = timestamp # Timestamp
            elif duration > max_time and foundInAPreviousNode == False:
                meter[7] = "10"
                meter[5] = fabrication_number # Fabrication number
                meter[11] = timestamp # Timestamp
    return meter

def createWirelessMap(wireless_list):
    wireless_map = {}
    for meter in wireless_list:
        key = tuple(meter[0:4])
        if key in wireless_map:
            wireless_map[key].append(meter)
            print("wlnode app",meter)
        else:
            wireless_map[key] = [meter]
            print("wlnode",meter)

    return wireless_map


def optimise_meterlist():
    print("in optimise")
    meter_list = []
    try:
        with open("/config/meterlist.csv") as file:
            delimiter = sniffer_csv(file)
            meter_list = list(rcf(file, delimiter))
    except Exception as e:
        print("error in wireless_node_optimize: "+str(e))
    
    wireless_list = []
    try:
        with open("/tmp/meterlist_wireless.txt") as file:
            delimiter = sniffer_csv(file)
            wireless_list = list(rcf(file, delimiter))
    except Exception as e:
        print("error in wireless_node_optimize: "+str(e))

    wireless_map = createWirelessMap(wireless_list)

    for i in range(len(meter_list)):
        wirelessMeterFound = False
        
        if meter_list[i][8] == 'R':
            meter = meter_list[i]
            key = tuple(meter[0:4])
            if key in wireless_map:
        
                meter_list[i] = setFabricationAndStatus(meter_list[i], wireless_map[key])
                wirelessMeterFound = True

        if meter_list[i][8] == 'R' and not wirelessMeterFound:
            if (
                (meter_list[i][1] != "FFFF" and meter_list[i][1] != 0xFFFF) and 
                (meter_list[i][2] != "FF" and meter_list[i][2] != 0xFF) and 
                (meter_list[i][3] != "FF" and meter_list[i][3] != 0xFF)
            ):
                meter_list[i][7] = "10"
            else:
                meter_list[i][7] = "0"
    
    meter_list = sorted(meter_list, key= lambda x: x[0])
    with open("/config/meterlist.csv", "w") as cf:
        writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for m in meter_list:
            writer.writerow(m)
    meterlist_to_cyclic_conf()

if __name__=="__main__":
    optimise_meterlist()









