////////////////////////////////////////////
// Fetching the meterlist when page loads //
////////////////////////////////////////////



// This will match the input from the manufacturer header with the data in 
// Manufacturer description dictionary (csvDict)
function matchInput(property) {
    var input = document.getElementById(property).value.toLowerCase();

    // If user have pressed backspace after misspelling the window.meters
    // will be filled up again with the fetched array, otherwise it will be empty
    //if (!window.meters.length && input != "") {
    window.meters = window.fetchedMeters;
    //}

    var newMeters = [];
    var re = new RegExp("\\b"+input, "i");
    if (input == "") {
        window.meters = window.fetchedMeters;
        window.printMeterlist();
        return;
    } 
    for (m in window.meters) {
        if (window.csvDict[window.meters[m].mfct_str] != undefined){
            var mfctMatch = window.csvDict[window.meters[m].mfct_str].toLowerCase().match(re);  
        }
        var idMatch = window.meters[m].id.match(re);
        if (mfctMatch) {
            newMeters.push(meters[m]);
        }
        if (idMatch) {
            newMeters.push(meters[m]);
        }
    }
    window.meters = newMeters;
    window.printMeterlist();
};

function printMeterlist() {
    var meterOutput = "";
    for (m in window.meters) {
        var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
        if (window.meters[m].fab) {
            secAddr += ":" + window.meters[m].fab;
        }
        //console.log("has", window.dupSet.hasOwnProperty(secAddr));
        if (window.dupSet.hasOwnProperty(window.meters[m].order)){
            meterOutput += `<tr id='${window.meters[m].order}-row' class='fail-bg-color'>`;
        } else
        {
            meterOutput += `<tr id='${window.meters[m].order}-row'>`;
        }
        meterOutput += `<td>${parseInt(m)+1}</td>`;
        
        if (window.meters[m].type == "R") {
            meterOutput += `<td>Wireless</td>`;
        } else if (window.meters[m].type == "N") {
            meterOutput += `<td>Node</td>`;
        } else if (window.meters[m].type == "W") {
            meterOutput += `<td>Wired</td>`;
        } else {
            meterOutput += "<td></td>";
        }
        
        meterOutput += `
            <td>
            <button 
                class="" 
                type = "submit" 
                name = "secAddress" 
                value='${secAddr}'>${window.meters[m].id}</button>
            </td>`;
        
        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(window.meters[m].med)) {
            meterOutput += `
                <td>
                ${window.DeviceTypes[window.meters[m].med]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters[m].med}
                </td>
            `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the 
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(window.meters[m].mfct_str)) {
            meterOutput += `
                <td>
                ${window.csvDict[window.meters[m].mfct_str]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters[m].mfct_str}
                </td>
            `;
        }

        // Add the fabrication number to the meterlist
        if (window.meters[m].fab) {
            meterOutput += `
                <td>
                ${window.meters[m].fab}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the prim number
        if (window.meters[m].prim) {
            meterOutput += `
                <td>
                ${window.meters[m].prim}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the verification status image
        if (window.meters[m].status == "20" || window.meters[m].status == "Ver") {
            meterOutput += `
                <td>
                <img src="../../img/status-20.png" />
                </td>
            `;
        } else if (window.meters[m].status == "10") {
            meterOutput += `
                <td>
                <img src="../../img/status-10.png" />
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                <img src="../../img/status-0.png" />
                </td>
            `;
        }

        // Add the wireless svg
        if (window.meters[m].key == ""){
            meterOutput += `<td><div class="icon original key"></div></td>`;
        }
        else {
            meterOutput += `<td><div class="icon colored key"></div></td>`;
        }

        // Add the description
        meterOutput += `<td>${window.meters[m].description}</td>`;

        // Edit button
        /*meterOutput += `<td><button 
                            class='edit-button'
                            type='button' 
                            onclick='editMeter(${window.meters[m].order})'>
                            Edit
                            </button></td>`;*/

        meterOutput += `<td class="cb" onclick="editMeter(${window.meters[m].order}, 'false');" >
                            <div class="icon original edit"></td>`;

        // Add the remove button
        meterOutput += `<td class="cb" onclick="changeColor('${window.meters[m].order}');" >
        <div
            class="icon original trash-alt"
            name="STAY"
            id="${window.meters[m].order}"
            >
        </div></td>`;

        meterOutput += "</tr>"
    }
    document.getElementById("meterDiv").innerHTML = meterOutput;
}

window.dupSet = {};

const myInit = {
    credentials: "include",
    method: 'GET',
    headers:  {
        'Content-Type': 'application/json'
    },
};
const removeMeters = {
    credentials: "include",
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    },
};
const addSingleMeterHeader = {
    credentials: "include",
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    }
};
const statusReq = {
    credentials: "include",
    method: 'GET',
    headers:  {
        'Content-Type': 'application/json'
    },
};

const statusRequest = new Request("/get_status", statusReq);
const myRequest = new Request("/meterlist", myInit);
const addWirelessRequest = new Request("/add_wireless", myInit);
const addWiredRequest = new Request("/merge_search_files", myInit);
const addSingleMeterRequest = new Request("/add_single_meter", addSingleMeterHeader);
const removeMeterRequest = new Request("/removeMeters", removeMeters);
const verifyMeterlistRequest = new Request("/verify_meterlist", myInit);
const readMeterlistRequest = new Request("/read_meterlist", myInit);
//const autoCreateMyConfigRequest = new Request("/auto_template_generator", autoCreateMyConfigHeader);

function addEditMeterContent(meterToEdit, modalContent) {
    let editMeterContainer = document.createElement("div");
    editMeterContainer.id = "edit-meter-container";

    let table = document.createElement("table");
    table.classList.add("edit-table");
    
    let tableOutput = `<colgroup>
                        <col span="1" style="width: 20%;">
                        <col span="1" style="width: 80%;">
                    </colgroup>`;
    tableOutput += `<tbody>`;
    
    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">ID:</span>
                    </td>
                    <td>
                        <input class="edit-input" style="width:100%;" id="id-input-value" value="${meterToEdit.id}" onkeyup="checkInput(this,8,'numeric', 'id-input-info-text')"></input>
                        <span id="id-input-info-text"></span>
                    </td>
                    </tr>`;

    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">Manufacturer:</span>
                    </td>
                    <td>    
                        <input class="edit-input" id="mfct-input-value" value="${meterToEdit.mfct}" onkeyup="checkInput(this,4,'alphanumeric', 'mfct-input-info-text')"></input>
                        <span id="mfct-input-info-text"></span>
                    </td>
                    </tr>`;
    
    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">Version:</span>
                    </td>
                    <td>    
                        <input class="edit-input" id="ver-input-value" value="${meterToEdit.ver}" onkeyup="checkInput(this,2,'alphanumeric', 'ver-input-info-text')"></input>
                        <span id="ver-input-info-text"></span>
                    </td>
                    </tr>`;

    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">Medium:</span>
                    </td>
                    <td>    
                        <input class="edit-input" id="med-input-value" value="${meterToEdit.med}" onkeyup="checkInput(this,2,'alphanumeric', 'med-input-info-text')"></input>
                        <span id="med-input-info-text"></span>
                    </td>
                    </tr>`;
    
    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">Wireless-key:</span>
                    </td>
                    <td>    
                        <input class="edit-input" id="wl-key-input-value" value="${meterToEdit.key}" onkeyup="checkInput(this,32,'alphanumeric', 'wl-key-input-info-text')"></input>
                        <span id="wl-key-input-info-text"></span>
                    </td>
                    </tr>`;

    tableOutput += `<tr>
                    <td>
                        <span class="edit-meter-text">Description:</span>
                    </td>
                    <td>    
                        <input class="edit-input" id="description-input-value" value="${meterToEdit.description}" onkeyup="checkInput(this,50,'allLetters', 'description-input-info-text')"></input>
                        <span id="description-input-info-text"></span>
                    </td>
                    </tr>`; 

    tableOutput += `</tbody>`;
    table.innerHTML = tableOutput;
    editMeterContainer.appendChild(table);
    modalContent.appendChild(editMeterContainer);
}

function checkInput(object, length, style, info_id) {
    var regx = new RegExp("^[A-Za-z0-9åäöÅÄÖ]+$");
    var regx2 = new RegExp(/\s+/);
    // Check if input is alphanumeric
    var isAlNum = true ? regx.test(object.value) : false;
    var spaces = true ? regx2.test(object.value) : false;

    if (object.value.length > 0 && isNaN(object.value) && style == "numeric") {
        document.getElementById(info_id).innerHTML = "Input is not numeric";
        object.classList.add("error-border");
    } else if (object.value.length > length) {
        document.getElementById(info_id).innerHTML = `Max length is ${length}`;
        object.classList.add("error-border");
    } else if (object.value.length > 0 && style == "alphanumeric" && !isAlNum) {
        document.getElementById(info_id).innerHTML = "Input is not alphanumeric";
        object.classList.add("error-border");
    } else if (style == "allLetters" && spaces) {
        document.getElementById(info_id).innerHTML = "No spaces are allowed";
        object.classList.add("error-border");
    }
    else {
        document.getElementById(info_id).innerHTML = "";
        object.classList.remove("error-border");
    }
}

function editMeter(meterOrderNr, newMeter) {
    let meterToEdit = {};
    if (newMeter == 'true') {
        meterToEdit = {
            "id": "",
            "mfct": "",
            "ver": "",
            "med": "",
            "key": "",
            "description": "",
        }
    } else {
        meterToEdit = window.meters.find((currentValue, index, arr) => {
            return currentValue ? currentValue.order === meterOrderNr : null;
        });
    }
    if (document.getElementById("edit-meter-container") != null) {
        document.getElementById("edit-meter-container").remove();
    }

    // Adds the meter parameter table content
    let modalContent = document.getElementById("modal-content");
    addEditMeterContent(meterToEdit, modalContent);
    
    if (document.getElementById("save-edit-meter") != null) {
        document.getElementById("save-edit-meter").remove();
    }
    // Add the save edit button
    let saveEditButton = document.createElement("button");
    saveEditButton.id = "save-edit-meter";
    saveEditButton.classList.add("save-edit-button");
    saveEditButton.innerHTML = "Save";
    if (document.getElementById("response-text") != null) {
        document.getElementById("response-text").remove();
    }
    var responseText = document.createElement("span");
    responseText.id = "response-text";

    meterToEdit.newMeter = newMeter;
    saveEditButton.onclick = () => {
        let idInput = document.getElementById("id-input-value").value;
        meterToEdit.id = idInput;
        let mfctInput = document.getElementById("mfct-input-value").value;
        meterToEdit.mfct = mfctInput;
        let verInput = document.getElementById("ver-input-value").value;
        meterToEdit.ver = verInput;
        let medInput = document.getElementById("med-input-value").value;
        meterToEdit.med = medInput;
        let wlKetInput = document.getElementById("wl-key-input-value").value;
        meterToEdit.key = wlKetInput;
        let descriptionInput = document.getElementById("description-input-value").value;
        meterToEdit.description = descriptionInput;
        fetch("/edit_meter", {
            credentials: "include",
            method:"POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify(meterToEdit, newMeter)
        })
        .then(response => response.json())
        .then(json => {
            //console.log("edit-response", json["content"]);
            if (json["content"].key == "incorrect") {
                responseText.innerHTML = "Incorrect wl-key input"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].key == "not_utf8") {
                responseText.innerHTML = "Wl-key input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].description == "incorrect") {
                responseText.innerHTML = "Incorrect description input";
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].description == "not_utf8") {
                responseText.innerHTML = "Description input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].id == "incorrect") {
                responseText.innerHTML = "Incorrect id input"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].id == "not_utf8") {
                responseText.innerHTML = "Id input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].mfct == "incorrect") {
                responseText.innerHTML = "Incorrect manufacturer input"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].mfct == "not_utf8") {
                responseText.innerHTML = "Manufacturer input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].ver == "incorrect") {
                responseText.innerHTML = "Incorrect version input"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].ver == "not_utf8") {
                responseText.innerHTML = "Version input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].med == "incorrect") {
                responseText.innerHTML = "Incorrect medium input"
                responseText.classList.add("response-text", "fail-bg-color");
            } else if (json["content"].med == "not_utf8") {
                responseText.innerHTML = "Medium input is not utf-8"
                responseText.classList.add("response-text", "fail-bg-color");
            } 

            // If a new meter have been added
            else if (json["content"].newMeter == "true") {
                window.running = json["running"]
                window.status = json["status"]
                window.functionDidStart = json["functionDidStart"]
                if (window.functionDidStart) {
                    var autoCreateIcon = document.getElementById("add-single-meter-icon");
                    autoCreateIcon.classList.remove("plus-square");
                    autoCreateIcon.classList.remove("original-color");
                    autoCreateIcon.classList.add("button-loader");
                }
                if (window.running) {
                    setTimeout(function(){ fetchStatus(false, statusRequest); }, 4000);
                    editModal.style.display = "none"; 
                } else {
                    editModal.style.display = "none";
                    window.loadMeterlist();
                }
                
            } else {
                loadMeterlist();
                editModal.style.display = "none"; 
            }
        })

    }
    modalContent.appendChild(saveEditButton); 
    modalContent.appendChild(responseText);

    let close = document.getElementById("modal-close");
    editModal.style.display = "block";
    close.onclick = () => {
        editModal.style.display = "none";
    }
}
let editModal = document.getElementById("edit-modal");

function commitMeterlist(){
    window.addLoader();
    var sendMeters = [];
    for (const [key, value] of Object.entries(window.removeMeters)) {
        //console.log("key", key, "value", value)
        sendMeters.push(key);
    }
    window.removeMeters = {};

    fetch("/remove_meters", {
        credentials: "include",
        method: 'post',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(sendMeters)
    })
    .then(function(response){
        return response.json();
    })
    .then(function(json) {
        window.fetchedMeters = json[0];
        window.meters = window.fetchedMeters;
        window.DeviceTypes = json[1];
        localStorage.DeviceTypes = json[1];
        window.csvDict = json[2];
        localStorage.csvDict = json[2];
        window.duplicate_entries = json[3];
        for (var i = 0; i < window.meters.length;i++) {
            window.meters[i].order =  i;
        }

        window.setMinHeight();

        window.dupSet = {}
        for (n in window.duplicate_entries){
            var dupAddr = `${window.duplicate_entries[n][0]}.${window.duplicate_entries[n][1]}.${window.duplicate_entries[n][2]}.${window.duplicate_entries[n][3]}`;
            for (m in window.meters) {
                var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
                if (dupAddr == secAddr) {
                    window.dupSet[window.meters[m].order] = true;
                }
            }  
        }
        printDuplicates();

        window.printMeterlist();
        document.getElementById("list-loader").remove();
        document.getElementById("search-progress").remove();
        const keys = Object.keys(localStorage.csvDict);
        })
        .catch(function(err) {
            console.log("Fetch problem: " + err.message)
        })
    };

function addLoader(){
    if (document.getElementById("list-loader") == null) {
        var loaderDiv = document.getElementById("loaderDiv");
        var loader = document.createElement("div");
        loader.id = "list-loader";
        loader.classList.add("loader");

        var h2 = document.createElement("h2");
        h2.id = "search-progress";
        h2.classList.add("search-progress");
        h2.innerHTML = "Loading Meterlist...";
        loaderDiv.appendChild(loader);
        loaderDiv.appendChild(h2);
    }
}

function fetchRoute(request, id) {
    fetch(request)
    .then(response => response.json())
    .then(json => {
        window.running = json[0]
        window.status = json[1]
        window.functionDidStart = json[2]
        if (window.functionDidStart) {
            var autoCreateIcon = document.getElementById(id);
            autoCreateIcon.classList.remove("play-circle");
            autoCreateIcon.classList.remove("original-color");
            autoCreateIcon.classList.add("button-loader");
        }
        
        if (window.running) {
            setTimeout(function(){ fetchStatus(false, statusRequest); }, 4000);
        } else {
            loadMeterlist();
        }
        //window.updateStatusDiv();
    })
    .catch(err =>
        console.log("Fetch problem: " + err.message));
}

function autoCreateMyConfig() {
    fetch("/auto_create_myconfig", {
        credentials: "include",
        method: "GET",
        headers: {
            "Content-Type": "application/json"
        },
    })
    .then(response => response.json())
    .then(json => {
        window.running = json["running"]
        window.status = json["status"]
        window.functionDidStart = json["functionDidStart"]
        if (window.functionDidStart) {
            var autoCreateIcon = document.getElementById("auto-create-icon");
            autoCreateIcon.classList.remove("play-circle");
            autoCreateIcon.classList.remove("original-color");
            autoCreateIcon.classList.add("button-loader");
        }
        fetchStatus(false, statusRequest);
        //window.updateStatusDiv();
    })
    .catch(err =>
        console.log("Fetch problem: " + err.message));
}

function addWireless() {
    fetchRoute(addWirelessRequest, "add-wireless-icon");
}

function addWired() {
    fetchRoute(addWiredRequest, "add-wired-icon");
}

function verifyMeterlist() {
    fetchRoute(verifyMeterlistRequest, "verify-meters-icon");
}

function readMeterlist() {
    fetchRoute(readMeterlistRequest, "read-meters-icon")
}

function setIcon(function_, id) {
    if (window.whichFunctionRuns == function_) {
        var id = document.getElementById(id);
        id.classList.add("button-loader");
    } else {
        var id = document.getElementById(id);
        id.classList.add("original-color");
        if (function_ != "add_single_meter") {
            id.classList.add("play-circle");
        } else {
            id.classList.add("plus-square");
        }
    }
}

function fetchStatus(loadingPage, statusRequest) {
    /*fetch("/get_status", {
        credentials: "include",
        method: 'get',
        headers: {
            'Content-Type': 'application/json'
        },
    })*/
    fetch("/get_status", statusRequest)
    .then(response => response.json())
    .then(json => {
        window.status = json["status"];
        window.running = json["running"];
        window.whichFunctionRuns = json["whichFunctionRuns"]
        if (loadingPage) {
            setIcon("verify_meterlist", "verify-meters-icon");
            setIcon("read_meterlist", "read-meters-icon");
            setIcon("add_wired", "add-wired-icon");
            setIcon("add_wireless", "add-wireless-icon");
            setIcon("auto_create_myconfig", "auto-create-icon");
            setIcon("add_single_meter", "add-single-meter-icon");
        }
        if (window.running && !loadingPage) {
            //console.log("första");
            setTimeout(function(){ fetchStatus(false, statusRequest); }, 4000);
        } else if (!window.running && !loadingPage) {
            //console.log("andra");
            var loaders = document.getElementsByClassName("button-loader");
            if (loaders.length != 0)
            {
                var elementsWithLoader = document.getElementsByClassName("button-loader");
                elementsWithLoader[0].classList.add("original-color");
                if (elementsWithLoader.item(0).id == "add-single-meter-icon") {
                    elementsWithLoader[0].classList.add("plus-square");
                } else {
                    elementsWithLoader[0].classList.add("play-circle");
                }
                elementsWithLoader[0].classList.remove("button-loader");
            }
            loadMeterlist();
        } else if (window.running && loadingPage) {
            //console.log("tredje");
            loadMeterlist();
        } else if (!window.running && loadingPage) {
            //console.log("fjärde");
            loadMeterlist();
        }
        
    })
    .catch(err =>
        console.log("error in fetch "+err.message)
    )
}

function loadMeterlist() {
    window.addLoader();

    fetch(myRequest)
    .then(function(response){
        return response.json();
    })
    .then(function(json) {
        window.fetchedMeters = json["data"];
        window.meters = window.fetchedMeters;
        window.DeviceTypes = json["DeviceTypes"];
        window.csvDict = json["csvDict"];
        window.duplicate_entries = json["duplicate_entries"];
        window.running = json["running"];
        window.status = json["status"];
        window.search_result = json["search_result"];
        window.mbushubInfo = json["mbushubInfo"]
        for (var i = 0; i < window.meters.length;i++) {

            window.meters[i].order =  i;
        }


        window.setMinHeight();
        
        window.dupSet= {}
        for (n in window.duplicate_entries){
            var dupAddr = `${window.duplicate_entries[n][0]}.${window.duplicate_entries[n][1]}.${window.duplicate_entries[n][2]}.${window.duplicate_entries[n][3]}`;
            for (m in window.meters) {
                var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
                if (dupAddr == secAddr) {
                    window.dupSet[window.meters[m].order] = true;
                }
            }  
        }
        //if (window.duplicate_entries.length > 0){
        printDuplicates();
        //}
        
        addMbusHubInfo();

        window.printMeterlist();
        document.getElementById("list-loader").remove();
        document.getElementById("search-progress").remove();
        const keys = Object.keys(localStorage.csvDict);
        
        if (window.running) {
            setTimeout(function(){ fetchStatus(false, statusRequest); }, 4000);
        } 

        //window.updateStatusDiv();
        
    })
    .catch(function(err) {
        console.log("Fetch problem: " + err.message)
    });
};

//loadMeterlist();

function printDuplicates() {
    if (document.getElementById("duplicate-container") != null) {
        document.getElementById("duplicate-container").remove();
    }
    if (window.duplicate_entries.length > 0) {
        const duplicateInfoDiv = document.getElementById("duplicate-info-div");
        let duplicateContainer = document.createElement("div");
        duplicateContainer.id = "duplicate-container";
        duplicateContainer.classList.add("fail");
        let h3 = document.createElement("h3");
        h3.innerHTML = "Please remove the duplicates from your meterlist:";
        duplicateContainer.appendChild(h3);
        let duplicateList = document.createElement("ul");
        duplicateList.style.listStyle = "none";
        for (m in window.duplicate_entries) {
            let li = document.createElement("li");
            const secAddr = `${window.duplicate_entries[m][0]}.${window.duplicate_entries[m][1]}.${window.duplicate_entries[m][2]}.${window.duplicate_entries[m][3]}`;
            li.innerHTML = secAddr;
            duplicateList.appendChild(li);
        }
        duplicateContainer.appendChild(duplicateList);
        duplicateInfoDiv.appendChild(duplicateContainer);
    }
}

function addMbusHubInfo() {
    if (document.getElementById("mbushub-info-container") != null) {
        document.getElementById("mbushub-info-container").remove();
    }
    
    if (!window.mbushubInfo["mbushubOK"]) {
        let mbushubInfo = document.getElementById("mbushub-info-div");
        let container = document.createElement("div");
        container.id = "mbushub-info-container";
        let p = document.createElement("p");
        let p2 = document.createElement("p");
        mbushubInfo.classList.add("fail-text");
        p.innerHTML = `MBusHub version: ${window.mbushubInfo["mbushubVersion"]}`;
        p2.innerHTML = "You need to upgrade your MBusHub version";  
        container.appendChild(p);
        container.appendChild(p2);
        mbushubInfo.appendChild(container);
    }
}

function updateStatusDiv() {
    var statusDiv = document.getElementById("status-div");
    if (window.running) {
        statusDiv.classList.add("status-running");
        statusDiv.classList.remove("status-not-running");
        
    } else {
        if (statusDiv.classList.contains("status-running")) {
            statusDiv.classList.add("status-not-running");
        }
        statusDiv.classList.remove("status-running");
    }
    
    var status_div_loader = document.getElementById("status-div-loader");
    var status_div_text = document.getElementById("status-div-text");
    var status_div_search_result = document.getElementById("status-div-search-result");

    if (document.getElementById("status-p-text") != null) {
        document.getElementById("status-p-text").remove();
    }
    var p = document.createElement("p");
    p.id = "status-p-text";
    p.innerHTML = window.status;
    p.classList.add("status-div-text");
    var searchResultDiv = document.createElement("div");
    if (window.running) {
        if (document.getElementById("search-result-div") != null) {
            document.getElementById("search-result-div").remove();
        }
        
        searchResultDiv.id = "search-result-div";
        var statUl = document.createElement("ul")
        for (res in window.search_result) {
            var li = document.createElement("li");
            li.style.listStyle = "none";
            li.innerHTML = window.search_result[res];
            statUl.appendChild(li);
        }
        searchResultDiv.appendChild(statUl);
    }
    var loaderDiv = document.createElement("div");
    if (window.running && document.getElementById("status-loader") == null) {
        
        loaderDiv.classList.add("loader");
        loaderDiv.id = "status-loader";
    } else if (!window.running && document.getElementById("status-loader") != null) {
        document.getElementById("status-loader").remove();
    }
    status_div_loader.appendChild(loaderDiv);
    status_div_text.appendChild(p);
    if (window.running) {
        status_div_search_result.appendChild(searchResultDiv);
    } else {
        if (document.getElementById("search-result-div") != null) {
            document.getElementById("search-result-div").remove();
        }
    }
}

// To avoid the screen to jump when making a meterlist search
// The min-height is set to a div around the table
function setMinHeight() {
    var headHeight = 78;
    var tdHeight = 57;
    var minimumH = 78 + tdHeight*window.meters.length;
    document.getElementById("min-height-div").style.minHeight = minimumH.toString()+"px";
};

////////////////////////////////////////////
//             Sort functions             //
//////////////////////////////////////////// 

// Used to toggle the sorting order when pressing the id-number header text
var order = true;

// Sort the array on number for id-number and primary address
function sortByProperty(property) {
    if (window.order) {
        return function (a,b) {
            if (a[property] < b[property]) {
                return 1;
            } else if (a[property] > b[property]) {
                return -1;
            }
            return 0;
        }
    } else {
        return function (a,b) {
            if (a[property] > b[property]) {
                return 1;
            } else if (a[property] < b[property]) {
                return -1;
            }
            return 0;
        }
    }
}

function sortThis(property) {
    window.meters.sort(window.sortByProperty(property));
    
    // Toggle the sorting order
    window.order = !window.order;
    
    // Print the meterlist
    window.printMeterlist();
}

window.removeMeters = {};
// Toggle function to toggle between ON/OFF for each Mbus object and the statusbyte
function changeColor(cbox){
    var trash = document.getElementById(cbox);
    var name = trash.getAttribute("name");
    if (name == "STAY") {
        document.getElementById(cbox+"-row").style.backgroundColor="rgba(255,148,120,0.2)";
        trash.setAttribute("name", "REMOVE");
        trash.classList.toggle("original", false);
        trash.classList.toggle("colored", true);
        window.removeMeters[cbox] = true;
    } else {
        if (cbox % 2 == 0) {
            document.getElementById(cbox+"-row").style.backgroundColor="white";
        } else {
            document.getElementById(cbox+"-row").style.backgroundColor="rgb(242,242,242)";
        }
        trash.setAttribute("name", "STAY");
        trash.classList.toggle("original", true);
        trash.classList.toggle("colored", false);
        delete window.removeMeters[cbox];
    }
}

///////////////////////////////////////////

function downloadTemplate()
{
    window.location = "/downloadCsvFile?FILE=meterlist_template.csv";
}

function downloadEncryptionTemplate()
{
    window.location = "/downloadCsvFile?FILE=encryption_keys_template.csv";
}

function downloadEncryptionKeys()
{
    window.location = "/downloadEncryptionKeys?FILE=encryption_keys.txt";
}

function uploadMeterList()
{
    //var fileName = $('#meterlistfile').val();
    const fileName = document.getElementById("meterlistfile").value;

    if ((!endsWith(fileName, '.csv')) && (!endsWith(fileName, '.txt')))
    {
        alert(fileName + ' is not a valid filename, the name must end with .csv or .txt');
        return;
    }
    const meterlistfile = document.getElementById("meterlistfile").files[0];
    let formData = new FormData();
    formData.append("meterlistfile",meterlistfile);
    fetch('/upload_meterlist', {
        credentials: "include",
        method: "POST", 
        body: formData
    })
    .then(response => response.json())
    .then(json => {
        if (json["responseText"] == "ok")
        {
            loadMeterlist();
        }
    })
    .catch(err =>
        console.log("error in fetch "+err.message)
    )
}

function saveMeterFile()
{
    if (window.confirm('You are about to overwrite the saved file /config/meterlist.csv. Are You Sure?')) {
        window.location = "/copy_file_to_config?FILE=meterlist.csv";
    }
}
function removeMeterList()
{
    if (window.confirm('You are about to remove the file /tmp/meterlist.csv. Are You Sure?')) {
        window.location = "/remove_file?FILE=meterlist.csv";
    }
}

function downloadCsvFile()
{
    window.location = "/downloadCsvFile?FILE=meterlist.csv";
}

function copyMeterlist()
{
    if (window.confirm('You are about to overwrite the saved file /tmp/meterlist.csv. Are You Sure?')) {
        window.location = "/copyFromConfig"
    }
}
function startup_manual(input)
{
    var hashTag = input;
    window.location = "/startup_manual?HASHTAG=" + hashTag;
}

function controlInput() {
    var idInput = document.getElementById("id-number-input").value;
    var input_bg = document.getElementById("id-number-input-bg");
    var input_error_td = document.getElementById("id-number-input-error");
    if (document.body.contains(document.getElementById("id-number-input-error-text"))) {
        document.getElementById("id-number-input-error-text").remove();
    }
    if (isNaN(idInput)) {
        
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", true);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        var errorText = document.createElement("p");
        errorText.classList.toggle("fail-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Only digits allowed!";
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }
        
    }
    else if (idInput.length > 8 || isNaN(idInput)) {
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", true);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        var errorText = document.createElement("p");
        errorText.classList.toggle("fail-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Only 8 digits allowed!"
        //console.log("nr childNodes", input_error_td.childNodes.length );
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }
    }
    else if (idInput.length < 8 && !isNaN(idInput)) {
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", false);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        if (document.body.contains(document.getElementById("id-number-input-error-text"))) {
            document.getElementById("id-number-input-error-text").remove();
        }
    }
    else if (idInput.length == 8 && !isNaN(idInput)){
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", false);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", true);
        var errorText = document.createElement("p");
        errorText.classList.toggle("success-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Correct input!";
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }
    } 

}

function verifySingleMeter() 
{
    var idInput = document.getElementById("id-number-input").value;
    if (idInput.length == 8 && !isNaN(idInput)){
        window.location = "/addSingelMeter?IDINPUT=" + idInput;
    }
}

function showCsvFile()
{
    var select = document.getElementById("show-config-file");
    var val = select.value;
    window.open("/show_csv_file?FILE="+val);
}

function uploadEncryptionKeys()
{
    var encrypt_input = document.getElementById("upload-encryption-key-input").files[0];
    if ((!endsWith(encrypt_input.name, '.csv')) && (!endsWith(encrypt_input.name, '.txt')))
    {
        alert(encrypt_input.name + ' is not a valid filename, the name must end with .csv or .txt');
        return;
    }
    let formData = new FormData();

    formData.append("upload-encryption-keys_file", encrypt_input);
    fetch("/upload_encryption_keys", {
        credentials: "include",
        method: "POST", 
        body: formData
    })
    .then(function(response){
        return response.json();
    })
    .then(function(json) {
        window.encrypt_errorlist = json[0];
        var errorlist_div = document.getElementById("upload-encryption-keys-errorlist");
        if (window.encrypt_errorlist[0] != "NO_ERROR")
        {
            errorlist_div.classList.toggle("fail", true);
            for (var i = 0; i< window.encrypt_errorlist.length; i++){
                var p = document.createElement("p");
                var row = document.createTextNode(window.encrypt_errorlist[i].id+";"+window.encrypt_errorlist[i].key);
                p.appendChild(row);
                errorlist_div.appendChild(p);
            }
        }
        if (document.getElementById("encryption-info") == null) {
            var encryptionDiv = document.getElementById("upload-encryption-key-div");
            var div = document.createElement("div");
            div.id = "encryption-info";
            var p = document.createElement("p");
            var row = document.createTextNode("You need to restart the wireless module with \
                                                the file wireless_include_startup_config.csv \
                                                for the encrypted wireless meters to be \
                                                decoded correctly!");
            div.classList.add("info-text");
            p.appendChild(row);
            div.appendChild(p)
            encryptionDiv.appendChild(div);
        }
        window.loadMeterlist();                      

    })
    .catch(function(err) {
        console.log("Fetch problem: " + err.message)
    })
}

fetchStatus(true, statusRequest);