
////////////////////////////////////////////
// Fetching the meterlist when page loads //
////////////////////////////////////////////

const myInit = {
    credentials: "include",
    method: 'GET',
    headers:  {
        'Content-Type': 'application/json'
    },
};

let myRequest = new Request("/meterlist", myInit);

function editSlaveportFile() {
    window.open("/load_slaveport_file");
}

function printMeterlist() {
    var meterOutput = "";
    for (m in window.meters) {
        meterOutput += "<tr>";
        meterOutput += `<td>${parseInt(m)+1}</td>`;

        if (window.meters[m].type == "R") {
            meterOutput += `<td>Wireless</td>`;
        } else if (window.meters[m].type == "N") {
            meterOutput += `<td>Node</td>`;
        } else if (window.meters[m].type == "W") {
            meterOutput += `<td>Wired</td>`;
        } else {
            meterOutput += "<td></td>";
        }
        var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
        meterOutput += `
            <td>
            <button
                class=""
                type = "submit"
                name = "secAddress"
                value='${secAddr}'>${window.meters[m].id}</button>
            </td>`;

        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(window.meters[m].med)) {
            meterOutput += `
                <td>
                ${window.DeviceTypes[window.meters[m].med]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters[m].med}
                </td>
            `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(window.meters[m].mfct_str)) {
            meterOutput += `
                <td>
                ${window.csvDict[window.meters[m].mfct_str]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters[m].mfct_str}
                </td>
            `;
        }

        // Add the fabrication number to the meterlist
        if (window.meters[m].fab) {
            meterOutput += `
                <td>
                ${window.meters[m].fab}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the prim number
        if (window.meters[m].prim) {
            meterOutput += `
                <td>
                ${window.meters[m].prim}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        // Check if meter is inMyConfig list

        if (window.inMyConfig.includes(secAddr)) {
            meterOutput += `
                <td>
                <img src="../../img/status-20.png" />
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                <img src="../../img/status-0.png" />
                </td>
            `;
        }


        //meterOutput += `<td>${meters[m].id}</td>`;
        meterOutput += "</tr>"
    }
    //meterOutput += "</table>";
    document.getElementById("meterDiv").innerHTML = meterOutput;
    if (document.getElementById("loaderDiv") != null) {
        document.getElementById("loaderDiv").remove();
    }

}

function fetchStatus() {
    fetch("/get_status", {
        credentials: "include",
        method: 'get',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
    })
    .then(response => response.json())
    .then(json => {
        window.status = json["status"];
        window.running = json["running"];
        if (window.running) {
            setTimeout(fetchStatus, 4000);
        } else {
            removeSpinner();
            loadMyMetersMeterlist();
        }

    })
    .catch(err =>
        console.log("error in fetch "+err.message)
    )
}

function loadMyMetersMeterlist() {
    fetch(myRequest)
    .then(function(response){
        return response.json();
    })
    .then(function(json) {
        window.fetchedMeters = json["data"];
        window.meters = window.fetchedMeters;

        window.duplicate_entries = json["duplicate_entries"];
        window.inMyConfig = json["inMyConfig"];

        window.setMinHeight();
        printDuplicates();
        window.printMeterlist();
    })
    .catch(function(err) {
        console.log("Fetch problem: " + err.message)
    });
}

// To avoid the screen to jump when making a meterlist search
// The min-height is set to a div around the table
function setMinHeight() {
    var headHeight = 78;
    var tdHeight = 57;
    var minimumH = 78 + tdHeight*window.meters.length;
    document.getElementById("min-height-div").style.minHeight = minimumH.toString()+"px";
};


///////////////////////////////////////////

function uploadMeterList()
{
    var fileName = $('#meterlistfile').val();
    if ((!endsWith(fileName, '.csv')) && (!endsWith(fileName, '.txt')))
    {
    alert(fileName + ' is not a valid filename, the name must end with .csv or .txt');
    return;
    }
    $('#uploadMeterlist').submit();
}

function createMyConfig(modbus) {
    var device_format= document.getElementById("device_name_format").value;
    var channel_name = document.getElementById("channel_name").value;
    const number_of_telegrams = document.getElementById("number_of_telegrams").value;

    const returnValues = {
        "device_format": device_format,
        "channel_name": channel_name,
        "modbus": modbus,
        "max_value_age":60,
        "number_of_telegrams":number_of_telegrams
    };
    
    fetch("/create_main_csv_file", {
        credentials: "include",
        method: "post",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(returnValues)
    })
    .then(response => response.json())
    .then(json => {
        window.running = json["running"];
        window.status = json["status"];
        window.functionDidStart = json["functionDidStart"];
        if (window.functionDidStart) {
            addSpinner();
            setTimeout(fetchStatus, 4000);
        }

    })
    .catch(err =>
    console.log("fetch error: "+err.message)
    )
}

function printDuplicates() {
if (document.getElementById("duplicate-container") != null) {
    document.getElementById("duplicate-container").remove();
}
if (window.duplicate_entries.length > 0) {
    const duplicateInfoDiv = document.getElementById("duplicate-info-div");
    let duplicateContainer = document.createElement("div");
    duplicateContainer.id = "duplicate-container";
    duplicateContainer.classList.add("fail");
    let h3 = document.createElement("h3");
    h3.innerHTML = "Please remove the duplicates from your meterlist:";
    duplicateContainer.appendChild(h3);
    let duplicateList = document.createElement("ul");
    duplicateList.style.listStyle = "none";
    for (m in window.duplicate_entries) {
        let li = document.createElement("li");
        const secAddr = `${window.duplicate_entries[m][0]}.${window.duplicate_entries[m][1]}.${window.duplicate_entries[m][2]}.${window.duplicate_entries[m][3]}`;
        li.innerHTML = secAddr;
        duplicateList.appendChild(li);
    }
    duplicateContainer.appendChild(duplicateList);
    duplicateInfoDiv.appendChild(duplicateContainer);
}
}

function addSpinner() {
    if (document.getElementById("spinner-container") == null) {
        var spinnerDiv = document.getElementById("spinnerDiv");
        var container = document.createElement("div");
        container.classList.add("search-container");
        container.id = "spinner-container";
        var loader = document.createElement("div");
        loader.classList.add("loader");
        var h2 = document.createElement("h2");
        h2.classList.add("search-progress");
        h2.innerHTML = "Creating myconfig.csv...";
        container.appendChild(loader);
        container.appendChild(h2);
        spinnerDiv.appendChild(container);
    }
}

function removeSpinner() {
    if (document.getElementById("spinner-container") != null) {
        document.getElementById("spinner-container").remove();
    }
}

function showCsvFile()
{
    const select = document.getElementById("show-config-file");
    const val = select.value;
    window.open("/show_csv_file?FILE="+val);
}
loadMyMetersMeterlist();
