function printTable(table, dupSet) {
    var tableContent = document.getElementById("table-content");
    var out = "";
    console.log("in printtable");
    for (var i = 0; i < length; i++) {
      console.log("i", i);
      if (dupSet.hasOwnProperty(i)) {
        console.log("inf ail")
        out += `<tr class="fail-bg-color">`;
      } else {
        out += "<tr>";
      }
      out += `<td>${i+1}</td>`;
      out += `<td><input
                    id=${i}
                    type="text"
                    value="${table[i][1]}" /></td>`;
      out += `<td>${table[i][3]}</td>`;
      out += `<td>${table[i][4]}</td>`;
      out += "</tr>";
    }
    tableContent.innerHTML = out;
  }

  function populateTable() {
    var dupSet = {};
    fetch("/edit_slaveport_file", {
      credentials: "include",
      method: "GET",
      headers: {
        "Content-Type": "application/json"
      }
    })
    .then(response => response.json())
    .then(json => {
      table = json["table"];
      console.log("table", table);
      length = json["length"];
      console.log("length", length);
      printTable(table, dupSet);
    })
    .catch(err =>
      console.log("Fetch error in edit_slaveportFile: " + err.message)
    )
  }

  function saveSlaveportFile() {
    var infoDiv = document.getElementById("info-div");
    console.log("length in save", length);
    var registers = [];
    for (var i = 0; i < length; i++) {
      var register = document.getElementById(i).value;
      registers.push(register);
    }

    fetch("/save_slaveport_file", {
      credentials: "include",
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify(registers)
    })
    .then(response => response.json())
    .then(json => {
      var dupSet = {};
      if (json["duplicates"]) {
        var duplicates = json["duplicates"];
        var registers = json["registers"];
        for (var i = 0; i < length; i++) {
          table[i][1] = registers[i];
        }
        infoDiv.classList.toggle("success", false);
        infoDiv.classList.toggle("fail", true);
        infoDiv.textContent = "Duplicates. Register: ";
        const keys = Object.keys(duplicates);
        console.log("keys", keys);
        for (var i = 0; i < keys.length; i++) {
          const key = keys[i];
          for (var j = 0; j < duplicates[key].length; j++) {
            infoDiv.textContent += `${duplicates[key][j]+1} `;
            dupSet[duplicates[key][j]] = "duplicate";
          }
        }
        console.log("table in dup", table);
        console.log("length in dup", length);
        console.log("dupSet",dupSet);
        printTable(table, dupSet);
      } else {
        table = json["table"];
        length = json["length"];
        infoDiv.classList.toggle("fail", false);
        infoDiv.classList.toggle("success", true);
        infoDiv.textContent = "Registers successfully saved, you can close this window now.";
        printTable(table, dupSet);
      }
    })
    .catch(err => {
      infoDiv.classList.toggle("fail", true);
      infoDiv.textContent = "Could not save the registers!!";
    })
  }
  var length = 0;
  var table = [];
  populateTable();