function addSpinner() {
    var spinner = document.getElementById("showSpinner");
    var container = document.createElement("div");
    container.id = "loader-container";
    var div = document.createElement("div");
    div.classList.add("loader");
    div.id = "loader-div";
    var p = document.createElement("p");
    p.innerHTML = "Creating template file, please wait for page to reload...";
    container.appendChild(div);
    container.appendChild(p);
    spinner.appendChild(container);
}

function handleFormatChanged() {
    const formatSelect = document.querySelector("#format")
    const timeFormatSelect = document.getElementById("time_stamp")
    const tagTypeSelect = document.getElementById("tag_type")

    const timeFormatOptions = timeFormatSelect.options
    const tagTypeOptions = tagTypeSelect.options

    timeFormatOptions[0].disabled = false // (8)
    timeFormatOptions[1].disabled = false // (16)
    timeFormatOptions[2].disabled = false // (24)
    
    tagTypeOptions[0].disabled = false // value (1)
    tagTypeOptions[1].disabled = false // record (8)

    const format = formatSelect.value
    switch(format) {
        case "1":
            timeFormatOptions[1].selected = true
            timeFormatOptions[0].disabled = true 
            timeFormatOptions[2].disabled = true
            tagTypeOptions[1].selected = true // record
            break
        case "2": 
            timeFormatOptions[1].selected = true
            timeFormatOptions[0].disabled = true
            timeFormatOptions[2].disabled = true
            tagTypeOptions[1].selected = true // record
            break
        case "3":
            timeFormatOptions[2].selected = true
            tagTypeOptions[1].selected = true // record
        break
        case "4":
            break
        case "5":
            // user defined
            break
        default:
            console.error("selected undefined format")
            break
    }

}

function removeSpinner() {
    var spinner = document.getElementById("loader-container");
    spinner.remove();
}

function autoTemplateGenerator() {
    const format = document.querySelector("#format").value
    const time_format = document.querySelector("#time_stamp").value
    const tag_type = document.querySelector("#tag_type").value
    const timestamp = document.querySelector("#time_stamp_telegram").value
    const time_record_no = document.querySelector("#time_record_no").value
    const read_period = document.querySelector("#read_period").value
    const read_offset = document.querySelector("#read_offset").value
    const number_of_telegrams = 3;
    
    const payload = {
        "format":format,
        "time_stamp":time_format,
        "tag_type":tag_type,
        "time_stamp_telegram":timestamp,
        "time_record_no":time_record_no,
        "read_period":read_period,
        "read_offset":read_offset,
    }

    fetch(`/auto_template_generator?number_of_telegrams=${number_of_telegrams}`, {
        credentials: "include",
        method: 'post',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(payload)
    })
    .then(response => response.json())
    .then(json => {
        window.functionDidStart = json["functionDidStart"];
        window.running = json["running"];
        window.status = json["status"];

        if (window.functionDidStart) {
            var autoCreateIcon = document.getElementById("auto-template-generator-icon");
            autoCreateIcon.classList.remove("play-circle");
            autoCreateIcon.classList.remove("original-color");
            autoCreateIcon.classList.add("button-loader");
        }
        fetchTemplateStatus(false);

    })
    .catch(err =>
        console.log("error in fetch "+err.message)
    )
}

function addLoader(){
    if (document.getElementById("list-loader") == null) {
        var loaderDiv = document.getElementById("loaderDiv");
        var loader = document.createElement("div");
        loader.id = "list-loader";
        loader.classList.add("loader");

        var h2 = document.createElement("h2");
        h2.id = "search-progress";
        h2.classList.add("search-progress");
        h2.innerHTML = "Loading Templates...";
        loaderDiv.appendChild(loader);
        loaderDiv.appendChild(h2);
    }
}

function loadTemplateTypes() {
    addLoader();
    fetch("/load_template_types", {
        credentials: "include",
        method: "get",
        headers: {
            "Content-Type": "application/json"
        },
    })
    .then(response => response.json())
    .then(json => {

        window.meters = json['singleTypeMeterlist'];
        printMeter();
        document.getElementById("list-loader").remove();
        document.getElementById("search-progress").remove();
    })
    .catch(err => {
        console.log("error fetch: "+err.message)
    }
    )
}

function setIcon(function_, id) {
    if (window.whichFunctionRuns == function_) {
        var id = document.getElementById(id);
        id.classList.add("button-loader");
    } else {
        var id = document.getElementById(id);
        id.classList.add("original-color");
        id.classList.add("play-circle");
    }
}

function fetchTemplateStatus(loadingPage) {
    fetch("/get_status", {
        credentials: "include",
        method: 'get',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
    })
    .then(response => response.json())
    .then(json => {
        window.status = json["status"];
        window.running = json["running"];
        window.whichFunctionRuns = json["whichFunctionRuns"]
        if (loadingPage) {
            setIcon("auto_template_generator", "auto-template-generator-icon");
        }
        if (window.running && !loadingPage) {
            //console.log("första");
            setTimeout(function(){ fetchTemplateStatus(false); }, 4000);
        } else if (!window.running && !loadingPage) {
            //console.log("andra");
            var elementsWithLoader = document.getElementsByClassName("button-loader");
            elementsWithLoader[0].classList.add("original-color");
            elementsWithLoader[0].classList.add("play-circle");
            elementsWithLoader[0].classList.remove("button-loader");
            loadTemplateTypes();
        } else if (window.running && loadingPage) {
            //console.log("tredje");
            loadTemplateTypes();
            setTimeout(function(){ fetchTemplateStatus(false); }, 4000);
        } else if (!window.running && loadingPage) {
            //console.log("fjärde");
            loadTemplateTypes();
        }

    })
    .catch(err =>
        console.log("error in fetch "+err.message)
    )
}

function printMeter() {
    var meterOutput = "";
    for (m in window.meters) {
        var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
        if (window.meters[m].fab) {
            secAddr += ":" + window.meters[m].fab;
        }

        meterOutput += `<tr>`;

        meterOutput += `<td>${parseInt(m)+1}</td>`;
        
        if (`${window.meters[m].mfct_str}` == "ABB" && `${window.meters[m].ver}` == "20") {
            const template_name = `${window.meters[m].mfct}_${window.meters[m].ver}_${window.meters[m].med}_${window.meters[m].mfct_spec_ver}`;
        } else {
            const template_name = `${window.meters[m].mfct}_${window.meters[m].ver}_${window.meters[m].med}`;
        }

        if (window.meters[m].is_found) {
            meterOutput += `
                <td>
                <button
                    class=""
                    type = "submit"
                    name = "secAddress"
                    value='${secAddr}' disabled>${window.meters[m].id}</button>
                </td>`;
        } else {
            meterOutput += `
                <td>
                <button
                    class=""
                    type = "submit"
                    name = "secAddress"
                    value='${secAddr}'>${window.meters[m].id}</button>
                </td>`;
        }
        // Template name
        if (`${window.meters[m].mfct_str}` == "ABB" && `${window.meters[m].ver}` == "20") {
            meterOutput += `<td>${window.meters[m].mfct}_${window.meters[m].ver}_${window.meters[m].med}_${window.meters[m].mfct_spec_ver}</td>`
        } else { 
            meterOutput += `<td>${window.meters[m].mfct}_${window.meters[m].ver}_${window.meters[m].med}</td>`;
        }

        if (window.meters[m].type == "R") {
            meterOutput += `<td>Wireless</td>`;
        } else if (window.meters[m].type == "N") {
            meterOutput += `<td>Node</td>`;
        } else if (window.meters[m].type == "W") {
            meterOutput += `<td>Wired</td>`;
        } else {
            meterOutput += "<td></td>";
        }

        meterOutput += `<td>${window.meters[m].time_stamp}</td>`;

        meterOutput += `<td>${window.meters[m].read_period}</td>`;

        meterOutput += `<td>${window.meters[m].tag_type}</td>`;

        meterOutput += `<td>${window.meters[m].time_stamp_telegram}</td>`;

        meterOutput += `<td>${window.meters[m].time_record_no}</td>`;

        meterOutput += "</tr>"
    }
    document.getElementById("metersToLoad").innerHTML = meterOutput;
}


function refreshPage()
{
    window.location.pathname = "/secondary_search";
}

function saveTemplateFile()
{
    if (window.confirm('You are about to overwrite the saved file /config/template.csv. Are You Sure?')) {
    window.location = "/copy_file_to_config?FILE=template.csv";
    }
}

function removeTemplateFile()
{
    if (window.confirm('You are about to remove the file /tmp/template.csv. Are You Sure?')) {
    window.location = "/remove_file?FILE=template.csv";
    }
}

function showCsvFile(val)
{
    window.open("/show_csv_file?FILE="+val);
}


fetchTemplateStatus(true);
