function showLicenseStr() {
    const licenseContainer = document.getElementById("license-container")
    const showLicenseButton = document.getElementById("showLicenseButton")
    const copyButton = document.getElementById("copyToClipboardButton")
    copyButton.onclick = async () => await copyLicenseToClipboard()
    const showMsg = "Show License"
    const hideMsg = "Hide License"
    if (!navigator.clipboard) {
        copyButton.hidden = true
    }

    if (licenseContainer.hidden) {
        licenseContainer.hidden = false
        showLicenseButton.textContent = hideMsg

    } else {
        showLicenseButton.textContent = showMsg
        licenseContainer.hidden = true
    }

}

async function copyTextToClipboard(license) {

    if (navigator.clipboard) {
        try {
            console.log("copying with clipboard api")
            await navigator.clipboard.writeText(license)
            console.log("Successfully copied license.")
            return
        } catch (error) {
            console.error("Failed to copy license to clipboard.")
        }
    }
}

async function copyLicenseToClipboard() {
    const license = document.getElementById("license").textContent
    console.log("license", license)
    await copyTextToClipboard(license)
}


function initAdministration() {
    var licenseLabel = $('#LicenseLabel');
    var usrKey = $('#userKey');
}

function querySt(ji) {

    hu = window.location.search.substring(1);
    gy = hu.split("&");

    for (i = 0; i < gy.length; i++) {
        ft = gy[i].split("=");
        if (ft[0] == ji) {
            return ft[1];
        }
    }
}

const resetConfiguration = async (softwareName) => {
    const validSoftwareNames = [
        'system',
        'mbushub',
        'quickpost',
        'modbus2mbus',
        'wireless',
        'web',
        'ip'
    ]
    const feedback = document.getElementById('feeback-basic-settings')
    const exists = validSoftwareNames.filter((value) => value === softwareName).length >= 1;
    console.log(exists)
    if (!exists) {
        console.error(`Unable to reset configuration of softwareName: ${softwareName}, could not find it in the list of valid names.`);
        return;
    }


    try {

        const req = await fetch('/defaultSettings?DEFSET='+softwareName)
        if (req.ok) {
            feedback.innerText = `${softwareName} configuration is now set to default.`
        }
    } catch (err) {
        feedback.innerText = `Failed to set ${softwareName} configuration to default. ${err}`
    }
    
}


const setWebSecurityConfiguration = async () => {
    const radioButtons = document.querySelectorAll('input[name="webserver-setting"]');
    let selectedValue = "";
    for (const radioButton of radioButtons) {
        if (radioButton.checked) {
            selectedValue = radioButton.value;
            break;
        }
    }

    if (selectedValue === "") {
        console.error('selected webserver value setting was empty')
        return;
    }
    try {

        const response = await fetch('/setWebConf', {
            credentials: 'include',
            body: JSON.stringify({
                'selected': selectedValue
            }),
            headers: {
                'Content-type':'application/json'
            }
            ,method: "POST"
        })

        if (response.ok) {

            const data = await response.json();
            const feedback = document.getElementById('webserver-settings-feedback')
            if (feedback !== null) {
                feedback.innerText = data.message
            }
            
            window.location.reload()
        }

    }catch(err) {
        console.error('failed to fetch ', err )
    }
}

document.getElementById('password-form').addEventListener('submit', (event) => {
    event.preventDefault()
    changePassword()
})

const changePassword = async () => {
    const passwordFeedback = document.getElementById('password-strength-feedback')
    const route = "/changePassword"
    const formData = new FormData(document.getElementById('password-form'))
    
    const payload = {};
    formData.forEach(function(value, key){
        payload[key] = value;
    });
    const json = JSON.stringify(payload);
    try {

        const response = await fetch(route, {
            body: json,
            method: 'POST',
            credentials: 'include',
            headers: {'Content-Type': 'application/json'}
        })

        const data = await response.json()
        passwordFeedback.innerHTML = ""
        passwordFeedback.innerText = data.message
        
    } catch (err) {
        passwordFeedback.innerHTML = ""
        passwordFeedback.innerText = err.message
    }
}

const onPasswordChanged = (pw) => {
    const passwordFeedback = document.getElementById('password-strength-feedback')
    const result = zxcvbn(pw, ['Admin','admin'])
    passwordFeedback.style.minHeight = "100px"
    passwordFeedback.innerHTML = ""
    const appendPasswordSuggestions = (suggestions, node) => {
        suggestions.forEach((value, index, array) => {
            const suggestion = document.createElement('li')
            suggestion.innerText = value
            node.appendChild(suggestion)
        })
    }
    if (pw !== null && pw.length !== 0) {
        
        const listNode = document.createElement('ul')
        listNode.className = "flow"
        const suggestions = [...result.feedback.suggestions]
        const time = result.crack_times_display.offline_slow_hashing_1e4_per_second + " (offline attack)"
        if (result.feedback.warning !== "") {
            suggestions.unshift("Warning: " + result.feedback.warning)
        } 
        if (pw.length < 8) {
            suggestions.unshift('Warning: You must have a minimum of 8 characters in your password.')
        }
        suggestions.push("Your password can be guessed in: " + time)
        appendPasswordSuggestions(suggestions, listNode)       
        passwordFeedback.appendChild(listNode)
    }

}

const setIdentification = async () => {
    const identity = document.getElementById('identification').value ?? null
    
    if (identity === null) {
        console.err('could not find input with id: "identity"')
        return
    }

    console.log("identity" , identity)
    const res = await fetch('/identity', {
        method: 'POST',
        credentials: 'include',
        headers: {
            'content-type':'application/json'
        },
        body: JSON.stringify({"identity": identity })
    })
    
    const feeback = document.getElementById('identity-feedback')
    if (res.ok) {
        feeback.innerText = `Identity set, please reload the page to see the changes.`
    } else {
        feeback.innerText = "Failed to change identity"
    }

}

initAdministration();