/** this file should be for common methods used for multiple scripts to reduce code duplication and simplify caching  **/

/** fetch device types and store in window for now. should just make a let variable instead **/
const fetchDevicetypes = async () => {
    try {
        const hash = file_hashes.device_types
        const res = await fetch('/device_types?hash='+hash, {
            credentials:'include',
            method: 'GET',
        })
        const devices = await res.json()
        console.log(devices)
        window.DeviceTypes = devices
    } catch (error) {
        console.error(error)
    }
}

/** fetch manufacturer list and store in window for now (31 KB) call sparingly. will be cached after first call, see backend headers.
 * should just make a let variable instead **/
const fetchManufacturerList = async () => {
    try {
        const hash = file_hashes.manufacturers
        const res = await fetch('/manufacturers.txt?hash='+hash, {
            credentials:'include',
            method: 'GET',
        })
        let csvDict = {}
        const manufacturers = await res.text()
        for (line in manufacturers.split('\n')) {
            const kv = line.split('\t', 2)
            const k = kv[0]
            const val = kv[1]
            csvDict = Object.assign(csvDict, {k : val})
        }
        window.csvDict = {...csvDict}
        delete csvDict
    } catch (error) {
        console.error(error)
    }
}

fetchDevicetypes()
fetchManufacturerList()