
let packages = []
let availableTimezones = null
let selectedTimezone = null
const installFeedback = document.getElementById('install-feedback')

const API = "/api/v1/"

const updateOpkgButton = document.getElementById('update-software-list-button')
if (updateOpkgButton !== null) {
    updateOpkgButton.onclick = async () => {
        updateOpkgButton.disabled = true
        let text = updateOpkgButton.innerText
        updateOpkgButton.innerText = "Updating..."
        try {
            await updatePackageList()
            updateOpkgButton.innerText = text
        } catch(e) {
            updateOpkgButton.innerText = "failed to update list"
        }
        updateOpkgButton.disabled = false
    }

}



async function reboot() {
    if (confirm('Are you sure you want to reboot the Pi-900?')) {
        try {

            const response = await fetch("/reboot", {
                method: "POST",
                credentials: "include"
            })
            const feedback = document.getElementById('reboot-feedback')
            if (response.ok) {
                feedback.innerText = "System will now reboot, please wait a few minutes and then try to refresh the page." 
            }

        } catch (err) {
            feedback.innerText = "failed to reboot system: " + err
        }

    }
}

function uploadCsvFile() {
    const fileName = document.getElementById('conffile').value;
    if ((!endsWith(fileName, '.csv')) && (!endsWith(fileName, '.xml')) && (!endsWith(fileName, '.ini'))) {
        alert(fileName + ' is not a valid filename, the name must end with .csv, .xml or .ini');
        return;
    }

    document.getElementById('ffilens').submit()
}

function rmCsvFile() {
    if (window.confirm('Are you sure you want to remove this CSV/XML file?')) {
        const csvRmFile = document.getElementById('conffile').value.replace(" ", "%20");
        window.location = "/rmCsvFile?CSVRMF=" + csvRmFile;
    }

}

function downloadCsvFile() {
    let csvRmFile = document.getElementById("csvseldl").value;
    window.location = "/downloadCsvFile?FILE=" + encodeURIComponent(csvRmFile);
}

function setUnsetRandIP() {
    let ipMode = document.getElementById("randomip");
    if (ipMode.value == 'Set') {
        ipMode.value = 'Unset';
    }
    else {
        ipMode.value = 'Set';
    }
}

function refreshPage() {
    window.location.pathname = "/administration";
}

function uploadConf() {
    const fileName = document.getElementById('conffile').value;
    if (!fileName.endsWith('mbushub.ini')) {
        alert(fileName + ' is not a valid filename, the name must be mbushub.ini');
        return;
    }
    if (window.confirm("Are you sure you want to replace the current configuration file?"))
        document.getElementById('ffilens').submit();
}

function rmCsvFile() {
    if (window.confirm('Are you sure you want to remove this CSV/XML file?')) {
        let csvRmFile = document.getElementById("csvselrm").value.replace(" ", "%20");
        window.location = "/rmCsvFile?CSVRMF=" + csvRmFile;
    }
}

function downloadCsvFile() {
    let csvRmFile = document.getElementById("csvseldl").value;
    window.location = "/downloadCsvFile?FILE=" + encodeURIComponent(csvRmFile);
}

function setUnsetRandIP() {
    if (document.getElementById('randomip').value === 'Set') {
        document.getElementById('randomip').value = 'Unset';
    }
    else {
        document.getElementById('randomip').value = 'Set';
    }
}

function refreshPage() {
    window.location.pathname = "/administration";
}

function uploadBackupConf() {
    let fileName = document.getElementById('bconffile').value
    if (fileName.endsWith('_backup.tgz')) {
        alert(fileName + ' is not a valid filename.\nThe name must be a proper config backup file _backup.tgz');
        return;
    }
    if (window.confirm("Are you sure you want to replace the current configuration files?"))
        document.getElementById('bffilens').submit();
}


function showSpinner(show) {
    const container = document.getElementById('spinner-container')
    container.width = 32;
    container.height = 32;
    const spinnerID = "spinner-icon"
    let spinner = document.getElementById(spinnerID)
    
    if (spinner === null) {
        spinner = document.createElement('img')
        spinner.width = 32;
        spinner.height = 32;
        spinner.alt = "installing"
        spinner.src = "img/spinner.gif"
        spinner.id = spinnerID
        spinner.style.display = "block"
        container.appendChild(spinner)
    }
    spinner.style.visibility = show ? "visible" : "hidden"
}


const upgradeOPKGPackage = async (packageName) => {

    const response = await fetch(`${API}system/packages/upgrade`, {
            method: "POST",
            credentials: "include",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({ "package_name": packageName })
    })
    return response
}

const installOPKGPackage = async (packageName) => {
    const response = await fetch(`${API}system/packages/install`, {
            method: "POST",
            credentials: "include",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({ "package_name": packageName })
    })
    return response
}



function renderPackageTable() {
    console.log("Loading list")
    const table = document.getElementById("opkg-package-view")
    table.innerHTML = "Updating list..."
    
    table.innerHTML = ""
    for (let index in packages) {
        const package = packages[index]
        const package_name = package.name
        const package_version = package.version
        const next_version = package.next_version
        const is_installed = package.is_installed
        const canUpgrade = is_installed && next_version !== null && next_version !== "-"

        
        const style = "max-width: 160px"
        
        const row = document.createElement('tr')
        const nameCell = document.createElement('td')
        const currentVersionCell = document.createElement('td')
        const nextVersionCell = document.createElement('td')
        const buttonCell = document.createElement('td')


        nextVersionCell.style = style
        currentVersionCell.style = style
        buttonStyle = "margin-right: auto;"
        buttonClass = "btn";

        nameCell.innerText = package_name
        currentVersionCell.innerText = package_version
        nextVersionCell.innerText = next_version ?? "-"

        if (is_installed) {
            currentVersionCell.innerText = package_version
       
            const btn = document.createElement('button')
            btn.classList.add(buttonClass)
            btn.innerText = "Upgrade"
            btn.disabled = true
            if (canUpgrade) {
                btn.disabled = false
                btn.onclick = async () => {
                    showSpinner(true)
                    btn.disabled = true
                    btn.innerText = "Upgrading..."
                    const res = await upgradeOPKGPackage(package_name)
                    if (res.ok) {
                        btn.innerText = "Updated"
                        currentVersionCell.innerText = nextVersionCell.innerText
                        nextVersionCell.innerText = "-" 
                    }else {
                        btn.innerText = "Failed upgrade"
                        btn.disabled = false
                    }
                    showSpinner(false)
                }
            }
            buttonCell.appendChild(btn)
            
        }else if (!is_installed) {
            const button = document.createElement('button')
            button.style = buttonStyle
            button.classList.add(buttonClass);
            button.innerText = "Install"
            currentVersionCell.innerText = "Not installed"

            button.onclick = async () => {
                showSpinner(true)
                button.disabled = true
                button.innerText = "Installing..."
                const res = await installOPKGPackage(package_name)

                if (res.ok) {
                    button.innerText = "Installed"
                    nextVersionCell.innerText = ""
                    currentVersionCell.innerText = next_version
                } else {
                    button.innerText = "Failed install"
                }
                showSpinner(false)
            }
            buttonCell.appendChild(
                button    
            )
        } else if (canUpgrade) {
            const button = document.createElement('button')
            button.style = buttonStyle
            button.classList.add(buttonClass)
            button.innerText = "Upgrade"
            button.onclick = async () => {
                showSpinner(true)
                button.disabled = true
                button.innerText = "Updating..."

                const res = await upgradeOPKGPackage(package_name)
                if (res.ok) {
                    button.innerText = "Updated"
                    button.disabled = true
                    nextVersionCell.innerText = "Up to date"
                } else {
                    button.innerText = "Failed Update"
                }

            }

            buttonCell.appendChild(button)
        }

        row.append(
            nameCell, currentVersionCell, nextVersionCell, buttonCell
        )
        table.appendChild(row)
    };
}

async function fetchOpkgInstalledList() {
    try {
        const response = await fetch(`${API}system/packages`, {
            headers: {
                "Content-Type": "application/json"
            },
            credentials: 'include'
        })

        const data = await response.json()
        return data
    } catch (err) {
        console.error("Failed getting installed packages: ", err)
        return []
    }
}

async function fetchOpkgUpgradablePackageList() {
    try {

        const response = await fetch(`${API}system/packages/update`, {
            headers: {
                "Content-Type": "application/json"
            },
            credentials: 'include',

        })

       
        const data = await response.json()
        if (!response.ok) {
            
            switch (response.status) {
                case 423:
                    installFeedback.innerText = "Failed to update, already installing or updating. please wait!"
                    break
                default:
                    installFeedback.innerText = "Failed to update."
            }
        }

        return data
    } catch (err) {
        console.error("Failed getting upgradable packages: ", err)
        return []
    }
}

function showFile() {
    let fileName = document.getElementById('inifilesel').value
    window.open("/showFile?FILE=" + fileName);
}

function enableSecurity(form) {
    if (window.confirm('Are you sure you want to enable security?'))
        form.submit();
}

const setTimeAndDate = async () => {
    const newDt = document.getElementById('TimeDate').value;
    
    
    try {
        const response = await fetch('/setClock', {
            credentials: 'include',
            body: JSON.stringify({'TimeDate': newDt}),
            method: 'POST',
            headers: {
                'content-type':'application/json'
            }
        })
        const feeback = document.getElementById('timedate-feedback')
        if (response.ok) {
            feeback.innerText = 'Date set to ' + newDt
        } else {
            feeback.innerText = 'Failed to set new date time'
        }
    }
    catch (err) {
        feeback.innerText = 'Something went wrong when setting date, ' + err
    }

}

const timeDateBtn = document.getElementById('set-timedate-button')
timeDateBtn.onclick = async () => {
    timeDateBtn.disabled = true
    await setTimeAndDate()
    timeDateBtn.disabled = false
}

const fetchSelectedTimezone = async () => {
    try {
        const response = await fetch('/selected-timezone', {
            method: 'GET',
            credentials: 'include'
        })
        const data = await response.json()
        selectedTimezone = data.selected_timezone
        document.getElementById('timezones-select').value = selectedTimezone
    }catch(err) {
        feedback.innerText = "Failed to get selected timezone: " + err
    }
}

const testConnectivity = async () => {
    const feeback = document.getElementById('test-connection-feeback')
    const ipInput = document.getElementById('test-ping-ip')
    if (ipInput == null) {
        console.error("failed to get test-ping-ip")
        return
    }
    
    
    const ip = ipInput.value
    feeback.innerText = "Pinging address please wait..."
    const res = await fetch(`/test-connection?ip=${ip}`)
    
    if (res.ok) {
        feeback.innerText = `You successfully pinged address: ${ip}`
    } else {
        feeback.innerText = `Failed to ping ${ip}`
    }
}

const setTimeZone = async () => {
    const value = document.getElementById('timezones-select').value
    const feedback = document.getElementById('timezone-feedback')
    try {
        const response = await fetch('/selected-timezone', {
            method: 'POST',
            credentials: 'include',
            headers: {
                'content-type':'application/json'
            },
            body: JSON.stringify(
                {"selected_timezone": value}
            )
        })


        if (!response.ok) {
            console.error('Failed to set timezone')
            feedback.innerText = "Failed to set timezone"
        }
        else {
            feedback.innerText = "Setting timezone to " + value
        }
    }catch(err) {
        feedback.innerText = "Error when setting timezone: " + err
    }
}

const fetchAvailableTimezones = async () => {
    if (availableTimezones !== null) return

    try {
        const response = await fetch('/available-timezones', {
            method: 'get',
            credentials: 'include'
        })
        const select = document.getElementById('timezones-select')
        select.innerHTML = ""
        const data = await response.json()
        availableTimezones = [...data] 
        data.forEach((value, index, array) => {
            const option = document.createElement('option')
            option.value = value
            option.innerText = value
            option.selected = selectedTimezone === value 
            select.appendChild(option)
        })
    } catch (err) {
        console.log(err)
    }

}

fetchAvailableTimezones()
fetchSelectedTimezone()


const updateInstalledPackages = async () => {
    showSpinner(true)
    packages = await fetchOpkgInstalledList()
    showSpinner(false)
    renderPackageTable()
}

const updatePackageList = async () => {
    showSpinner(true)
    packages = await fetchOpkgUpgradablePackageList()
    showSpinner(false)
    renderPackageTable()
}

(async() => {
    await updateInstalledPackages()
})()
