#!/usr/bin/python3
# -*- coding: utf-8 -*-;
#kate: space-indent on; indent-width 4; mixedindent off; indent-mode python

import struct
import sys, time,os, datetime
import serial,  csv
import mbuslib
import subprocess

watchdogtime=0
from weblib import *

def StopMBusHub():
    subprocess.call(["killall","cyclic"])
    subprocess.call(["killall","mbushub.elf"])
    FoolWatchDog()
    subprocess.call(["killall","cyclic"])
    subprocess.call(["killall","mbushub.elf"])

def FoolWatchDog():
    t = time.time()
    global watchdogtime
    if t > watchdogtime + 5:
        watchdogtime = t
        f = open("/tmp/mbushub.pid","wb")
        tb = struct.pack("<I",int(watchdogtime))
        f.write(tb)
        f.close()
        f = open("/tmp/wireless.pid","wb") # XXXXXXXXX Remove when Cyclic has more masterports. Only needed if Wireless is connecto to M-bus Master
        tb = struct.pack("<I",int(watchdogtime))
        f.write(tb)
        f.close()


def PrintData(data,oneline=False):
    tstr = ""
    for j in range(len(data)):
        if oneline == False and j&0x0F == 0:
            tstr += '\n'
        tstr += "%02X "%data[j]
    print(tstr)

def CalcBcc(arr):
    bcc=0
    for i in range(len(arr)):
        bcc += arr[i]
    return bcc & 0xFF

def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def TransmitReceive(port, request, bytesToRead, timeout):
    port.timeout = timeout
    port.write(request)
    time.sleep(0.1)
    response = port.read(bytesToRead)
    return response

def CreateShortFrame(cfield, afield):
    req   = b"\x10"+struct.pack("BB",cfield, afield)
    req += struct.pack("B",CalcBcc(req[1:])) + b"\x16"
    return req

def CreateSlvSelect(idnum, mfct, ver, med):
    req = b"\x68\x0B\x0B\x68\x53\xFD\x52"
    req += struct.pack("<IHBB",idnum, mfct, ver, med)
    req += struct.pack('B',CalcBcc(req[4:]))+b"\x16"
    return req

def CreateReqUd2(adress):
    toggle = 0x7B
    checkSum = (toggle + adress) & 0xFF
    req_ud2 = struct.pack("BBBBB", 0x10, toggle, adress, checkSum, 0x16)
    return req_ud2

def VerifyE5(resp): # Check for none ACK response.
    retval = ""
    if len(resp) == 0:
        retval = "No SND_NKE response"
        print(retval)
        return False
    elif len(resp) != 1 or resp[0] != 0xE5:
        retval = "Invalid SND_NKE_RESPONSE, %02X"%resp[0]
        print(retval)
        return False
    return True

def VerifyLongFrame(frame):
    if len(frame) == 0:
        print("No response received")
        return False
    if len(frame) < 21:  # Check number of received bytes.
        print("Too few bytes received")
        print(len(frame))
        return False
    if (frame[0] != 0x68 or frame[3] != 0x68): # Check frame characters.
        print("Incorrect frame characters")
        return False
    if (frame[1] != frame[2] or frame[1] != len(frame)-6): # Check length.
        print("Incorrect message length")
        return False
    if (CalcBcc(frame[4:len(frame)-2]) != frame[len(frame)-2]): # Check checksum.
        print("Incorrect checksum")
        return False
    return True

def read_csv_file(sfname, mode,delim):
    srows = []
    try:
        cf=open(sfname,mode)
        sreader = csv.reader(cf,delimiter=delim)
        srows=[]
        for row in sreader:
            if len(row) > 0:
                if row[0][0] != "#":
                    for i in range(len(row)):
                        row[i] = row[i].strip() # Strip unnecessary leading and trailing spaces
                    srows.append(row)
        cf.close()
    except:
        pass
    return srows

"""
Check through the meters_found files if a node is found.
Merge it to the nodes_found.
"""
def mergeNodes():
    print("IN MERGE NODES!!!")
    nodeaddresses =  [['4129', '01', '36'], ['1596', '14', '31'], ['1596', '15', '31']]
    meters = read_csv_file("/tmp/meters_found.txt", 'r', ';')
    nodes = read_csv_file("/tmp/nodes_found.txt", 'r',';')
    for m in meters:
        found = False
        if m[1:4] in nodeaddresses:
            for n in nodes:
                if n[0:4] == m[0:4]:
                    found = True
            if not found:
                nodes.append(m)
    cf=open("/tmp/nodes_found.txt",'w', newline='')
    writer = csv.writer(cf, delimiter=';', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
    for n in nodes:
        writer.writerow(n)
    cf.close()

class LongTelegram:
    def __init__(self, secondary, primary, raw):
        self.secondary = secondary
        self.primary = primary
        self.raw = raw

def readAck(port, timeout=0):
    byte = (1 / port.baudrate) * 11
    print("sleep time is ", byte)
    #time.sleep(byte)
    #port.timeout = byte + timeout
    port.timeout = 1

    #try:
    print("ohh")
    acknowledge = port.read(1)[0]
    print("ahh")
    if acknowledge != 0xe5:
        print("ack is ", acknowledge)
        raise ValueError("Invalid ack")
    #except IndexError:
        #raise ValueError("Missing ack")
    return b'\xe5'

def readLongFrame(port, timeout=0):
    byte = (1 / port.baudrate) * 11
    #time.sleep(byte)
    port.timeout = byte + 2.2
    if port.read(1)[0] != 0x68: raise ValueError("corrupt head")

    port.timeout = byte * 2
    length = port.read(2)

    port.timeout = byte
    if port.read(1)[0] != 0x68: raise ValueError("corrupt head")

    # An extra timeout of 0.1 sec are added since the timeout is to
    # short to work when repeaters are connected to the m-bus loop
    port.timeout = byte * (length[0] + 2) + 0.1
    data = port.read(length[0]+2)

    telegram = bytes([0x68, length[0], length[1], 0x68]) + data

    PrintData(telegram)
    if not VerifyLongFrame(telegram): raise ValueError("invalid telegram")

    ident, man, ver, med = struct.unpack("<IHBB", telegram[7:15])

    return LongTelegram(
        mbuslib.SecondaryAddress(ident, man, ver, med),
        telegram[5],
        telegram
    )

def serialRead(ser, starttimeout, timeoutMode):
    string = b''
    timeOut = 0.3
    if timeoutMode == "normal":
        timeOut = 0.3
    elif timeoutMode == "exhaustive":
        timeOut = 3
    print("timeOut", timeOut)
    try:
        ser.timeout = starttimeout
        string += ser.read(1)
        ser.timeout = timeOut
        while True:
            ch = ser.read(1)
            if len(ch) == 0:
                break
            string += ch
    except:
        pass
    ser.timeout = timeOut
    return string

def DoSecondarySearch(ser, baudrate, secid, manufacturer, version, medium, timeoutMode, searchtype, stop=None):
    port = serial.Serial(ser,
        baudrate=baudrate,
        bytesize=serial.EIGHTBITS,  # number of databits
        parity=serial.PARITY_EVEN,  # enable parity checking
        stopbits=serial.STOPBITS_ONE,   # number of stopbits
        timeout=1,         # set a timeout value, None for waiting forever
        xonxoff=0,          # enable software flow control
        rtscts=0            # enable RTS/CTS flow control
    )

    StopMBusHub()

    MAN = 0
    VER = 1
    MED = 2

    wireless_nodes = [[0x4129,0x01,0x36], [0x1596,0x14,0x31], [0x1596,0x15,0x31]]
    piigab_node = [0x4129,0x01,0x36]

    # Start timeout
    timeout = 1

    if searchtype == 'nodes':
        output_file = '/tmp/nodes_found.txt'
        address_list = wireless_nodes
    else:
        output_file = '/tmp/meters_found.txt'
        address_list = [[manufacturer, version, medium]]


    with open(output_file, 'w') as out, open('/tmp/searchlog.txt', 'w') as log, open('/tmp/search_result.txt', 'w') as result:

        writer = csv.writer(
            out,
            delimiter=';',
            quotechar='\"',
            quoting=csv.QUOTE_MINIMAL
        )

        for address in address_list:
            if stop and stop.is_set():
                break

            if searchtype == "nodes" and address == piigab_node:
                print("setting piigab timeout 2.2")
                timeout = 2.2
            else:
                print("setting timeout 1")
                timeout = 1

            search = mbuslib.SecondarySearch(mbuslib.SecondaryAddress(
                secid,
                address[MAN],
                address[VER],
                address[MED]
            ))


            while True:
                current = search.next()
                if not current or (stop and stop.is_set()):
                    break

                print("debug (search): ", str(current))
                result.write(str(current) + "\n")
                result.flush()
                FoolWatchDog()

                message = CreateSlvSelect(
                    current.id,
                    current.manufacturer,
                    current.version,
                    current.medium
                )

                log.write("Sending: %s\n"%(PrintData(message,oneline=True)))
                port.write(message)
                
                try:
                    response = serialRead(port, timeout, timeoutMode)
                    log.write("Received %08X,%s\n"%(current.id, PrintData(response,oneline=True)))
                    FoolWatchDog()
                    if len(response) > 0:
                        print("debug (search): hit!")
                         
                        # X indicates where in the id-number we are.
                        # F indicates wildcard
                        # Numbers represents user defined search-values.
                        # <15XFFF62> here we are not at the lastIndex since we have wildcards to the right of the search.index.
                        # <15FFFX62> here we are at the lastIndex since we do not have wildcards to the right of the search.index.
                        # If we are not at the lastIndex we step one step further to the right through the search.hit() method.
                        if search.index != search.lastIndex:
                            print("index {} lastIndex {}".format(search.index, search.lastIndex))
                            search.hit()
                            continue
                        if search.index == search.lastIndex:
                            print("debug (search): found meter")
                            print("index {} lastIndex {}".format(search.index, search.lastIndex))
                            message = CreateReqUd2(253)
                            time.sleep(0.1)
                            log.write("Sending: %s\n"%(PrintData(message,oneline=True)))
                            port.write(message)
                            try:
                                response = readLongFrame(port, timeout=timeout)
                                #response = serialRead(port, 2.2, timeoutMode)
                                log.write("Received %08X,%s\n"%(current.id, PrintData(response.raw,oneline=True)))
                                secondary = response.secondary

                                triple = [
                                    secondary.manufacturer,
                                    secondary.version,
                                    secondary.medium
                                ]

                                print("debug (search): found ", response.secondary)
                                meter = [
                                    "%08X"%secondary.id,
                                    "%04X"%secondary.manufacturer,
                                    "%02X"%secondary.version,
                                    "%02X"%secondary.medium,
                                    MfctToStr(secondary.manufacturer),
                                    "",
                                    response.primary,
                                    "20",
                                    "N" if triple in wireless_nodes else "W",
                                    "",
                                    "",
                                    datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                                ]
                            except Exception as e:
                                print("err (search):", str(e))
                                # Failed to read the meter correctly but know the
                                # address it should have thus it's possible to at
                                # least add the address.
                                meter = ["%08X"%search.id]

                            FoolWatchDog()
                            writer.writerow(meter)
                            out.flush() # focrce output

                            message = CreateShortFrame(0x40, 253)
                            log.write("Sending: %s\n"%(PrintData(message,oneline=True)))
                            port.write(message)
                            time.sleep(0.1)
                            snd_nke_response = serialRead(port, timeout, timeoutMode)
                except Exception as e:
                    print("err (search):", str(e))
    mergeNodes()
    
def DoPrimarySearch(serial_dev, ser_baudrate, startAddress, stopAddress, stop=None):
    s = None
    try:
        s = serial.Serial(serial_dev,
            #baudrate=2400,         # baudrate
            baudrate=ser_baudrate,
            bytesize=serial.EIGHTBITS,  # number of databits
            parity=serial.PARITY_EVEN,  # enable parity checking
            stopbits=serial.STOPBITS_ONE,   # number of stopbits
            timeout=1,         # set a timeout value, None for waiting forever
            xonxoff=0,          # enable software flow control
            rtscts=0            # enable RTS/CTS flow control
        )
    except:
        pass
    print("ser_baudrate", ser_baudrate)
    StopMBusHub()
    #cf=open("/tmp/meters_found.txt",'w', newline='')
    with open("/tmp/meters_found.txt", "w") as cf, open("/tmp/search_result.txt", "w") as test:
        writer = csv.writer(cf, delimiter=';', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        nodeaddresses =  [[0x4129,0x01,0x36], [0x1596,0x14,0x31]] # This should preferably be read from a configuration file.
        for addr in range(startAddress, stopAddress+1):
            #if not cont:
            #    break
            if stop and stop.is_set():
                break
            FoolWatchDog()
            print("Sending REQ_UD2 on address: {}\t\t".format(addr), end="")
            test.write("REQ_UD2 address: {}\n".format(addr))
            test.flush()
            request = CreateShortFrame(0x40, addr)
            PrintData(request,oneline=True)
            rec = TransmitReceive(s, request, 1024, 2.2)
            if len(rec) > 0: #Some answer is received
                meter = ['']*12
                request = CreateReqUd2(addr)
                PrintData(request,oneline=True)
                rec = TransmitReceive(s, request, 1024, 2.2)
                if VerifyLongFrame(rec):
                    id,  mfct,  ver,  med = struct.unpack("<IHBB",rec[7:15])
                    meter[0] = "%08X"%id
                    meter[1] = "%04X"%mfct
                    meter[2] = "%02X"%ver
                    meter[3] = "%02X"%med
                    meter[4] = MfctToStr(mfct)
                    meter[6] = int(rec[5]) #Primary address
                    meter[7] = "20"
                    if [mfct, ver, med] in nodeaddresses:
                        meter[8] = "N"
                    else:
                        meter[8] = "W"
                    meter[9] = ""
                    meter[10] = ""
                    meter[11] = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                else:
                    meter[6] = addr # The meter has answered and we know the Addr is correct but REQ_UD2 did not work.
                writer.writerow(meter)
                cf.flush()
    #cf.close()
    s.close()


"""
Normal secondary address search algorithm
Input: Command line wildcard secondary address:
Output: `/tmp/meters_found.txt` and/or `/tmp/nodes_found.txt`
Parameter: secondary address, normal secondary address with wild cards.
Parameter: nodes/None
    nodes, write if you only want to search for wireless nodes. This is faster
           and more reliable than searching for all meters.
           Writes to /tmp/nodes_found.txt
    None, searches for all meters. All meters are written to /tmp/meters_found.txt.
           If any wireless nodes are found, they are merget to /tmp/nodes_found.txt.

Note that if you are searching for all meters, the function will save all
wireless meters from wireless nodes. This is undesirable, we only want to find
wired meters in this function.
The suggested solution is to read the wireless meterlist afterwards and remove
all wireless meters from /tmp/meters_found.txt before using the list.
If the meter responds to REQ_UD2, the full secondary address will be saved.
Status = 20
If the meter only responds to SLV_SEL, only the Id-number will be saved.
Status = 0
"""
if __name__ == "__main__":
    if len(sys.argv) < 3:
        print("Usage: %s /dev/<serialport> p <start address> <stop address>"%sys.argv[0])
        print("Usage: %s /dev/<serialport> s <id> <mfct> <version> <medium> <timeout_mode normal/exhaustive> <meters/nodes optional>"%sys.argv[0])
        sys.exit(0)
    search_type = sys.argv[2]
    if search_type == "p":
        startAddress = 1
        stopAddress = 251
        if len(sys.argv) > 1:
            startAddress = int(sys.argv[3])
        if len(sys.argv) > 2:
            stopAddress = int(sys.argv[4])
        serial_dev = "/dev/ttyS4"
        DoPrimarySearch(serial_dev, 2400, startAddress, stopAddress)
    else:
        serial_dev = sys.argv[1]
        sval0 = int(sys.argv[3],16)
        manufacturer = 0xFFFF
        timeoutMode = "normal"
        stop = None
        if len(sys.argv) > 4:
            manufacturer = int(sys.argv[4], 16)
        version = 0xFF
        if len(sys.argv) > 5:
            version = int(sys.argv[5], 16)
        medium = 0xFF
        if len(sys.argv) > 6:
            medium = int(sys.argv[6], 16)
        if len(sys.argv) > 7:
            timeoutMode = str(sys.argv[7])
            print("timeoutmode %s"%timeoutMode)
        searchtype="meters"
        if len(sys.argv) > 8:
            if sys.argv[8] == "nodes":
                searchtype = "nodes"
        DoSecondarySearch(serial_dev, 2400, sval0, manufacturer, version, medium, timeoutMode,searchtype, stop)
