from base64 import decode
from quopri import decodestring
import sys
from webbrowser import get
from flask import render_template, render_template_string, request, redirect,  json, Blueprint, make_response, jsonify, Response, send_file
import os,  copy, re
from werkzeug.utils import secure_filename
import subprocess
import traceback, math

sys.path.append("..")
import weblib
import time
from enum import Enum
import mbuslib as mbl
import struct,  datetime
import threading
import mbus_search as mbsearch
import verify_meters as verify
import verify_meterlist
import Browse
import make_node_meterlist
import wireless_node_optimise
import csv
import shutil

def removefile(f):
    try:
        os.remove(f)
    except:
        pass

search_blueprint = Blueprint('search', __name__, url_prefix='/', template_folder='templates')


def loadMeterlist():
    meterlist = []
    delimiter = ','
    try:
        with open("/config/meterlist.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            meterlist = list(weblib.rcf(file, delimiter))
    except Exception as e:
        print("Error: reading /config/meterlist.csv "+str(e))
        traceback.print_exc()
    return meterlist, delimiter

def writeMeterList(meterlist, dlmt):
    with open("/config/meterlist.csv",'w', newline='') as mlf: # This should be changed to /config/ for config file verification
        mlwriter = csv.writer(mlf, delimiter=dlmt, quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for meter in meterlist:
            mlwriter.writerow(meter)
    weblib.meterlist_to_cyclic_conf()

# TODO: figure out a way to avoid iterating the structure twice
def partition(predicate, iterable):
    """
    Partition an iterable into a pair of two iterables differing by a given
    predicate.
    """
    matching = filter(predicate, iterable)
    non_matching = filter(lambda x: not(predicate(x)), iterable)
    return (matching, non_matching)

# TODO: replace the current checkMeterList with this function by changing the
#       name to match the old. Actually writing and loading files would be
#       either the caller's responsibility or that of a wrapper function.
def newCheckMeterList(found_meters, meter_list):
    # TODO: ASSUMPTION! there are no duplicate records in meterlist as if they
    #       exist they'll be erased by this function. Verify if this is actually
    #       true in the rest of the code before enabling this function.
    """
    Merge the meterlist with found meters from a previous search with respect to
    existing records in the meterlist.
    """

    # use a set for the node addresses to simplify comparison when merging meter
    # lists.
    # TODO: move this list to weblib.py or constants.py
    nodeaddresses =  set([
        (0x4129,0x01,0x36), # PiiGAB
        (0x1596,0x14,0x31), # Elvaco
        (0x1596,0x15,0x31)  # Elvaco
    ])

    def setAsNode(record):
        if tuple(record[1:4]) in nodeaddresses:
            record[8] = 'N'

    # construct a dictionary of existing meters for faster lookup and easier
    # handling.
    existing = map(lambda x: (x[0], x), meter_list)
    # separate possible updates from new meters since new meters are only
    # checked for type.
    conflict, new = partition(lambda x: x in existing, found_meters)
    # apply the node type if the meter is found to be a node
    new = map(setAsNode, new)
    # merge existing items into a list of filtered where each entry of the
    # updated and existing nodes.
    filtered = []
    for meter in conflict:
        # find the existing meter with the same ID so that it may be compared
        current = existing[meter[0]]
        if current[1] in [meter[1], 0xffff] and \
           current[2] in [meter[2], 0xff] and \
           current[3] in [meter[3], 0xff]:
            # replace it when matched with the updated meter
            current = meter
        # add it to the list of filtered items
        filtered += [current]
    return filtered + list(new)



def checkMeterList(meterfile,mlist,mtype):
    ml1 = []
    try:
        with open(meterfile) as file:
            delimiter = weblib.sniffer_csv(file)
            ml1 = list(weblib.rcf(file, delimiter))
    except Exception as e:
        print("error in checkMeterList: "+str(e))
    for i in range(len(ml1)):
        found = False
        for j in range(len(mlist)):
            if mbl.compareSecAddresses(mbl.secAddrStrToHex(ml1[i][0:4]), mbl.secAddrStrToHex(mlist[j][0:4])) > 0:
                found = True

                mlist[j][1] = ml1[i][1]
                mlist[j][2] = ml1[i][2]
                mlist[j][3] = ml1[i][3]
                mlist[j][4] = ml1[i][4]
                mlist[j][5] = ml1[i][5]
                mlist[j][6] = ml1[i][6]
                mlist[j][7] = ml1[i][7]
                if [ml1[i][1], ml1[i][2], ml1[i][3]] in weblib.nodeaddresses:
                    mlist[j][8] = "N"
                else:
                    mlist[j][8] = mtype

        if not found:
            print("in not found")
            if [ml1[i][1], ml1[i][2], ml1[i][3]] in weblib.nodeaddresses:
                print("in node addresses")
                ml1[i][8] = "N"
            else:
                print("in else")
                ml1[i][8] = mtype
            mlist.append(ml1[i])


def mergeSearchFiles(wiredOrNode):
    meterlist, delimiter = loadMeterlist()
    # Add wired meters to meterlist
    if wiredOrNode == "node":
        if os.path.exists("/tmp/nodes_found.txt"):
            print("in add node")
            checkMeterList("/tmp/nodes_found.txt",meterlist,"N")
    elif wiredOrNode == "wired":
        if os.path.exists("/tmp/meters_found.txt"):
            print("in add wired")
            checkMeterList("/tmp/meters_found.txt",meterlist,"W")
    elif wiredOrNode == "addWired":
        print("in addAll")
        if os.path.exists("/tmp/meters_found.txt"):
            checkMeterList("/tmp/meters_found.txt",meterlist,"W")
        if os.path.exists("/tmp/nodes_found.txt"):
            checkMeterList("/tmp/nodes_found.txt",meterlist,"N")
    #Write output to /tmp/meterlist.csv
    writeMeterList(meterlist, delimiter)

def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def wlGetSecondaryAddress(data): # From the wireless telegram
    i_meter_id = struct.unpack("<I",data[4:8])
    i_mfct = struct.unpack("<H",data[2:4])[0]
    meter_id = "%08X"%i_meter_id
    mfct = "%04X"%i_mfct
    ver = data[8]
    med = data[9]
    name = "%c"%(((i_mfct>>10)&0x1F)+64)+"%c"%(((i_mfct>>5)&0x1F)+64)+"%c"%((i_mfct&0x1F)+64)
    meter_type = "" #DeviceTypes[med] if med in DeviceTypes else "%02X"%med
    return meter_id, mfct, "%02X"%(ver), "%02X"%(med), name, meter_type

def wlGetTimeStamp(data):
    # Timestamp: INT64 to YYYY-MM-DD HH:MM:SS
    tmp = struct.unpack("Q", data[0:8])
    tmp = datetime.datetime.fromtimestamp(tmp[0])
    timestamp = "%04d-%02d-%02d %02d:%02d:%02d"%(tmp.year, tmp.month, tmp.day, tmp.hour, tmp.minute, tmp.second)
    return timestamp

def wlParseLineToBytes(line):
    data = b""
    for i in range(int(len(line)/2)): # Iterate over every other characters.
        try: # Try to convert hex string to int.
            temp = int(line[2*i:2*i+2], 16)
            data += struct.pack("B",temp)
        except:
            print("Error: '%s' contains a none hexadecimal number."%(line[2*i:2*i+2]))
    return data

def wlParseTelegram(telegram):
    #0108FD3F58000000003B
    #4644B4091128101505077A54000610EDD653CE9F3D0F1D0E00000000193910011216FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000CAA
    #        Secondary address:      15102811.09B4.05.07 [BMT] [Water]
    primaryAddress = telegram[0]
    timestamp = wlGetTimeStamp(telegram[1:9])
    (rssi0, rssi1, rssi2, rssi3, rssi4) = struct.unpack('BBBBB', telegram[9:14])
    if (rssi0  & 0xFC) == 0xFC:
        rssi0 = "N/A"
    else:
        rssi0 = -int((rssi0 & 0xFC)/2)
    if (rssi1  & 0xFC) == 0xFC:
        rssi1 = "N/A"
    else:
        rssi1 = -int((rssi1 & 0xFC)/2)
    print("h3")
    active     = (rssi4 & 0x02) >> 1
    available  = (rssi4 & 0x04) >> 2
    meter_id, manufacturer, version, medium, name, meter_type = wlGetSecondaryAddress(telegram[15:])
    myprimaryaddress = telegram[14]
    return meter_id, manufacturer, version, medium, primaryAddress, name, meter_type, rssi0, rssi1, active, available, timestamp, myprimaryaddress

def readFromMeters(fname):
    contents_temp = []
    global meterCount
    meterCount = 0
    exists = os.path.isfile(fname)
    if exists:
        with open(fname) as f:
            for line in f:
                line = line.rstrip('\n')
                contents_temp.append(line)
                meterCount+=1
        return contents_temp
    return

class TemplateParameters:
    def __init__(self,**kwargs):
        if kwargs['channel_name']:
            self.channel_name = kwargs['channel_name']
        else: self.channel_name = 'channel'

        if kwargs['time_stamp']:
            self.time_stamp = kwargs['time_stamp']
        else: self.time_stamp = ''
    
        if kwargs['read_period']:
            self.read_period = kwargs['read_period']
        else: self.read_period = ''
    
        if kwargs['tag_type']:
            self.tag_type = kwargs['tag_type']
        else: self.tag_type = ''

        if kwargs['time_stamp_telegram']:
            self.time_stamp_telegram = kwargs['time_stamp_telegram']
        else: self.time_stamp_telegram = ''

        self.time_record_no = kwargs['time_record_no']
        if kwargs['time_record_no']:
            self.time_record_no = kwargs['time_record_no']
        else: self.time_record_no = ''

        if kwargs['is_found']:
            self.is_found = kwargs['is_found']
        else: self.is_found = False

def getTemplateParameters(tmplname,templates):
    is_found=False

    params = TemplateParameters(
        channel_name='channel',
        time_stamp='',
        read_period='',
        tag_type='',
        time_stamp_telegram='',
        time_record_no='',
        is_found=False
    )
        # 1 find device that matches tmpname
    # 2 when device found. get first row TAG underneath and extract values if it is not a _Mod VALUE.
    for t in templates:


        names_are_eqal = tmplname.lower() == t[3].lower()
        is_device_tag = t[0].lower() == "[device]"
        is_tag = t[0].lower() == "[tag]"

        if not names_are_eqal:
            continue
    
        is_time = t[4] == "time"
        is_mod_val = False if is_device_tag else t[4].lower().endswith("_mod")

        if is_device_tag:
            # if device has already been found we return, otherwise it will overwrite params.
            if is_found:
                params.is_found = True
                return params
            
            is_found = True
            params.channel_name = t[1]
            params.time_stamp = "YYYY.MM.DD" # This can be set if the line exists
            try:
                ts = int(t[24]) & 0x18
                if ts == 0x10:
                    params.time_stamp = "MM/DD/YYYY"
                elif ts == 0x18:
                    params.time_stamp = "YYYY-MM-DD"
            except:
                pass
            try:
                params.read_period = int(t[41])/60
            except:
                pass
            try:
                ts = int(t[24]) & 0x02
                if ts == 0x02:
                    params.time_stamp_telegram = "Telegram"
                else:
                    params.time_stamp_telegram = "Quickpost"
            except:
                pass
        elif is_tag:
            if names_are_eqal:
                if not is_time and not is_mod_val:
                    try:
                        tag_type = t[20]
                        if tag_type == '1':
                            params.tag_type = "Value"

                        elif tag_type == '8':
                            params.tag_type = "Record"

                        
                    except:
                        pass

                if is_time:
                    params.time_stamp = "YYYY.MM.DD" # This can be set if the line exists
                    try:
                        ts = int(t[24]) & 0x18
                        if ts == 0x10:
                            params.time_stamp = "MM/DD/YYYY"
                        elif ts == 0x18:
                            params.time_stamp = "YYYY-MM-DD"
                    except:
                        pass
                    try:
                        params.time_record_no = int(t[19])
                    except:
                        pass
        params.is_found = is_found
    return params



# Goes through the "/tmp/meterlist_wireless.txt" and adds every unique wireless meter to "/config/meterlist.csv"
#
def addUniqueWireless():
    print("in uniqueMeter")
    unique_meters = []
    if not os.path.exists("/tmp/meterlist_wireless.txt"):
        return #Nothing to do

    wireless_meters = []
    try:
        with open("/tmp/meterlist_wireless.txt") as file:
            delimiter = weblib.sniffer_csv(file)
            wireless_meters = list(weblib.rcf(file, delimiter))
    except Exception as e:
        print("error in addUniqueWireless: "+str(e))
    wireless_meters=sorted(wireless_meters)
    age_max = 24*60
    for wlRow in wireless_meters:
        if int(wlRow[9]) > age_max:
            continue
        found = False
        for uniq in unique_meters:
            if mbl.compareSecAddresses(mbl.secAddrStrToHex(wlRow[0:4]), mbl.secAddrStrToHex(uniq[0:4])) > 0:
                found = True
        if not found:
            adder = [''] * 12
            adder[0:9] = wlRow[0:9]
            adder[11] = wlRow[11]
            unique_meters.append(adder)
    print(unique_meters)

    #To make sure no wired or wireless nodes are removed from /config/meterlist.csv
    meterlist, delimiter = loadMeterlist()
    for um in unique_meters:
        found=False
        for m in meterlist:
            if mbl.compareSecAddresses(mbl.secAddrStrToHex(um[0:4]), mbl.secAddrStrToHex(m[0:4])) > 0:
                found = True
                print("should add %s"%um[0])
                m[1] = um[1]
                m[2] = um[2]
                m[3] = um[3]
                m[4] = um[4]
                m[5] = um[5]
                m[6] = um[6]
                m[7] = um[7]
                m[8] = um[8]
        if not found:
            meterlist.append(um)

    writeMeterList(meterlist, delimiter)

# Compare the files "/tmp/meters_found.txt" and "/tmp/meterlist_wireless.txt".
# If a meter is found in both files it will be erased from "/tmp/mers_found.txt"
# The erased meter is a wireless meter responding to a secondary or primary search
# through a wireless node.
def compareWiredAndWireless():
    print("in compareWiredAndWireless")
    wired_meters = []
    wireless_meters = []
    new_wired = []

    try:
        with open("/tmp/meters_found.txt") as file:
            delimiter = weblib.sniffer_csv(file)
            wired_meters = list(weblib.rcf(file, delimiter))
    except Exception as e:
        print("error in compareWiredAndWireless: "+str(e))

    try:
        with open("/tmp/meterlist_wireless.txt") as file:
            delimiter = weblib.sniffer_csv(file)
            wireless_meters = list(weblib.rcf(file, delimiter, 11))
    except Exception as e:
        print("error in compareWiredAndWireless: "+str(e))

    for wired in wired_meters:
        found = False
        for radio in wireless_meters:
            if mbl.compareSecAddresses(mbl.secAddrStrToHex(radio[0:4]), mbl.secAddrStrToHex(wired[0:4])) > 0:
                found = True
        if not found:
            new_wired.append(wired)

    with open("/tmp/meters_found.txt",'w', newline='') as mlf: # This should be changed to /config/ for config file verification
        mlwriter = csv.writer(mlf, delimiter=';', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for meter in new_wired:
            mlwriter.writerow(meter)

def checkForRegisterDuplicates(registers):
    duplicate_entries = {}
    entries = {}

    for pos,reg in enumerate(registers):
        if reg not in entries:
            entries[reg] = pos
        else:
            if reg not in duplicate_entries:
                duplicate_entries[reg] = [entries[reg], pos]
            else:
                duplicate_entries[reg].append(pos)
    return duplicate_entries

def checkForDuplicates(meterlist):
    duplicate_entries = []
    entries = {}

    for line in meterlist:

        if line[0] not in entries:
            entries.update({
                line[0]: {
                    "man": set([line[1]]),
                    "med": set([line[2]]),
                    "ver": set([line[3]])
                }
            })

        else:

            man = (line[1] == "") or ("" in entries[line[0]]["man"]) or (line[1] in entries[line[0]]["man"])
            med = (line[2] == "") or ("" in entries[line[0]]["med"]) or (line[2] in entries[line[0]]["med"])
            ver = (line[3] == "") or ("" in entries[line[0]]["ver"]) or (line[3] in entries[line[0]]["ver"])
            if man and med and ver:
                duplicate_entries.append(line)

            entries[line[0]]["man"].add(line[1])
            entries[line[0]]["med"].add(line[2])
            entries[line[0]]["ver"].add(line[3])

    return duplicate_entries

@search_blueprint.route("/load_slaveport_file", methods=["GET"])
def loadEditSlaveportFile():
    return render_template("edit_slaveport_mbus2modbus.html")

@search_blueprint.route("/save_slaveport_file", methods=["POST"])
def saveSlaveportFile():
    registers = request.get_json()
    print("registers", registers)
    duplicates = checkForRegisterDuplicates(registers)
    print("duplicates", duplicates)
    try:
        if len(duplicates) > 0:
            print("len duplicates")
            index = {
                'registers': registers,
                'duplicates': duplicates
            }
            return make_response(jsonify(index), 200)
    except Exception as e:
        print("errorororo : ", str(e))
    old_file = []

    try:
        with open("/config/slaveport_Mbus2Modbus.csv") as old:
            for l in old.readlines():
                old_file.append(l.split(","))

        with open("/config/registers-tmp.csv", "w") as new:
            for num,line in enumerate(old_file):
                line[1] = registers[num]
                tmp = line[0]+","+line[1]+","+line[2]+","+line[3]+","+line[4]
                new.write(tmp)

        os.rename("/config/registers-tmp.csv", "/config/slaveport_Mbus2Modbus.csv")
        table = []
        length = 0
        with open("/config/slaveport_Mbus2Modbus.csv") as file:
            for l in file.readlines():
                row = l.split(',')
                table.append(row)
                length += 1

        index = {
            'table': table,
            'length': length
        }
        print("old_file", old_file)

        return make_response(jsonify(index), 200)
    except Exception as e:
        print("error: "+str(e))
        return make_response("Error", 400)


@search_blueprint.route("/edit_slaveport_file", methods=["GET"])
def editSlaveportFile():
    table = []
    length = 0
    with open("/config/slaveport_Mbus2Modbus.csv") as file:
        for l in file.readlines():
            row = l.split(',')
            table.append(row)
            length += 1

    index = {
        'table': table,
        'length': length
    }

    return make_response(jsonify(index), 200)

@search_blueprint.route("/get_pdf_data", methods=["GET"])
def getPdfData():
    protocols = 0
    clients = 0
    meters = 0

    try:
        mbs=os.popen("/binary/mbushub.elf -S")
        serialno=mbs.readline().strip('\n')
        mbs.close()
        mbhl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbhl.readline().strip('\n').split(';')
        mbhl.close()
        clients=licensearray[0]
        meters=licensearray[1]
        protocols=licensearray[2].split(',')
    except:
        pass

    mac = ""
    try:
        with open("/sys/class/net/eth0/address") as file:
            mac = file.read()
    except:
        pass

    network = []
    try:
        with open("/etc/network/interfaces") as file:
            lines = file.readlines()
            for line in lines:
                line = line.split()
                if len(line)>0:
                    if line[0] == 'iface' and (line[1] == 'eth0' or line[1] == 'eth1'):
                        network.append(line[1])
                        network.append(line[3])
                    elif line[0] == "address":
                        network.append(line[1])
                    elif line[0] == "netmask":
                        network.append(line[1])
                    elif line[0] == "gateway":
                        network.append(line[1])
    except:
        pass

    header = ""
    try:
        if os.path.exists("/var/www1/identification.py"):
            with open("/var/www1/identification.py") as file:
                header = file.read()
                print("header",header)
                print("length header",len(header))
    except Exception as e:
        print("Wrong with header name:"+str(e))

    print("network", network)
    print("header", header)
    JSONDict = {
        "protocols": protocols,
        "serialno": serialno,
        "mac": mac,
        "network": network,
        "header": header
    }
    return make_response(jsonify(JSONDict),200)

@search_blueprint.route("/meter_search_and_overview",  methods=['GET',  'POST'])
def meterSearchAndOverview():
    meterlist, delimiter = loadMeterlist()
    meterlist = sorted(meterlist)

    meters = {
        'numMeters': 0,
        'verified' : 0,
        'nodes' : 0,
        'wired' : 0,
        'wireless' : 0,
        'han' : 0
    }

    for m in meterlist:
        meters["numMeters"] += 1
        if len(m) > 7 and (m[7] == "20" or m[7] == "Ver"):
            meters["verified"] += 1
        if len(m) > 8 and m[8] == "N":
            meters["nodes"] += 1
        if len(m) > 8 and m[8] == "W":
            meters["wired"] += 1
        if len(m) > 8 and m[8] == "R":
            meters["wireless"] += 1
        if len(m) > 8 and m[8] == "H":
            meters["han"] += 1

    info = {
        'tab': "B",
        'meters' : meters
    }
    return render_template('meter_search_and_overview.html',  **info)

def checkIfMeterInMyConfig():
    meterlist, delimiter = loadMeterlist()
    try:
        with open("/config/myconfig.csv", "r") as fd:
            # Make a set of tuple(id, mfct, ver, med) from meterlist
            meterlist = set(map(lambda x: (x[0], x[1], x[2], x[3]), meterlist))
            # Parse myconfig.csv file
            config = csv.reader(fd, delimiter=',')
            # Filter for the rows with Device
            config = filter(lambda x: x[0] == "[Device]", config)
            # Make a tuple of the secondary address in column 19
            config = map(lambda x: tuple(x[19].split(':')[0].split('.')), config)
            # Filter for the meters present in both meterlist and myconfig.csv
            config = filter(lambda x: x in meterlist, config)
            # Join the result as a secondary address
            result = list(map(lambda x: "{}.{}.{}.{}".format(*x), config))
            return result
    except:
        return []
    assert False, "unreachable"

OPTIMIZE = 1
VERIFY_METERLIST = 2
READ_METERLIST = 3
ADD_SINGLE_METER = 4
MAKE_NODE_METERLIST = 5
ADD_UNIQUE = 6
VERIFY_METERLIST_SINGLE = 7
SECONDARY_SEARCH = 8
MERGE_NODES = 9
MERGE_SEARCH_FILES = 10
PRIMARY_SEARCH = 11
NODE_SEARCH = 12
AUTO_TEMPLATE_GENERATOR = 13
CREATE_MAIN_CSV_FILE = 14
RESTART_QUICKPOST = 15
MERGE_WIRED = 16
CREATE_WIRELESS_INCLUDE = 17
RESTART_WIRELESS = 18
METER_REQUEST = 19

def schedulerMain(channel):
    while scheduler.step(channel):
        print("schedulerMain")
    print("scheduler stopped")

class StateMachine:
    def __init__(self,):
        self.queue = []
        self.state = None
        self.running = None
        self.channel = None

    def start(self):
        self.channel = threading.Event()
        self.running = threading.Thread(target=schedulerMain, args=(self.channel,))
        self.running.start()
        print("start")

    def report(self):
        tag = None
        if self.state:
            tag = self.state if isinstance(self.state, int) else self.state[0]

        if tag == None:
            return "no_search_running"
        elif tag == OPTIMIZE:
            return "optimizing"
        elif tag == CREATE_WIRELESS_INCLUDE:
            return "create_wireless_include"
        elif tag == MAKE_NODE_METERLIST:
            return "make_node_meterlist"
        elif tag == ADD_UNIQUE:
            return "add_unique"
        elif tag == VERIFY_METERLIST_SINGLE:
            return "add_single_meter"
        elif tag == VERIFY_METERLIST:
            return "verify_meterlist"
        elif tag == READ_METERLIST:
            return "reading_meterlist"
        elif tag == METER_REQUEST:
            return "meter_request"
        elif tag == MERGE_NODES:
            return "restart_mbushub"
        elif tag == MERGE_SEARCH_FILES:
            return "merge_search_files"
        elif tag == MERGE_WIRED:
            return "merge_wired_meters"
        elif tag == RESTART_QUICKPOST:
            return "restart_quickpost"
        elif tag == RESTART_WIRELESS:
            return "restart_wireless"
        elif tag == NODE_SEARCH:
            return "node_search"
        elif tag == AUTO_TEMPLATE_GENERATOR:
            return "auto_template_generator"
        elif tag == CREATE_MAIN_CSV_FILE:
            return "create_main_csv_file"
        elif tag == SECONDARY_SEARCH:
            return "secondary_search"
        elif tag == PRIMARY_SEARCH:
            return "primary_search"
        elif tag == METER_REQUEST:
            return "meter_request"
        else:
            return "unknown step"

    def step(self, channel):
        try:
            if self.queue == []:
                self.state = None
                return False
            else:
                print("POPPING!!!")
                self.state = self.queue.pop(0)
                tag = self.state
                if not isinstance(self.state, int):
                    tag = self.state[0]

            print("\x1b[32mstate",self.state,"\x1b[0m")

            if self.state == MAKE_NODE_METERLIST:
                sw = make_node_meterlist.searchWireless(weblib.ipNumber, weblib.ipPort, "meterlist.csv","/config")
                sw.create_meter_list(2*24*60)
            elif tag == RESTART_QUICKPOST:
                restartQuickpost()
            elif tag == RESTART_WIRELESS:
                try:
                    restartWireless()
                except Exception as e:
                    print("Is it a wireless unit?"+str(e))
            elif tag == ADD_UNIQUE:
                addUniqueWireless()
            elif tag == CREATE_WIRELESS_INCLUDE:
                createWirelessInclude()
            elif tag == OPTIMIZE:
                wireless_node_optimise.optimise_meterlist()
            elif self.state == VERIFY_METERLIST:
                verify_meterlist.DoVerify(weblib.ipNumber, weblib.ipPort, "u", "/config/meterlist.csv", False, False, channel)
            elif self.state == VERIFY_METERLIST_SINGLE:
                verify_meterlist.DoVerify(weblib.ipNumber, weblib.ipPort, "u", "/tmp/verifySingle.txt", True, True, channel)
            elif self.state == READ_METERLIST:
                verify_meterlist.DoVerify(weblib.ipNumber, weblib.ipPort, "u", "/config/meterlist.csv", True, False, channel)
            elif self.state == MERGE_NODES:
                subprocess.call(["%s/etc/init.d/S94mbushub"%weblib.PROOT,"restart"])
                subprocess.call(["%s/etc/init.d/S49cyclic"%weblib.PROOT,"restart"])
                mergeSearchFiles("node")
            elif tag == MERGE_SEARCH_FILES:
                compareWiredAndWireless()
                mergeSearchFiles("wired")
            elif tag == MERGE_WIRED:
                mergeSearchFiles("addWired")
            elif tag == NODE_SEARCH:
                sercomport,serbaudrate = getMBusMainPort()
                mbsearch.DoSecondarySearch(sercomport,serbaudrate,0xFFFFFFFF,0xFFFF,0xFF,0xFF,"normal","nodes", channel)
            elif print(self.state) or tag == AUTO_TEMPLATE_GENERATOR:
                (parameters,number_of_telegrams, max_value_age) = self.state[1]
                autoCreateTemplateFunc(params=parameters,
                                       number_of_telegrams=number_of_telegrams,
                                       max_value_age=max_value_age)
            elif tag == CREATE_MAIN_CSV_FILE:
                (device_format, channel_name, modbus, number_of_telegrams, max_value_age) = self.state[1]
                print("device_name ",device_format)
                print("channel_name ",channel_name)
                print("modbus ",modbus)
                print("number_of_telegrams", number_of_telegrams)
                print("max_value_age", max_value_age)

                createMainCsvFile(device_format, channel_name, modbus, number_of_telegrams, max_value_age)
            elif tag == PRIMARY_SEARCH:
                (startaddr,endaddr) = self.state[1]
                sercomport, serbaudrate = getMBusMainPort()
                mbsearch.DoPrimarySearch(sercomport, serbaudrate, startaddr, endaddr, channel)
            elif tag == SECONDARY_SEARCH:
                (idnum,mfct,ver,med,timeoutMode) = self.state[1]
                sercomport, serbaudrate = getMBusMainPort()
                print("idnum {}".format(idnum))
                print("mfct {}".format(mfct))
                print("ver {}".format(ver))
                print("med {}".format(med))
                mbsearch.DoSecondarySearch(sercomport,serbaudrate,idnum,mfct,ver,med,timeoutMode,"", channel)
            elif tag == METER_REQUEST:
                secaddr = self.state[1]
                askBrowse(weblib.ipNumber, weblib.ipPort, "u", secaddr, 3)

        except Exception as e:
            traceback.print_exc()
        return True

    def addWireless(self):
        if self.queue == []:
            self.queue = [
                
                MAKE_NODE_METERLIST,
                ADD_UNIQUE, OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def addWired(self):
        if self.queue == []:
            self.queue = [
                MERGE_WIRED
            ]
            self.start()
            return True
        else:
            return False

    def addSingleMeter(self):
        if self.queue == []:
            self.queue = [
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST_SINGLE,
                OPTIMIZE,
                CREATE_WIRELESS_INCLUDE
            ]
            self.start()
            return True
        else:
            return False

    def verifyMeterlist(self):
        if self.queue == []:
            self.queue = [
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST, OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def readMeterlist(self):
        if self.queue == []:
            self.queue = [
                MAKE_NODE_METERLIST,
                READ_METERLIST,
                OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def startSecondary(self, idnum, mfct, ver ,med, timeoutMode):
        if self.queue == []:
            self.queue = [
                (
                    SECONDARY_SEARCH,
                    (idnum,mfct,ver,med,timeoutMode)
                )
                ,
                MERGE_NODES,
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST,
                MERGE_SEARCH_FILES,
                VERIFY_METERLIST,
                OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def startPrimary(self, startaddr, endaddr):
        if self.queue == []:
            self.queue = [
                (
                    PRIMARY_SEARCH,
                    (startaddr,endaddr)
                )
                ,
                MERGE_NODES,
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST,
                MERGE_SEARCH_FILES,
                VERIFY_METERLIST,
                OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def startNodeSearch(self):
        if self.queue == []:
            self.queue = [
                NODE_SEARCH,
                MERGE_NODES,
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST,
                OPTIMIZE
            ]
            self.start()
            return True
        else:
            return False

    def autoCreateMyConfig(self,device_format,channel_name,modbus, number_of_telegrams=3, max_value_age=60) : # type:(StateMachine,str,str,bool,int,int) -> bool
        if self.queue == []:
            self.queue = [
                (
                    AUTO_TEMPLATE_GENERATOR,
                    (
                        BrowseParameters(
                            format='3',
                            device_format=device_format,
                            channel_name=channel_name,
                            read_period='',
                            read_offset='',
                            tag_type='8',
                            time_record_no='4',
                            time_stamp='24',
                            time_stamp_telegram='2'
                        )
                    ,number_of_telegrams, max_value_age)
                )
                ,
                (
                    CREATE_MAIN_CSV_FILE,
                    (device_format, channel_name, modbus, number_of_telegrams, max_value_age)
                ),
                RESTART_QUICKPOST
            ]
            self.start()
            return True
        else:
            return False


    def autoTemplateGenerator(self, parameters, number_of_telegrams=3, max_value_age=60) : # type:(StateMachine,BrowseParameters,int, int) -> bool
        if self.queue == []:
            self.queue = [
                (
                    AUTO_TEMPLATE_GENERATOR,
                    (parameters,number_of_telegrams, max_value_age)
                )
            ]
            self.start()
            return True
        else:
            return False

    def createMainCsvFile(self, device_format, channel_name, modbus, number_of_telegrams=3, max_value_age=60):
        if self.queue == []:
            self.queue = [
                (
                    CREATE_MAIN_CSV_FILE,
                    (device_format, channel_name, modbus, number_of_telegrams, max_value_age)
                ),
                RESTART_QUICKPOST
            ]

            self.start()
            return True
        else:
            return False

    def APIuploadMeterlist(self):
        if self.queue == []:
            self.queue = [
                MAKE_NODE_METERLIST,
                VERIFY_METERLIST,
                OPTIMIZE,
                CREATE_WIRELESS_INCLUDE
            ]
            self.start()
            return True
        else:
            return False

    def meterRequest(self, secAddr):
        if self.queue == []:
            self.queue = [
                (
                    METER_REQUEST,
                    secAddr
                )
                ]
            self.start()
            return True
        else:
            return False

scheduler = StateMachine()

####################################################################################
#
# Here we define state variables
#
# Secondary Search Variables
#   idnum,
#   mfct,
#   ver,
#   med
#
# Primary Search Variables
#   startaddr,
#   endaddr
#
# Creation of myconfig
#   device_format
#   serialno
#
# State Machine
#   whichFunctionRuns
#
# Browse - Return values from the last successful Browse request
#
#   browse_output_id                - Identification
#   browse_output_mfct              - Manufacturer
#   browse_output_ver               - Version
#   browse_output_med               - Medium
#   browse_output_primary_address   - Primary address
#   browse_output_mfct_spec_ver     - Manufacturer specific version string
#   browse_output_error             - Store the different error strings produced by Browse.py
#                                       E.g When Browse do not receive an 0xE5 from a SLV_SEL
#                                       the string will be "No SLV_SEL resp"
#                                       This string is used to write information to the logfile
#                                       for the user-feedback window in menu.html
#
#####################################################################################

class StateVariables:
    def __init__(self, serialno):
        self.idnum = 0xFFFFFFFF
        self.mfct = 0xFFFF
        self.ver = 0xFF
        self.med = 0xFF
        self.startaddr = 0
        self.endaddr = 250
        self.device_format = "idmfctvermed"
        self.channel_name = serialno
        self.whichFunctionRuns = "no_function"
        self.browse_output_id = 0xFFFFFFFF
        self.browse_output_mfct = ""
        self.browse_output_ver = ""
        self.browse_output_med = ""
        self.browse_output_primary_address = ""
        self.browse_output_mfct_spec_ver = ""
        self.browse_output_error = ""

serial = weblib.serialNo()
stateVariables = StateVariables(serial)

# Clears all the state variables connected to Browse.py readout
def clearStateVariablesBeforeRequest():
    stateVariables.browse_output_id = 0xFFFFFFFF
    stateVariables.browse_output_mfct = ""
    stateVariables.browse_output_ver = ""
    stateVariables.browse_output_med = ""
    stateVariables.browse_output_primary_address = ""
    stateVariables.browse_output_mfct_spec_ver = ""
    stateVariables.browse_output_error = ""

def getMBusMainPort():
    mbushubini_def = weblib.configparser.RawConfigParser()
    mbushubini_def.read("/config/mbushub_default.ini")
    mbushubini = weblib.configparser.RawConfigParser()
    mbushubini.read("/config/mbushub.ini")

    parser = weblib.Configuration(mbushubini_def, mbushubini)

    sercomport = parser.get(str, "MasterPort", "sercomport")
    serbaudrate = parser.get(int, "MasterPort", "serbaudrate")

    if sercomport == "MBMASTER":
        sercomport = "/dev/ttyS4"
    elif sercomport == "RS485":
        sercomport = "/dev/ttyS2"
    elif sercomport == "RS232":
        sercomport = "/dev/ttyS5"
    else:
        sercomport = "/dev/ttyS4"
    print("ser {}".format(sercomport))
    return sercomport, serbaudrate

@search_blueprint.route("/edit_meter", methods=["GET", "POST"])
def editMeterRoute():
    content = request.get_json()
    print("edit-content",content)

    meterlist, delimiter = loadMeterlist()
    meterlist = sorted(meterlist)
    ok = True
    try:
        container = content["description"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['description']",str(e))
        content["description"] = "not_utf8"
        ok = False
    try:
        container = content["id"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['id']",str(e))
        content["id"] = "not_utf8"
        ok = False
    try:
        container = content["mfct"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['mfct']",str(e))
        content["mfct"] = "not_utf8"
        ok = False
    try:
        container = content["ver"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['ver']",str(e))
        content["ver"] = "not_utf8"
        ok = False
    try:
        container = content["med"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['med']",str(e))
        content["med"] = "not_utf8"
        ok = False
    try:
        container = content["key"].encode('utf-8')
        container = container.decode('utf-8')
        print("string is utf-8")
    except Exception as e:
        print("error contetnt['key']",str(e))
        content["key"] = "not_utf8"
        ok = False
    if not ok:
        JSONDict = {
            "content": content,
        }
        return make_response(jsonify(JSONDict), 200)

    ok = True
    if len(content["description"]) > 50 or " " in content["description"]:
        content["description"] = "incorrect"
        ok = False
    if len(content["id"]) > 8 or not content["id"].isnumeric():
        content["id"] = "incorrect"
        ok = False
    if (len(content["mfct"]) > 0 and len(content["mfct"]) != 4) or (len(content["mfct"]) > 0 and not weblib.isHex(content["mfct"])):
        content["mfct"] = "incorrect"
        ok = False
    if (len(content["ver"]) > 0 and len(content["ver"]) != 2) or (len(content["ver"]) > 0 and not weblib.isHex(content["ver"])):
        content["ver"] = "incorrect"
        ok = False
    if (len(content["med"]) > 0 and len(content["med"]) != 2) or (len(content["med"]) > 0 and not weblib.isHex(content["med"])):
        content["med"] = "incorrect"
        ok = False
    if (len(content["key"]) > 0 and len(content["key"]) != 32) or (len(content["key"]) > 0 and not weblib.isHex(content["key"])):
        content["key"] = "incorrect"
        ok = False

    if len(content["id"]) < 8:
        content["id"] = content["id"].zfill(8)
        print("content[id]",content["id"])

    if not ok:
        JSONDict = {
            "content": content,
        }
        return make_response(jsonify(JSONDict), 200)

    # A new meter have been added
    if content["newMeter"] == "true":
        meter = [""]*11
        meter[0] = content["id"]
        meter[1] = content["mfct"]
        meter[2] = content["ver"]
        meter[3] = content["med"]
        meter[9] = content["key"]
        meter[10] = content["description"]
        print("newMeter",meter)
        with open("/tmp/verifySingle.txt", "w") as file:
            writer = csv.writer(file, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            writer.writerow(meter)

        functionDidStart = False
        if scheduler.addSingleMeter():
            functionDidStart = True
            stateVariables.whichFunctionRuns = "add_single_meter"

        running = scheduler.running != None and scheduler.running.is_alive()
        print("running {}".format(running))
        status = scheduler.report()
        print("status {}".format(status))
        JSONDict = {
            "content": content,
            "running": running,
            "status": status,
            "functionDidStart": functionDidStart,
        }

        return make_response(jsonify(JSONDict), 200)

    with open("/config/meterlist.csv-tmp", 'w',newline='') as cf:
        writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for num,m in enumerate(meterlist):
            print("num {0} m {1}".format(num, m))
            if num == int(content["order"]):
                m[0] = content["id"]
                m[1] = content["mfct"]
                m[2] = content["ver"]
                m[3] = content["med"]
                m[9] = content["key"]
                m[10] = content["description"]


            writer.writerow(m)

    os.rename("/config/meterlist.csv-tmp", "/config/meterlist.csv")
    weblib.meterlist_to_cyclic_conf()

    createWirelessInclude()

    JSONDict = {
        "content":content,
    }

    return make_response(jsonify(JSONDict),200)


@search_blueprint.route('/api/v1/meters/add/internal',methods=['POST'])
def add_internal_meter():
    meter = [""]*11
    meter[0] = weblib.serialNo()
    meter[1] = "4129"
    meter[2] = "FF"
    meter[3] = "31"
    meter[9] = ""
    meter[10] = "Internal_telegram"
    with open("/tmp/verifySingle.txt", "w") as file:
        writer = csv.writer(file, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        writer.writerow(meter)

    functionDidStart = False
    if scheduler.addSingleMeter():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "add_single_meter"

    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONDict = {
        "content": meter,
        "running": running,
        "status": status,
        "functionDidStart": functionDidStart,
    }

    return make_response(jsonify(JSONDict), 200)


@search_blueprint.route("/meterlist", methods=['PUT', 'GET', 'POST', 'DELETE'])
def getMeterlist():
    inMyConfig = checkIfMeterInMyConfig()

    meterlist, delimiter = loadMeterlist()
    meterlist = sorted(meterlist)

    meters = returnMeters(meterlist)

    duplicate_entries = checkForDuplicates(meterlist)
    print("duplicates")
    for m in duplicate_entries:
        print(m)

    search_result = []
    try:
        search_result = lastNlines()
        print(search_result)
    except Exception as e:
        search_result = ["no_result"]

    if request.method == 'GET' and request.is_json:

        print("Funkar!")
        data = []

        for row in meterlist:
            secaddress = "{}.{}.{}.{}".format(row[0],row[1],row[2],row[3])
            fabrication = row[5]
            if len(fabrication) > 0:
                secaddress += ":{}".format(fabrication)

            print("secadress", secaddress)
            d= {}
            d['id'] = row[0]
            d['mfct'] = row[1]
            d['ver'] = row[2]
            d['med'] = row[3]
            d['mfct_str'] = row[4]
            d['fab'] = fabrication
            d['prim'] = row[6]
            d['status'] = row[7]
            d['type'] = row[8]
            d['key'] = row[9]
            d['description'] = row[10]
            d['timestamp'] = row[11]
            d['mfct_spec_ver'] = row[12]

            data.append(d)

        print(scheduler.state)
        print(scheduler.running)
        print(scheduler.report())
        running = scheduler.running != None and scheduler.running.is_alive()
        status = scheduler.report()
        if status == None:
            status="no_search"
            stateVariables.whichFunctionRuns = "no_function"

        JSONDict = {
            "meters": meters,
            "data": data,
            "inMyConfig": inMyConfig,
            "duplicate_entries": duplicate_entries,
            "running": running,
            "status": status,
            "search_result": search_result,
            "whichFunctionRuns": stateVariables.whichFunctionRuns,
        }
        return make_response(jsonify(JSONDict),200)

def lastNlines():
    result = []
    with open("/tmp/search_result.txt", "r") as file:
        i = 0
        for line in (file.readlines() [-4:]):
            result.append(line)
            i+=1
    return result

def returnMeters(meterlist):
    meters = {
        'numMeters': 0,
        'verified' : 0,
        'nodes' : 0,
        'wired' : 0,
        'wireless' : 0,
        'han' : 0
    }

    for m in meterlist:
        meters["numMeters"] += 1
        if len(m) > 7 and (m[7] == "20" or m[7] == "Ver"):
            meters["verified"] += 1
        if len(m) > 8 and m[8] == "N":
            meters["nodes"] += 1
        if len(m) > 8 and m[8] == "W":
            meters["wired"] += 1
        if len(m) > 8 and m[8] == "R":
            meters["wireless"] += 1
        if len(m) > 8 and m[8] == "H":
            meters["han"] += 1

    return meters

@search_blueprint.route("/remove_meters", methods=['GET', 'POST'])
def removeMeters():
    meterlist, delimiter = loadMeterlist()
    meterlist = sorted(meterlist)

    newMeterlist = []
    if request.method == 'POST' and request.is_json:
        with open("/config/meterlist.csv-tmp", 'w',newline='') as cf:
            writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            for num,m in enumerate(meterlist):
                print("num {0} m {1}".format(num, m))
                add = True
                content = request.get_json()
                print("type content {}".format(type(content)))
                for rem in content:
                    print("rem {}".format(rem))
                    if int(num) == int(rem):
                        add = False
                        break
                if add:
                    print("writing",m)
                    writer.writerow(m)

        os.rename("/config/meterlist.csv-tmp", "/config/meterlist.csv")
        weblib.meterlist_to_cyclic_conf()

    meterlist, delimiter = loadMeterlist()

    duplicate_entries = checkForDuplicates(meterlist)
    print("duplicates")
    for m in duplicate_entries:
        print(m)

    meters = returnMeters(meterlist)
    print("meters",meters)
    print("Funkari remove!")
    data = []

    for row in meterlist:
        d= {}
        d['id'] = row[0]
        d['mfct'] = row[1]
        d['ver'] = row[2]
        d['med'] = row[3]
        d['mfct_str'] = row[4]
        d['fab'] = row[5]
        d['prim'] = row[6]
        d['status'] = row[7]
        d['type'] = row[8]
        d['key'] = row[9]
        d['description'] = row[10]
        d['timestamp'] = row[11]
        data.append(d)

    JSONreturnArray = [data, duplicate_entries, meters]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/copy_file_to_config",  methods=['GET'])
def copyFileToConfig():
    filename = secure_filename(request.args.get("FILE"))
    src = "/tmp/{}".format(filename)
    dst = "/config/{}".format(filename)

    try:
        shutil.copyfile(dst, src)
    except Exception:
        pass # TODO: display an error

    if filename == "template.csv":
        return redirect('/create_templates')

    return redirect('/meter_search_and_overview')

@search_blueprint.route("/remove_file",  methods=['GET'])
def removeFile():
    a=request.args.get("FILE")
    print("a",a)
    try:
        filename = secure_filename(a)
        print("filename",filename)
        os.remove("/config/"+filename)
    except Exception as e:
        print("error in remove file: "+str(e))

    if a == "meterlist.csv":
        return redirect('/meter_search_and_overview')
    elif a == "template.csv":
        return redirect('/create_templates')


@search_blueprint.route("/show_browse_result",  methods=['GET','POST'])
def showBrowseResult():
    removefile("/tmp/browseOutput.json")
    data = ""
    req_idnum = ""
    req_mfct = ""
    req_ver = ""
    req_med = ""
    req_fab = ""

    try:
        print(request.form['secAddress'])
        secaddr = request.form['secAddress']
        s_p = secaddr.split(':')
        req_idnum,  req_mfct, req_ver, req_med = s_p[0].split('.')
        default = lambda x,  y: y if x == "" else x
        req_mfct = default(req_mfct,  "FFFF")
        req_ver = default(req_ver,  "FF")
        req_med = default(req_med,  "FF")
        secaddr = '.'.join([req_idnum, req_mfct, req_ver, req_med])
        if len(s_p) > 1:
            secaddr = secaddr + ":" + s_p[1]
            req_fab = s_p[1]
    except:
        traceback.print_exc()
        return render_template("show_browse_timeout.html")

    clearStateVariablesBeforeRequest()

    if scheduler.meterRequest(secaddr):
        print("STARTED")
        stateVariables.whichFunctionRuns = "reading_meter"
        while scheduler.running.is_alive():
            pass
        print("req_id {} stateVariable id {}".format(req_idnum, stateVariables.browse_output_id))
        print("req man {} stateVaraible man {}".format(req_mfct, stateVariables.browse_output_mfct))
        print("req ver {} stateVaraible ver {}".format(req_ver, stateVariables.browse_output_ver))
        print("req med {} stateVaraible med {}".format(req_med, stateVariables.browse_output_med))
        print("stateVaraible mfct_spec_ver {}".format(stateVariables.browse_output_mfct_spec_ver))

        print("id {} mfct {} ver {} med {}".format(req_idnum,req_mfct,req_ver,req_med))

        if mbl.compareSecAddresses(
            [
                stateVariables.browse_output_id,
                stateVariables.browse_output_mfct,
                stateVariables.browse_output_ver,
                stateVariables.browse_output_med
            ],
            [
                req_idnum,
                req_mfct,
                req_ver,
                req_med
            ]
            ) > 0:

            meterlist = []
            try:
                with open("/config/meterlist.csv") as file:
                    meterlist = list(weblib.rcf(file, ','))
            except Exception as e:
                traceback.print_exc()

            # Reading the wireless meterlist
            # We need to define when there should be an update for the
            # meters in wireless meterlist
            # Maybe we can look at the modification date on the wireless meterlist file
            # and decide from within a specific timeframe.
            # For now we only update the existing wireless meters from the file.
            try:
                wml = verify_meterlist.readWirelessMeterlist()
                print("wml", wml)

                wireless_map = wireless_node_optimise.createWirelessMap(wml)

                for i in range(len(meterlist)):
                    print("meterlist id mfct ver med", meterlist[i][0],meterlist[i][1],meterlist[i][2],meterlist[i][3])
                    mfct_spec_ver = (meterlist[i][1], meterlist[i][2], meterlist[i][3])
                    if mbl.compareSecAddresses(
                        [
                            stateVariables.browse_output_id,
                            stateVariables.browse_output_mfct,
                            stateVariables.browse_output_ver,
                            stateVariables.browse_output_med
                        ],
                        [
                            meterlist[i][0],
                            meterlist[i][1],
                            meterlist[i][2],
                            meterlist[i][3]
                        ]
                    ) > 0:
                        print("meterlist[i][0]",meterlist[i][0])
                        if meterlist[i][1].strip() == "" or meterlist[i][1] == 0xFFFF:
                            meterlist[i][1] = stateVariables.browse_output_mfct
                            print("meterlist[i][1]", meterlist[i][1])
                        if meterlist[i][2].strip() == "" or meterlist[i][2] == 0xFF:
                            meterlist[i][2] = stateVariables.browse_output_ver
                        if meterlist[i][3].strip() == "" or meterlist[i][3] == 0xFF:
                            meterlist[i][3] = stateVariables.browse_output_med

                        print("hex meterlist[i][1]",int(meterlist[i][1],16))
                        meterlist[i][4] = MfctToStr(int(meterlist[i][1],16))
                        meterlist[i][6] = stateVariables.browse_output_primary_address

                        metertype = meterlist[i][8].strip()

                        meterlist[i], _, metertype, fab = verify_meterlist.checkIfWireless(
                            wml,
                            meterlist[i],
                            metertype,
                            req_fab,
                            int(meterlist[i][0],16) & 0xFFFFFFFF,
                            int(meterlist[i][1],16) & 0xFFFF,
                            int(meterlist[i][2],16) & 0xFF,
                            int(meterlist[i][3],16) & 0xFF
                        )

                        if [meterlist[i][1], meterlist[i][2], meterlist[i][3]] in weblib.nodeaddresses:
                            meterlist[i][8] = "N"
                            meterlist[i][7] = "20"
                            meterlist[i][11] = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                        elif meterlist[i][8] == "R":
                            print("wireless meter")
                            key = tuple(meterlist[i][0:4])
                            print("key", key)
                            if key in wireless_map:
                                meterlist[i] = wireless_node_optimise.setFabricationAndStatus(meterlist[i], wireless_map[key])
                        else:
                            meterlist[i][8] = "W"

                            if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET:
                                if stateVariables.browse_output_mfct_spec_ver == "":
                                    meterlist[7] = "0"
                                else:
                                    meterlist[i][7] = "20"
                                    meterlist[i][11] = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                                    meterlist[i][12] = stateVariables.browse_output_mfct_spec_ver
                            else:
                                meterlist[i][7] = "20"
                                meterlist[i][11] = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")

                with open("/config/meterlist.csv",'w', newline='') as mlf:
                    mlwriter = csv.writer(mlf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
                    for meter in meterlist:
                        mlwriter.writerow(meter)
                #meterlist_to_cyclic_conf() Don't save cyclic list here
            except:
                traceback.print_exc()

        else:
            print("No answer from meter or wrong meter answering!!!")
    else:
        print("Request was not sent. Is the scheduler busy?")

    resp = False
    if os.path.isfile('/tmp/browseOutput.json'):
        with open('/tmp/browseOutput.json') as testFile:
            for line in testFile:
                data = json.loads(line)
        resp = True

    try:
        sa = secaddr.split(':')
        idnum, mfct, ver, med = sa[0].split('.')
        idnum = int(idnum,16)
        mfct  = int(mfct,16)
        mfctString=MfctToStr(mfct)
        ver   = int(ver,16)
        med   = int(med,16)

        theDeviceType = ""
        if  "%02X"%med in weblib.DeviceTypes:
            theDeviceType = weblib.DeviceTypes["%02X"%med]

        if mfctString in weblib.csvDict:
            mfctString = weblib.csvDict[mfctString]
    except:
        return render_template("show_browse_timeout.html")

    info = {
        'theDeviceType' : theDeviceType,
        'mfctString' : mfctString,
        'data' : data,
        #'csvDict' : csvDict,
        #'DeviceTypes' : DeviceTypes,
        'secaddr' : secaddr
    }
    if resp:
        return render_template("show_browse_result.html", **info )
    else:
        return render_template("show_browse_timeout.html", **info )

@search_blueprint.route("/upload_encryption_keys", methods=['GET', 'POST'])
def uploadEncryptionKeys():
    file = request.files["upload-encryption-keys_file"]
    if file:
        file.save("/tmp/encryption_keys.txt")
        encryption_keys = []
        try:
            with open("/tmp/encryption_keys.txt") as file:
                delimiter = weblib.sniffer_csv(file)
                encryption_keys = list(weblib.rcf(file, delimiter, 2))
        except Exception as e:
            print("error in upload_encryption_keys: "+str(e))
        data = []
        error_set = set()

        # Control the input from the encryption key upload
        for id in encryption_keys:
            print("id {0} key {1}".format(id[0], id[1]))
            if len(id[0]) < 8:
                id[0] = id[0].zfill(8)
            if id[0].isdigit() == False or len(id[1]) != 32 or id[1].isalnum() == False:
                print("id isdigit {}".format(id[0].isdigit()))
                print("len id[1] {}".format(len(id[1])))
                print("isalnum {}".format(id[1].isalnum()))
                error_dict = {}
                error_dict['id'] = id[0]
                error_dict['key'] = id[1]
                data.append(error_dict)
                error_set.add(id[0])

        # Add the wireless key to meterlist[9]
        meterlist = []
        try:
            with open("/config/meterlist.csv") as file:
                delimiter = weblib.sniffer_csv(file)
                meterlist = list(weblib.rcf(file, delimiter))
        except Exception as e:
            print("error in upload_encryption_keys: "+str(e))

        # Match the encryption key id with meter-id in the meterlist.
        # Since the encryption key info only contain id-number there will
        # only be a check for matching id-number.
        for en_m in encryption_keys:
            for meter in meterlist:
                print("en_m {}".format(en_m))
                if en_m[0] == meter[0]:
                    if en_m[0] in error_set:
                        print("en_m[0] {}".format(en_m[0]))
                        print("in_error_set")
                        break
                    else:
                        meter[9] = en_m[1]
                        print("in_else")
                        break
        meterlist = sorted(meterlist)

        with open("/config/meterlist.csv",'w', newline='') as mlf:
            mlwriter = csv.writer(mlf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            for meter in meterlist:
                mlwriter.writerow(meter)

        createWirelessInclude()

        # Return the array with incorrect id;encryption_key
        if len(data) == 0:
            data.append("NO_ERROR")
        JSONreturnArray = [data]
        JSONreturnArray = json.dumps(JSONreturnArray)
        return JSONreturnArray

def createWirelessInclude():
    # Write to /config/wireless_include_startup_config.csv
    meterlist, delimiter = loadMeterlist()
    with open("/config/wireless_include_startup_config.csv-tmp", "w") as file:
        mlwriter = csv.writer(file, delimiter=";", quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        start_row = [""]*4
        start_row[0] = "FFFFFFFF.FFFF.FF.FF"
        mlwriter.writerow(start_row)

        def write_meter(meter):
            temp_meter = "{0}.{1}.{2}.{3}".format(meter[0], meter[1], meter[2], meter[3])
            print(meter)
            wireless_meter = [""]*4
            wireless_meter[0] = temp_meter
            wireless_meter[2] = meter[9]
            print(wireless_meter)
            return wireless_meter

        for meter in meterlist:
            if meter[1] == "":
                meter[1] = "FFFF"
            if meter[2] == "":
                meter[2] = "FF"
            if meter[3] == "":
                meter[3] = "FF"
            if len(meter[9]) == 32 and meter[9].isalnum():
                mlwriter.writerow(write_meter(meter))

    os.rename("/config/wireless_include_startup_config.csv-tmp", "/config/wireless_include_startup_config.csv")
    try:
        restartWireless()
    except Exception as e:
        print("Is it a wireless unit?"+str(e))

@search_blueprint.route("/downloadEncryptionKeys", methods=["GET"])
def downloadEncryptionKeys():
    cstr = request.args.get('FILE')
    meterlist, delimiter = loadMeterlist()
    with open("/tmp/encryption_keys.txt", "w") as file:
        for meter in meterlist:
            if len(meter[9]) == 32 and meter[9].isalnum():
                line = meter[0] + ";" + meter[9] + "\n"
                file.write(line)

    try:
        return send_file('/tmp/encryption_keys.txt', attachment_filename=cstr, mimetype='application/octet-stream', as_attachment=True,  cache_timeout=0)
    except:
        return 'File not found'


# The upload meterlist route overwrite the existing /config/meterlist.csv file
@search_blueprint.route("/upload_meterlist",  methods=['GET',  'POST'])
def uploadMeterlist():
    file = request.files['meterlistfile']
    file_encoding = request.form.get("encoding")
    separator = request.form.get("separator")

    def join(string, letter) -> str:
        return string.join(letter)
    
    if file:
        meterlist = []
        try:
            file.save("/tmp/meterlist.csv")
            # This part is needed to sort out the meterlist header which are 
            # removed in the read_csv_file function
            with open("/tmp/meterlist.csv", encoding=file_encoding) as mlf:
                meterlist = list(weblib.rcf(mlf, separator))
                if file_encoding == 'latin-1':
                    templist = meterlist.copy()
                    meterlist.clear()
                    for row in templist:
                        newRow = []
                        for cell in row:
                            newRow.append(
                                cell.encode('latin-1', errors='replace')
                                .decode('latin-1', errors='replace'))
                        meterlist.append(newRow)
                meterlist = sorted(meterlist)
              
            for m in meterlist:
                if len(m[0]) < 8:
                    m[0] = m[0].zfill(8)
                # pad values with zeroes if not correct length.
                # Leave empty if empty
                if len(m[1]) > 0:
                    m[1] = m[1].zfill(4)
                if len(m[2]) == 1:
                    m[2] = m[2].zfill(2)
                if len(m[3]) == 1:
                    m[3] = m[3].zfill(2)
        except Exception as e:
            print("error in upload_meterlist: "+str(e))
        # This should be changed to /config/ for config file verification
        with open("/config/meterlist.csv", 'w', newline='', encoding='utf-8') as meterlistfile:
            mlwriter = csv.writer(
                meterlistfile, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            for meter in meterlist:
                mlwriter.writerow(meter)

        createWirelessInclude()
        JSONDict = {
            "responseText": "ok",
        }
        return make_response(jsonify(JSONDict), 200)


class Meter:    
    def __init__(self, **kwargs):
        self.id = kwargs['id']
        self.mfct = kwargs['mfct']
        self.ver = kwargs['ver']
        self.med = kwargs['med']
        self.mfct_str = kwargs['mfct_str']
        self.fab = kwargs['fab']
        self.prim = kwargs['prim']
        self.status = kwargs['status']
        self.type = kwargs['type']
        self.mfct_spec_ver = kwargs['mfct_spec_ver']
        self.channel_name = kwargs['channel_name']
        self.time_stamp = kwargs['time_stamp']
        self.read_period = kwargs['read_period']
        self.tag_type = kwargs['tag_type']
        self.time_stamp_telegram = kwargs['time_stamp_telegram']
        self.time_record_no =kwargs['time_record_no']
        self.is_found =kwargs['is_found']


@search_blueprint.route("/load_template_types", methods=["GET"])
def loadTemplateTypes():
    # Create a list of a all metertypes. One meter of each type
    meterlist = []
    templates = []
    try:
        with open("/config/meterlist.csv") as file:
            meterlist = list(weblib.rcf(file, ','))
    except Exception as e:
        print("error: "+str(e))

    try:
        with open("/config/template.csv") as file:
            templates = list(weblib.rcf(file=file,delimiter=',',minlen=45))
    except Exception as e:
        print(str(e))

    singleTypeMeterlist = []
    mfctvermed_mfctSpecVer = set()
    for meter in meterlist:

        mfct_spec_ver = (meter[1], meter[2], meter[3])
        try:
            if weblib.isHex(meter[1]) and weblib.isHex(meter[2]) and weblib.isHex(meter[3]) and meter[8] in ["R", "W", "N",  "H"]:
                if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET and meter[12] == "":
                    print("missing abb_spec_ver")
                    continue
                else:
                    m = (meter[1], meter[2], meter[3], meter[12])
                    if not m in mfctvermed_mfctSpecVer:
                        tmpl_name = MfctToStr(int(meter[1],16))+"_%02X_%02X"%(int(meter[2],16),int(meter[3],16))

                        if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET:
                            tmpl_name = "_".join([tmpl_name, meter[12]])
                    
                        meter1 = meter[0:9] #+ ['']# Careful. We should have some definitions to refer to. This is bad style programming but it works until it fails :)
                        meter1.append(meter[12]) # TIMESTAMP
                        print("meter1 ",meter1)
                        params = getTemplateParameters(tmpl_name,templates)
                        
                        mfctvermed_mfctSpecVer.add(m)
                        meterToSend = Meter(
                            id = meter1[0],
                            mfct = meter1[1],
                            ver = meter1[2],
                            med = meter1[3],
                            mfct_str = meter1[4],
                            fab = meter1[5],
                            prim = meter1[6],
                            status = meter1[7],
                            type = meter1[8],
                            mfct_spec_ver = meter1[9],
                            channel_name = params.channel_name,
                            time_stamp = params.time_stamp,
                            read_period = params.read_period,
                            tag_type = params.tag_type,
                            time_stamp_telegram = params.time_stamp_telegram,
                            time_record_no = params.time_record_no,
                            is_found =params.is_found,
                        )
                        print("METER TIMESTAMP: ", meterToSend.time_stamp)
                        singleTypeMeterlist.append(meterToSend.__dict__)
        except Exception as e:
            print("errror createing template types "+str(e))
            singleTypeMeterlist = ["error"]
    JSONDict = {
        "singleTypeMeterlist": singleTypeMeterlist,
    }
    return make_response(jsonify(JSONDict), 200)



@search_blueprint.route("/create_templates",  methods=['GET'])
def createTemplates():
    # Below are the default values. The values should be saved to /tmp/Browse.ini as soon as a meter to read from is selected. No further action should be needed.
    # Make the Id button gray as soon as the meter has been added to the meterlist
    # The user should be able to see and test the template file.

    serialno = weblib.serialNo()
    defaults = { 'format' : '3',
        'channel_name' : serialno,
        'time_stamp' : '24',
        'read_period' : '',
        'read_offset' : '',
        'tag_type' : '8',
        'time_stamp_telegram' : '0',
        'time_record_no' : '4',
        'device_format' : 'idmfctvermed'
        }
    if not os.path.exists("/tmp/Browse.ini"):
        browseini = weblib.configparser.RawConfigParser()
        browseini["BROWSE_PARAMETERS"] = defaults
        with open('/tmp/Browse.ini', 'w') as configfile:
            browseini.write(configfile)
    info = {
        "tab": "P",
    }
    try:
        browseini = weblib.configparser.RawConfigParser()
        browseini.read("/tmp/Browse.ini")
        info.update(browseini["BROWSE_PARAMETERS"])
    except Exception as e:
        print("failed to read Browse.ini in tmp")
        info.update(defaults)


    return render_template('create_template.html',  **info)


@search_blueprint.route("/merge_search_files")
def mergeSearchFilesRoute():
    functionDidStart = False
    if scheduler.addWired():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "add_wired"

    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/create_template_item",  methods=['POST'])
def createTemplateItem():
    # TODO
    # Make a create_template_item state in scheduler so
    # the logfile output can be viewed in the user
    # feedback window.

    serialno = weblib.serialNo()
    
    number_of_telegrams = 3

    mbushubini_def = weblib.configparser.RawConfigParser()
    mbushubini_def.read("/config/mbushub_default.ini")
    mbushubini = weblib.configparser.RawConfigParser()
    mbushubini.read("/config/mbushub.ini")

    parser = weblib.Configuration(mbushubini_def, mbushubini)
    sercomport = parser.get(float, "MasterPort", "timeout")

    time_out = (sercomport/1000) + 0.2
    print("sercomport_timeout", time_out)
    removefile("/tmp/browseOutput.json")

    if not os.path.exists("/tmp/Browse.ini"):
        browseini = weblib.configparser.ConfigParser()
        browseini["BROWSE_PARAMETERS"] = { 'format' : '3',
        'channel_name' : serialno,
        'time_stamp' : '24',
        'read_period' : '',
        'read_offset' : '',
        'tag_type' : '8',
        'time_stamp_telegram' : '0',
        'time_record_no' : '4',
        'device_format' : 'idmfctvermed'
        }
        with open('/tmp/Browse.ini', 'w') as configfile:
            browseini.write(configfile)
    
    browseini = weblib.configparser.ConfigParser()
    browseini.read('/tmp/Browse.ini')
    try:
        browseini["BROWSE_PARAMETERS"]["format"] = request.form["format"]
        browseini["BROWSE_PARAMETERS"]["time_stamp"] = request.form["time_stamp"]
        browseini["BROWSE_PARAMETERS"]["read_period"] = request.form["read_period"]
        browseini["BROWSE_PARAMETERS"]["read_offset"] = request.form["read_offset"]
        browseini["BROWSE_PARAMETERS"]["tag_type"] = request.form["tag_type"]
        browseini["BROWSE_PARAMETERS"]["time_stamp_telegram"] = request.form["time_stamp_telegram"]
        browseini["BROWSE_PARAMETERS"]["time_record_no"] = request.form["time_record_no"]
    except Exception as e:
        print("failed to read browse.ini parameters when creating a template item.", str(e))
    with open('/tmp/Browse.ini', 'w') as configfile:
        browseini.write(configfile)
    if not os.path.exists("/config/template.csv"):
        root = "[Root],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\r\n"
        channel = "[Channel],channel,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\r\n"#%browseini["BROWSE_PARAMETERS"]["channel_name"]
        with open("/config/template.csv",  'w') as f:
            f.write(root)
            f.write(channel)
    secaddr = request.form['secAddress']
    print("cti_secaddr %s"%secaddr)
    sec_a = secaddr.split(":")
    req_id,req_mfct,req_ver,req_med = sec_a[0].split(".")
    req_fab = ""
    if len(sec_a) > 1:
        req_fab = sec_a[1]

    meterlist, delimiter = loadMeterlist()
    req_mfct_spec_ver = ""
    for m in meterlist:
        
        if (
            m[0] == req_id and
            m[1] == req_mfct and
            m[2] == req_ver and
            m[3] == req_med
        ):
            req_mfct_spec_ver = m[12]
            break

    with open("/tmp/search_result.txt", "w") as logfile:
        for meter in meterlist:
            mfct_spec_ver = (meter[1], meter[2], meter[3])
            if (
                meter[1] == req_mfct and
                meter[2] == req_ver and
                meter[3] == req_med
            ):
                if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET and meter[12] == "":
                    print("ABB meter missing man_apec_ver")
                    continue
                if req_mfct_spec_ver == meter[12]:
                    req_meter = ".".join([meter[0], req_mfct, req_ver, req_med])
                    if meter[5]:
                        req_meter += ":" + meter[5]

                    for i in range(3):
                        logfile.write("Read {}.{}.{}.{}\n".format(meter[0],req_mfct,req_ver,req_med))
                        logfile.flush()
                        if askBrowse(weblib.ipNumber, weblib.ipPort, "u", req_meter, number_of_telegrams, 0, 0):
                            print("req_id {} stateVariable id {}".format(req_id, stateVariables.browse_output_id))
                            print("req man {} stateVaraible man {}".format(req_mfct, stateVariables.browse_output_mfct))
                            print("req ver {} stateVaraible ver {}".format(req_ver, stateVariables.browse_output_ver))
                            print("req med {} stateVaraible med {}".format(req_med, stateVariables.browse_output_med))
                            print("stateVaraible mfct_spec_ver {}".format(stateVariables.browse_output_mfct_spec_ver))

                            if mbl.compareSecAddresses(
                                [
                                    stateVariables.browse_output_id,
                                    stateVariables.browse_output_mfct,
                                    stateVariables.browse_output_ver,
                                    stateVariables.browse_output_med
                                ],
                                [
                                    meter[0],
                                    req_mfct,
                                    req_ver,
                                    req_med
                                ]
                                ) == 2:
                                print("The correct meter answered!")
                                logfile.write("Read OK\n")
                                logfile.flush()
                                resp, info = createJsonReturnDataForMeter(req_mfct,req_med, secaddr)

                                if resp:
                                    return render_template("create_template_item.html", **info )
                                else:
                                    return render_template("show_browse_timeout.html", **info )

                            else:
                                logfile.write("Wrong meter resp\n")
                                logfile.flush()
                                print("Not correct meter answered.")
                                time.sleep(time_out)

                        else:
                            print("Meter did not respond in Browse.py")
                            print(stateVariables.browse_output_error)
                            logfile.write(stateVariables.browse_output_error+"\n")
                            logfile.flush()
                            time.sleep(time_out)

    resp, info = createJsonReturnDataForMeter(req_mfct,req_med, secaddr)
    return render_template("show_browse_timeout.html", **info )

def createJsonReturnDataForMeter(req_mfct,req_med, secaddr):
    resp = False
    data = ""
    if os.path.isfile('/tmp/browseOutput.json'):
        with open('/tmp/browseOutput.json') as testFile:
            for line in testFile:
                data = json.loads(line)
        resp = True

    req_mfct = int(req_mfct,16)
    req_med = int(req_med,16)
    mfctString = MfctToStr(req_mfct)

    theDeviceType = ""
    if  "%02X"%req_med in weblib.DeviceTypes:
        theDeviceType = weblib.DeviceTypes["%02X"%req_med]

    if mfctString in weblib.csvDict:
        mfctString = weblib.csvDict[mfctString]

    info = {
        'mfct' : req_mfct,
        'theDeviceType' : theDeviceType,
        'mfctString' : mfctString,
        'data' : data,
        #'csvDict' : csvDict,
        #'DeviceTypes' : DeviceTypes,
        'secaddr' : secaddr
    }
    return resp, info

@search_blueprint.route("/add_template_item", methods=['GET', 'POST'])
def addTemplateItem():
    browseini = weblib.configparser.ConfigParser()
    browseini.read("/tmp/Browse.ini")
    time_stamp_type = browseini["BROWSE_PARAMETERS"]["time_stamp_telegram"]
    objectStatusList = []

    device = request.form['device']
    nrOfObjects = request.form['numberOfObjects']

    # The vifList contains all the vifs set by the user
    vifList = []
    for i in range(1, int(nrOfObjects)+1):
        vif = ""
        try:
            vif = request.form[str(i)+"-vif"]
            vifList.append(vif)
        except Exception as e:
            print("error vifList "+str(e))

    try:
        report_statusbyte = request.form['status'] == "ON"
    except Exception:
        report_statusbyte = False


    try:
        report_meter_id = request.form['meter_id'] == 'ON'
    except Exception:
        report_meter_id = False

    for i in range(1, int(nrOfObjects)+1):
        objectStatus = ""
        try:
            objectStatus = request.form[str(i)]
            objectStatusList.append(str(i))
        except:
            pass
    
    browse_output = {}
    try:
        with open('/tmp/browseOutput.json','r') as file:
           browse_output = json.load(fp=file)
    except Exception as e:
        print("Failed to read from /tmp/browseoutput.json when adding template item.", str(e))
    
    template_name = browse_output['device']['name']
    meter_id = browse_output['device']['adress'].split('.')[0]

    template = []
    try:
        with open("/tmp/templates_tmp.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            template = list(weblib.rcf(file, delimiter, 45))
    except Exception as e:
        print("error in add_template_item: "+str(e))

    with open("/tmp/temporary_tmp.csv", "w") as tmp:
        writer = csv.writer(tmp, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        counter = 0
        meter_id_written = False
        for line in template:
            print("len(template)",len(template))
            if line[0] == "[Device]":
                writer.writerow(line)
                meter_id_written = False
            elif line[0] == '[Tag]':
                if line[20] == "22" and report_statusbyte:
                    writer.writerow(line)
                elif report_meter_id and not meter_id_written:
                    # add meter id
                    meter_id_line = [ "" for i in range(45) ]
                    meter_id_line[0] = "[Tag]"
                    meter_id_line[1] = "channel"
                    meter_id_line[3] = template_name
                    meter_id_line[4] = "MeterID"
                    meter_id_line[20] = "17"
                    meter_id_line[21] = "8"
                    meter_id_line[22] = "1"

                    writer.writerow(meter_id_line)
                    meter_id_line[4] = meter_id_line[4] + "_Mod" 
                    meter_id_line[21] = "3"
                    writer.writerow(meter_id_line)
                    meter_id_written = True
                
                
                if line[19] in objectStatusList:
                    # Step up the tag counter if the vif ends with _Mod which is set in Browse.py
                    # The regular tag always comes one row before the _Mod tag
                    if line[4].endswith("_Mod"):
                        line[4] = vifList[counter]+"_Mod"
                        counter = counter+1
                    else:
                        print("counter",counter)
                        if time_stamp_type == "0":
                            line[4] = vifList[counter]
                        else:
                            # If time_stamp_type == "2" user has choosen time stamp = "Telegram" and there is a
                            # time object added by Browse.py in the end of csv file for this meter.
                            # The [Device] rows in the csv file field[24] has time_format + time_stamp_type, if time format is 16
                            # +2 will be added when user choose time stamp = "Telegram".
                            # tagtype is 1, which means value
                            # datatype is 8 which means "Record" (reading out string)
                            # vif is "time"
                            # record number is 4 by default but can be changed by user in create_tempalte.html,
                            # wireless meters received by PiiGAB units always have time in record nr. 4
                            # Quickpost use this object to add the timestamp.
                            if int(counter) == int(nrOfObjects):
                                writer.writerow(line)
                                break
                    writer.writerow(line)

    try:
        appendFileToFile("/config/template.csv", "/tmp/temporary_tmp.csv")
    except Exception as e:
        traceback.print_exc()

    return redirect("/create_templates")

@search_blueprint.route("/mymeters_overview")
def mymetersOverview():

    serialno = ""
    if not os.path.exists("/tmp/Browse.ini"):
        try:
            mbs=os.popen("/binary/mbushub.elf -S")
            serialno=mbs.readline().strip('\n')
            mbs.close()
        except:
            pass
    else:
        browseini = weblib.configparser.ConfigParser()
        browseini.read("/tmp/Browse.ini")
        serialno = browseini["BROWSE_PARAMETERS"]["channel_name"]
        if serialno == "":
            try:
                mbs=os.popen("/binary/mbushub.elf -S")
                serialno=mbs.readline().strip('\n')
                mbs.close()
            except:
                pass

    info = {
        "tab": "P1",
        'serialno' : serialno,
    }
    return render_template('mymeters_overview.html',  **info)

@search_blueprint.route("/create_main_csv_file", methods=['GET', 'POST'])
def createMainCsvFileRoute():
    content = request.get_json()

    device_format = content["device_format"]
    channel_name = content["channel_name"]
    number_of_telegrams = content["number_of_telegrams"]
    max_value_age = content["max_value_age"]

    modbus = content["modbus"]

    modbus = True if modbus == "true" else False

    print("device_format ",device_format)
    print("channel_name ",channel_name)
    print("modbus",modbus)

    stateVariables.device_format = device_format
    stateVariables.channel_name = channel_name
    functionDidStart = False

    if scheduler.createMainCsvFile(device_format, channel_name, modbus, number_of_telegrams, max_value_age):
        functionDidStart = True
        stateVariables.whichFunctionRuns = "create_main_csv_file"

    running = scheduler.running != None and scheduler.running.is_alive()
    status = scheduler.report()
    JSONDict = {
        "running": running,
        "status": status,
        "functionDidStart": functionDidStart,
    }
    return make_response(jsonify(JSONDict), 200)

COLUMN_NUMBER_OF_TELEGRAMS = 13

def createMainCsvFile(device_format, channel_name, modbus, number_of_telegrams=3, max_value_age=60):
    inMyconfig = ""
    # The modbus variable sets to 'true' when user dont want the earlier modbus registers to be shifted
    if not modbus:
        if os.path.exists("/config/masterport_Mbus2Modbus.csv"):
            shutil.copyfile("/config/masterport_Mbus2Modbus.csv","/config/backup_masterport_Mbus2Modbus.csv")
        if os.path.exists("/config/slaveport_Mbus2Modbus.csv"):
            shutil.copyfile("/config/slaveport_Mbus2Modbus.csv", "/config/backup_slaveport_Mbus2Modbus.csv")
        if os.path.exists("/config/slaveport_Mbus2Modbus_register_description.csv"):
            shutil.copyfile("/config/slaveport_Mbus2Modbus_register_description.csv", "/config/backup_slaveport_Mbus2Modbus_register_description.csv")
    else:
        inMyconfig = checkIfMeterInMyConfig()

    channel_default = weblib.serialNo()

    if channel_name == "":
        channel_name = channel_default

    df = device_format

    browseini = weblib.configparser.RawConfigParser()

    try:
        browseini.read("/tmp/Browse.ini")
        browseini["BROWSE_PARAMETERS"]["device_format"] = df
        browseini["BROWSE_PARAMETERS"]["channel_name"] = channel_name
        with open('/tmp/Browse.ini', 'w') as configfile:
            browseini.write(configfile)
    except Exception as e:
        traceback.print_exc()

    meterlist = []

    try:
        with open("/config/meterlist.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            meterlist = list(weblib.rcf(file, delimiter))
    except Exception as e:
        traceback.print_exc()

    # Append 'true' to each meter present in my_config.csv
    if modbus:
        for meter in meterlist:
            secaddr = "{}.{}.{}.{}".format(meter[0], meter[1], meter[2], meter[3])
            for m in inMyconfig:
                if secaddr == m:
                    meter.append("true")
                    break

    # Save all the different template-names in a set to be able to compare
    # to each meter in the meterlist.
    template = []
    try:
        with open("/config/template.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            template = list(weblib.rcf(file, delimiter, 11))
    except Exception as e:
        traceback.print_exc()

    template_set = set()
    for temp in template:
        if temp[0] == "[Device]":
            if temp[3] not in template_set:
                template_set.add(temp[3])

    print("template", template_set)
    print("meterlist", meterlist)

    # Try read the modbus_register.ini file if modbus == "true"
    registerCounter = 100
    if modbus:
        try:
            modbusregisterini = weblib.configparser.RawConfigParser()
            modbusregisterini.read("/config/modbus_register.ini")
            registerCounter = int(modbusregisterini["Main"]["register"])
        except Exception as e:
            traceback.print_exc()

    length = len(meterlist)

    # Set the mode to 'a+' append if user wants to append new meters to avoid shifting modbus registers
    mode = ""
    if modbus:
        mode = "a+"
    else:
        mode = "w"
    writeHeader = False

    # Only write header(root,channel) if modbus is false.
    # Which means we do not append, we start over.
    if not os.path.exists("/config/masterport_Mbus2Modbus.csv") or modbus == False:
        writeHeader = True

    with open("/config/masterport_Mbus2Modbus.csv", mode,newline='') as cf:
        writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        if writeHeader:
            for row in template:
                if len(row) < 1:
                    continue
                if row[0].lower() =='[root]':
                    writer.writerow(row)
                    break
            for row in template:
                if len(row) < 1:
                    continue
                if row[0].lower() == '[channel]':
                    row[1] = channel_name
                    writer.writerow(row)
                    break

        def makeASCIICompatible(input):
            copy = ""

            for i in range(0,len(input)):
                if input[i] in weblib.conversion_table:
                    copy += weblib.conversion_table[input[i]]
                else:
                    copy += input[i]
            return copy

        def replaceIllegalCharacters(string):
            return ''.join([i if ord(i) < 128 else '?' for i in string])

        def roundUp(register):
            return int(math.ceil(register / 100.0)) * 100

        for count,rs in enumerate(meterlist):
            try: # Only add template if the secondary address is ok
                idnum = int(rs[0], 16)
                mfct = int(rs[1], 16)
                ver = int(rs[2], 16)
                med = int(rs[3], 16)

                descriptionString = ""
                if len(rs[10]) > 0:
                    descriptionString = makeASCIICompatible(rs[10])
                    descriptionString = replaceIllegalCharacters(descriptionString)

                metername = "%s_%02X_%02X"%(MfctToStr(mfct), ver, med)
                if metername == "ABB_20_02" and rs[12] != "":
                    metername = "_".join([metername, rs[12]])
                secaddr = "%08X.%04X.%02X.%02X"%(idnum, mfct, ver, med)
                if device_format == "idmfctvermed":
                    devicename = "%08X%s%02X%02X"%(idnum,MfctToStr(mfct) , ver, med)
                elif device_format == "mfctid":
                    devicename = "%s%08X"%(MfctToStr(mfct),  idnum)
                elif device_format == "id":
                    devicename = "%08X"%idnum
                elif device_format == "description" and rs[10] != "":
                    devicename = descriptionString
                elif device_format == "description" and rs[10] == "":
                    devicename = "%08X%s%02X%02X"%(idnum,MfctToStr(mfct) , ver, med)
                fab = None
                try:
                    fab = int(rs[5], 16)
                except:
                    pass
                if fab:
                    secaddr += ":"+"%08X"%fab
                for rt in template:
                    # Looks if 'true' is appended to the meter in meterlist
                    # Which means the meter are present in my_config.csv
                    # If the user do not care about shifting modbus registers => modbus == 'false'
                    if (rs[-1] != "true" and modbus == True) or modbus == False:
                        if rt[0].lower() == '[device]' and rt[3] == metername:
                            row=copy.copy(rt)
                            row[1] = channel_name
                            row[3] = devicename
                            # Adding the description
                            if len(rs[10]) > 0:
                                row[7] = descriptionString

                            row[COLUMN_NUMBER_OF_TELEGRAMS] = number_of_telegrams
                            row[43] = max_value_age
                            row[19] = secaddr

                            writer.writerow(row)

                        if rt[0].lower() == '[tag]' and rt[3] == metername:
                            row = copy.copy(rt)
                            row[1] = channel_name
                            row[3] = devicename
                            tagname = row[4]
                            # Adding description
                            if rs[10] != "":
                                row[7] = descriptionString

                            if tagname[-4:].lower() == "_mod":
                                # JumpLength set to 0. If no info in row[21] no jump are made
                                # It is not a modbus readable object. Probably an LVAR or some sort of mfct specific object
                                jumpLength = 0
                                registCounterString = str(registerCounter)

                                if row[21] == "2":
                                    jumpLength = 1
                                    row[38] = registCounterString
                                elif row[21] == "3":
                                    jumpLength = 2
                                    row[38] = registCounterString
                                elif row[21] == "4":
                                    jumpLength = 4
                                    row[38] = registCounterString
                                elif row[21] == "20":
                                    jumpLength = 4
                                    row[38] = registCounterString

                                registerCounter = registerCounter + jumpLength

                            writer.writerow(row)

                registerCounter = roundUp(registerCounter)

            except Exception as e:
                traceback.print_exc()


    # Writing the Mbus2Modbus.csv which will be put in the slaveport.
    mc = []

    try:
        with open("/config/masterport_Mbus2Modbus.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            mc = list(weblib.rcf(file, delimiter, 45))
    except Exception as e:
        traceback.print_exc()

    try:
        with open("/config/slaveport_Mbus2Modbus.csv", 'w',newline='') as cf:
            writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            for row in mc:
                modRow = ['']*5
                tagname = row[4]
                dataType = row[21]
                if tagname[-4:].lower() == "_mod" and len(dataType) > 0:
                    modRow[0] = "[item]"
                    modRow[1] = row[38]
                    modRow[3] = "{}.{}.{}".format(row[1],row[3],row[4])

                    # JumpLength set to 0. If no info in row[21] no jump are made
                    # It is not a modbus readable object. Probably an LVAR or some sort of mfct specific object
                    #jumpLength = 0

                    if dataType == "2":
                        modRow[4] = "INT16"
                    elif dataType == "3":
                        modRow[4] = "INT32"
                    elif dataType == "4":
                        modRow[4] = "FLOAT"
                    elif dataType == "20":
                        modRow[4] = "INT64"
                    else:
                        modRow[4] = "Undefined"

                    writer.writerow(modRow)
    except Exception as e:
        traceback.print_exc()

    # Write to myconfig WITHOUT the _Mod tags.
    mq = []
    try:
        with open("/config/masterport_Mbus2Modbus.csv") as file:
            delimiter = weblib.sniffer_csv(file)
            mq = list(weblib.rcf(file, delimiter, 45))
    except Exception as e:
        traceback.print_exc()

    with open('/config/myconfig.csv',  "w",  newline="") as qf:
        writer = csv.writer(qf,  delimiter=",",  quotechar='\"',  quoting=csv.QUOTE_MINIMAL)
        for m in mq:
            tagname = m[4]
            if tagname[-4:].lower() != "_mod":
                writer.writerow(m)

    # Write to the modbus_register.ini file
    with open("/config/modbus_register.ini", "w") as file:
        file.write("[Main]\n")
        file.write("register="+str(registerCounter)+"\n")

    mbushubini = weblib.configparser.ConfigParser()
    mbushubini.read("/config/mbushub.ini")

    mbushubini["MasterPort"]["csvfile"] = "masterport_Mbus2Modbus.csv"
    with open('/config/mbushub.ini', 'w') as configfile:
        mbushubini.write(configfile)

    subprocess.call(["%s/etc/init.d/S94mbushub"% weblib.PROOT,"restart"])
    subprocess.call(["%s/etc/init.d/S49cyclic"% weblib.PROOT,"restart"])

def restartQuickpost():
    quickpostini = weblib.configparser.ConfigParser()
    if len(quickpostini.read("/config/quickpost.ini")) == 0:
        # If the file doesn't exist we need to read from the
        # default configuration file instead to avoid crashing
        quickpostini.read("/config/quickpost_default.ini")

    quickpostini["Main"]["csvfile"] = "myconfig.csv"
    with open('/config/quickpost.ini-tmp', 'w') as configfile:
        quickpostini.write(configfile)

    os.rename("/config/quickpost.ini-tmp", "/config/quickpost.ini")

    subprocess.call(["%s/etc/init.d/S95quickpost"% weblib.PROOT,"restart"])

def restartWireless():
    wireless = weblib.configparser.ConfigParser()
    if len(wireless.read("/config/wireless.ini")) == 0:
        # If the file doesn't exist we need to read from the
        # default configuration file instead to avoid crashing
        wireless.read("/config/wireless_default.ini")

    wireless["Main"]["include_file"] = "wireless_include_startup_config.csv"
    with open('/config/wireless.ini-tmp', 'w') as configfile:
        wireless.write(configfile)

    os.rename("/config/wireless.ini-tmp", "/config/wireless.ini")

    subprocess.call(["%s/etc/init.d/S98wireless"% weblib.PROOT,"restart"])

@search_blueprint.route("/search_page", methods=['GET', 'POST'])
def searchPage():

    info = {
        "tab": "S"
    }
    return render_template("search.html", **info)

@search_blueprint.route("/start_node_search", methods=["GET", "POST"])
def startNodeSearchRoute():
    functionDidStart = False
    if scheduler.startNodeSearch():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "node_search"

    print("functionDidStart", functionDidStart)
    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray



class BrowseParameters:

    def __init__(
        self,format,channel_name,
        time_stamp,read_period,read_offset,
        tag_type,time_stamp_telegram,
        time_record_no,device_format
        ): # type: (str,str,str,str,str,str,str,str,str)-> BrowseParameters | ValueError
            if not format: raise ValueError("Empty format")
            if not channel_name: raise ValueError("Empty channel_name")
            if not time_stamp: raise ValueError("Empty time_stamp")
            if not tag_type: raise ValueError("Empty tag_type")
            if not time_stamp_telegram: raise ValueError("Empty time_stamp_telegram")
            if not device_format: raise ValueError("Empty device_format")
            if not time_record_no: time_record_no = ''
            if not read_period: read_period = '' #raise ValueError("Empty read_period")
            if not read_offset: read_offset = '' #raise ValueError("Empty read_offset")

            self.format = format 
            self.channel_name = channel_name
            self.time_stamp = time_stamp
            self.read_period = read_period
            self.read_offset = read_offset
            self.tag_type = tag_type
            self.time_stamp_telegram = time_stamp_telegram
            self.time_record_no = time_record_no
            self.device_format = device_format

@search_blueprint.route("/start_secondary_search", methods=["GET", "POST"])
def startSecondarySearchRoute():
    content = request.get_json()
    print("content[0] ",content[0])
    print(type(content[0]))
    id_num = int(content[0],16)
    manufacturer = int(content[1],16)
    version = int(content[2],16)
    medium = int(content[3],16)
    timeoutMode = content[4]
    print("idnum {}".format(id_num))
    print("manufacturer {}".format(manufacturer))
    print("version {}".format(version))
    print("medium {}".format(medium))
    stateVariables.idnum = id_num
    stateVariables.mfct = manufacturer
    stateVariables.ver = version
    stateVariables.med = medium
    stateVariables.timeoutMode = timeoutMode
    functionDidStart = False
    if scheduler.startSecondary(id_num,manufacturer,version,medium,timeoutMode):
        functionDidStart = True
        stateVariables.whichFunctionRuns = "secondary_search"

    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))

    status = stateVariables.whichFunctionRuns
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/stop_secondary_search", methods=["GET", "POST"])
def stopSecondarySearch():
    if scheduler.running:
        scheduler.channel.set()
        scheduler.running.join()
        scheduler.channel.clear()
    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/start_primary_search", methods=["GET", "POST"])
def startPrimarySearch():
    content = request.get_json()
    startaddr = int(content[0])
    endaddr = int(content[1])
    print("startaddr {}".format(startaddr))
    print("endaddr {}".format(endaddr))
    stateVariables.startaddr = startaddr
    stateVariables.endaddr = endaddr

    functionDidStart = False
    if scheduler.startPrimary(startaddr,endaddr):
        functionDidStart = True
        stateVariables.whichFunctionRuns = "primary_search"
    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/stop_primary_search", methods=["GET","POST"])
def stopPrimarySearch():
    if scheduler.running:
        scheduler.channel.set()
        scheduler.running.join()
        scheduler.channel.clear()

    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/meters_found", methods=['GET', 'POST'])
def metersFoundRoute():
    meters_found = []
    try:
        with open("/tmp/meters_found.txt") as file:
            try:
                meters_found = list(weblib.rcf(file, ";"))
            except Exception as e:
                return make_response("rcf error: "+str(e),400)
    except Exception as e:
        print("error in meterlist route: "+str(e))
        try:
            with open("/tmp/meters_found.txt") as file2:
                return make_response("error: "+file2.read(), 400)
        except Exception as e:
            print("error in reading meters_found.txt" + str(e))

    nodes_found = []
    try:
        with open("/tmp/nodes_found.txt") as file:
            delimiter = weblib.sniffer_csv(file)
            nodes_found = list(weblib.rcf(file, delimiter))
    except Exception as e:
        print("error in meterlist route: "+str(e))

    if request.method == 'GET' and request.is_json:

        print("in get /meters_found!")
        metersfound = []

        for row in meters_found:
            mf= {}
            mf['id'] = row[0]
            mf['mfct'] = row[1]
            mf['ver'] = row[2]
            mf['med'] = row[3]
            mf['mfct_str'] = row[4]
            mf['fab'] = row[5]
            mf['prim'] = row[6]
            mf['status'] = row[7]
            mf['type'] = row[8]
            mf['key'] = row[9]
            mf['description'] = row[10]
            mf['timestamp'] = row[11]
            metersfound.append(mf)

        nodesfound = []

        for row in nodes_found:
            nf= {}
            nf['id'] = row[0]
            nf['mfct'] = row[1]
            nf['ver'] = row[2]
            nf['med'] = row[3]
            nf['mfct_str'] = row[4]
            nf['fab'] = row[5]
            nf['prim'] = row[6]
            nf['status'] = row[7]
            nf['type'] = row[8]
            nf['key'] = row[9]
            nf['description'] = row[10]
            nf['timestamp'] = row[11]
            nodesfound.append(nf)

        search_result = []
        try:
            search_result = lastNlines()
        except Exception as e:
            print("error lastNlines: {}".format(e))

        running = scheduler.running != None and scheduler.running.is_alive()
        status = scheduler.report()
        addressData = {
            "start": stateVariables.startaddr,
            "end": stateVariables.endaddr,
            "id": format(stateVariables.idnum,"08X"),
            "mfct": format(stateVariables.mfct,"04X"),
            "ver": format(stateVariables.ver,"02X"),
            "med": format(stateVariables.med,"02X"),
        }
        JSONDict = {
            "metersfound": metersfound,
            "nodesfound": nodesfound,
            "running": running,
            "status": status,
            #"DeviceTypes": DeviceTypes,
            #"csvDict": csvDict,
            "addressData": addressData,
            "search_result": search_result,
        }

        return make_response(jsonify(JSONDict), 200)

@search_blueprint.route("/menu_status", methods=["GET", "POST"])
def menuStatus():
    search_result = []
    try:
        search_result = lastNlines()
    except Exception as e:
        #print("error lastNlines: {}".format(e))
        search_result = ["no_result"]
    running = scheduler.running != None and scheduler.running.is_alive()
    status = scheduler.report()
    if not running:
        status = "no_search_running"
        stateVariables.whichFunctionRuns = "no_function"

    board_temperature = "Missing"
    mbus_stage_temperature = "Missing"

    error_flag = 0
    try:
        conf = weblib.configparser.RawConfigParser()
        conf.read('/tmp/pi900_state.txt')
        board_temperature = conf.get('Main','Temperature_40V')
        mbus_stage_temperature = conf.get('Main','Temperature_MBus')

        error_flag  = int(conf.get('Main','MBusErrorVal'))
    except:
        pass

    error_message="No error"
    if (error_flag & 1):
        error_message = "M-Bus Overload"
    if (error_flag & 2):
        error_message = "M-Bus Short Circuit"
    mbusCurrent = 0
    mbusMaxCurrent = 0
    mbusVoltage = 0
    try:
        mbusVoltage      = float(conf.get('Main','MBusVoltage'))
        mbusCurrent      = float(conf.get('Main','MbusCurrent'))
        mbusMaxCurrent   = float(conf.get('Main','MbusMaxCurrent'))
    except:
        pass

    mbusCurrentString      = "%.1f mA"%mbusCurrent
    mbusMaxCurrentString   = "%.1f mA"%mbusMaxCurrent
    mbusVoltageString      = "%.1f V"%mbusVoltage
    mbusCurrentPercentUsed = "Unavailable"
    if mbusMaxCurrent > 0:
        mbusCurrentPercentUsed = "{}% of mbus loop".format(int(mbusCurrent/mbusMaxCurrent * 100))

    JSONDict = {
        "error_message": error_message,
        "mbusCurrentString": mbusCurrentString,
        "mbusMaxCurrentString": mbusMaxCurrentString,
        "mbusCurrentPercentUsed": mbusCurrentPercentUsed,
        "board_temperature": board_temperature,
        "mbus_stage_temperature": mbus_stage_temperature,
        "mbusVoltageString": mbusVoltageString,
        "running": running,
        "status": status,
        "search_result": search_result,
        "whichFunctionRuns": stateVariables.whichFunctionRuns,
    }
    return make_response(jsonify(JSONDict), 200)

@search_blueprint.route("/add_wireless")
def addWireless2():
    functionDidStart = False
    if scheduler.addWireless():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "add_wireless"

    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/verify_meterlist", methods=['GET'])
def verifyMeterlistRoute():
    functionDidStart = False
    if scheduler.verifyMeterlist():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "verify_meterlist"
    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/read_meterlist", methods=['GET'])
def readMeterlistRoute():
    functionDidStart = False
    if scheduler.readMeterlist():
        functionDidStart = True
        stateVariables.whichFunctionRuns = "read_meterlist"
    running = scheduler.running != None and scheduler.running.is_alive()
    print("running {}".format(running))
    status = scheduler.report()
    print("status {}".format(status))
    JSONreturnArray = [running, status, functionDidStart]
    JSONreturnArray = json.dumps(JSONreturnArray)
    return JSONreturnArray

@search_blueprint.route("/show_csv_file", methods=["GET","POST"])
def showCsvFileRoute():
    fname='/config/'+os.path.basename(request.args.get('FILE'))
    try:
        f=open(fname,encoding="utf-8")
        a=f.read()
        f.close()
        str0 = "\n\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n</head>\n<body>\n<table border=1>\n<tr>\n<td>"
        for i in range(0,37):
            str0 += "%d</td><td>"%i
        str0 += "</td>\n</tr>\n<tr>\n<td>"
        str0 += "%s"%a.replace(',','</td><td>').replace('\r','').replace('\n','</td>\n</tr>\n<tr>\n<td>').replace('<td></td>','<td>&nbsp;</td>')
        str0 += "</td>\n</tr>\n</body>\n</html>"
        return render_template_string(str0)
    except:
        error_string = "\n\n<html>\n<head>\n<meta charset=\"UTF-8\">\n</head>\n<body>\n"
        error_string += "<h1>No such file, have it been created?</h1>"
        error_string += "</body>\n</html>"
        return render_template_string(error_string)

@search_blueprint.route("/get_status", methods=["GET"])
def getStatus():
    running = scheduler.running != None and scheduler.running.is_alive()
    status = scheduler.report()
    if status == "no_search_running":
        stateVariables.whichFunctionRuns = "no_function"
    JSONDict = {
        "running": running,
        "status": status,
        "whichFunctionRuns": stateVariables.whichFunctionRuns,
    }
    return make_response(jsonify(JSONDict), 200)

@search_blueprint.route("/auto_template_generator", methods=['POST'])
def autoTemplateRoute():
    form_data = request.get_json()
    
    removefile("/tmp/browseOutput.json")
    serialno = weblib.serialNo()
    device_format = "idmfctvermed"

    functionDidStart = False
    print("form data:", form_data)
    number_of_telegrams = 3
    parameters = BrowseParameters(
        format=form_data['format'],
        channel_name=serialno,
        read_offset=form_data['read_offset'],
        read_period=form_data['read_period'],
        time_stamp=form_data['time_stamp'],
        time_stamp_telegram=form_data['time_stamp_telegram'],
        tag_type=form_data['tag_type'],
        time_record_no=form_data['time_record_no'],
        device_format=device_format
    )
    print("parameters:", parameters.__str__)

    if scheduler.autoTemplateGenerator(parameters=parameters,number_of_telegrams=number_of_telegrams):
        functionDidStart = True
        stateVariables.whichFunctionRuns = "auto_template_generator"
    running = scheduler.running != None and scheduler.running.is_alive()
    status = scheduler.report()
    print("status in auto:",status)
    JSONDict = {
        "running": running,
        "status": status,
        "functionDidStart": functionDidStart,
    }
    return make_response(jsonify(JSONDict), 200)

@search_blueprint.route("/auto_create_myconfig", methods=['GET', 'POST'])
def autoCreateMyconfigRoute():
    removefile("/tmp/browseOutput.json")
    removefile("/config/template.csv")
    serialno = weblib.serialNo()
    print("serialno in autocreatemyconfig ",serialno)
    device_format = "idmfctvermed"
    modbus = False

    number_of_telegrams = request.args.get('number_of_telegrams', default=3)
    max_value_age = request.args.get('max_value_age', default=3)

    functionDidStart = False
    if scheduler.autoCreateMyConfig(device_format,serialno,modbus, number_of_telegrams,max_value_age):
        functionDidStart = True
        stateVariables.whichFunctionRuns = "auto_create_myconfig"
    running = scheduler.running != None and scheduler.running.is_alive()
    status = scheduler.report()
    JSONDict = {
        "running": running,
        "status": status,
        "functionDidStart": functionDidStart,
    }
    return make_response(jsonify(JSONDict), 200)

# Appends a text files content to another file
def appendFileToFile(destination, source):
    with open(destination, "a+") as dst:
        with open(source, "r") as src:
            dst.write(src.read())

def autoCreateTemplateFunc(params,number_of_telegrams=3,max_value_age=60) : # type:(BrowseParameters,int) -> TemplateParameters 
    removefile("/config/template.csv")
    mbushubini_def = weblib.configparser.RawConfigParser()
    mbushubini_def.read("/config/mbushub_default.ini")
    mbushubini = weblib.configparser.RawConfigParser()
    mbushubini.read("/config/mbushub.ini")
    
    parser = weblib.Configuration(mbushubini_def, mbushubini)
    sercomport = parser.get(float, "MasterPort", "timeout")

    # Maybe we should add the switchblocktime here instead of +0.2 sec
    # Or do we add 0.2 sec because we could have waited 100ms before the first
    # initialization of the slave and then 100ms seconds after the req_ud2 answer?
    time_out = (sercomport/1000) + 0.2
    print("timeout masterport sercomport",time_out)
    
    browseini = weblib.configparser.ConfigParser()

    browseini["BROWSE_PARAMETERS"] = {
        'format' :  params.format,
        'channel_name' : params.channel_name,
        'time_stamp' : params.time_stamp,
        'read_period' : params.read_period,
        'read_offset' : params.read_offset,
        'tag_type' : params.tag_type,
        'time_stamp_telegram' : params.time_stamp_telegram,
        'time_record_no' : params.time_record_no,
        'device_format' : params.device_format
    }

    with open('/tmp/Browse.ini', 'w') as configfile:
        browseini.write(configfile)

    if not os.path.exists("/config/template.csv"):
        root = "[Root],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\r\n"
        channel = "[Channel],channel,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\r\n"#%browseini["BROWSE_PARAMETERS"]["channel_name"]
        with open("/config/template.csv",  'w') as f:
            f.write(root)
            f.write(channel)

    meterlist, delimiter = loadMeterlist()

    mfctvermed_mfctSpecVer = set()

    with open("/tmp/search_result.txt", "w") as logfile:
        for meter in meterlist:
            mfct_spec_ver = (meter[1], meter[2], meter[3])
            if meter[0] and meter[1] and meter[2] and meter[3]:

                if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET and meter[12] == "":
                    print("ABB2002 missing man_spec_ver")
                    continue
                m = (meter[1], meter[2], meter[3], meter[12])

                # Ask each meter of the same type up to 3 times.
                for i in range(3):
                    if not m in mfctvermed_mfctSpecVer:
                        # Only set Browse parameters first try.
                        if i == 0:
                            if meter[8] == "N":
                                break
                            if meter[8] == "W":
                                browseini["BROWSE_PARAMETERS"]["time_stamp_telegram"] = "0"
                                browseini["BROWSE_PARAMETERS"]["time_record_no"] = ""
                                with open('/tmp/Browse.ini', 'w') as configfile:
                                    browseini.write(configfile)
                            elif meter[8] == "R":
                                browseini["BROWSE_PARAMETERS"]["time_stamp_telegram"] = "2"
                                if browseini["BROWSE_PARAMETERS"]["time_record_no"] == "":
                                    browseini["BROWSE_PARAMETERS"]["time_record_no"] = "4"
                                with open('/tmp/Browse.ini', 'w') as configfile:
                                    browseini.write(configfile)
                            secaddr = "%s.%s.%s.%s"%(meter[0], meter[1], meter[2], meter[3])
                            if meter[5]:
                                secaddr += ":%s"%meter[5]
                            print("secaddr_ %s"%secaddr)

                        removefile("/tmp/browseOutput.json")

                        print("before askBrowse", secaddr)

                        # If askBrowse returns True a meter answered to the REQ_UD2
                        # We then need to see if it is the same meter as we requested.
                        logfile.write("Read %s.%s.%s.%s\n"%(meter[0],meter[1],meter[2],meter[3]))
                        logfile.flush()
                        try:

                            if askBrowse(weblib.ipNumber, weblib.ipPort, "u", secaddr, number_of_telegrams, 0, 1):

                                if mbl.compareSecAddresses(
                                    [
                                        stateVariables.browse_output_id,
                                        stateVariables.browse_output_mfct,
                                        stateVariables.browse_output_ver,
                                        stateVariables.browse_output_med
                                    ],
                                    [
                                        meter[0],
                                        meter[1],
                                        meter[2],
                                        meter[3]
                                    ]
                                    ) == 2:

                                    if meter[8] == "W":

                                        if mfct_spec_ver in weblib.MANUFACTURER_SPECIFIC_VERSION_SET:
                                            if stateVariables.browse_output_mfct_spec_ver == meter[12]:
                                                print("Same mfct spec ver!")
                                                mfctvermed_mfctSpecVer.add(m)

                                                try:
                                                    appendFileToFile("/config/template.csv", "/tmp/templates_tmp.csv")
                                                    logfile.write("Read OK\n")
                                                    logfile.flush()
                                                    break
                                                except Exception as e:
                                                    traceback.print_exc()

                                            else:
                                                logfile.write("No mfct spec ver\n")
                                                logfile.flush()
                                                print("NOT same type.")
                                                print("should break")
                                                break
                                        else:
                                            mfctvermed_mfctSpecVer.add(m)

                                            try:
                                                appendFileToFile("/config/template.csv", "/tmp/templates_tmp.csv")
                                                logfile.write("Read OK\n")
                                                logfile.flush()
                                                break
                                            except Exception as e:
                                                traceback.print_exc()
                                    else:
                                        mfctvermed_mfctSpecVer.add(m)

                                        try:
                                            appendFileToFile("/config/template.csv", "/tmp/templates_tmp.csv")
                                            logfile.write("Read OK\n")
                                            logfile.flush()
                                            break
                                        except Exception as e:
                                            traceback.print_exc()

                                else:
                                    print("No response from meter or wrong meter answered.")
                                    print("Timeout from MBusHub Masterport + 0.2 sec. Then up to 2 retries are made.")
                                    logfile.write("Wrong meter resp\n")
                                    logfile.flush()
                                    time.sleep(time_out)
                            else:
                                # The MBusHub timeout plus 0.2 sec to make a new readout try.
                                logfile.write(stateVariables.browse_output_error + "\n")
                                logfile.flush()
                                time.sleep(time_out)
                        except Exception as e:
                            print("e",str(e))
                            traceback.print_exc()
                    else:
                        print("Meter type already been added!")

def askBrowse(ipNumber, ipPort, init, secaddr, number_of_telegrams=3, slv_sel_snd_nke=0, deselect=0):

    clearStateVariablesBeforeRequest()
    print("in askBrowse secaddr",secaddr)

    try:
        browseReturnDict = Browse.browse(ipNumber, ipPort, "u", secaddr, number_of_telegrams, slv_sel_snd_nke, deselect)
        if len(browseReturnDict) == 2:
            print("Browse did not read the meter correctly.")
            print("return string from Browse", browseReturnDict["status-string"])
            stateVariables.browse_output_error = browseReturnDict["status-string"]
            return False
        else:
            print("successful readout in Browse")
            stateVariables.browse_output_id = browseReturnDict["identification"]
            stateVariables.browse_output_mfct = browseReturnDict["manufacturer"]
            stateVariables.browse_output_ver = browseReturnDict["version"]
            stateVariables.browse_output_med = browseReturnDict["medium"]
            stateVariables.browse_output_primary_address = browseReturnDict["primaryAddress"]
            stateVariables.browse_output_mfct_spec_ver = browseReturnDict["abb_version_string"]
            stateVariables.browse_output_error = ""

            print("After Browse",
                browseReturnDict["identification"],
                browseReturnDict["manufacturer"],
                browseReturnDict["version"],
                browseReturnDict["medium"],
                browseReturnDict["primaryAddress"],
                browseReturnDict["name"],
                browseReturnDict["m_type"],
                browseReturnDict["abb_version_string"]
            )
            return True

    except Exception as e:
        traceback.print_exc()
        return False

#Returns the secondary address from the /tmp/templates_tmp.csv which are created by Browse.py
def checkTempSecondaryAddress():
    temp = []
    try:
        with open("/tmp/templates_tmp.csv") as file:
            temp = list(weblib.rcf(file, ',', 45))
    except Exception as e:
        print("error in checkTempSecondaryAddress: "+str(e))

    templateSecondaryAdress = ""
    if temp:
        templateSecondaryAdress = temp[0][19].split(":")[0]
        print("templateSecondaryAdress %s"%templateSecondaryAdress)
    return templateSecondaryAdress

@search_blueprint.route("/startup_manual",  methods=['GET'])
def startup_manual():
    HASHTAG=request.args.get("HASHTAG")
    print("%s"%HASHTAG)
    info = {
        'tab': "Doc",
        'HASHTAG': HASHTAG
    }
    if HASHTAG == None:
        return render_template("startup-config.html", **info)
    else:
        print("in else")
        return render_template("startup-config.html",  **info)

if __name__=="__main__":
    addUniqueWireless()



@search_blueprint.route('/device_types',methods=['GET'])
def get_device_types():
    """returns device types"""
    with open('static/data/device_types.json','r') as f:
        res = Response()
        res.set_data(f.read())
        res.content_type = "application/json"
        res.headers.add_header('Cache-Control', 'max-age=31536000, immutable')
        return res
    return "", 500

@search_blueprint.route('/manufacturers.txt',methods=['GET'])
def get_manufacturers():
    """returns a textfile with a tab as a separator: KEY\tManufacturer Desc"""
    with open('static/data/manufacturers.txt','r') as f:
        res = Response()
        res.set_data(f.read())
        res.headers.add_header('Cache-Control', 'max-age=31536000, immutable')
        return res
    return "", 500
