import weblib
from flask import Blueprint, Response, jsonify, request
import api.api_constants
import lib.package_installer as package_installer 
import os
import lib.piigab_900_system as piigab_system
from werkzeug.utils import secure_filename 
installer = package_installer.OPKGInstaller()
import traceback
blueprint = Blueprint(
    "system-api",__name__, url_prefix=api.api_constants.BASE_URI + "/system"
)


@blueprint.route('/',methods=['GET'])
def api_get_system_info():
    return jsonify(piigab_system.get_system_information())

@blueprint.route("/packages", methods=["GET"])
def api_get_program_list():
    all_packages = list(map(lambda x: x.__dict__, installer.list_programs()))
    query_name = request.args.get('name')
    
    if query_name:
        return jsonify(
            list(filter(lambda x: x['name'] == query_name ,all_packages)) 
        )
    return jsonify(all_packages)


@blueprint.route("/os", methods=["GET"])
def api_get_operating_system():
    name = weblib.PI900_OS_NAME
    return jsonify({"os": name})


@blueprint.route("/packages/update",methods=['GET'])
def api_update_package_list():
    try:
        installer.update()
        packages = list(map(lambda x: x.__dict__, installer.list_programs()))
        return jsonify(packages)
    except package_installer.AlreadyInstallingException as e:
        return Response(status=423,response=str(e))
    except Exception as e:
        return Response(status=500)


@blueprint.route("/packages/install", methods=['POST'])
def api_install_package():
    package_name = request.json['package_name']
    print("installing %s" % package_name)
    try:
        installer.install_from_repo(package_name)
        return Response(status=200)
    except package_installer.AlreadyInstallingException as e:
        return Response(status=423, response=str(e))
    except Exception as e:
        return Response(status=500)
    


@blueprint.route("/packages/upgrade", methods=['POST'])
def api_upgrade_package():
    package_name = request.json['package_name']
    print("installing %s" % package_name)
    try:
        installer.upgrade(package_name)
        return Response(status=200)
    except package_installer.AlreadyInstallingException as e:
        return Response(status=423, response=str(e))
    except Exception as e:
        traceback.print_exc()
        return Response(status=500)
    
""" 
"" 
TODO improve functionallity , currently force installs. make it possible for user to choose 
what package they want to install from the uploaded 'bundle' in the package list. 
TODO: figure out a way to select between online repo 
and offline repo
"" 
@blueprint.route('/packages/install/manual', methods=['POST'])
def install_bundle():
    path = "/tmp/package-bundle.tar.gz"
    if not 'filename' in request.files:
        return Response(status=400)
    file = request.files['filename']
    file.save(path)
    try:
        return jsonify(installer.install_bundle())
    except package_installer.AlreadyInstallingException as e:
        return Response(status=423, response=str(e))
    except Exception as e:
        print(str(e))
        return Response(status=500)
"""


@blueprint.route('/licenses',methods=['GET','POST'])
def api_license_string():
    if request.method == 'POST':
        new_license = request.json['license']
        if not isinstance(new_license,str):
            print("not a license string")
            return Response(status=400)
        
        if not len(new_license) == 128:
            print("license string is not 128 in length")
            return Response(status=400)
        try:
            piigab_system.update_license(new_license)
            return Response(status=200)
        except Exception:
            traceback.print_exc()
            return Response(status=400)
    else:
        try:
            info = piigab_system.get_license_information()
            return jsonify(info)
        except Exception as e:
            traceback.print_exc()
            print("failed to read license", str(e))
            return Response(status=400)

@blueprint.route('/packages/install/ipk',methods=['POST'])
def api_install_ipk():
    path = "/tmp/myfile.ipk"

    if not 'filename' in request.files:
        return Response(status=400)
    file = request.files['filename']
    file.save(path)
    try:
        installer.install_ipk(path)
        return Response(status=200)
    except package_installer.AlreadyInstallingException as e:
        return Response(status=423, response=str(e))
    except Exception as e:
        print(str(e))
        return Response(status=500)
