#!/usr/bin/python3
# coding: utf-8

import os
import struct, sys, socket, time #,json
import configparser,  csv
import traceback
from weblib import *
import mbus_decode

exponentGlobal = []
nameGlobal = ""
typeGlobal = ""
primaryAddress = 0      # Primary address.

mbusini = configparser.RawConfigParser()
ret = mbusini.read("./MbusOPC.ini" ,encoding="ISO-8859-1")

def CalcBcc(array):
    cc=0
    for i in range(len(array)):
        cc += array[i]
    return cc&0xFF

def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def SecondaryAddress(data):
    data = bytearray(data)
    id = data[0:4]
    id.reverse()
    id = "".join("%02X" % b for b in id)
    manu = data[4:6]
    manu.reverse()
    manu = "".join("%02X" % b for b in manu)
    ver = data[6]
    med = data[7]
    
    tmp = struct.unpack("<H",data[4:6])[0]
    name = MfctToStr(tmp)
    lansen_exception_medium = [0x1D, 0x1E, 0x2B]
    if name == "LAS" and med in lansen_exception_medium:
        a=mbusini.get("MEDIA_LANSEN", "%02X"%(med%0x7F))
    else:
        a=mbusini.get("MEDIA_VARIABLE", "%02X"%(med%0x7F))
    a=a.split(',')
    meter_type = "Reserved"
    print("a",a)
    if len(a[0]) > 0:
        meter_type = a[0]
    return id, manu, "%02X"%(ver), "%02X"%(med), name, meter_type

def Status(value):
    result = ""

    # Status for bit 0 and 1.
    if (value & 0x03):
        bit1_2 = value & 0x03
        result = "Application busy" if bit1_2 == 1 else "Any application error" if bit1_2 == 2 else "Abnormal condition / alarm"

    # Status for bit 2.
    if (value & 0x04) == 0x04:
        result += ", " if len(result) > 0 else result
        result += "Power low"

    # Status for bit 3.
    if (value & 0x08) == 0x08:
        result += ", " if len(result) > 0 else result
        result += "Permanent error"

    # Status for bit 4.
    if (value & 0x10) == 0x010:
        result += ", " if len(result) > 0 else result
        result += "Temporary error"

    # Status for bit 5.
    if (value & 0x20) == 0x20:
        result += ", " if len(result) > 0 else result
        result += "Manufacturer bit1 set"

    # Status for bit 6.
    if (value & 0x40) == 0x40:
        result += ", " if len(result) > 0 else result
        result += "Manufacturer bit1 set"

    # Status for bit 7.
    if (value & 0x80) == 0x80:
        result += ", " if len(result) > 0 else result
        result += "Manufacturer bit1 set"

    return result

# Take input and select the records that should be saved to a template.
def SelectDataRecordNumbers():
    print("Type in the data record numbers, example '1 2 5 10': ", end="")
    inp = input()
    if inp == "":    # Exit if no records is given.
        return
    numbers = inp.split()   # ToDo: Return only destinct values, remove duplicates.
    # ToDo:
    # Check if all numbers are valid integers.
    # Return list of integers.
    return numbers

def SelectDataRecordsByGivenNumbers(numbers, records):
    selected = {}    # Storage for all selected data records.
    # Gets the data records according to selected inputs.
    for number in numbers:
        number = int(number)
        if number in records:
            selected[number] = records[number]
    return selected

# Select data records for a template.
#def SelectDataRecords(records):
#    numbers = SelectDataRecordNumbers()
#    selected = SelectDataRecordsByGivenNumbers(numbers, records)
#    #recordsForTemplate.update(selected)

# Save a telegram's record in a JSON-file.
def SaveTelegramInJSonFile(records, telegramCounter, secondaryAddress,  statusByte,  statusText,  configWord, more_telegrams):
    #templateFolderPath = "/tmp/"
    #SetupTemplateFolder(templateFolderPath)
    templateFilePath = "/tmp/browseOutput.json" #= CreateTemplateFile(templateFolderPath, secondaryAddress[1], secondaryAddress[2], secondaryAddress[3])
    json = StoreRecordsAsJSON(records, telegramCounter, secondaryAddress,  statusByte,  statusText,  configWord)
    CreateJSONTemplate(json, templateFilePath)
    if more_telegrams:
        print("Telegram number", telegramCounter)
    else:
        if telegramCounter == 1: # English grammatic, telegram in plural or not
            print("JSON-file with the data records for %s telegram stored at: %s"%(telegramCounter, templateFilePath))
        else:
            print("JSON-file with the data records for %s telegrams stored at: %s"%(telegramCounter, templateFilePath))
        print("")

def SaveTelegramInCsvFile(records, telegramCounter, secondaryAddress, templateParams,  statusByte, statusText, more_telegrams, abb_version_string):
    templateFileName = "/tmp/templates_tmp.csv"
    data = StoreRecordsAsCSV(records, telegramCounter, secondaryAddress, templateParams,  statusByte, statusText, more_telegrams, abb_version_string)
    CreateCSVTemplate(data, templateFileName)

# Creates the template data from selected records.
def StoreRecordsAsJSON(records, telegramCounter, secondaryAddress,  statusByte,  statusText,  configWord):
    #print("json reocrds", records)
    #json.dumps({'device':{'name':'4129.03.31','telegram':1,'address':'16809984.4129.03.31','tag':[{'name':'Fabrication','record':'1','datatype':'BCD8'},{'name':'Volts V E-1','record':'2','datatype':'INT16'},{'name':'Current A E-4','record':'3','datatype':'INT16'}]}})
    #{"device": {"name": "4129.03.31", "telegram": 1, "address": "16809984.4129.03.31", "tag": [{"name": "Fabrication", "record": "1", "datatype": "BCD8"}, {"name": "Volts V E-1", "record": "2", "datatype": "INT16"}, {"name": "Current A E-4", "record": "3", "datatype": "INT16"}]}}
    deviceName = "%s_%s_%s"%(MfctToStr(int(secondaryAddress[1], 16)), secondaryAddress[2], secondaryAddress[3])
    secondaryAddress = "%s.%s.%s.%s"%(secondaryAddress[0], secondaryAddress[1], secondaryAddress[2], secondaryAddress[3])
    # ToDo: Replace all ' with " in the output JSON-file.
    # Returns unix timestamp for current time
    #timestamp = time.time()
    # Get datetime object in local time
    #now = datetime.datetime.fromtimestamp(timestamp)

    named_tuple = time.localtime() # get struct_time
    now = time.strftime("%Y-%m-%d %H:%M:%S", named_tuple)

    # Return unix timestamp from datetime object
    #timestamp = d.timestamp()
    jsonData = ""
    jsonData += "{"
    jsonData += "'device':"
    jsonData += "{"
    jsonData += "'name':'%s','telegram':%s,'adress':'%s','prim_adr':%s,'name2':'%s', 'type':'%s', 'time':'%s', 'statusByte':'%s', 'statusText':'%s', 'configWord':'%s'},"%(deviceName, telegramCounter, secondaryAddress, primaryAddress, nameGlobal,  typeGlobal,  now,  statusByte,  statusText,  configWord) # La till en måsvinge } efter adress
    jsonData += "'tag':"
    jsonData += "["

    length = len(records) - 1
    templateVIBs=[] # Check if the same tag has appeared earlier
    for count,record in enumerate(records): #Ändrade så att sista kommatecknet försvinner i json-outputen
        expOutput = records[record][8]
        tagName = records[record][7].replace("\'", "\\'")
        dataType = records[record][2]
        value = records[record][0]
        humanvalue = records[record][1]
        vif = records[record][9]
        function = records[record][4]
        i = countItems(vif, templateVIBs)
        templateVIBs.append(vif)
        if i>0:
            vif += '%d'%i
        if record <= length:
            expOutput = records[record][8]

        jsonData += "{"
        jsonData += "'name':'%s','value':'%s','humanvalue':'%s','exponent':'%s','record':'%s','datatype':'%s', 'vif':'%s', 'function':'%s'"%(tagName,value,humanvalue,expOutput,record,dataType,vif,function)
    
        if count < length:
            jsonData += "},"
        else:
            jsonData += "}"

    jsonData += "]"
    jsonData += "}"
    jsonData = jsonData.replace('\'',  '\"')

    return jsonData

def countItems(val,  list):
    i = 0
    for item in list:
        if val == item:
            i += 1
    return i

# Get the datatype for modbus readout
def getDataType(dataType):
    if dataType == "BCD8" or dataType == "INT24" or dataType == "INT32" or dataType == "BCD6":
        return 3
    elif dataType == "INT48" or dataType == "INT64" or dataType == "BCD12":
        return 20
    elif dataType == "REAL32":
        return 4
    elif dataType == "REAL64":
        return 5
    elif dataType == "BCD4" or dataType == "INT16" or dataType == "INT8":
        return 2
    return ""

# Save a telegram's record in a CSV-file.
def StoreRecordsAsCSV(records, telegramNumber, secondaryAddress, templateParams, statusByte, statusText, more_telegrams, abb_version_string):
    print("records", records)
    st = MfctToStr(int(secondaryAddress[1], 16))
    saddr = "%s.%s.%s.%s"%(secondaryAddress[0], secondaryAddress[1], secondaryAddress[2], secondaryAddress[3]) #Add fab no XXXXXXXXXXXXXXXXXXXXXXXX
    # ToDo: Replace all ' with " in the output JSON-file.
    # Returns unix timestamp for current time
    # Get datetime object in local time
    csvData = []

    # Create a mfct_spec_ver tuple to compare to the MANUFACTURER_SPECIFIC_VERSION_SET in weblib.py
    mfct_spec_ver = (secondaryAddress[1], secondaryAddress[2], secondaryAddress[3])

    device = ['']*45
    device[0]="[Device]"
    device[1] = 'channel' # templateParams['channel_name']
    device[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
    if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
        device[3] = "_".join([device[3], abb_version_string])
    device[13] = 3 # Number of telegrams
    device[19] = saddr
    if (templateParams['format'] == "1" or templateParams['format'] == "2" or templateParams['format'] == "4") and templateParams['tag_type'] == "8":
        device[21] = "f"
    device[24] = int(templateParams['time_stamp']) + int(templateParams['time_stamp_telegram'])
    r =  templateParams['read_period']
    if r.isnumeric():
        device[41] = 60*int( templateParams['read_period'])
    r =  templateParams['read_offset']
    if r.isnumeric():
        device[42] = 60*int( templateParams['read_offset'])
    csvData.append(device)

    #Appending the statusbyte to the template file
    tag = ['']*45
    tag[0] = "[Tag]"
    tag[1] = 'channel' # templateParams['channel_name']
    tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
    if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
        tag[3] = "_".join([tag[3], abb_version_string])
    tag[4] = "StatusByte"
    #tag[19] = record
    tag[20] = 22
    tag[21] = 8 # String
    tag[22] = 1 # Readable
    tag[25] = 0
    tag[36] = 0
    csvData.append(tag)

    #Appending the Modbus statusbyte to the template file
    tag = ['']*45
    tag[0] = "[Tag]"
    tag[1] = 'channel' # templateParams['channel_name']
    tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
    if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
        tag[3] = "_".join([tag[3], abb_version_string])
    tag[4] = "StatusByte_Mod"
    #tag[19] = record
    tag[20] = 22
    tag[21] = 2 # INT16, Smallest value in modbus register
    tag[22] = 1 # Readable
    tag[25] = 0
    tag[36] = 0
    csvData.append(tag)

    #Appending the MeterID to the template file
    tag = ['']*45
    tag[0] = "[Tag]"
    tag[1] = 'channel' # templateParams['channel_name']
    tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
    if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
        tag[3] = "_".join([tag[3], abb_version_string])
    tag[4] = "MeterID"
    #tag[19] = secondaryAddress[0]
    tag[20] = 17
    tag[21] = 8 #
    tag[22] = 1 # Readable
    csvData.append(tag)
    #Appending the Modbus MeterID to the template file
    tag = ['']*45
    tag[0] = "[Tag]"
    tag[1] = 'channel' # templateParams['channel_name']
    tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
    if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
        tag[3] = "_".join([tag[3], abb_version_string])
    tag[4] = "MeterID_Mod"
    #tag[19] = secondaryAddress[0]
    tag[20] = 17
    tag[21] = 3 # INT32
    tag[22] = 1 # Readable
    csvData.append(tag)

    templateVIBs=[] # Check if the same tag has appeared earlier

    for record in records:
        if records[record][4] == True or records[record][0] == "Error": #If manufacturer specific or error, do nothing
            continue
        templateVIB = records[record][9]
        dataType = records[record][2]
        i = countItems(templateVIB, templateVIBs)
        templateVIBs.append(templateVIB)
        if i>0:
            templateVIB += '%d'%i
        tag = ['']*45
        tag[0] = "[Tag]"
        tag[1] = 'channel'
        tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
        if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
            tag[3] = "_".join([tag[3], abb_version_string])
        tag[4] = templateVIB
        tag[19] = record
        tag[20] = templateParams['tag_type']
        tag[21] = 8 # String
        tag[22] = 1 # Readable

        csvData.append(tag)

        #Modbus tag
        #print("dataType {}".format(dataType))
        tag = ['']*45
        tag[0] = "[Tag]"
        tag[1] = 'channel'
        tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
        if mfct_spec_ver in MANUFACTURER_SPECIFIC_VERSION_SET:
            tag[3] = "_".join([tag[3], abb_version_string])
        tag[4] = templateVIB + "_Mod"
        tag[19] = record
        #tag[20] = templateParams['tag_type']
        tag[20] = 1
        tag[21] = getDataType(dataType)
        
        tag[22] = 1 # Readable
        tag[36] = 0 # 
        csvData.append(tag)

    if int(templateParams['time_stamp_telegram']) == 2:
        tag = ['']*45
        tag[0] = "[Tag]"
        tag[1] = 'channel'
        tag[3] = "%s_%s_%s"%(st, secondaryAddress[2], secondaryAddress[3]) # Template device Name
        tag[4] ="time"
        tag[19] = int(templateParams['time_record_no'])
        tag[20] = 1 # Tagtype
        tag[21] = 8 # String
        tag[22] = 1 # Readable
        tag[24] = int(templateParams['time_stamp']) + int(templateParams['time_stamp_telegram'])
        csvData.append(tag)

    return csvData

# Create the csv template.
def CreateTemplate(data, templateFilePath):
    #file = open(templateFilePath, 'a+')
    with open(templateFilePath,  'w') as fil:
        for line in data:
            fil.write(line)

# Create the json template.
def CreateJSONTemplate(data, templateFilePath):
    #file = open(templateFilePath, 'a+')
    with open(templateFilePath,  'w') as fil:
        for line in data:
            fil.write(line)

# Create the csv file
def CreateCSVTemplate(data, templateFilePath):
    with open(templateFilePath,'w', newline='') as cf:
        writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for row in data:
            writer.writerow(row)

def CreateSlvSelect(idnum, mfct=0xFFFF, ver=0xFF, med=0xFF, fab = None):
    req1 = b"\x53\xFD\x52"
    req1 += struct.pack("<IHBB",idnum, mfct, ver, med)
    if fab:
        req1 += b"\x0C\x78" + struct.pack("<I", fab)
    req = b"\x68" + struct.pack("BB",len(req1),len(req1)) + b"\x68" + req1
    req += struct.pack('B',CalcBcc(req[4:]))+b"\x16"
    return req

def CreateShortFrame(cfield, afield):
    req   = b"\x10"+struct.pack("BB",cfield, afield)
    req += struct.pack("B",CalcBcc(req[1:])) + b"\x16"
    return req

def VerifyE5(resp): # Check for none ACK response.
    retval = ""
    if len(resp) == 0:
        retval = "No SND_NKE response"
        print(retval)
        return False
    elif len(resp) != 1 or resp[0] != 0xE5:
        retval = "Invalid SND_NKE_RESPONSE, %02X"%resp[0]
        print(retval)
        return False
    return True

def CreateAppReset(addr,  subcode=None):
    req = b"\x53" + struct.pack("B",addr) + b"\x50"
    if subcode:
        req += struct.pack("B", subcode)
    req = b"\x68" + struct.pack("BB", len(req), len(req)) + b"\x68" + req;
    req += struct.pack("B", CalcBcc(req[4:]) ) + b"\x16"
    return req

def VerifyLongFrame(frame):
    generalApplicationError = False
    if len(frame) == 0:
        print("No response received")
        return generalApplicationError, False
    if (frame[0] != 0x68 or frame[3] != 0x68): # Check frame characters.
        print("Incorrect frame characters")
        return generalApplicationError, False
    if (frame[1] != frame[2] or (frame[1] != len(frame)-6 and frame[1] != len(frame)-262)): # Check length. Allow for too long telegrams GG 2021-12-21
        print("Incorrect message length")
        return generalApplicationError, False
    if (CalcBcc(frame[4:len(frame)-2]) != frame[len(frame)-2]): # Check checksum.
        print("Incorrect checksum")
        return generalApplicationError, False
    if len(frame) < 21 and frame[6] == 0x70:
        generalApplicationError = True
        return generalApplicationError, True
    if len(frame) < 21:  # Check number of received bytes.
        print("Too few bytes received")
        print(len(frame))
        return generalApplicationError, False
    return generalApplicationError, True

def getIniVal(inif,  group,  item,  default = ''):
    retval = ''
    try:
        retval = inif.get(group, item)
    except:
        pass
    if not retval:
        retval = default
    #print("retval = %s"%retval)
    return retval

def browse(ip, port, init, adr, numberOfTelegrams=1, slv_sel_snd_nke=False, deselect=False):
    try:
        #The program must work without a Browse.ini file XXXXXXXXXXXXXXXXXX
        browseini = configparser.RawConfigParser()
        browseini.read("/tmp/Browse.ini")
        del exponentGlobal[:]
        templateParams = {}
        templateParams['format'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "format", "FORMAT3")
        templateParams['channel_name'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "channel_name", "pi900")
        templateParams['time_stamp'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "time_stamp", "24")
        templateParams['read_period'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "read_period")
        templateParams['read_offset'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "read_offset")
        templateParams['tag_type'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "tag_type", "8")
        templateParams['time_stamp_telegram'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "time_stamp_telegram", '0')
        templateParams['time_record_no'] = getIniVal(browseini, "BROWSE_PARAMETERS",  "time_record_no", '4')

        mbushubini_def = configparser.RawConfigParser()
        mbushubini_def.read("/config/mbushub_default.ini")
        mbushubini = configparser.RawConfigParser()
        mbushubini.read("/config/mbushub.ini")

        parser = Configuration(mbushubini_def, mbushubini)
        sercomport = parser.get(float, "MasterPort", "timeout")

        time_out = (sercomport/1000) + 0.2
        print("sercomport", time_out)

        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.settimeout(time_out)
        response=""

        # Use either primary or secondary address.
        if len(adr) < 4: # Primary address. Well, needs to be documented. 123 is a valid secondary address 00000123.FFFF.FF.FF
            adr = int(adr)
        else:   # Secondary address
            # Request format: 68 L L 68 C ADR CI XX XX XX XX MM MM VV MM CS 16.
            secaddr = adr.split(':')
            idnum, mfct, ver, med = secaddr[0].split('.')
            idnum = int(idnum,16)
            mfct  = int(mfct,16)
            ver   = int(ver,16)
            med   = int(med,16)
            fabr  = None
            # Enhanced selection in SLV_SEL request?
            if (len(secaddr) > 1):
                fabr = int(secaddr[1],16)

            if slv_sel_snd_nke == True:
                print("slv_sel_snd_nke")
                request = CreateSlvSelect(idnum, mfct, ver, med, fabr)
                s.sendto(request, (ip, port))
                response = s.recv(1024)

                if not VerifyE5(response):
                    return_map = {
                        'success': False,
                        'status-string': "No SLV_SEL resp"
                    }
                    return return_map

                snd_nke_req = CreateShortFrame(0x40, 253)
                s.sendto(snd_nke_req, (ip, port))
                snd_nke_resp = s.recv(1024)

                if not VerifyE5(response):
                    return_map = {
                        'success': False,
                        'status-string': "No SNK_NKE resp"
                    }
                    return return_map

                request = CreateSlvSelect(idnum, mfct, ver, med, fabr)
                s.sendto(request, (ip, port))
                response = s.recv(1024)

                if not VerifyE5(response):
                    return_map = {
                        'success': False,
                        'status-string': "No SLV_SEL resp"
                    }
                    return return_map
            else:
                print("slv_sel_only")
                request = CreateSlvSelect(idnum, mfct, ver, med, fabr)
                s.sendto(request, (ip, port))
                response = s.recv(1024)

                if not VerifyE5(response):
                    return_map = {
                        'success': False,
                        'status-string': "No SLV_SEL resp"
                    }
                    return return_map
            adr = 253

        # Send SND_NKE and receive ACK.
        if init == "s":
            request = CreateShortFrame(0x40,  adr)
            s.sendto(request, (ip, port))
            response = s.recv(1024)
            if not VerifyE5(response):
                return_map = {
                    'success': False,
                    'status-string': "No SNK_NKE resp"
                }
                return return_map
        # Send APP_RST and receive ACK.
        if init == "a":
            request = CreateAppReset(adr)
            s.sendto(request, (ip, port))
            response = s.recv(1024)
            if not VerifyE5(response):
                return_map = {
                    'success': False,
                    'status-string': "No APP_RES resp"
                }
                return return_map

        toggle = 0x7B           # Toggle field for REQ_UD2.
        dataRecord = 0          # Init data record index.
        telegramCounter = 1     # Telegram counter.
        secondaryAddress = None   # Secondary address.
        run = True              # Keep on reading the M-Bus meter.
        records = {}            # List of all records for a telegram.
        more_telegrams = True
        statusByte = ""
        statusText = ""
        configWord = ""

        # The secondary address variables from the RSP_UD
        # These will be returned so the input secondary-address can
        # be compared with the output-secondary-address
        identification = ""
        manufacturer = ""
        version = ""
        medium = ""
        name = ""
        m_type = ""
        abb_version_raw = ""
        abb_version_string = ""
        primaryAddress = ""

        while telegramCounter <= int(numberOfTelegrams) and more_telegrams: # Send REQ_UD2 and receive RSP_UD.
            try:
                request = CreateShortFrame(toggle,  adr)
                s.sendto(request, (ip, port))
                response = s.recv(1024)
            except Exception as e:
                print("Failed to read the M-Bus meter", e)

                return_map = {
                    'success': False,
                    'status-string': "No REQ_UD resp"
                }

                return return_map

            toggle = 0x5B if toggle == 0x7B else 0x7B
            responseLength=len(response)
            generalApplicationError, aCorrectResponse = VerifyLongFrame(response)

            if not aCorrectResponse:
                break
            elif generalApplicationError and aCorrectResponse:
                primaryAddress = response[5]
                secondaryAddress = identification, manufacturer, version, medium, name, m_type = SecondaryAddress(response[7:15])
                statusByte = ""
                statusText = "CI-field 0x70, General Application Error"
                configWord = ""
            elif not generalApplicationError and aCorrectResponse:
                primaryAddress = response[5]
                identification, manufacturer, version, medium, name, m_type = SecondaryAddress(response[7:15])
                secondaryAddress = (identification, manufacturer, version, medium, name, m_type)
                statusByte = "%02X"%response[16]
                statusText = Status(response[16])

                configWord = response[17:19]
                configWord = bytearray(configWord)
                configWord.reverse()
                configWord = "".join("%02X" % b for b in configWord)

            OPCname = MfctToStr(int(manufacturer, 16))
            if OPCname != "KAM":
                OPCname += version + medium # "ABB2002" example
            print("\n --- Telegram %s ---\n"%(telegramCounter))
            print("\tPrimary address:\t%s"%(primaryAddress))
            print("\tSecondary address:\t%s.%s.%s.%s [%s] [%s]"%(identification, manufacturer, version, medium, name, m_type))
            print("\tStatus:\t\t\t%s %s"%(statusByte, statusText))
            print("")
            print("{:3s} {:7s} {:40s} {:20s}".format("#", "Type", "Value", "Physical quantity"))
            print("-------------------------------------------------------------------------------")

            indexInTelegram = 19

            # ============================================================================
            # === Iterate over all objects in the telegram and display them in a table ===
            # ============================================================================
            mfct_data = False

            print("responseLength", responseLength)
            if not generalApplicationError:
                while indexInTelegram + 2 < responseLength:

                    returnMap = mbus_decode.decode_field(response[indexInTelegram:], OPCname, telegramCounter)  # Decode the object/record.
                    value = returnMap["value"]
                    humanvalue = returnMap["humanvalue"]
                    dataTypeStr = returnMap["dataTypeStr"]
                    recordLength = returnMap["recordLength"]
                    function = returnMap["function"]
                    mfct_data = returnMap["mfct_data"]
                    more_telegrams = returnMap["more_telegrams"]
                    vib = returnMap["vib"]
                    exponent = returnMap["exponent"]
                    templateVIB = returnMap["templateVIB"]
                    abb_version_raw = returnMap["abb_version_data"]

                    if len(abb_version_raw) > 0 and telegramCounter == 1:
                        abb_version_string = abb_version_raw.decode("utf-8")[::-1]
                        print("abb_version_string", abb_version_string)

                    indexInTelegram +=  recordLength   # Point to next object in telegram.

                    if value == None:
                        continue
                    #if templateVIB == 'mfct':
                    #    continue
                    dataRecord += 1
                    records[dataRecord] = (value, humanvalue, dataTypeStr, recordLength, function, mfct_data, more_telegrams, vib, exponent, templateVIB, dataRecord)
                    print("{:3s} {:7s} {:40s} {:20s}".format(str(dataRecord), dataTypeStr, str(value)+exponent, vib))
                    exponentGlobal.append(exponent)

            print("")

            if (more_telegrams):
                telegramCounter += 1
            else:
                break

        print("")
        SaveTelegramInJSonFile(records, telegramCounter, secondaryAddress,  statusByte,  statusText, configWord, more_telegrams)
        SaveTelegramInCsvFile(records, telegramCounter, secondaryAddress, templateParams,  statusByte, statusText, more_telegrams, abb_version_string)

        # Addition - Always make a SND_NKE to address 253 after REQ_UD2
        # Some wired meters do not understand SLV_SEL with fabrication-number
        # therefore a SND_NKE is needed to deselect the meter

        if deselect == True:
            print("deselect")
            snd_nke_req = CreateShortFrame(0x40, 253)
            s.sendto(snd_nke_req, (ip, port))
            snd_nke_resp = s.recv(1024)

        print(identification, manufacturer, version, medium, primaryAddress, name, m_type, abb_version_string)
        return_map = {
            'identification': identification,
            'manufacturer': manufacturer,
            'version': version,
            'medium': medium,
            'primaryAddress': primaryAddress,
            'name': name,
            'm_type': m_type,
            'abb_version_string': abb_version_string
        }
        return return_map

    except Exception as e:
        print("error in Browse",str(e))
        traceback.print_exc()

if __name__ == "__main__":
    if len(sys.argv) < 5:
        print("Usage %s <IP-address> <IP-Port> <init> <M-Bus address>"%sys.argv[0])
        sys.exit(0)

    ip = sys.argv[1]
    port = int(sys.argv[2])
    init = sys.argv[3]
    adr = sys.argv[4]

    if len(sys.argv) > 5:
        numberOfTelegrams = int(sys.argv[5])
        select = int(sys.argv[6])
        deselect = int(sys.argv[7])
        browse(ip, port, init, adr, numberOfTelegrams, select, deselect)
    else:
        browse(ip, port, init, adr)
