#!/bin/sh

INSTDIR="/tmp/install/install_package/"
if [ -f "/data/install/install_package/install_arm.sh" ]; then
  INSTDIR="/data/install/install_package/"
elif [ -f "/tmp/install_package/install_arm.sh" ]; then
  INSTDIR="/tmp/install_package/"
fi


chown -R root:root ${INSTDIR}/*
chmod a+x ${INSTDIR}/etc/checkIFStatus.sh

if [ -f /var/www1/templates/header.html ]; then

    # If NOT file /var/www1/identification.py exists then the new
    # header structure is NOT implemented. We grep the name from the header
    # and put in file.
    # Else the new header structure is implemented and we can safely remove header
    # from install package.
    if [ ! -f /var/www1/identification.py ]; then
        grep mainHead /var/www1/templates/header.html | sed 's/.*}}//' | sed 's/&nbsp;//g' | sed 's/<\/h1>//' > /var/www1/identification.py
    fi
fi

if [ -f /var/www/header.html -a ! -f /var/www1/templates/header.html ]; then
    mkdir -p /var/www1/templates

    # Copy name from old web-interface and put in file.
    if [ ! -f /var/www1/identification.py ]; then
        grep mainHead /var/www/header.html | sed 's/.*900[ST]//' | sed 's/&nbsp;//g' | sed 's/<\/h1>//' > /var/www1/identification.py
    fi
fi

mkdir -p /config/tmp
mkdir -p /var/www1/licenses

cp -a ${INSTDIR}/* /

if [ ! -f /etc/lighttpd/lighttpd.conf ]; then
    cd /etc/lighttpd && ln -s lighttpd_https.conf lighttpd.conf
fi

cd /usr/lib && ln -sf libmosquitto.so.1 libmosquitto.so
cd /usr/lib && ln -sf libcrypto.so.1.0.0 libcrypto.so
cd /usr/lib && ln -sf libcrypto.so.1.0.0 libcrypto.so.1
cd /usr/lib && ln -sf libssl.so.1.0.0    libssl.so
cd /usr/lib && ln -sf libssl.so.1.0.0    libssl.so.1
cd /usr/lib && ln -sf libcurl.so.4.8.0 libcurl.so.4
cd /usr/lib && ln -sf libcurl.so.4.8.0 libcurl.so
cd /usr/lib && ln -sf libssh2.so.1.0.1 libssh2.so.1
cd /usr/lib && ln -sf libssh2.so.1.0.1 libssh2.so
cd /usr/lib && ln -sf libexpat.so.1.6.0 libexpat.so.1
cd /usr/lib && ln -sf libexpat.so.1.6.0 libexpat.so
cd /usr/lib && ln -sf libjsoncpp.so.1.8.4 libjsoncpp.so.19
cd /usr/lib && ln -sf libjsoncpp.so.1.8.4 libjsoncpp.so
find /var/www1 -name *.pyc -exec rm {} \;
python -m py_compile /usr/lib/python3.4/flask_httpauth.py
rm -rf /var/www/cgi-bin/*
rm -f /var/www1/mbus_primary_search.py
rm -f /var/www1/mbus_secondary_search.py
rm -f /var/www1/api/webapi.py
sync

