#!/bin/sh

# This script is now run every 5 minutes by a cron daemon. Was 60 seconds earlier
# /etc/checkIFStatus.sh <interface> <command> <ip-address>
# interface is required. eth0
# command not required, "ping" is the only supported command
# ip-address, only used for ping


ifname=$1

if [ -z "$ifname" ];
then
    echo "Missing argument <network interface>"
    exit 1
fi

# /tmp/random_ip_starttime contains the time of random IP being set.
# A DCHP request should be tested after an hour which will result in a new random IP
if [ -f /tmp/random_ip_starttime ];
then
    read line < /tmp/random_ip_starttime
    EPOCHSEC=$(date +%s)
    let t=$EPOCHSEC-$line
    #echo $t >> /tmp/random_ip_test
    if [ $t -ge 3600 ];
    then
        rm /tmp/random_ip_starttime
        /etc/init.d/S40network restart
        exit 0
    fi
fi

# Ping an IP-address, if no response, we assume the Pi-900 is failing and reboot.
# Run from cron at user settable frequency
case "$2" in
    ping)
        i=0
        while [[ $i -lt 12 ]]
        do
            ping -c 1 "$3"
            val=$?
            if [ $val -eq 0 ]; then
                exit 0
            fi
            #echo $i
            sleep 12
            let i+=1
        done
        echo "Now we have pinged 11 times without success, time to reboot"
        /sbin/reboot
        ;;
esac

# If the IP-address is static we exit the script
# Continue if address is dhcp or manual, meaning dhcp
# dhcp has been changed to manual but many units will continue using dhcp until
# the address is set. We must check for both
staticf=$(grep iface /etc/network/interfaces |grep eth0|awk '{print $4}')
if [ "$staticf" != "dhcp" ] && [ "$staticf" != "manual" ];
then
    # Static IP-address. Exiting
    exit 0
fi

# Set a random IP if in the range 192.168.10.3--250
iseth=$(/sbin/ifconfig "$ifname" |grep Bcast |awk '{print $2}')
if [ -z "$iseth" ];
then
    if [ -f /etc/random_ip ];
    then
        echo "Setting static Random ip for $ifname"
        /usr/bin/killall udhcpc
        /sbin/ifdown "$ifname"
        /sbin/ifup -i /etc/network/interfaces_random "$ifname"
        #echo $EPOCHSECONDS > /tmp/random_ip_starttime
        date +%s > /tmp/random_ip_starttime
    else
        /sbin/ifdown "$ifname"
        sleep 2
        /sbin/ifup "$ifname"
    fi
fi

