from flask import Blueprint, render_template
import sys
import time
sys.path.append("..")
from weblib import *
wireless_blueprint = Blueprint('wireless', __name__, url_prefix='/', template_folder='templates')
import struct 
import datetime
from io import BytesIO
import zipfile
import subprocess
import os
import shutil

@wireless_blueprint.route("/wireless_config",  methods=['GET',  'POST'])
def wireless_config():
    cnf = Configs("config","wireless")

    wirelessModeDict={'0':'S2','1':'T1','3':'S1','11':'T1+C'}

    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2'}
    mPortDict={'UDP':{'ALL':[('MBUS','M-Bus')]},'TCP':{'ALL':[('MBUS','M-Bus')]},'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]}}
    sPortDict={'UDP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'TCP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
            'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                    'MBSLAVE1':[('MBUS','M-Bus')],'MBSLAVE2':[('MBUS','M-Bus')]}}
    mProtocolDict={'MBUS':'M-Bus'}
    yesno=['YES','NO']

    wlversion=""
    fabnum=""
    try:
        mbv=os.popen("/binary/wireless -v")
        wlversion=mbv.read().strip()
        mbv.close()
        mbv=os.popen("/binary/wireless -S")
        fabnum=mbv.read().strip()
        mbv.close()
    except:
        pass
        
    wirelessLicense=""
    tagLicense=""
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        mbl.close()
        protocols=licensearray[2].split(',')
        wirelessLicense=protocols[10]
        wl=protocols[10].split('.')
        tagLicense=wl[1]
    except:
        pass

    wirelessmode   = cnf.getopt('Main','wirelessmode')
    if not (wirelessmode in wirelessModeDict.keys()):
        wirelessmode = '10'

    csvfileArray=glob.glob("/config/[wW][iI][rR][eE][lL][eE][sS][sS]*.[cC][sS][vV]")
    for i in range(len(csvfileArray)):
        csvfileArray[i] = os.path.basename(csvfileArray[i])
    #logfiles=glob.glob("/data/wireless/wireless_log_telegrams_*.[0-9]*")
    #for i in range(len(logfiles)):
    #    fname,f1 = logfiles[i].split('.')
    #    open(fname+".txt",'ab') as outFile:
    #        with open(logfiles[i],'rb') as inFile:
    #            outFile.write(inFile.read())
    #    os.remove (logfiles[i])
    logfArray=glob.glob("/data/wireless/wireless_log_telegrams_*")
    for i in range(len(logfArray)):
        logfArray[i] = os.path.basename(logfArray[i])
    logStatus = "Not Running"
    telegram_log_time = int(cnf.getopt('Main','telegram_logtime'))
    if telegram_log_time - int(time.time()) > 0:
        logStatus = "In %d days"%((telegram_log_time - int(time.time()))//86400)
    info = {
        'wirelessLicense' : wirelessLicense, 
        'tagLicense' : tagLicense, 
        'wirelessModeDict' : wirelessModeDict,
        'baudRateList' : baudRateList,
        'bitList' : bitList,
        'parityList' : parityList,
        'stopBitList' : stopBitList,
        'ipLocalList' : ipLocalList,
        'typeDict' : typeDict,
        'portDict' : portDict,
        'mPortDict' : mPortDict,
        'sPortDict' : sPortDict,
        'mProtocolDict' : mProtocolDict,
        'yesno' : yesno,
        'wlversion' : wlversion,
        'fabnum' : fabnum,
        'wirelessmode' : wirelessmode,
        'primaryaddress' : cnf.getopt('Main','primaryaddress'),
        'telegram_preserve_time' : cnf.getopt('Main','telegram_preserve_time'),
        'enable_leds'  : cnf.getopt('Main','enable_leds'),
        'telegram_log' : cnf.getopt('Main','telegram_log'),
        'include_file' : cnf.getopt('Main','include_file'),
        'extra_ci_field' : cnf.getopt('Main','extra_ci_field'),
        'exclude_file' : cnf.getopt('Main','exclude_file'),
        'check_kamstrup_crc': cnf.getopt('Main','check_kamstrup_crc'),
        'Stimeout'     : cnf.getopt('SlavePort','timeout'),
        'Sporttype'    : cnf.getopt('SlavePort','porttype'),
        'Slocalip'     : cnf.getopt('SlavePort','localip'),
        'Slocalport'   : cnf.getopt('SlavePort','localport'),
        'Sremoteip'    : cnf.getopt('SlavePort','remoteip'),
        'Sremoteport'  : cnf.getopt('SlavePort','remoteport'),
        'Ssercomport'  : cnf.getopt('SlavePort','sercomport'),
        'Sserbaudrate' : cnf.getopt('SlavePort','serbaudrate'),
        'Sserbits'     : cnf.getopt('SlavePort','serbits'),
        'Sserparity'   : cnf.getopt('SlavePort','serparity'),
        'Sserstopbit'  : cnf.getopt('SlavePort','serstopbit'),
        'csvfileArray' : csvfileArray,
        'logfArray'    : logfArray,
        'logStatus'    : logStatus
    }
    return render_template('wireless_config.html', **info)


@wireless_blueprint.route("/wireless_showCsvFile")
def wireless_showCsvFile():
    param = request.args.get("FILE")
    fname='/config/'+os.path.basename(param)

    result = "<html>\n<head>\n<meta charset=\"UTF-8\">\n</head>\n<body>\nError: File not found"
    if os.path.isfile(fname):
        result = """<html>\n<head>\n<meta charset=\"UTF-8\">\n</head>\n<body>\n<table border=1>\n<tr>\n
                <td>Secondary Address</td><td>Primary Address</td><td>Wireless Key</td><td>Active</td>\n</tr>\n"""
        with open(fname,encoding="latin-1") as fp:
            line = fp.readline().strip()
            while line:
                cols=line.split(";")
                result += "<tr><td>%s</td>"%cols[0]
                if len(cols) > 1:
                    result += "<td>%s</td>"%cols[1]
                else:
                    result += "<td>&nbsp;</td>"
                if len(cols) > 2:
                    result += "<td>%s</td>"%cols[2]
                else:
                    result += "<td>&nbsp;</td>"
                if len(cols) > 3 and cols[3] == '0':
                    result += "<td>%s</td>"%cols[3]
                else:
                    result += "<td>1</td>"
                result += "</tr>\n"
                line = fp.readline()
    result += "</body>\n</html>"
    return render_template_string(result)

@wireless_blueprint.route("/wireless_log", methods=['GET', 'POST'])
def wireless_log():
    fname = "/tmp/wireless"
    filename = fname+"_log.txt"
    if request.args.get("start"):
        if not os.path.exists(fname+".log"):
            pytouch("%s.log"%fname)
            os.chmod("%s.log"%fname, 0o666)
            time.sleep(2)
        shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("clear"):
        f=open("%s.log"%fname,'w+')
        f.close()
        f=open("%s_log.txt"%fname,'w+')
        f.close()
        os.chmod("%s.log"%fname, 0o666)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("show"):
        if os.path.exists("%s.log"%fname):
            shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
            os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("startup"):
        filename = fname+"_startup.log"

    logstring=""
    try:
        f=open(filename,'r')
        logstring=f.read()
        logstring.replace('\n','<br />')
        logstring = "\n"+logstring
        f.close()
    except:
        pass

    info = {'logstring': logstring}
    return render_template('wireless_log.html', **info)

@wireless_blueprint.route("/wireless_EditCsvFile")
def wireless_EditCsvFile():
    param = request.args.get("FILE")
    filename=os.path.basename(param)

    if os.path.isfile("/config/"+filename):
        table = []
        l_table=0
        f = open("/config/"+filename,'r')
        for l in f.readlines():
            table.append(l.split(';'))
            l_table += 1
        f.close()
        context = {
            'title' : "Editing %s"%filename,
            'filename':filename,
            'l_table' : l_table,
            'table' : table
        }
        return render_template('wireless_EditCsvFile.html', **context)
    else:
        result = "<html>\n<head>\n<meta charset=\"UTF-8\">\n</head>\n<body>\nError: File not found</body></html>"
        return render_template_string(result)

@wireless_blueprint.route("/wireless_MeterList")
def wireless_MeterList():
    cnf=Configs("config","wireless")

    '''
        Read from a file where information about the wireless meters/telegrams are stored in.
        The wireless application in PI-900S write the information to the file.
        Each row in the file represent a wireless telegram.
        The first 18 bytes in each telegram contains the wanted informaiton.
        * Primary address: byte 0.
        * Timestamp: byte 1 - 9.
        * RSSI: byte 9.
        * Secondary address: byte 10 - 17
        
        Example:
        0643192C5800000000833A44A7327824006807047A8C1000202F2F0C06000000000C14000000000B3B0000000B2D0000000B5A3202000B5E300200046D2008102B0F0000015AEC
        --________________--________________
        
        06               = Primary address 6.
        43192C5800000000 = 64-bit timestamp: 2016-11-16 09:30:59.
        83               = RSSI -125.
        3A44A73278240068 = Secondary address 68002478.32A7.44.3A. Read backwards.
    '''

    # List of device types.
    DeviceTypes = {
        # All missing values are reserved.
        0x00:"Other", 0x01:"Oil", 0x02:"Electricity", 0x03:"Gas",
        0x04:"Heat", 0x05:"Steam", 0x06:"Warm water", 0x07:"Water",
        0x08:"Heat cost allocator", 0x09:"Compressed Air", 0x0A:"Cooling (outlet)", 0x0B:"Cooling (inlet)",
        0x0C:"Heat (inlet)", 0x0D:"Heat/cooling", 0x0E:"Bus/System", 0x0F:"Unknown",
        0x14:"Calorific value", 0x15:"Hot water", 0x16:"Cold water", 0x17:"Dual water",
        0x18:"Pressure", 0x19:"A/D converter", 0x1A:"Smoke detector", 0x1B:"Room sensor",
        0x1C:"Gas detector", 0x20:"Breaker", 0x21:"Valve", 0x25:"Customer unit",
        0x28:"Waste water", 0x29:"Garbage", 0x31:"Communication controller", 0x32:"Unidirectional repeater",
        0x33:"Bidirectional repeater", 0x36:"Radio converter (system)", 0x37:"Radio converter (meter)"
    }

    def printData(data):
        tstr = ""
        for j in range(len(data)):
            if j&0x0f == 0 and j != 0:
                tstr += '\n'
            tstr += "%02X "%data[j]
        print(tstr)

    def getSecondaryAddress(data): # From the wireless telegram
        i_meter_id = struct.unpack("<I",data[4:8])
        i_mfct = struct.unpack("<H",data[2:4])[0]
        meter_id = "%08X"%i_meter_id
        mfct = "%04X"%i_mfct
        ver = data[8]
        med = data[9]
        name = "%c"%(((i_mfct>>10)&0x1F)+64)+"%c"%(((i_mfct>>5)&0x1F)+64)+"%c"%((i_mfct&0x1F)+64)
        meter_type = DeviceTypes[med] if med in DeviceTypes else "%02X"%med
        return meter_id, mfct, "%02X"%(ver), "%02X"%(med), name, meter_type

    def getTimeStamp(data):
        # Timestamp: INT64 to YYYY-MM-DD HH:MM:SS
        tmp = struct.unpack("Q", data[0:8])
        tmp = datetime.datetime.fromtimestamp(tmp[0])
        timestamp = "%04d-%02d-%02d %02d:%02d:%02d"%(tmp.year, tmp.month, tmp.day, tmp.hour, tmp.minute, tmp.second)
        return timestamp

    def parseLineToBytes(line):
        data = b""
        # Iterate over every other characters.
        for i in range(int(len(line)/2)):
            # Try to convert hex string to int.
            try:
                temp = int(line[2*i:2*i+2], 16)
                #print("%02X"%temp)
                data += struct.pack("B",temp)
            except:
                print("Error: '%s' contains a none hexadecimal number."%(line[2*i:2*i+2]))
                # TODO: handle this: sys.exit()
        return data

    #0108FD3F58000000003B
    #4644B4091128101505077A54000610EDD653CE9F3D0F1D0E00000000193910011216FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000CAA
    #        Secondary address:      15102811.09B4.05.07 [BMT] [Water]

    # Parse information in 
    def parseTelegram(telegram):
        primaryAddress = telegram[0]
        timestamp = getTimeStamp(telegram[1:9])
        (rssi0, rssi1, rssi2, rssi3, rssi4) = struct.unpack('BBBBB', telegram[9:14])
        if (rssi0  & 0xFC) == 0xFC:
            rssi0 = "N/A"
            hc0   = "#"
        else:
            hc0 = rssi0 & 0x03
            rssi0 = -int((rssi0 & 0xFC)/2)
        if (rssi1  & 0xFC) == 0xFC:
            rssi1 = "N/A"
            hc1   = "#"
        else:
            hc1 = rssi1 & 0x03
            rssi1 = -int((rssi1 & 0xFC)/2)
        print("h3")
        active     = (rssi4 & 0x02) >> 1
        available  = (rssi4 & 0x04) >> 2
        meter_id, manufacturer, version, medium, name, meter_type = getSecondaryAddress(telegram[15:])
        return ("%s.%s.%s.%s"%(meter_id, manufacturer, version, medium), primaryAddress, name, meter_type, rssi0, rssi1, active, available, timestamp)
        #return ("%s.%s.%s.%s"%(meter_id, manufacturer, version, medium), primaryAddress, name, meter_type, rssi0, timestamp)

    def getMyPrimaryAddress(telegram):
        return telegram[14]

    # =============================================================================
    # === Main ====================================================================
    # =============================================================================

    fabnum=""
    try:
        mbv=os.popen("/binary/wireless -S")
        fabnum=mbv.read().strip()
        mbv.close()
    except:
        pass

    meterlist = []
    primaryaddress = cnf.getopt('Main','primaryaddress')
    wlmodes=["S1","T1","Invalid mode","S1","R","Invalid mode","Invalid mode","Invalid mode","Invalid mode","Invalid mode","Invalid mode","T1+C"]
    n=int(cnf.getopt('Main','wirelessmode'))
    wirelessmode="Invalid mode"
    if n >=0 and n < 12:
        wirelessmode = wlmodes[n]

    n_active = 0
    n_available = 0
    n_active_and_available = 0
    try:
        filePath = "/tmp/wireless_telegrams.txt"
        #added by mats
        #meterlistFilePath = "/tmp/meterlist.txt"
        #meterFile = open(meterlistFilePath,  'a')
        
        fil = open(filePath)
        for line in fil:
            telegram = parseLineToBytes(line)
            parsed_telegram=parseTelegram(telegram)
            if parsed_telegram[6]:
                n_active += 1
            if parsed_telegram[7]:
                n_available += 1
                if parsed_telegram[6]:
                    n_active_and_available += 1
            meterlist.append(parsed_telegram)
            
            #added by mats
            #meterFile.write(meterlist)
            
            primaryaddress = getMyPrimaryAddress(telegram)
        fil.close()
    except:
        pass

    # render template with context data
    context = { 'title': 'List of Wireless Meters',
        'header': ["Secondary Address", "Prim Addr", "MFCT", "Meter Type", "RSSI 0", "RSSI 1", "Active", "Available", "Time Stamp (LocalTime)"],
        'items': meterlist,
        'fabnum' : fabnum,
        'meterlist' : meterlist,
        'primaryaddress' : primaryaddress,
        'wlmodes' : wlmodes,
        'n' : n,
        'wirelessmode' : wirelessmode,
        'n_active' : n_active,
        'n_available': n_available,
        'n_active_and_available' : n_active_and_available
    }
    return render_template('wireless_MeterList.html', **context)

@wireless_blueprint.route("/wireless_SetConf", methods=['GET','POST'])
def wireless_SetConf():
    cnf = Configs("config","wireless")
    pa = 250
    cnf.write_section('Main')
    try:
        pa=int(request.form['primaryaddress'])
    except:
        pass
    if pa > 250 or pa < 1:
        pa = 250
    cnf.conf['Main']['primaryaddress'] = "%d"%pa
    t = int(request.form['telegram_log_time'])
    if t > 0:
        cnf.conf['Main']['telegram_logtime'] = "%d"%(int(time.time())+t*86400)
    else:
        cnf.conf['Main']['telegram_logtime'] = "0"
    cnf.write_section('MasterPort','M')
    cnf.write_section('SlavePort','S')
    cnf.save_config()

    remove_cache=""
    if "removecache" in request.form:
        remove_cache=getParameter("removecache")

    subprocess.call(["killall","wireless"])
    time.sleep(0.2)

    wirelessmode=int(getParameter("wirelessmode"))
    if (remove_cache=="remove" and wirelessmode >=0 and wirelessmode < 12):
        wlmodes = ["S1","T1","T2","S1","R","","","","C2","C1","T2C","T1C"]
        subprocess.call(["/%s/etc/init.d/S98wireless"%PROOT,"stop"])
        try: # The link may not exist
            os.remove("/tmp/wireless_telegrams_%s.txt"%wlmodes[wirelessmode])
        except:
            pass
        try: # The link may not exist
            os.remove("/config/tmp/wireless_telegrams_%s.txt"%wlmodes[wirelessmode])
        except:
            pass
        try: # The link may not exist
            os.remove("/config/tmp/wireless_telegrams.txt") # This file should not exist but I have seen it. Remove when proven to be unneded.
        except:
            pass
    os.sync()
    subprocess.call(["/%s/etc/init.d/S98wireless"%PROOT,"restart"])
    time.sleep(1)
    return render_template_string("""<HTML>
    <HEAD>
        Writing conf file
        <meta http-equiv=\"refresh\" content=\"0;url=/wireless_config\">
    </HEAD>
    </HTML>""")

@wireless_blueprint.route("/wireless_SaveCsv", methods=['GET','POST'])
def wireless_SaveCsv():
    def getParameter( name ):
        if name in request.form:
            return request.form[name]
        return ""

    filename = os.path.basename(getParameter("filename"))
    f = open("/config/"+filename,"w")
    #f = open("/config/"+"humm.csv","w")
    i=0
    chars=['a','b','c','d']
    l_table=int(getParameter("l_table"))
    #l_table=2000
    for i in range(l_table+15):
        icell = "a%d"%i
        strn = ""
        if getParameter(icell):
            for j in range(4):
                strn += getParameter("%s%d"%(chars[j],i)).strip() + ";"
            f.write(strn+"\n")
        i += 1
    f.close()
    os.sync()
    time.sleep(1)
    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/wireless_EditCsvFile?FILE=%s\">
        </HEAD>
    </HTML>"""%filename)

@wireless_blueprint.route("/wireless_DownloadLogFile")
def wireless_DownloadLogFile():
    cstr = os.path.basename(request.args.get("FILE")).replace(' ','\ ')
    try:
        return send_file('/tmp/%s'%cstr, attachment_filename=cstr, mimetype='application/octet-stream', as_attachment=True)
    except:
        return 'File not found'

@wireless_blueprint.route("/wireless_DownloadLogFile1")
def wireless_DownloadLogFile1():
    filen=os.path.basename(request.args.get("FILE"))
    stream = BytesIO()
    with zipfile.ZipFile(stream, 'w', compression=zipfile.ZIP_DEFLATED) as zf:
        zf.write("/data/wireless/%s"%filen, filen)
    stream.seek(0)

    try:
        return send_file(stream, attachment_filename=filen+".zip", mimetype='application/octet-stream', as_attachment=True)
    except:
        return 'File not found'

@wireless_blueprint.route("/wireless_manual")
def wireless_documentation():
    return render_template('wireless_manual.html')

