import os
import configparser, glob
import serial, time
from flask import Flask, render_template, request, send_file, redirect, url_for, render_template_string, after_this_request,  json,  Blueprint
import csv
from manufacturer_dict import *
import subprocess

serial_dev = "/dev/ttyS4" #Master port on P900S This should not be hardcoded. FIXME XXXXX

pi900_type = "900S"
pi900_version = "unknown"
pi900_os   = "2016.02"
PI900_OS_NAME   = "Marlene"
pi900_ipk  = "900S2"
pi900_tgz  = "900S"

try:
    from pi900_type import *
except:
    pass

if pi900_type == "900T": # If defined in pi900_version
    pi900_tgz = "900T"

PROOT = ""
if os.path.isdir("/usr/local/www"):
    from pi900_version import *
    pi900_os = "2021.02"
    PROOT = "/usr/local"
    PI900_OS_NAME = "Charleton"
if os.path.isdir("/etc/chatscripts"):
    pi900_type="900T-LTE"
    pi900_ipk="900LTE"

# /usr/local/etc/pi900_type.json contains all info above except version.
# This file will be installed during testbench.
# This solution should work fine until 900T is produced, then the pi900_type.json file must be in place. FIXME


typefile = "/usr/local/etc/pi900_type.json"
if os.path.isfile(typefile):
    with open(typefile,'r') as f:
        t = json.load(f)
        pi900_type = t["pi900_type"]
        pi900_os   = t["pi900_os"]
        pi900_ipk  = t["pi900_ipk"]


BASEPATH="/"
ipNumber = '127.0.0.1'
ipPort = 9001


nodeaddresses = [[0x4129,0x01,0x36], [0x1596,0x14,0x31], [0x1596,0x15,0x31]]

ident_nr=""
manufacturer=""
version=""
media=""
meterCount = 0

baudRateList=['300','600','1200','2400','4800','9600','19200','38400', '57600']
bitList=['5','6','7','8']
parityList=[('N','No parity'),('O','Odd Parity'),('E','Even Parity'),('M','Mark Parity'),('S','Space Parity')]
stopBitList=['1','2']
ipLocalList=['ALL','ETHERNET1','ETHERNET2']
yesno=['YES','NO']

# List of device types.
DeviceTypes = {
    # All missing values are reserved.
    "00":"Other", "01":"Oil", "02":"Electricity", "03":"Gas",
    "04":"Heat", "05":"Steam", "06":"Warm warm", "07":"Water",
    "08":"Heat cost allocator", "09":"Air", "0A":"Cooling (outlet)", "0B":"Cooling (inlet)",
    "0C":"Heat (inlet)", "0D":"Heat/cooling", "0E":"Bus/System", "0F":"Unknown",
    "14":"Calorific value", "15":"Hot water", "16":"Cold water", "17":"Dual water",
    "18":"Pressure", "19":"A/D converter", "1A":"Smoke detector", "1B":"Room sensor",
    "1C":"Gas detector", "1D":"Magnet", "1E":"Leakage", "20":"Breaker", "21":"Valve", "25":"Customer unit",
    "28":"Waste water", "29":"Garbage", "2A":"Carbon dioxide", "2B":"VOC", "31":"Gateway", "32":"Unidirectional repeater",
    "33":"Bidirectional repeater", "36":"Radio converter (system)", "37":"Radio converter (meter)",
    "38":"Bus converter"
}

# Set of tuples containing meters which should have a "Manufacturer Specific Version String" in column 13 meterlist[12]
# If these meters are missing meterlist[12] they will not be added to the template.
MANUFACTURER_SPECIFIC_VERSION_SET = {
    
    ("0442", "20", "02")

}


# Don't cast exception if file doesn't exist
def removefile(fname):
    try:
        os.remove(fname)
    except Exception as e:
        print("Failed removing file: ", str(e))

def pytouch(fname):
    with open(fname,'w') as f:
        f.write("")

class Configs:
    def __init__(self,path,bname):
        self.path = path
        self.bname = bname
        self.conf = configparser.RawConfigParser()
        self.dconf = configparser.RawConfigParser()
        try:
            self.conf.read('/%s/%s.ini'%(self.path,self.bname))
        except:
            pass
        self.dconf.read('/%s/%s_default.ini'%(self.path,self.bname))

    # Returns option from .ini file. If not found then from _default.ini
    def getopt(self, cport, opt):
        retval=''
        try:
            retval=self.conf.get(cport,opt)
        except:
            retval=self.dconf.get(cport,opt)
        return retval

    # Returns option with a default value specified, not from _default.ini
    def getoptdef(self, cport, opt, default):
        retval=''
        try:
            retval=self.conf.get(cport,opt)
        except:
            retval=default
        return retval

    # Sets an option with value if specified
    # With request.form or default, if no value is specified
    # See M-Bus slaveports on how to use nameext
    def setopt(self, sect, opt,nameext='',value=None):
        retval=''
        if not value:
            try:
                retval=request.form[nameext+opt]
                #print("%s %s"%(opt,retval))
            except:
                retval=self.dconf[sect][opt]
        else:
            retval = value
        self.conf[sect][opt]=retval

    # Recreates a section with default values from default.ini.
    # Fills in all values with setopt.
    # Run before any setopt
    def write_section(self, sect,nameext=""):
        self.conf.remove_section(sect)
        self.conf.add_section(sect)
        for i in self.dconf.options(sect):
            self.setopt(sect,i,nameext)

    # The setopt1 and write_section1 are used in Modbus2MBus
    def setopt1(self, sect, opt,nameext, secttemplate=None):
        retval=''
        try:
            retval=request.form[nameext+opt]
        except:
            pass
        if retval == '':
            try:
                if not secttemplate:
                    retval=self.dconf[sect][opt]
                else:
                    retval=self.dconf[secttemplate][opt]
            except:
                pass
        self.conf[sect][opt]=retval

    def write_section1(self, sect,nameext="", secttemplate=None):
        self.conf.remove_section(sect)
        self.conf.add_section(sect)
        for i in self.dconf.options(secttemplate):
            self.setopt1(sect,i,nameext, secttemplate)

    def save_config(self):
        # To avoid other routes from reading and empty file we first write to a
        # temporary location to exploit `rename` being an atomic operation as by
        # http://man7.org/linux/man-pages/man2/rename.2.html.
        path = '/%s/%s.ini'%(self.path,self.bname)
        with open(path + '-tmp','w') as cfile:
            self.conf.write(cfile)
        os.rename(path + '-tmp', path)

class Configuration:
    def __init__(self, default, new):
        self.default = default
        self.new = new

    def get(self, ty, section, field):
        try:
            result = self.new[section][field]
        except:
            result = self.default[section][field]

        if ty == str:
            return result
        if ty == int:
            return int(result)
        if ty == float:
            return float(result)
        
        raise ValueError("unknown type")

    def read(self, ty):
        assert(isinstance(ty, dict))

        return {
            section: {
                field: self.get(ty[section][field], section, field)
                for field in ty[section]
            } for section in ty
        }

def validIPAddress(IP):
    """
    :type IP: str
    :rtype: str
    """
    def isIPv4(s):
        try:
            return str(int(s)) == s and 0 <= int(s) <= 255
        except:
            return False
    def isIPv6(s):
        if len(s) > 4:
            return False
        try:
            return int(s, 16) >= 0 and s[0] != '-'
        except:
            return False
    if IP.count(".") == 3 and all(isIPv4(i) for i in IP.split(".")):
        return "IPv4"
    if IP.count(":") == 7 and all(isIPv6(i) for i in IP.split(":")):
        return "IPv6"
    return "Neither"

def getParameter( name ):
    if name in request.form:
        return request.form[name]
    return ""

def setGPIO(gpio, onoff):
    try:
        f=open("/sys/class/gpio/%s/value"%gpio,'w')
        if (onoff == 'On'):
            f.write('1')
        else:
            f.write('0')
        f.close()
    except:
        pass

def getGPIO(gpio):
    retval = "Undefined"
    try:
        f=open("/sys/class/gpio/%s/value"%gpio,'r')
        s = f.read().strip()
        f.close()
        retval = "On" if (s == '1') else "Off"
    except:
        pass
    return retval

#Read csv file. delimiter can be set by delim. Minlen is the minimum number of fields returned.
# minlen = 6, [1,2,3,4] -> [1,2,3,4,'','']
def read_csv_file1(sfname, mode, delim, minlen):
    srows = []
    try:
        with open(sfname, mode) as cf:
            sreader = csv.reader(cf,delimiter=delim)
            srows=[]
            for row in sreader:
                if len(row) > 0:
                    if row[0][0] != "#":
                        for i in range(len(row)):
                            row[i] = row[i].strip() # Strip unnecessary leading and trailing spaces
                        if len(row) < minlen:
                            row += ['']*(minlen-len(row))
                        srows.append(row)
    except:
        pass
    return srows

def sniffer_csv(file):
    delimiter = ','
    position = 0
    while True:
        position = file.tell()
        line = file.readline()
        print("line ",line)
        new_pos = file.tell()
        print("new_pos", new_pos)
        if position == new_pos:
            break
        print("pos {}",position)
        if len(line) == 0:
            continue
        if line[0] != '#':
            print("#")
            if ";" in line:
                print("delim {}".format(line))
                delimiter=";"
                #position -= len(line)
            break
        
    file.seek(position)
    return delimiter

def rcf(file, delimiter, minlen=13):
    sreader = csv.reader(file,delimiter=delimiter)
    
    for row in sreader:
        if len(row) == 0:
            continue
        if len(row[0]) > 0 and row[0][0] == "#":
            continue
        for r in range(len(row)):
            row[r] = row[r].strip()
        yield row + ['']*(minlen-len(row))


def read_csv_file(sfname, mode, minlen):
    srows = []
    delimiterChar = ","
    def rowReader(row):
        for i in range(len(row)):
            row[i] = row[i].strip() # Strip unnecessary leading and trailing spaces
        if len(row) < minlen:
            print("8")
            row += ['']*(minlen-len(row))
        srows.append(row)

    try:
        with open(sfname, mode) as lines:
            for line in lines:
                print("line {}".format(line))
                if line[0] != '#':
                    print("#")
                    if ";" in line:
                        print("delim {}".format(line))
                        delimiterChar=";"
                    break
            # Reset the pointer to start of file
            lines.seek(0,0)
            sreader = csv.reader(lines,delimiter=delimiterChar)
            for row in sreader:
                print("row {}".format(row))
                if len(row) > 1: # Is it necessary to check if len > 0 and > 1??? XXXXX
                    if row[0][0] != "#":
                        rowReader(row)
                else:
                    if  len(row) > 0 and row[0] != "#":
                        rowReader(row)
                
    except:
        print("crash in weblib")
        raise
    return srows

def isHex(i):
    try:
        int(i, 16)
        return True
    except:
        return False

def serialNo():
    serialno = "serialno"
    try:
        mbs=os.popen("/binary/mbushub.elf -S")
        serialno=mbs.readline().strip('\n')
        mbs.close()
    except Exception as e:
        print("error getting serialno: "+str(e))
    return serialno

# Latin-1 conversion table
conversion_table = {
    "À": "A",
    "Á": "A",
    "Â": "A",
    "Ã": "A",
    "Ä": "A",
    "Å": "A",
    "Æ": "AE",
    "Ç": "C",
    "È": "E",
    "É": "E",
    "Ê": "E",
    "Ë": "E",
    "Ì": "I",
    "Í": "I",
    "Î": "I",
    "Ï": "I",
    "Ð": "D",
    "Ñ": "N",
    "Ò": "O",
    "Ó": "O",
    "Ô": "O",
    "Õ": "O",
    "Ö": "O",
    "×": "x",
    "Ø": "O",
    "Ù": "U",
    "Ú": "U",
    "Û": "U",
    "Ü": "U",
    "Ý": "Y",
    "Þ": "P",
    "ß": "ss",
    "à": "a",
    "á": "a",
    "â": "a",
    "ã": "a",
    "ä": "a",
    "å": "a",
    "æ": "ae",
    "ç": "c",
    "è": "e",
    "é": "e",
    "ê": "e",
    "ë": "e",
    "ì": "i",
    "í": "i",
    "î": "i",
    "ï": "i",
    "ð": "o",
    "ñ": "n",
    "ò": "o",
    "ó": "o",
    "ô": "o",
    "õ": "o",
    "ö": "o",
    "÷": "/",
    "ø": "o",
    "ù": "u",
    "ú": "u",
    "û": "u",
    "ü": "u",
    "ý": "y",
    "þ": "p",
    "ÿ": "y"
}

# Functions taken from mbuslib. Make a single version later XXXXXXXXXXXXXXXXXX
def getHex(i, defval):
    retval = defval
    try:
        retval = int(i, 16)
    except:
        pass
    return retval


# Changes ['12345678','',None] to [0x12345678,0xFFFF,0xFF,0xFF]
def secAddrStrToHex1(saddr):
    id = getHex(saddr[0], 0xFFFFFFFF)
    mfct = getHex(saddr[1], 0xFFFF)
    ver = getHex(saddr[2], 0xFF)
    med = getHex(saddr[3], 0xFF)
    return [id, mfct, ver, med]

def meterlist_to_cyclic_conf():
    rows = read_csv_file("/config/meterlist.csv", 'r', 4)
    f = open("/config/cyclic.csv",'w')
    for r in rows:
        l=secAddrStrToHex1([r[0],r[1],r[2],r[3]])
        print(l)
        f.write("[Device],a,,b,,,1,,,,,,,1,,,,,,%08X.%04X.%02X.%02X,,,,,24,,,,,,,,,,,,,,,,,,,900,\n"%(l[0],l[1],l[2],l[3]))
    f.close()
    if os.path.isfile("/config/use_cyclic"):
        subprocess.call(["%s/etc/init.d/S49cyclic"%PROOT,"restart"])

