#!/usr/bin/python3
# -*- coding: utf-8 -*-;
#kate: space-indent on; indent-width 4; mixedindent off; indent-mode python

import struct, sys, socket,  csv,  os
import time,  datetime, traceback
from weblib import *
import core.search
import mbuslib as mbl

"""
The program works on meterlist files with the following format:
0   , 1    , 2   , 3   , 4          , 5           , 6               , 7                  , 8                , 9
<Id>,<MFCT>,<VER>,<MED>,<MFCT STRNG>,<Fabrication>,<Primary Address>, <Verified or empty>,<Meter Type W,R,N>, <timestamp>

The meterlist is named meterlist.txt and is placed in either /tmp/ or /config/
The Id number must be there. The other are optional for the verification.

The /tmp directory (RAM memory, doesn't age flash memory) is for preconfiguring.
The /config directory is for files that have been worked on by the user and they should be treated with
respect.
Respect means :)
Do not overwrite without the users consent!

The list of searched meters is verified by definition.
An uploaded list must be verified and MFCT,VER,MED must be added to it.

A meter without MFCT,VER,MED must not be appended to the /config/... file.

ToDo:
The /config/meterlist.csv must be verified as well.
"""

def PrintData(data):
    tstr = ""
    for j in range(len(data)):
        if j%16 == 0:
            tstr += '\n'
        tstr += "%02X "%data[j]
    print(tstr)

def PrintDataOnOneLine(data):
    tstr = ""
    for j in range(len(data)):
        tstr += "%02X "%data[j]
    return tstr
    #print(tstr, end="")

def CalcBcc(arr):
    bcc=0
    for i in range(len(arr)):
        bcc += arr[i]
    return bcc & 0xFF


def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def CreateShortFrame(cfield, afield):
    req   = b"\x10"+struct.pack("BB",cfield, afield)
    req += struct.pack("B",CalcBcc(req[1:])) + b"\x16"
    return req

def CreateSlvSelect(idnum, mfct, ver, med, fab = None):
    req1 = b"\x53\xFD\x52" # (C-field),FD is the primary address 253, 52 is the selection of slaves (CI-field)
    req1 += struct.pack("<IHBB",idnum, mfct, ver, med)
    if fab:
        req1 += b"\x0C\x78" + struct.pack("<I", fab)
    req = b"\x68" + struct.pack("BB",len(req1),len(req1)) + b"\x68" + req1 # Length bytes between 68 L-byte L-byte 68 is => length (in bytes) of secondary address(idnum(4bytes), manufacturer(2bytes),version(1byte),medium(1byte)) + 3bytes(C-field,A-field,CI-field)
    req += struct.pack('B',CalcBcc(req[4:]))+b"\x16"
    return req

def CreateReqUd2(adress):
    toggle = 0x7B
    checkSum = (toggle + adress) & 0xFF # address 253(integer) + 7B(hex) =  178(hex) => 178(hex) & FF = 78(hex)
    req_ud2 = struct.pack("BBBBB", 0x10, toggle, adress, checkSum, 0x16)
    return req_ud2

def VerifyLongFrame(frame):
    if len(frame) == 0:
        print("No response received")
        return False
    # Check number of received bytes.
    if len(frame) < 21:
        print("Too few bytes received")
        print(len(frame))
        return False

    # Check frame characters.
    if (frame[0] != 0x68 or frame[3] != 0x68):
        print("Incorrect frame characters")
        return False

    # Check length.
    if (frame[1] != frame[2] or frame[1] != len(frame)-6):
        print("len()frame %s"%len(frame))
        print("frame[1] %s"%frame[1])
        print("diff %s"%str(len(frame)-6))
        print("Incorrect message length")
        return False
    # Check checksum.
    if (CalcBcc(frame[4:len(frame)-2]) != frame[len(frame)-2]):
        print("Incorrect checksum")
        return False
    return True

def isHex(i):
    try:
        int(i, 16)
        return True
    except:
        return False

def isDec(i):
    try:
        int(i, 10)
        return True
    except:
        return False

# Only full wildcards are allowed in this function. Exempel mfct = 0x4129 or 0xFFFF. Not 0x41FF
# Id must be without a wildcard
# Only saddr2 is checked for wildcards
# Return values 0 if no match, 1 if id's match, 2 if all fields match, -1 in case of an error
def compareSecAddresses(saddr1, saddr2):
    match = 0
    try:
        mbid1 = int(saddr1[0],16) & 0xFFFFFFFF
        mfct1 = int(saddr1[1],16) & 0xFFFF
        ver1  = int(saddr1[2],16) & 0xFF
        med1  = int(saddr1[3],16) & 0xFF
    except:
        return -1
    mbid2 = saddr2[0]
    mfct2 = saddr2[1]
    ver2  = saddr2[2]
    med2  = saddr2[3]
    if mbid1 == mbid2:
        match = 1
        print("match 1")
        if mfct1 == mfct2 and ver1 == ver2 and med1 == med2:
            print("match 2")
            match = 2
        elif mfct1 != mfct2 and mfct2 != 0xFFFF and mfct2 != "":
            match = 0
        elif ver1 != ver2 and ver2 != 0xFF and ver2 != "":
            match = 0
        elif med1 != med2 and med2 != 0xFF and med2 != "":
            match = 0
    return match

def writeMeterlist(verifySingle, meterlist):
        mode = ""
        if verifySingle:
            mode = "a+"
        else:
            mode = "w"
        print("mode {}".format(mode))
        with open("/config/meterlist.csv", mode, newline='') as cf:
            writer = csv.writer(cf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            for m in meterlist:
                print("m {}".format(m))
                writer.writerow(m)

def checkIfWireless(wml, meter,  metertype, fab, mbid, mfct, ver, med, found=False, verifyMeters=False):
    print("in checkIfWireless")
    for w in wml:
        c = compareSecAddresses(w[0:4],[mbid,mfct,ver,med])
        if metertype in ['W','N','H','M',''] and c == 2: # An incorrectly marked meter, correcting
            metertype = 'R'
            meter[8] = "R"
            found = True
            if fab == 0xFFFFFFFF or fab == "":
                fab = int(w[5],16)
                print("fab empty")
                meter[5] = w[5]
            break
        else:
            if c == 1:
                meter[1] = w[1]
                meter[2] = w[2]
                meter[3] = w[3]
                meter[4] = w[4]
                meter[5] = w[5]
                meter[6] = w[6]
                if verifyMeters: # Is this part maybe unneccessary? If it is a wireless meter then it is verified if it is found in meterlist_wireless, there will be no REQ_UD2 question asked.
                    mfct = int(w[1],16)
                    ver  = int(w[2],16)
                    med  = int(w[3],16)
            if c > 0:
                found = True
                meter[8] = 'R'

                assert(fab != 0xFFFFFFFF)
                fab = int(w[5],16)
                break
    
    return meter, found, metertype, fab


def readWirelessMeterlist():
    wml = []
    print("in createWirelessMeterlist")
    if (os.path.isfile("/tmp/meterlist_wireless.txt")):
        try:
            with open("/tmp/meterlist_wireless.txt") as file:
                delimiter = sniffer_csv(file)
                wml = list(rcf(file, delimiter))
        except Exception as e:
            traceback.print_exc()
            print("error in meterlist_wireless.txt: "+str(e))
    return wml

def updateMeterWithBrowseOutput(meter):
    meter[1] = core.search.stateVariables.browse_output_mfct
    meter[2] = core.search.stateVariables.browse_output_ver
    meter[3] = core.search.stateVariables.browse_output_med

    meter[4] = MfctToStr(int(core.search.stateVariables.browse_output_mfct,16))

    meter[6] = core.search.stateVariables.browse_output_primary_address
    meter[7] = "20"
    if [
        int(core.search.stateVariables.browse_output_mfct,16), 
        int(core.search.stateVariables.browse_output_ver, 16), 
        int(core.search.stateVariables.browse_output_med, 16)
        ] in nodeaddresses:
        meter[8] = "N"
    else:
        meter[8] = "W"
    meter[11] = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    m = (meter[1], meter[2], meter[3])
    meter[12] = core.search.stateVariables.browse_output_mfct_spec_ver

    return meter

# We read through the full meterlist.csv
# We start by comparing it to the meterlist_wireless.txt
# If we find the meter in meterlist_wireless.txt, we will use the information from there
# if the meter is a wireless meter.
# If the meter is not found found in the meterlist_wireless file, we assume it is a node
# or a wired meter.
# We need to replace the Ver text by a number. 0 or empty not verified. 1 info ok. 2 meter
# checked to answer or a wireless meter with < 24h old telegram.
#
#cont = True # Set to false for the verfication to stop
def DoVerify(ip, port, init, meterfile,verifyMeters, verifySingle, stop):
    print("start")


    mbushubini_def = configparser.RawConfigParser()
    mbushubini_def.read("/config/mbushub_default.ini")
    mbushubini = configparser.RawConfigParser()
    mbushubini.read("/config/mbushub.ini")

    parser = Configuration(mbushubini_def, mbushubini)
    sercomport = parser.get(float, "MasterPort", "timeout")
    time_out = (sercomport/1000) + 0.2
    print("sercomport", time_out)

    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.settimeout(time_out) # A timeout is needed for meters that don't respond
    meterlist = []
    if (os.path.isfile(meterfile)):
        try:
            with open(meterfile) as file:
                delimiter = sniffer_csv(file)
                meterlist = list(rcf(file, delimiter))
        except Exception as e:
            print("error in open meterfile: "+str(e))
    else:
        return

    wml = readWirelessMeterlist()

    # Here we should return a warning if no meterlist_wireless is found.
    # This is ok if there are no wireless meters but will be problematic if there are some. XXXXXXXXXXXXXXXXXXXXXXXX
    with open("/tmp/search_result.txt", "w") as logfile:
        for i in range(len(meterlist)):
            #print("meter %s"%meter)
            #Here we have to look at the fabrication number to know if we have to get timestamp from wireless_nodes_telegrams.txt file or similar file.
            #The fabrication number have to be added for the local wireless card in the 900-unit.
            #
            if stop.is_set():
                # If we stop the script through "Stop Reading" or "Stop verification" the changes
                # that has been made in the meterlist must be saved.
                writeMeterlist(verifySingle, meterlist)
                break
            print("meter %s"%meterlist[i])
            
            if meterlist[i][0][0] == "#":
                continue
            
            retval = ""
            ok = True
            if not isHex(meterlist[i][0]):
                # verification fails
                continue

            print("verify meterlist id", meterlist[i][0])
            mbid = int(meterlist[i][0], 16) & 0xFFFFFFFF
            metertype = ""
            print("mbid",mbid)

            mfct = 0xFFFF
            ver = 0xFF
            med = 0xFF
            fab = ""
            prim = ""
            if isHex(meterlist[i][1]):
                mfct = int(meterlist[i][1], 16) & 0xFFFF              
            if isHex(meterlist[i][2]):
                ver = int(meterlist[i][2], 16) & 0xFF
            if isHex(meterlist[i][3]):
                med = int(meterlist[i][3], 16) & 0xFF
            if isDec(meterlist[i][5]):
                fab = int(meterlist[i][5], 16) & 0xFFFFFFFF
            if isHex(meterlist[i][6]):
                prim = int(meterlist[i][6], 16) & 0xFF

            metertype = meterlist[i][8]
            found = False

            meterlist[i], found, metertype, fab = checkIfWireless(
                wml, 
                meterlist[i],  
                metertype,
                fab, 
                mbid, 
                mfct, 
                ver,
                med,
                found,
                verifyMeters)

            if not verifyMeters:
                if mfct != 0xFFFF and ver != 0xFF and med != 0xFF:
                    if metertype in ['W','N']:
                        found = True
                        continue
                    elif metertype == 'R' and fab != '':
                        found = True
                        continue
            if not found: # This should only happen if the meter is Wired or Node. Not if wireless meter.
                # We make up to 3 Slave Select requests before asking next meter in list.
                for k in range(3):
                    if stop.is_set():
                        # If we stop the script through "Stop Reading" or "Stop verification" the changes
                        # That has been made in the meterlist must be saved.
                        writeMeterlist(verifySingle, meterlist)
                        break
                    ok = True
                    logfile.write("Read %08X.%04X.%02X.%02X\n"%(mbid,mfct,ver,med))
                    logfile.flush()
                    
                    ok = False
                    print("VERIFY")

                    secaddr = "%08X.%04X.%02X.%02X"%(mbid,mfct,ver,med)
                    
                    print("secaddr in verify_meterlist before browse", secaddr)

                    # If askBrowse return True the read went ok and
                    # browse have returned a rsp_ud from a meter.
                    # Now we need to check if the requested meter is the one
                    # that actually answered.

                    if core.search.askBrowse(ipNumber, ipPort, "u", secaddr, 1, 0, 1):
                        if mbl.compareSecAddresses(
                            [
                                core.search.stateVariables.browse_output_id, 
                                core.search.stateVariables.browse_output_mfct,
                                core.search.stateVariables.browse_output_ver,
                                core.search.stateVariables.browse_output_med
                            ],
                            [
                                meterlist[i][0],
                                meterlist[i][1],
                                meterlist[i][2],
                                meterlist[i][3]
                            ]
                            ) > 0:

                            # Correct meter answered and the meter should be updated
                            logfile.write("Read OK\n")
                            logfile.flush()
                            print("Correct meter answered")
                            ok = True
                            meterlist[i] = updateMeterWithBrowseOutput(meterlist[i])

                            break
                        else:
                            # Wrong meter answers
                            #
                            # verifyMeters is True if we use Read All Meters Button
                            # If verifyMeters is True we make up to 3 requests before we move
                            # on to the next meter.
                            logfile.write("Wrong meter answered\n")
                            logfile.flush()
                            if not verifyMeters:
                                break
                    else:
                        # The Browse read did not work.
                        # We need to check if we should do a re-request

                        # The meter has enough information to be connected
                        # to a certain template type then it shall receive the 
                        # 10 else 0

                        # Write the Browse error to the logfile
                        logfile.write(core.search.stateVariables.browse_output_error + "\n")
                        logfile.flush()

                        print(core.search.stateVariables.browse_output_error)
                        if mfct != 0xFFFF and ver != 0xFF and med != 0xFF:
                            m = (meterlist[i][1], meterlist[i][2], meterlist[i][3])
                            if (m in MANUFACTURER_SPECIFIC_VERSION_SET):
                                meterlist[i][7] = "0" if meterlist[i][12] == "" else "10"
                            else:
                                print("Setting status 10")
                                meterlist[i][7] = "10"
                        else:
                            print("Not enough information for template creation")
                            meterlist[i][7] = "0"

                        # If not Read Meter have been pressed there should only be 1 Slave Select
                        # Maybe this should be changed to 3 times also.
                        # The primary/secondary search also go through this function.
                        if not verifyMeters:
                            break
                        # This sleep is needed for the meter to respond for a new Slave Select 
                        # The timeout look at mbushub masterport timeout.
                        # The socket timeout is still set to 5 seconds so the mbushub masterport
                        # timeout will only affect this timeout up to 5 sedconds.
                        # Maybe we should also change the socket timeout to look at mbushub masterport timeout.
                        if k < 2:
                            print("time.sleep({})".format(time_out))
                            time.sleep(time_out)

                        print("meterlist[i] {}".format(meterlist[i][0]))
                        print("in for-loop ok= {}".format(ok))
    #if cont: # If the verification has been stopped. Don't overwrite the meterlist.
    #if not stop.is_set():
    # We want to be able to overwrite the meterlist with the newly verified meters.
    # Only meters which have been modified will be changed.
    writeMeterlist(verifySingle, meterlist)

if __name__ == "__main__":
    if len(sys.argv) < 5:
        print("Usage %s <IP-address> <IP-Port> <init> <meterlist csv file>"%sys.argv[0])
        sys.exit(0)
    ip = sys.argv[1]
    port = int(sys.argv[2])
    init = sys.argv[3]
    meterfile = sys.argv[4]
    DoVerify(ip, port, init, meterfile, verifyMeters, verifySingle, stop)



