/** note: menu.js must be loaded before this script in order to work **/
/** turns on the menu auto update to on, see menu.js */
const enableAutoUpdateStatus = () => {
    try {
        document.getElementById('status-auto-update-on').checked = true
        startLoop()
    } catch (err) {
        console.error(err)
    }
}
/** turns off the menu auto update to on, see menu.js */
const disableAutoUpdateStatus = () => {
    try {
        stopLoop()
        document.getElementById('status-auto-update-off').checked = true
    }catch (err) {
        console.error(err)
    }
}

function initPage() {
    let id = document.getElementById("ident_nr");
    if (window.Idnum) {
        id.value = window.Idnum;
    } else {
        id.value = "FFFFFFFF";
        window.Idnum = "FFFFFFFF"
    }
    let mfct = document.getElementById("manufacturer");
    if (window.Manufact) {
        mfct.value = window.Manufact;
    } else {
        mfct.value = "FFFF";
        window.Manufact = "FFFF";
    }
    let ver = document.getElementById("version");
    if (window.Version) {
        ver.value = window.Version;
    } else {
        ver.value = "FF";
        window.Version = "FF";
    }
    let med = document.getElementById("medium");
    if (window.Medium) {
        med.value = window.Medium;
    } else {
        med.value = "FF";
        window.Medium = "FF";
    }
    let startSelect = document.getElementById("startAddr");
    for (var i = 0; i < 251; i++) {
        var option = document.createElement("option");
        option.value = i;
        option.innerHTML = i;
        startSelect.options.add(option);
    }
    let endSelect = document.getElementById("endAddr");
    for (var i = 0; i < 251; i++) {
        var option = document.createElement("option");
        option.value = i;
        option.innerHTML = i;
        endSelect.options.add(option);
    }

}

initPage();

const myInit = {
    credentials: "include",
    method: 'GET',
    headers: {
        'Content-Type': 'application/json'
    },
};

let metersFoundRequest = new Request("/meters_found", myInit);
let stopSecondarySearchRequest = new Request("/stop_secondary_search", myInit);
let stopPrimarySearchRequest = new Request("/stop_primary_search", myInit);
let startNodeSearchRequest = new Request("/start_node_search", myInit);

const startSecondarySearch = async (search_mode) => {
    if (search_mode == 'normal' || search_mode == 'exhaustive') {

    }

    const id = document.getElementById("ident_nr");
    const mfct = document.getElementById("manufacturer");
    const ver = document.getElementById("version");
    const med = document.getElementById("medium");
    if (id.value) {
        window.Idnum = id.value;
    } else {
        window.Idnum = "FFFFFFFF";
    }
    if (mfct.value) {
        window.Manufact = mfct.value;
    } else {
        window.Manufact = "FFFF";
    }
    if (ver.value) {
        window.Version = ver.value;
    } else {
        window.Version = "FF";
    }
    if (med.value) {
        window.Medium = med.value;
    } else {
        window.Medium = "FF";
    }

    const searchValues = [window.Idnum, window.Manufact, window.Version, window.Medium, search_mode];
    try {
        const response = await fetch("/start_secondary_search", {
            credentials: "include",
            method: "POST",
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(searchValues)
        })

        const json = await response.json()
        window.running = json[0]
        window.status = json[1]
        window.functionDidStart = json[2]
        enableAutoUpdateStatus()
        metersFound();
    } catch (err) {
        console.log("Fetch problem: " + err.message);
    }
};

const startPrimarySearch = async () =>  {
    const startaddr = document.getElementById("startAddr");
    const endaddr = document.getElementById("endAddr");
    window.startAddr = startaddr.value;
    window.endAddr = endaddr.value;
    const searchValues = [window.startAddr, window.endAddr];
    try {
        const response = await fetch("/start_primary_search", {
            credentials: "include",
            method: "POST",
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(searchValues)
        })
        const data = await response.json()
        window.running = data[0]
        window.status = data[1]
        window.functionDidStart = data[2]
        
        enableAutoUpdateStatus()
        metersFound();
    } 
    catch (err) 
    {
        console.log("Fetch problem: " + err.message);
    }
};

let metersFoundIntervalIndex = -1
function metersFound() {
    fetch(metersFoundRequest)
        .then(response => response.json())
        .then(json => {
            window.meters_found = json["metersfound"];
            window.nodes_found = json["nodesfound"];
            window.running = json["running"]
            window.status = json["status"]
            window.adressData = json["addressData"]
            window.search_result = json["search_result"]

            if (window.nodes_found.length > 0) {
                document.getElementById("node-root").style.visibility = "visible";
                window.printNodesFound();
            } else {
                document.getElementById("node-root").style.visibility = "collapse";
            }

            if (window.meters_found.length > 0) {
                document.getElementById("meter-root").style.visibility = "visible";
                window.printMetersFound();
            } else {
                document.getElementById("meter-root").style.visibility = "collapse";
            }

            if (window.running) {
                clearTimeout(metersFoundIntervalIndex)
                metersFoundIntervalIndex = setTimeout(metersFound, 5000);
            }
            document.getElementById("startAddr").value = window.adressData["start"];
            document.getElementById("endAddr").value = window.adressData["end"];
            document.getElementById("ident_nr").value = window.adressData["id"];
            document.getElementById("manufacturer").value = window.adressData["mfct"];
            document.getElementById("version").value = window.adressData["ver"];
            document.getElementById("medium").value = window.adressData["med"];
        })
        .catch(function (err) {
            console.log("Fetch problem: " + err.message)
        });
};

const fetchRoute2 = async (request) => {
    try {
        const response = await fetch(request)
        const json = await response.json()
        window.running = json[0]
        window.status = json[1]
        metersFound();
    } catch (err) {
        console.error("Fetch problem: " + err.message);
    }
}

const stopSecondarySearch = async () => {
    console.error("Stop secondary search")
    try {
        const response = await fetch("/stop_secondary_search", {
            credentials: 'include',
            headers: {'Content-Type':'application/json'},
            method:'POST',
        })

        const data = await response.json()
        window.running = data[0]
        window.status = data[1]
        disableAutoUpdateStatus()
    } catch (err) {
        console.error("Failed stopping search", err)
    }
}

function stopPrimarySearch() {
    fetchRoute2(stopPrimarySearchRequest);
    disableAutoUpdateStatus()
}

function startSearchNodes() {
    fetchRoute2(startNodeSearchRequest);
    enableAutoUpdateStatus()
}


function checkIfSure(formName, search_mode) {
    if (search_mode == 'normal' || search_mode == 'exhaustive') {
        var myform = document.getElementById(formName);
        var input = document.createElement('input');
        input.setAttribute('name', 'timeoutMode');//set the param name
        input.setAttribute('value', search_mode);//set the value
        input.setAttribute('type', 'hidden')//set the type, like "hidden" or other
        myform.appendChild(input);//append the input to the form
    }

    var exists = '{{metersFoundExists}}';
    if (exists == 'true') {
        if (window.confirm('This will erase previous search results. Are you sure you want to continue?')) {
            document.forms[formName].submit();
        }
    }
    else {
        document.forms[formName].submit();
    }
}

function printMetersFound() {
    var meterOutput = "";
    for (m in window.meters_found) {
        var secAddr = `${window.meters_found[m].id}.${window.meters_found[m].mfct}.${window.meters_found[m].ver}.${window.meters_found[m].med}`;
        meterOutput += `<tr>`;
        meterOutput += `<td>${parseInt(m) + 1}</td>`;
        meterOutput += `<td>${secAddr}</td>`;

        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(window.meters_found[m].med)) {
            meterOutput += `
                <td>
                ${window.DeviceTypes[window.meters_found[m].med]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters_found[m].med}
                </td>
            `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the 
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(window.meters_found[m].mfct_str)) {
            meterOutput += `
                <td>
                ${window.csvDict[window.meters_found[m].mfct_str]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.meters_found[m].mfct_str}
                </td>
            `;
        }

        // Add the prim number
        if (window.meters_found[m].prim) {
            meterOutput += `
                <td>
                ${window.meters_found[m].prim}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        meterOutput += "</tr>";
    }
    document.getElementById("meterDiv").innerHTML = meterOutput;
}

function printNodesFound() {
    var meterOutput = "";
    for (m in window.nodes_found) {
        var secAddr = `${window.nodes_found[m].id}.${window.nodes_found[m].mfct}.${window.nodes_found[m].ver}.${window.nodes_found[m].med}`;
        meterOutput += `<tr>`;
        meterOutput += `<td>${parseInt(m) + 1}</td>`;
        meterOutput += `<td>${secAddr}</td>`;

        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(window.nodes_found[m].med)) {
            meterOutput += `
                <td>
                ${window.DeviceTypes[window.nodes_found[m].med]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.nodes_found[m].med}
                </td>
            `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the 
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(window.nodes_found[m].mfct_str)) {
            meterOutput += `
                <td>
                ${window.csvDict[window.nodes_found[m].mfct_str]}
                </td>
            `;
        } else {
            meterOutput += `
                <td>
                ${window.nodes_found[m].mfct_str}
                </td>
            `;
        }

        // Add the prim number
        if (window.nodes_found[m].prim) {
            meterOutput += `
                <td>
                ${window.nodes_found[m].prim}
                </td>
            `;
        } else {
            meterOutput += "<td></td>";
        }

        meterOutput += "</tr>";
    }
    document.getElementById("nodeDiv").innerHTML = meterOutput;
}

metersFound();