
function showUploadModal() {
    let uploadMeterlistModal = document.getElementById("upload-meterlist-modal")
    uploadMeterlistModal.hidden = false
    uploadMeterlistModal.style.display = "block"
}

function closeUploadModal() {
    let uploadMeterlistModal = document.getElementById("upload-meterlist-modal")
    uploadMeterlistModal.hidden = true
    uploadMeterlistModal.style.display = "none"

}

// This will match the input from the manufacturer header with the data in
// Manufacturer description dictionary (csvDict)
function matchInput(property) {
    var input = document.getElementById(property).value.toLowerCase();

    // If user have pressed backspace after misspelling the window.meters
    // will be filled up again with the fetched array, otherwise it will be empty

    window.meters = window.fetchedMeters;


    var newMeters = [];
    var re = new RegExp("\\b" + input, "i");
    if (input == "") {
        window.meters = window.fetchedMeters;
        window.printMeterlist();
        return;
    }
    for (m in window.meters) {
        if (window.csvDict[window.meters[m].mfct_str] != undefined) {
            var mfctMatch = window.csvDict[window.meters[m].mfct_str].toLowerCase().match(re);
        }
        var idMatch = window.meters[m].id.match(re);
        if (mfctMatch) {
            newMeters.push(meters[m]);
        }
        if (idMatch) {
            newMeters.push(meters[m]);
        }
    }
    window.meters = newMeters;
    window.printMeterlist();
};

function printMeterlist() {
    var meterOutput = "";
    for (m in window.meters) {
        var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
        if (window.meters[m].fab) {
            secAddr += ":" + window.meters[m].fab;
        }

        if (window.dupSet.hasOwnProperty(window.meters[m].order)) {
            meterOutput += `<tr id='${window.meters[m].order}-row' class='fail-bg-color'>`;
        } else {
            meterOutput += `<tr id='${window.meters[m].order}-row'>`;
        }
        meterOutput += `<td>${parseInt(m) + 1}</td>`;

        if (window.meters[m].type == "R") {
            meterOutput += `<td>Wireless</td>`;
        } else if (window.meters[m].type == "N") {
            meterOutput += `<td>Node</td>`;
        } else if (window.meters[m].type == "W") {
            meterOutput += `<td>Wired</td>`;
        } else {
            meterOutput += "<td></td>";
        }

        meterOutput += `
        <td>
        <form action="/show_browse_result" method="post" >
        <button 
            class="" 
            type="submit"
            name='secAddress' 
            value='${secAddr}'>${window.meters[m].id}
        </button>
            <input style="display:none" disabled name="mfct_str" value="${window.meters[m].mfct}" />
        </form>
        </td>`;

        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(window.meters[m].med)) {
            meterOutput += `
            <td>
            ${window.DeviceTypes[window.meters[m].med]}
            </td>
        `;
        } else {
            meterOutput += `
            <td>
            ${meters[m].med}
            </td>
        `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(window.meters[m].mfct_str)) {
            meterOutput += `
            <td>
            ${window.csvDict[window.meters[m].mfct_str]}
            </td>
        `;
        } else {
            meterOutput += `
            <td>
            ${window.meters[m].mfct_str}
            </td>
        `;
        }

        // Add the fabrication number to the meterlist
        if (window.meters[m].fab) {
            meterOutput += `
            <td>
            ${window.meters[m].fab}
            </td>
        `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the prim number
        if (window.meters[m].prim) {
            meterOutput += `
            <td>
            ${window.meters[m].prim}
            </td>
        `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the verification status image
        if (window.meters[m].status == "20" || window.meters[m].status == "Ver") {
            meterOutput += `
            <td>
            <img src="../../img/status-20.png" />
            </td>
        `;
        } else if (window.meters[m].status == "10") {
            meterOutput += `
            <td>
            <img src="../../img/status-10.png" />
            </td>
        `;
        } else {
            meterOutput += `
            <td>
            <img src="../../img/status-0.png" />
            </td>
        `;
        }

        // Add timestamp
        meterOutput += `<td>${window.meters[m].timestamp}</td>`;

        // Add the description
        meterOutput += `<td>${window.meters[m].description}</td>`;

        // Add the wireless svg
        if (window.meters[m].key == "") {
            meterOutput += `<td><div class="icon original key"></div></td>`;
        }
        else {
            meterOutput += `<td><div class="icon colored key"></div></td>`;
        }

        // Edit button
        meterOutput += `<td class="cb" onclick="editMeter(${window.meters[m].order}, 'false');" >
                        <div class="icon original edit"></td>`;

        // Add the remove button
        meterOutput += `<td class="cb" onclick="changeColor('${window.meters[m].order}');" >
    <div
        class="icon original trash-alt"
        name="STAY"
        id="${window.meters[m].order}"
        >
    </div></td>`;

        meterOutput += "</tr>"
    }
    document.getElementById("meterDiv").innerHTML = meterOutput;
}

window.dupSet = {};

const getOptions = {
    credentials: "include",
    method: 'GET',
    headers: {
        'Content-Type': 'application/json'
    },
};
const removeMeters = {
    credentials: "include",
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    },
};
const addSingleMeterHeader = {
    credentials: "include",
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    }
};
const statusReq = {
    credentials: "include",
    method: 'GET',
    headers: {
        'Content-Type': 'application/json'
    },
};

const statusRequest = new Request("/get_status", statusReq);
const myRequest = new Request("/meterlist", getOptions);
const addWirelessRequest = new Request("/add_wireless", getOptions);
const addWiredRequest = new Request("/merge_search_files", getOptions);
const addSingleMeterRequest = new Request("/add_single_meter", addSingleMeterHeader);
const removeMeterRequest = new Request("/removeMeters", removeMeters);
const verifyMeterlistRequest = new Request("/verify_meterlist", getOptions);
const readMeterlistRequest = new Request("/read_meterlist", getOptions);
//const autoCreateMyConfigRequest = new Request("/auto_template_generator", autoCreateMyConfigHeader);

function addEditMeterContent(meterToEdit, modalContent) {
    let editMeterContainer = document.createElement("div");
    editMeterContainer.id = "edit-meter-container";

    let table = document.createElement("table");
    table.classList.add("edit-table");

    let tableOutput = `<colgroup>
                    <col span="1" style="width: 20%;">
                    <col span="1" style="width: 80%;">
                </colgroup>`;
    tableOutput += `<tbody>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">ID:</span>
                </td>
                <td>
                    <input class="edit-input" style="width:100%;" id="id-input-value" value="${meterToEdit.id}" onkeyup="checkInput(this,8,'numeric', 'id-input-info-text')"></input>
                    <span id="id-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">Manufacturer:</span>
                </td>

                <td>    
                    <input class="edit-input" id="mfct-input-value" value="${meterToEdit.mfct}" onkeyup="checkInput(this,4,'hexadecimal', 'mfct-input-info-text')"></input>
                    <span id="mfct-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">Version:</span>
                </td>

                <td>    
                    <input class="edit-input" id="ver-input-value" value="${meterToEdit.ver}" onkeyup="checkInput(this,2,'hexadecimal', 'ver-input-info-text')"></input>
                    <span id="ver-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">Medium:</span>
                </td>

                <td>    
                    <input class="edit-input" id="med-input-value" value="${meterToEdit.med}" onkeyup="checkInput(this,2,'hexadecimal', 'med-input-info-text')"></input>
                    <span id="med-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">Wireless-key:</span>
                </td>

                <td>    
                    <input class="edit-input" id="wl-key-input-value" value="${meterToEdit.key}" onkeyup="checkInput(this,32,'hexadecimal', 'wl-key-input-info-text')"></input>
                    <span id="wl-key-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `<tr>
                <td>
                    <span class="edit-meter-text">Description:</span>
                </td>
                <td>
                    <input class="edit-input" id="description-input-value" value="${meterToEdit.description}" onkeyup="checkInput(this,50,'allLetters', 'description-input-info-text')"></input>
                    <span id="description-input-info-text"></span>
                </td>
                </tr>`;

    tableOutput += `</tbody>`;
    table.innerHTML = tableOutput;
    editMeterContainer.appendChild(table);
    modalContent.appendChild(editMeterContainer);
}

function checkInput(object, length, style, info_id) {
    var regx = new RegExp("^[\x21-\x7E]+$");
    var hex_reg = new RegExp("^[A-Fa-f0-9]+$");
    var regx2 = new RegExp(/\s+/);
    var comma_reg = new RegExp("[,;]+");
    // Check if input is alphanumeric
    var isDesc = true ? regx.test(object.value) : false;
    var isComma = true ? comma_reg.test(object.value) : false;
    var isHex = true ? hex_reg.test(object.value) : false;
    var spaces = true ? regx2.test(object.value) : false;

    if (object.value.length > 0 && isNaN(object.value) && style == "numeric") {
        document.getElementById(info_id).innerHTML = "Input is not numeric";
        object.classList.add("error-border");
    } else if (object.value.length > length) {
        document.getElementById(info_id).innerHTML = `Max length is ${length}`;
        object.classList.add("error-border");
    } else if (object.value.length > 0 && style == "hexadecimal" && !isHex) {
        document.getElementById(info_id).innerHTML = "Input is not hexadecimal";
        object.classList.add("error-border");
    } else if (style == "allLetters" && spaces) {
        document.getElementById(info_id).innerHTML = "No spaces are allowed";
        object.classList.add("error-border");
    } else if (style == "allLetters" && isComma) {
        document.getElementById(info_id).innerHTML = "No , or ; allowed";
        object.classList.add("error-border");
    } else if (object.value.length > 0 && style == "allLetters" && !isDesc) {
        document.getElementById(info_id).innerHTML = "Input is not ASCII. Will be converted to ASCII in conf. file";
        object.classList.add("error-border");
    } else {
        document.getElementById(info_id).innerHTML = "";
        object.classList.remove("error-border");
    }
}

async function addInternalMeter() {
    const res = await fetch("/api/v1/meters/add/internal", {
        method: 'POST',
        credentials: 'include'
    })

    const icondiv = document.getElementById('add-internal-meter-icon')
    icondiv.classList.remove("plus-square");
    icondiv.classList.remove("original-color");
    icondiv.classList.add("button-loader");

    if (res.ok) {
        const json = await res.json()
        window.running = json["running"]
        window.status = json["status"]
        window.functionDidStart = json["functionDidStart"]

        setTimeout(() => {
            
            window.loadMeterlist();
            icondiv.classList.remove('button-loader')
            icondiv.classList.add("plus-square");
            icondiv.classList.add("original-color");
        }, 3000, [])
        
    } else {
        console.error("internal meter add failure")
    }
}

function editMeter(meterOrderNr, newMeter) {
    let meterToEdit = {};
    if (newMeter == 'true') {
        meterToEdit = {
            "id": "",
            "mfct": "",
            "ver": "",
            "med": "",
            "key": "",
            "description": "",
        }
    } else {
        meterToEdit = window.meters.find((currentValue, index, arr) => {
            return currentValue ? currentValue.order === meterOrderNr : null;
        });
    }
    if (document.getElementById("edit-meter-container") != null) {
        document.getElementById("edit-meter-container").remove();
    }

    // Adds the meter parameter table content
    let modalContent = document.getElementById("modal-content");
    addEditMeterContent(meterToEdit, modalContent);

    if (document.getElementById("save-edit-meter") != null) {
        document.getElementById("save-edit-meter").remove();
    }
    // Add the save edit button
    let saveEditButton = document.createElement("button");
    saveEditButton.id = "save-edit-meter";
    saveEditButton.classList.add("save-edit-button");
    saveEditButton.innerHTML = "Save";
    if (document.getElementById("response-text") != null) {
        document.getElementById("response-text").remove();
    }
    var responseText = document.createElement("span");
    responseText.id = "response-text";

    meterToEdit.newMeter = newMeter;
    saveEditButton.onclick = () => {
        let idInput = document.getElementById("id-input-value").value;
        meterToEdit.id = idInput;
        let mfctInput = document.getElementById("mfct-input-value").value;
        meterToEdit.mfct = mfctInput.toUpperCase();
        let verInput = document.getElementById("ver-input-value").value;
        meterToEdit.ver = verInput.toUpperCase();
        let medInput = document.getElementById("med-input-value").value;
        meterToEdit.med = medInput.toUpperCase();
        let wlKetInput = document.getElementById("wl-key-input-value").value;
        meterToEdit.key = wlKetInput;
        let descriptionInput = document.getElementById("description-input-value").value;
        meterToEdit.description = descriptionInput;
        fetch("/edit_meter", {
            credentials: "include",
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify(meterToEdit, newMeter)
        })
            .then(response => response.json())
            .then(json => {
                //console.log("edit-response", json["content"]);
                if (json["content"].key == "incorrect") {
                    responseText.innerHTML = "Incorrect wl-key input"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].key == "not_utf8") {
                    responseText.innerHTML = "Wl-key input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].description == "incorrect") {
                    responseText.innerHTML = "Incorrect description input";
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].description == "not_utf8") {
                    responseText.innerHTML = "Description input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].id == "incorrect") {
                    responseText.innerHTML = "Incorrect id input"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].id == "not_utf8") {
                    responseText.innerHTML = "Id input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].mfct == "incorrect") {
                    responseText.innerHTML = "Incorrect manufacturer input"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].mfct == "not_utf8") {
                    responseText.innerHTML = "Manufacturer input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].ver == "incorrect") {
                    responseText.innerHTML = "Incorrect version input"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].ver == "not_utf8") {
                    responseText.innerHTML = "Version input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].med == "incorrect") {
                    responseText.innerHTML = "Incorrect medium input"
                    responseText.classList.add("response-text", "fail-bg-color");
                } else if (json["content"].med == "not_utf8") {
                    responseText.innerHTML = "Medium input is not utf-8"
                    responseText.classList.add("response-text", "fail-bg-color");
                }

                // If a new meter have been added
                else if (json["content"].newMeter == "true") {
                    window.running = json["running"]
                    window.status = json["status"]
                    window.functionDidStart = json["functionDidStart"]
                    if (window.functionDidStart) {
                        var autoCreateIcon = document.getElementById("add-single-meter-icon");
                        autoCreateIcon.classList.remove("plus-square");
                        autoCreateIcon.classList.remove("original-color");
                        autoCreateIcon.classList.add("button-loader");
                    }
                    if (window.running) {
                        setTimeout(function () { fetchStatus(false, statusRequest); }, 4000);
                        editModal.style.display = "none";
                    } else {
                        editModal.style.display = "none";
                        window.loadMeterlist();
                    }

                } else {
                    loadMeterlist();
                    editModal.style.display = "none";
                }
            })

    }
    modalContent.appendChild(saveEditButton);
    modalContent.appendChild(responseText);

    let close = document.getElementById("modal-close");
    editModal.style.display = "block";
    close.onclick = () => {
        editModal.style.display = "none";
    }
}
let editModal = document.getElementById("edit-modal");

function commitMeterlist() {
    window.addLoader();
    var sendMeters = [];
    for (const [key, value] of Object.entries(window.removeMeters)) {
        //console.log("key", key, "value", value)
        sendMeters.push(key);
    }
    window.removeMeters = {};

    fetch("/remove_meters", {
        credentials: "include",
        method: 'post',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(sendMeters)
    })
        .then(function (response) {
            return response.json();
        })
        .then(function (json) {
            console.log("remmove meters response:", json)
            window.fetchedMeters = json[0];
            window.meters = json[0];
            window.duplicate_entries = json[1];
            const meterInfo = json[2];
            for (var i = 0; i < window.meters.length; i++) {
                window.meters[i].order = i;
            }

            window.setMinHeight();

            window.dupSet = {}
            for (n in window.duplicate_entries) {
                var dupAddr = `${window.duplicate_entries[n][0]}.${window.duplicate_entries[n][1]}.${window.duplicate_entries[n][2]}.${window.duplicate_entries[n][3]}`;
                for (m in window.meters) {
                    var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
                    if (dupAddr == secAddr) {
                        window.dupSet[window.meters[m].order] = true;
                    }
                }
            }
            printMeterInfo(meterInfo);
            printDuplicates();

            window.printMeterlist();
            document.getElementById("list-loader").remove();
            document.getElementById("search-progress").remove();
            const keys = Object.keys(localStorage.csvDict);
        })
        .catch(function (err) {
            console.log("Fetch problem: " + err.message)
        })
};

function addLoader() {
    if (document.getElementById("list-loader") == null) {
        var loaderDiv = document.getElementById("loaderDiv");
        var loader = document.createElement("div");
        loader.id = "list-loader";
        loader.classList.add("loader");

        var h2 = document.createElement("h2");
        h2.id = "search-progress";
        h2.classList.add("search-progress");
        h2.innerHTML = "Loading Meterlist...";
        loaderDiv.appendChild(loader);
        loaderDiv.appendChild(h2);
    }
}

function fetchRoute3(request, id) {
    
    fetch(request)
        .then(response => response.json())
        .then(json => {
            window.running = json[0]
            window.status = json[1]
            window.functionDidStart = json[2]
            if (window.functionDidStart) {
                var autoCreateIcon = document.getElementById(id);
                autoCreateIcon.classList.remove("play-circle");
                autoCreateIcon.classList.remove("original-color");
                autoCreateIcon.classList.add("button-loader");
            }

            if (window.running) {
                setTimeout(function () { fetchStatus(false, statusRequest); }, 4000);
            } else {
                loadMeterlist();
            }
        })
        .catch(err =>
            console.log("Fetch problem: " + err.message));
}

function autoCreateMyConfig() {
    const number_of_telegrams = document.getElementById("number_of_telegrams").value
    const max_value_age = 60
    fetch(`/auto_create_myconfig?number_of_telegrams=${number_of_telegrams}&max_value_age=${max_value_age}`, {
        credentials: "include",
        method: "GET",
        headers: {
            "Content-Type": "application/json"
        },
    })
        .then(response => response.json())
        .then(json => {
            window.running = json["running"]
            window.status = json["status"]
            window.functionDidStart = json["functionDidStart"]
            if (window.functionDidStart) {
                var autoCreateIcon = document.getElementById("auto-create-icon");
                autoCreateIcon.classList.remove("play-circle");
                autoCreateIcon.classList.remove("original-color");
                autoCreateIcon.classList.add("button-loader");
            }
            fetchStatus(false, statusRequest);
        })
        .catch(err =>
            console.log("Fetch problem: " + err.message));
}

function addWireless() {
    fetchRoute3(addWirelessRequest, "add-wireless-icon");
}

function addWired() {
    fetchRoute3(addWiredRequest, "add-wired-icon");
}

function verifyMeterlist() {
    var idElement = document.getElementById("verify-meterlist");
    var idText = document.getElementById("verify-meterlist-text");
    idText.innerHTML = "Stop verification";
    idElement.removeEventListener("click", verifyMeterlist);
    idElement.addEventListener("click", stopVerification);
    fetchRoute3(verifyMeterlistRequest, "verify-meters-icon");
}

function readMeterlist() {
    var idElement = document.getElementById("read-meterlist");
    var idText = document.getElementById("read-meterlist-text");
    idText.innerHTML = "Stop reading";
    idElement.removeEventListener("click", readMeterlist);
    idElement.addEventListener("click", stopReading);
    fetchRoute3(readMeterlistRequest, "read-meters-icon")
}

function stopVerification() {
    var idElement = document.getElementById("verify-meterlist");
    var idText = document.getElementById("verify-meterlist-text");
    idText.innerHTML = "Test unverified meters";
    idElement.removeEventListener("click", stopVerification);
    idElement.addEventListener("click", verifyMeterlist);
    fetch("/stop_secondary_search", statusReq)
        .then(response => response.json())
        .then(json => {
            var running = json[0];
            var status = json[1];
            console.log("stop verification");
        })
        .catch(err => {
            console.log("err", err.message);
        })
}

function stopReading() {
    var idElement = document.getElementById("read-meterlist");
    var idText = document.getElementById("read-meterlist-text");
    idText.innerHTML = "Read all meters";
    idElement.removeEventListener("click", stopReading);
    idElement.addEventListener("click", readMeterlist);
    fetch("/stop_secondary_search", statusReq)
        .then(response => response.json())
        .then(json => {
            var running = json[0];
            var status = json[1];
            console.log("stop verification");
        })
        .catch(err => {
            console.log("err", err.message);
        })
}

function setIcon(function_, id) {
    if (window.whichFunctionRuns == function_) {
        var id = document.getElementById(id);
        id.classList.add("button-loader");
    } else {
        var id = document.getElementById(id);
        id.classList.add("original-color");
        if (function_ != "add_single_meter") {
            id.classList.add("play-circle");
        } else {
            id.classList.add("plus-square");
        }
    }
}

function populateEventListeners(whichFunctionRuns, id, function_) {
    if (whichFunctionRuns == function_) {
        var idElement = document.getElementById(id);
        var idText = document.getElementById(id + "-text");
        if (function_ == "verify-meterlist") {
            console.log("in verify meterlist if");
            idText.innerHTML = "Stop verification";
            idElement.removeEventListener("click", verifyMeterlist);
            idElement.addEventListener("click", stopVerification);
        }
        if (id == "read-meterlist") {
            idText.innerHTML = "Stop reading";
            idElement.removeEventListener("click", readMeterlist);
            idElement.addEventListener("click", stopReading);
        }

    } else {
        var idElement = document.getElementById(id);
        if (function_ == "verify_meterlist") {
            var idText = document.getElementById(id + "-text");
            idText.innerHTML = "Test unverified meters";
            idElement.addEventListener("click", verifyMeterlist);
        }
        if (function_ == "read_meterlist") {
            var idText = document.getElementById(id + "-text");
            idText.innerHTML = "Read all meters";
            idElement.addEventListener("click", readMeterlist);
        }
    }
}

function fetchStatus(loadingPage, statusRequest) {
    fetch("/get_status", statusRequest)
        .then(response => response.json())
        .then(json => {
            window.status = json["status"];
            window.running = json["running"];
            window.whichFunctionRuns = json["whichFunctionRuns"]
            console.log("whichFunctionRuns", window.whichFunctionRuns)
            if (loadingPage) {
                setIcon("verify_meterlist", "verify-meters-icon");
                setIcon("read_meterlist", "read-meters-icon");
                setIcon("add_wired", "add-wired-icon");
                setIcon("add_wireless", "add-wireless-icon");
                setIcon("auto_create_myconfig", "auto-create-icon");
                setIcon("pdf_icon", "pdf-icon");
                setIcon("add_single_meter", "add-single-meter-icon");
                populateEventListeners(window.whichFunctionRuns, "verify-meterlist", "verify_meterlist");
                populateEventListeners(window.whichFunctionRuns, "read-meterlist", "read_meterlist");
            }
            if (window.running && !loadingPage) {
                setTimeout(function () { fetchStatus(false, statusRequest); }, 4000);
            } else if (!window.running && !loadingPage) {
                var loaders = document.getElementsByClassName("button-loader");
                if (loaders.length != 0) {
                    var elementsWithLoader = document.getElementsByClassName("button-loader");
                    elementsWithLoader[0].classList.add("original-color");
                    if (elementsWithLoader.item(0).id == "add-single-meter-icon") {
                        elementsWithLoader[0].classList.add("plus-square");
                    } else {
                        elementsWithLoader[0].classList.add("play-circle");
                    }
                    elementsWithLoader[0].classList.remove("button-loader");
                }
                populateEventListeners(window.whichFunctionRuns, "verify-meterlist", "verify_meterlist");
                populateEventListeners(window.whichFunctionRuns, "read-meterlist", "read_meterlist");
                loadMeterlist();
            } else if (window.running && loadingPage) {
                loadMeterlist();
            } else if (!window.running && loadingPage) {
                loadMeterlist();
            }

        })
        .catch(err =>
            console.log("error in fetch " + err.message)
        )
}



function loadMeterlist() {
    window.addLoader();

    fetch(myRequest)
        .then(function (response) {
            return response.json();
        })
        .then(function (json) {
            window.fetchedMeters = json["data"];
            console.log("json data", window.fetchedMeters);
            window.meters = window.fetchedMeters;
            window.duplicate_entries = json["duplicate_entries"];
            window.running = json["running"];
            window.status = json["status"];
            window.search_result = json["search_result"];
            const meters = json["meters"];
            for (var i = 0; i < window.meters.length; i++) {

                window.meters[i].order = i;
            }

            window.setMinHeight();

            window.dupSet = {}
            for (n in window.duplicate_entries) {
                var dupAddr = `${window.duplicate_entries[n][0]}.${window.duplicate_entries[n][1]}.${window.duplicate_entries[n][2]}.${window.duplicate_entries[n][3]}`;
                for (m in window.meters) {
                    var secAddr = `${window.meters[m].id}.${window.meters[m].mfct}.${window.meters[m].ver}.${window.meters[m].med}`;
                    if (dupAddr == secAddr) {
                        window.dupSet[window.meters[m].order] = true;
                    }
                }
            }

            printMeterInfo(meters);
            printDuplicates();

            window.printMeterlist();
            document.getElementById("list-loader").remove();
            document.getElementById("search-progress").remove();
            const keys = Object.keys(localStorage.csvDict);

            if (window.running) {
                setTimeout(function () { fetchStatus(false, statusRequest); }, 4000);
            }
        })
        .catch(function (err) {
            console.log("Fetch problem: " + err.message)
        });
};

function printMeterInfo(meters) {
    document.getElementById("meters-numMeters").innerHTML = meters["numMeters"];
    document.getElementById("meters-verified").innerHTML = `${meters["verified"]}/${meters["numMeters"]}`;
    document.getElementById("meters-wired").innerHTML = `${meters["wired"]}/${meters["numMeters"]}`;
    document.getElementById("meters-wireless").innerHTML = `${meters["wireless"]}/${meters["numMeters"]}`;
    document.getElementById("meters-nodes").innerHTML = `${meters["nodes"]}/${meters["numMeters"]}`;
    document.getElementById("meters-han").innerHTML = `${meters["han"]}/${meters["numMeters"]}`;
}

function printDuplicates() {
    if (document.getElementById("duplicate-container") != null) {
        document.getElementById("duplicate-container").remove();
    }
    if (window.duplicate_entries.length > 0) {
        const duplicateInfoDiv = document.getElementById("duplicate-info-div");
        let duplicateContainer = document.createElement("div");
        duplicateContainer.id = "duplicate-container";
        duplicateContainer.classList.add("fail");
        let h3 = document.createElement("h3");
        h3.innerHTML = "Please remove the duplicates from your meterlist:";
        duplicateContainer.appendChild(h3);
        let duplicateList = document.createElement("ul");
        duplicateList.style.listStyle = "none";
        for (m in window.duplicate_entries) {
            let li = document.createElement("li");
            const secAddr = `${window.duplicate_entries[m][0]}.${window.duplicate_entries[m][1]}.${window.duplicate_entries[m][2]}.${window.duplicate_entries[m][3]}`;
            li.innerHTML = secAddr;
            duplicateList.appendChild(li);
        }
        duplicateContainer.appendChild(duplicateList);
        duplicateInfoDiv.appendChild(duplicateContainer);
    }
}


// To avoid the screen to jump when making a meterlist search
// The min-height is set to a div around the table
function setMinHeight() {
    var headHeight = 78;
    var tdHeight = 57;
    var minimumH = 78 + tdHeight * window.meters.length;
    document.getElementById("min-height-div").style.minHeight = minimumH.toString() + "px";
};

////////////////////////////////////////////
//             Sort functions             //
////////////////////////////////////////////

// Used to toggle the sorting order when pressing the id-number header text
var order = true;

// Sort the array on number for id-number and primary address
function sortByProperty(property) {
    if (window.order) {
        return function (a, b) {
            if (a[property] < b[property]) {
                return 1;
            } else if (a[property] > b[property]) {
                return -1;
            }
            return 0;
        }
    } else {
        return function (a, b) {
            if (a[property] > b[property]) {
                return 1;
            } else if (a[property] < b[property]) {
                return -1;
            }
            return 0;
        }
    }
}

function sortThis(property) {
    window.meters.sort(window.sortByProperty(property));

    // Toggle the sorting order
    window.order = !window.order;

    // Print the meterlist
    window.printMeterlist();
}

window.removeMeters = {};
// Toggle function to toggle between ON/OFF for each Mbus object and the statusbyte
function changeColor(cbox) {
    var trash = document.getElementById(cbox);
    var name = trash.getAttribute("name");
    if (name == "STAY") {
        document.getElementById(cbox + "-row").style.backgroundColor = "rgba(255,148,120,0.2)";
        trash.setAttribute("name", "REMOVE");
        trash.classList.toggle("original", false);
        trash.classList.toggle("colored", true);
        window.removeMeters[cbox] = true;
    } else {
        if (cbox % 2 == 0) {
            document.getElementById(cbox + "-row").style.backgroundColor = "white";
        } else {
            document.getElementById(cbox + "-row").style.backgroundColor = "rgb(242,242,242)";
        }
        trash.setAttribute("name", "STAY");
        trash.classList.toggle("original", true);
        trash.classList.toggle("colored", false);
        delete window.removeMeters[cbox];
    }
}

///////////////////////////////////////////

function downloadTemplate() {
    window.location = "/downloadCsvFile?FILE=meterlist_template.csv";
}

function downloadEncryptionTemplate() {
    window.location = "/downloadCsvFile?FILE=encryption_keys_template.csv";
}

function downloadEncryptionKeys() {
    window.location = "/downloadEncryptionKeys?FILE=encryption_keys.txt";
}

function uploadMeterList() {
    closeUploadModal()
    const fileName = document.getElementById("meterlistfile").value;

    if ((!fileName.endsWith('.csv')) && (!fileName.endsWith('.txt'))) {
        alert(fileName + ' is not a valid filename, the name must end with .csv or .txt');
        return;
    }
    const meterlistfile = document.getElementById("meterlistfile").files[0];
    const encoding = document.getElementById("csvEncodingSelect").value;
    const separator = document.getElementById("csvDelimiterSelect").value;

    let formData = new FormData();

    var upload_div = document.getElementById("upload-meterlist");
    upload_div.innerHTML = "Uploading..";
    upload_div.classList.add("upload-meterlist");
    formData.append("meterlistfile", meterlistfile);
    formData.append("encoding", encoding);
    formData.append("separator", separator);
    for (const p of formData) {
        console.log("form param", p);
    }
    fetch('/upload_meterlist', {
        credentials: "include",
        method: "POST",
        body: formData
    })
        .then(response => response.json())
        .then(json => {
            if (json["responseText"] == "ok") {
                document.getElementById("meterlistfile").files[0] = null;
                document.getElementById("meterlistfile").value = null;
                loadMeterlist();
                upload_div.innerHTML = "Upload meterlist";
                upload_div.classList.remove("upload-meterlist");
            }
        })
        .catch(err =>
            console.log("error in fetch " + err.message)
        )
}

function saveMeterFile() {
    if (window.confirm('You are about to overwrite the saved file /config/meterlist.csv. Are You Sure?')) {
        window.location = "/copy_file_to_config?FILE=meterlist.csv";
    }
}
function removeMeterList() {
    if (window.confirm('You are about to remove the meterlist. Are You Sure?')) {
        window.location = "/remove_file?FILE=meterlist.csv";
    }
}

function downloadCsvFile() {
    window.location = "/downloadCsvFile?FILE=meterlist.csv";
}

function copyMeterlist() {
    if (window.confirm('You are about to overwrite the saved file /tmp/meterlist.csv. Are You Sure?')) {
        window.location = "/copyFromConfig"
    }
}
function startup_manual(input) {
    var hashTag = input;
    window.location = "/startup_manual?HASHTAG=" + hashTag;
}

function controlInput() {
    var idInput = document.getElementById("id-number-input").value;
    var input_bg = document.getElementById("id-number-input-bg");
    var input_error_td = document.getElementById("id-number-input-error");
    if (document.body.contains(document.getElementById("id-number-input-error-text"))) {
        document.getElementById("id-number-input-error-text").remove();
    }
    if (isNaN(idInput)) {

        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", true);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        var errorText = document.createElement("p");
        errorText.classList.toggle("fail-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Only digits allowed!";
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }

    }
    else if (idInput.length > 8 || isNaN(idInput)) {
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", true);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        var errorText = document.createElement("p");
        errorText.classList.toggle("fail-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Only 8 digits allowed!"
        //console.log("nr childNodes", input_error_td.childNodes.length );
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }
    }
    else if (idInput.length < 8 && !isNaN(idInput)) {
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", false);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", false);
        if (document.body.contains(document.getElementById("id-number-input-error-text"))) {
            document.getElementById("id-number-input-error-text").remove();
        }
    }
    else if (idInput.length == 8 && !isNaN(idInput)) {
        document.getElementById("id-number-input-bg").classList.toggle("remove-bg-color", false);
        document.getElementById("id-number-input-bg").classList.toggle("add-bg-color", true);
        var errorText = document.createElement("p");
        errorText.classList.toggle("success-text", true);
        errorText.id = ("id-number-input-error-text");
        errorText.innerHTML = "Correct input!";
        if (!document.body.contains(document.getElementById("id-number-input-error-text"))) {
            input_error_td.appendChild(errorText);
        }
    }

}

function verifySingleMeter() {
    var idInput = document.getElementById("id-number-input").value;
    if (idInput.length == 8 && !isNaN(idInput)) {
        window.location = "/addSingelMeter?IDINPUT=" + idInput;
    }
}

function showCsvFile() {
    var select = document.getElementById("show-config-file");
    var val = select.value;
    window.open("/show_csv_file?FILE=" + val);
}

function uploadEncryptionKeys() {
    var encrypt_input = document.getElementById("upload-encryption-key-input").files[0];
    if ((!encrypt_input.name.endsWith('.csv')) && (!encrypt_input.name.endsWith('.txt'))) {
        alert(encrypt_input.name + ' is not a valid filename, the name must end with .csv or .txt');
        return;
    }
    var upload_div = document.getElementById("upload-encryption-keys");
    upload_div.innerHTML = "Uploading..";
    upload_div.classList.add("upload-meterlist");

    let formData = new FormData();
    formData.append("upload-encryption-keys_file", encrypt_input);
    fetch("/upload_encryption_keys", {
        credentials: "include",
        method: "POST",
        body: formData
    })
        .then(function (response) {
            return response.json();
        })
        .then(function (json) {
            window.encrypt_errorlist = json[0];
            var errorlist_div = document.getElementById("upload-encryption-keys-errorlist");
            if (window.encrypt_errorlist[0] != "NO_ERROR") {
                errorlist_div.classList.toggle("fail", true);
                for (var i = 0; i < window.encrypt_errorlist.length; i++) {
                    var p = document.createElement("p");
                    var row = document.createTextNode(window.encrypt_errorlist[i].id + ";" + window.encrypt_errorlist[i].key);
                    p.appendChild(row);
                    errorlist_div.appendChild(p);
                }
            }

            document.getElementById("upload-encryption-key-input").files[0] = null;
            document.getElementById("upload-encryption-key-input").value = null;
            window.loadMeterlist();
            upload_div.innerHTML = "Upload encryption keys";
            upload_div.classList.remove("upload-meterlist");
        })
        .catch(function (err) {
            console.log("Fetch problem: " + err.message)
        })
}

function createPDF() {
    var protocols = "";
    var serialno = "";
    var mac = "";
    var network = [];
    var header = "";
    fetch("/get_pdf_data", {
        credentials: "include",
        method: "GET",
    })
        .then(response => { return response.json() })
        .then(json => {
            console.log("hello");
            protocols = json["protocols"];
            serialno = json["serialno"];
            mac = json["mac"];
            network = json["network"];
            header = json["header"];
            console.log("serialno", serialno);
            console.log("protocols", protocols);
            console.log("mac", mac);
            console.log("network", network);
            console.log("header", header);
            //var sTable = document.getElementById('tab').innerHTML;
            var meterlist = window.meters;
            var sTable = printPdfTable(meterlist);

            var style = "<style>";
            style = style + "table {width: 100%;font: 10px Calibri;}";
            style = style + "table, th, td {border: solid 1px #DDD; border-collapse: collapse;";
            style = style + "padding: 2px 2px;text-align: left;}";
            style = style + "</style>";

            // CREATE A WINDOW OBJECT.
            var win = window.open('', '', 'height=700,width=700');
            if (header != "") {
                header = '<div><span class="piigab-text">Project Name: </span>' + header + '</div>';
            }
            serialno = '<div><span class="piigab-text">Unit</span>: ' + serialno + '</div>';
            var licenses = "<div><span class='piigab-text'>Licenses: </span>";
            for (var i = 0; i < protocols.length; i++) {
                protocols[i] = protocols[i].replace(/^\s+|\s+$/g, '');
                if (protocols[i] != "-" && protocols[i] != "") {
                    licenses += protocols[i] + " ";
                }
            }
            licenses += "</div>";
            mac = '<div><span class="piigab-text">Mac: </span>' + mac + '</div>';
            var net_output = '<div><span class="piigab-text">Network: </span>';
            net_output += network[0] + " ";
            if (network[1] == "dhcp") {
                net_output += "Dynamic";
                net_output += "</div>";
            } else {
                net_output += "<span class='piigab-text'>Static </span>";
                net_output += "<span class='piigab-text'>Address: </span>" + network[2] + " ";
                net_output += "<span class='piigab-text'>Netmask: </span>" + network[3] + " ";
                net_output += "<span class='piigab-text'>Gateway: </span>" + network[4];
                net_output += "</div>";
            }

            var numberOfMeters = "<div><span class='piigab-text'>Number of meters: </span>" + meters.length + "</div>";
            console.log(serialno);

            var string = "<div class='pdf-image'><img src='../../img/piigab.png' height='30' /></div>";
            win.document.write('<html><head>');
            win.document.write('<link rel="stylesheet" type="text/css" href="/css/style.css">');
            win.document.write('<title>Project report</title>');   // <title> FOR PDF HEADER.
            win.document.write(style);          // ADD STYLE INSIDE THE HEAD TAG.
            win.document.write('</head>');
            win.document.write('<body class="size-14" onload="window.print()">');
            win.document.write('<div></div>');
            win.document.write(string);
            if (header != "") {
                win.document.write(header);
            }
            win.document.write(serialno);
            win.document.write(mac);
            win.document.write(net_output);
            win.document.write(licenses);
            win.document.write(numberOfMeters);
            win.document.write('<br />');
            win.document.write(sTable);         // THE TABLE CONTENTS INSIDE THE BODY TAG.
            win.document.write('</body>');
            win.document.write('</html>');

            win.document.close(); 	// CLOSE THE CURRENT WINDOW.

            //win.print();    // PRINT THE CONTENTS.
        })
        .catch(err =>
            console.log("Function error: " + err.message)

        )
}

function printPdfTable(meters) {
    var meterOutput = "";
    meterOutput += "<div></div>";
    meterOutput += `
<table class="size-10">
    <tr>
        <th>#</th>
        <th>Type</th>
        <th>Ident. nr</th>
        <th>Medium</th>
        <th>Manufacturer</th>
        <th>Prim</th>
        <th>Verified</th>
        <th>Last read</th>
        <th>Description</th>
    </tr>
    <tbody>`;



    for (m in meters) {
        var secAddr = `${meters[m].id}.${meters[m].mfct}.${meters[m].ver}.${meters[m].med}`;
        if (meters[m].fab) {
            secAddr += ":" + meters[m].fab;
        }
        //console.log("has", window.dupSet.hasOwnProperty(secAddr));
        if (window.dupSet.hasOwnProperty(meters[m].order)) {
            meterOutput += `<tr id='${meters[m].order}-row' class='fail-bg-color'>`;
        } else {
            meterOutput += `<tr id='${meters[m].order}-row'>`;
        }
        meterOutput += `<td>${parseInt(m) + 1}</td>`;

        if (meters[m].type == "R") {
            meterOutput += `<td>Wireless</td>`;
        } else if (meters[m].type == "N") {
            meterOutput += `<td>Node</td>`;
        } else if (meters[m].type == "W") {
            meterOutput += `<td>Wired</td>`;
        } else {
            meterOutput += "<td></td>";
        }

        meterOutput += `
        <td class="piigab-ok-text">
        ${meters[m].id}
        </td>`;

        // Add the device desciprtion from DeviceTypes
        if (window.DeviceTypes.hasOwnProperty(meters[m].med)) {
            meterOutput += `
            <td>
            ${window.DeviceTypes[meters[m].med]}
            </td>
        `;
        } else {
            meterOutput += `
            <td>
            ${meters[m].med}
            </td>
        `;
        }

        // Add manufacturer names from the csvDict. The manufacturer string eg(KAM) is used to get the 
        // manufacturer description eg(Kamstrup Energi A/S)
        if (window.csvDict.hasOwnProperty(meters[m].mfct_str)) {
            meterOutput += `
            <td>
            ${window.csvDict[meters[m].mfct_str]}
            </td>
        `;
        } else {
            meterOutput += `
            <td>
            ${meters[m].mfct_str}
            </td>
        `;
        }

        // Add the prim number
        if (meters[m].prim) {
            meterOutput += `
            <td>
            ${meters[m].prim}
            </td>
        `;
        } else {
            meterOutput += "<td></td>";
        }

        // Add the verification status image
        if (meters[m].status == "20" || meters[m].status == "Ver") {
            meterOutput += `
            <td class="piigab-ok-text">
            OK
            </td>
        `;
        } else if (meters[m].status == "10") {
            meterOutput += `
            <td class="piigab-text">
            OLD
            </td>
        `;
        } else {
            meterOutput += `
            <td class="piigab-text">
            NOT OK
            </td>
        `;
        }

        // Add timestamp
        meterOutput += `<td>${meters[m].timestamp}</td>`;

        // Add the description
        meterOutput += `<td>${meters[m].description}</td>`;

        meterOutput += "</tr>";
    }
    meterOutput += "</tbody></table>";
    return meterOutput;
}

fetchStatus(true, statusRequest);
