
let intervalNum = -1
const AUTO_UPDATE_STATUS = "auto-update-status";

const stopLoop = () => {
    clearInterval(intervalNum)
    intervalNum = -1
    localStorage.setItem(AUTO_UPDATE_STATUS,'false')
}
const startLoop = () => {
    
    if (intervalNum !== -1) {
        stopLoop()
    }
    localStorage.setItem(AUTO_UPDATE_STATUS,'true')
    intervalNum = setInterval(fetchRoute, 5000)

    document.getElementById('status-auto-update-on').checked = true
}



const onAutoUpdateChanged = (e) => {
    const value = document.querySelector('input[name="status-radio"]:checked').value
    console.log(value)
    if (value === "on") {
        console.log("starting auto update")
        startLoop()
    }
    else {
        console.log("stopping auto update")
        stopLoop()
    }
}


function foldOut() {
    document.getElementById("myDropdown").classList.toggle("show")
}

function foldOut2() {
    document.getElementById("myDropdown2").classList.toggle("show2")
}


const fetchRoute = async () => {
    let statusRequest = new Request("/menu_status", {
        credentials: "include",
        method: 'GET',
        headers: {
            'Content-Type': 'application/json'
        },
    });
    try {
        const response = await fetch(statusRequest)
        const json = await response.json()

        window.error_message = json["error_message"];
        window.mbusCurrentString = json["mbusCurrentString"];
        window.mbusMaxCurrentString = json["mbusMaxCurrentString"];
        window.mbusCurrentPercentUsed = json["mbusCurrentPercentUsed"];
        window.board_temperature = json["board_temperature"];
        window.mbus_stage_temperature = json["mbus_stage_temperature"];
        window.mbusVoltageString = json["mbusVoltageString"];
        window.running = json["running"];
        window.status = json["status"];
        window.search_result = json["search_result"];
        window.whichFunctionRuns = json["whichFunctionRuns"];
        updateMbusLoopStatus();
        updateSearchStatus();

    } catch (err) {
        console.error("Fetch problem: " + err.message)
    }
}

fetchRoute();

const updateMbusLoopStatus = () => {

    const error_node =  document.getElementById('unit-status-error')
    const current_node =  document.getElementById('unit-status-current')
    const voltage_node =  document.getElementById('unit-status-voltage')
    const percentage_node =  document.getElementById('unit-status-percentage')

    
    error_node.innerHTML = window.error_message;
    current_node.innerHTML = window.mbusCurrentString;
    voltage_node.innerHTML = window.mbusVoltageString;
    percentage_node.innerHTML = window.mbusCurrentPercentUsed;
}

const isSearching = (currentStatus) => {
    const searchStatuses =  [
        "primary_search","auto_create_myconfig",
        "auto_template_generator","secondary_search",
        "node_search","reading_meterlist",
        "add_single_meter","verify_meterlist"
    ]

    return searchStatuses.includes(currentStatus)
}

const updateSearchStatus = () => {

    const status_text = {
        "secondary_search": "Secondary search",
        "primary_search" : "Primary search",
        "auto_create_myconfig" : "Auto-create myconfig",
        "auto_template_generator":"Auto-template generator",
        "add_wireless": "Adding wireless meters",
        "add_wired": "Adding wired meters",
        "node_search":"Node search",
        "verify_meterlist": "Verifying meterlist",
        "reading_meterlist": "Reading meterlist",
        "no_search_running":"No search active",
        "add_single_meter":"Adding single meter",
        "create_main_csv_file":"Creating configuration files",
        "API_upload_meterlist_and_verify":"API upload meterlist",
        "meter_request":"Meter request",
    }
    
    
    document.getElementById('search-status-text').innerText = status_text[window.status]
    
    const searchResultDiv = document.getElementById("statusSubDiv");
    let statUl = document.getElementById("status-search-list");
    const showResult = isSearching(window.status) || isSearching(window.whichFunctionRuns)

    if (window.running) {
        searchResultDiv.hidden = false
        if (showResult) {
            // clear list
            if (statUl.children.length > 2) {
                statUl.replaceChildren([])
            }
            for (let index in window.search_result) {
                let li = document.createElement("li");
                li.style.listStyle = "none";
                li.classList.add('unit-status-text')
                li.innerHTML = window.search_result[index];
                statUl.appendChild(li);
            }
        }
    }else {
        searchResultDiv.hidden = true
        statUl.innerHTML = ""
    }
}


if (localStorage.getItem(AUTO_UPDATE_STATUS) === 'true') {
    startLoop()
}