#!/usr/bin/python
# -*- coding: utf-8 -*-;
#kate: space-indent on; indent-width 4; mixedindent off; indent-mode python

"""
The program will read the meterlist from all nodes and write it to /tmp/meterlist_wireless.txt
If the output file exists, it will be overwritten.
"""
import socket, struct
import sys,time, csv,  os, datetime
from weblib import *
#from operator import itemgetter

def calcBcc(arr):
    bcc=0
    for i in range(len(arr)):
        bcc += arr[i]
    return bcc&0xFF

def MfctToStr(mfct):
    if mfct == 0xFFFF:
        return ""
    strng  = "%c"%(((mfct>>10)&0x1F)+64)
    strng += "%c"%(((mfct>>5)&0x1F)+64)
    strng += "%c"%((mfct&0x1F)+64) # Manufacturer number
    return strng

def wlGetSecondaryAddress(data): # From the wireless telegram
    meter_id = struct.unpack("<I",data[4:8])[0]
    mfct = struct.unpack("<H",data[2:4])[0]
    #meter_id = "%08X"%i_meter_id
    #mfct = "%04X"%i_mfct
    ver = int(data[8])
    med = int(data[9])
    #name = "%c"%(((i_mfct>>10)&0x1F)+64)+"%c"%(((i_mfct>>5)&0x1F)+64)+"%c"%((i_mfct&0x1F)+64)
    #meter_type = "" #DeviceTypes[med] if med in DeviceTypes else "%02X"%med
    return meter_id, mfct, ver, med
#, name, meter_type

def wlGetTimeStamp(data):
    # Timestamp: INT64 to YYYY-MM-DD HH:MM:SS
    t = struct.unpack("Q", data[0:8])[0]
    tmp = datetime.datetime.fromtimestamp(t)
    timestamp = "%04d-%02d-%02d %02d:%02d:%02d"%(tmp.year, tmp.month, tmp.day, tmp.hour, tmp.minute, tmp.second)
    duration=time.time()-t
    return (timestamp,  duration)

def wlParseLineToBytes(line):
    data = b""
    for i in range(int(len(line)/2)): # Iterate over every other characters.
        try: # Try to convert hex string to int.
            temp = int(line[2*i:2*i+2], 16)
            data += struct.pack("B",temp)
        except:
            print("Error: '%s' contains a none hexadecimal number."%(line[2*i:2*i+2]))
    return data

def wlParseTelegram(telegram):
    #0108FD3F58000000003B
    #4644B4091128101505077A54000610EDD653CE9F3D0F1D0E00000000193910011216FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000CAA
    #        Secondary address:      15102811.09B4.05.07 [BMT] [Water]
    primaryAddress = int(telegram[0])
    timestamp, duration = wlGetTimeStamp(telegram[1:9])
    (rssi0, rssi1, rssi2, rssi3, rssi4) = struct.unpack('BBBBB', telegram[9:14])
    if (rssi0  & 0xFC) == 0xFC:
        rssi0 = -300
        #hc0   = "#"
    else:
        #hc0 = rssi0 & 0x03
        rssi0 = -int((rssi0 & 0xFC)/2)
    if (rssi1  & 0xFC) == 0xFC:
        rssi1 = -300
        #hc1   = "#"
    else:
        #hc1 = rssi1 & 0x03
        rssi1 = -int((rssi1 & 0xFC)/2)
    active     = (rssi4 & 0x02) >> 1
    available  = (rssi4 & 0x04) >> 2
    meter_id, manufacturer, version, medium = wlGetSecondaryAddress(telegram[15:])
    myprimaryaddress = int(telegram[14])
    return meter_id, manufacturer, version, medium, primaryAddress, rssi0, rssi1, active, available, timestamp, myprimaryaddress, duration

def printhex(data):
    tstr = ""
    for j in range(len(data)):
        if j%16 == 0 and j != 0:
            tstr += "\n"
        tstr += "%02X "%data[j]
    print(tstr)

#mfct=0x1596
#ver=0xFF
#med=0xFF
class searchWireless:
    def __init__(self, ipaddr,  portno, nodefile,  prjdir):
        self.HOST=ipaddr
        self.PORT = portno
        self.prjdir = prjdir
        self.nodefile = nodefile
        # SOCK_DGRAM is the socket type to use for UDP sockets
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.sock.settimeout(3) # May become a parameter later

    def sendRcv(self, sendm):
        try:
            self.sock.sendto(sendm, (self.HOST, self.PORT))
            time.sleep(.05)
            return self.sock.recv(1024)
        except:
            return b""

    def snd_nke(self,  adr):
        req  = b"\x10\x40"+struct.pack('B',adr)
        req += struct.pack('B',calcBcc(req[1:])) + b"\x16"
        if b"\xE5" == self.sendRcv(req):
            return True
        return False

    def slave_select(self,  sno,mfct,ver,med):
        req  = b"\x68\x0B\x0B\x68\x53\xFD\x52"+struct.pack('<I',sno)
        req += struct.pack('<H',mfct)
        req += struct.pack('B',ver)
        req += struct.pack('B',med)
        req += struct.pack('B',calcBcc(req[4:])) + b"\x16"
        if b"\xE5" == self.sendRcv(req):
            return True
        return False

    def req_ud2(self,  x, adress):
        req  = b"\x10" + struct.pack('B',x) + struct.pack('B',adress)
        req += struct.pack('B',calcBcc(req[1:])) + b"\x16"
        recvm =  self.sendRcv(req)
        l = len(recvm)
        false = (False, b"")
        if l < 6:
            return false
        else:
            lmbus = recvm[1] # The length byte L-byte, recvm[2] is also length byte
            if recvm[0] != 0x68 or recvm[3] != 0x68 or recvm[1] != recvm[2]:
                return false
            if l != lmbus+6: # +6 is the 2 start bytes, the 2 length bytes recvm[1] recvm[2], the checksum and the stopbyte
                return false
            if recvm[l-1] != 0x16: # The stopbyte have to be 16
                return false
            cc = recvm[l-2] # The checksum is the second to last byte
            if cc !=calcBcc(recvm[4:l-2]): # Check if the checksum is correct
                return false
        return (True, recvm)

    def parseCMI5110Node(self, file,  tlgr,  node_sno):
        mlist = []
        for i in range(1,len(tlgr)):
            b=19
            while (int(tlgr[i][b])==0x0d and int(tlgr[i][b+1])==0x7C):
                meter_id = tlgr[i][b+3:b+11]
                age  = struct.unpack("<H",tlgr[i][b+32:b+34])[0]
                status = 10
                if age < 24*60: # If age less than 24 hours, status should be 20
                    status = 20
                #if age == 255: # XXXXXXXXXXXXX Unresponsive meters have age = 255. This must be checked.
                #    age = 65535
                rssi = tlgr[i][b+34]
                if rssi > 0 and rssi < 63:
                    rssi = rssi * 2 - 130
                else:
                    rssi = -130
                saddr = struct.unpack("<IHBB",meter_id)
                file.write("%08X;%04X;%02X;%02X;"%saddr)
                file.write("%s;"%MfctToStr(saddr[1]))
                file.write("%08X;"%node_sno)
                file.write("%d;"%tlgr[i][b+29]) # Primary address
                #file.write("Meter key src = %d\n"%tlgr[i][b+30])
                #file.write("Telegram status = %d\n"%tlgr[i][b+31])
                file.write("%d;R;%d;"%(status, age)) # Age in minutes
                #file.write(";R;%d;"%age) # Age in minutes
                file.write("%d;"%rssi)
                file.write("%s;\n"%((datetime.datetime.now() - datetime.timedelta(minutes=age)).strftime("%Y-%m-%d %H:%M:%S")))
                b += 46
        return mlist

    def parsePI900SNode(self, file,  tlgr,  node_sno):
        for i in range(1,len(tlgr)):
            #printhex(tlgr[i])
            b=19
            #while (struct.unpack("BBB", tlgr[i][b:b+3]) == (0x0D, 0xFD,  0x76)):

            # Every wireless meter objects coming from a Pi-900 wireless node starts with 0D FD 76 10
            # 0D stands for variable length
            # FD primary address 253
            # 76 are used to indicate the variable data structure in long frames (RSP_UD)
            # 10 is the length 16 bytes
            while ( int(tlgr[i][b]) == 0x0D ):
                vlen = int(tlgr[i][b+3])
                printhex(tlgr[i][b:b+vlen+4])
                b += 4
                meter_id = tlgr[i][b:b+8]
                #t = struct.unpack("Q", tlgr[i][b+11:b+19])[0]
                #tmp = datetime.datetime.fromtimestamp(t)
                #timestamp = "%04d-%02d-%02d %02d:%02d:%02d"%(tmp.year, tmp.month, tmp.day, tmp.hour, tmp.minute, tmp.second)
                age  = struct.unpack("<H",tlgr[i][b+9:b+11])[0]
                status = 10
                if age < 24*60: # If age less than 24 hours, status should be 20
                    status = 20
                rssi = tlgr[i][b+11] # Will be changed to MAX value from vector
                rssi = -int((rssi&0xFC)/2)
                saddr = struct.unpack("<IHBB",meter_id)
                file.write("%08X;%04X;%02X;%02X;"%saddr)
                file.write("%s;"%MfctToStr(saddr[1]))
                file.write("%08X;"%node_sno)
                file.write("%d;"%tlgr[i][b+8]) # Primary address,
                #file.write("Meter key src = %d\n"%tlgr[i][b+30])
                #file.write("Telegram status = %d\n"%tlgr[i][b+31])
                file.write("%d;R;%d;"%(status, age)) # Age in minutes
                file.write("%d;"%rssi)
                file.write("%s;\n"%((datetime.datetime.now() - datetime.timedelta(minutes=age)).strftime("%Y-%m-%d %H:%M:%S")))
                b += vlen

    def create_meter_list(self, max_age, debug=False):
        fname=os.path.join(self.prjdir, self.nodefile)

        tmp = []
        try:
            with open(fname) as file:
                delimiter = sniffer_csv(file)
                tmp = list(rcf(file, delimiter))
        except Exception as e:
            print("error in make_node_meterlist: "+str(e))
        #tmp = read_csv_file(fname,'r',10)
        
        node_list = []
        for t in tmp:
            if t[8] == 'N':
                node_list.append(t)
        meter_list = []
        print("Nodelist")
        print(node_list)
        fname="/tmp/meterlist_wireless.txt"
        f=open(fname,'w')
        for node in node_list:
            node_serialno = int(node[0],16)
            mfct = int(node[1],16)
            ver = int(node[2],16)
            med = int(node[3],16)

            tlgr = []
            success = False
            for i in range(3): # Why 3 times?
                if not self.slave_select(node_serialno,mfct,ver,med):
                    continue
                tlgr=[]
                # C-field 7B = 0   1          F        1       1011    5B/7B   Short Frame    Request for Class 2 Data
                #                         DB*     FCB   FCV                 (*Direction bit)
                x=0x7B
                while 1:
                    ret, r = self.req_ud2(x,0xFD) # r is the recieved rsp_ud telegram
                    if not ret: # ret is an bollean telling if the rsp_ud is correct
                        break
                    tlgr.append(r)
                    if int(r[len(r)-3]) == 0x0F: # Check if this is the last telegram from the meter. Is this byte always 0x0F or 0x0F when meter comes from wireless node??
                        success = True
                        break
                    if x & 0x20: # Check if the FCB bit is set when master sends to slave
                        x &= 0xDF # DF is to ignore bit number 5 (DF == 1101 1111). This operation toggles the 7B to 5B, it will toggle to 5B only the FCB bit is set.
                    else:
                        x |= 0x20
                if success:
                    break
            if not success:
                continue
            if mfct == 0x4129:
                self.parsePI900SNode(f,  tlgr,  node_serialno)
            elif mfct == 0x1596:
                self.parseCMI5110Node(f,  tlgr,  node_serialno)
            else:
                print("Error: invalid node, %08X.%04X.%02X.%02X\n"%(node_serialno, mfct, ver, med))
        # Check if /tmp/wireless_telegrams exists and add it to the meterlist.
        if os.path.isfile("/tmp/wireless_telegrams.txt"):
            try:
                mbv=os.popen("/binary/wireless -S")
                fabnum=int(mbv.read().strip(),16)
                mbv.close()
                wlmfile = open("/tmp/wireless_telegrams.txt", 'r')
                #n_active = 0
                #n_available = 0
                #n_active_and_available = 0
                for line in wlmfile:
                    try:
                        byteline = wlParseLineToBytes(line)
                        meter_id, manufacturer, version, medium, primaryAddress, rssi0, rssi1, active, available, timestamp, myprimaryaddress, duration = wlParseTelegram(byteline)
                        age = duration//60
                        status = 10
                        if age < 24*60: # If age less than 24 hours, status should be 20
                            status = 20
                        rssi = max(rssi0,rssi1 )
                        f.write("%08X;%04X;%02X;%02X;"%(meter_id, manufacturer, version, medium))
                        f.write("%s;"%MfctToStr(manufacturer))
                        f.write("%08X;"%fabnum)
                        f.write("%d;"%primaryAddress) # Primary address
                        f.write("%d;R;%d;"%(status, age)) # Age in minutes
                        f.write("%d;%s;\n"%(rssi,timestamp))
                    except:
                        pass
            except:
                pass
        f.close()
        return True

if __name__=="__main__":
    if len(sys.argv) < 4:
        print("Usage: %s <IP-address> <Port number> <node file>"%sys.argv[0])
    ipaddr = sys.argv[1]
    portno = int(sys.argv[2])
    nodefile = sys.argv[3]
    sw = searchWireless(ipaddr, portno, nodefile,"/config")
    sw.create_meter_list(2*24*60)
