import lib.opkg as opkg

class AlreadyInstallingException(Exception):
    pass

class InstallFailedException(Exception):
    pass


# currently using opkg installer
class OPKGInstaller():
    def __init__(self):
        self.current_job = None # program name

    def set_job(self, new_job):
        self.current_job = new_job

    def clear_job(self):
        self.current_job = None
    
    def install_from_repo(self, program_name):

        if self.current_job:
            raise AlreadyInstallingException("installer busy: ", self.current_job)
        try:
            self.set_job("installing " + program_name)
            opkg.install_package(program_name)
            self.clear_job()
            return
        except opkg.OPKGInstallException:
            self.clear_job()
            raise
        except Exception:
            self.clear_job()
            raise
    

    def install_ipk(self,ipk_filepath):
        if self.current_job:
            raise AlreadyInstallingException("installer busy: ", self.current_job)
        
        try:
            self.set_job("installing ipk")
            opkg.install_ipk(ipk_filepath, force_reinstall=True)
            self.clear_job()
        except Exception:
            self.clear_job()
            raise

    """
    def install_bundle(self):
        if self.current_job:
            raise AlreadyInstallingException("installer busy: ", self.current_job)
    
        self.set_job("installing bundle... ")
        try:
            results = opkg.install_bundle()
            self.clear_job()
            return results
        except opkg.OPKGInstallException:
            self.clear_job()
            raise
        except Exception:
            self.clear_job()
            raise
    """
    
    def upgrade(self, program_name):

        if self.current_job:
            raise AlreadyInstallingException("installer busy: ", self.current_job)
        self.set_job("upgrading " + program_name)
        try:
            opkg.upgrade_package(program_name)
            self.clear_job()
            return
        except opkg.OPKGUpgradeException:
            self.clear_job()
            raise
        finally:
            self.clear_job()

    def list_programs(self):
        return opkg.list_packages()
    
    def update(self):
        if self.current_job:
            raise AlreadyInstallingException("installer busy: ", self.current_job)
        
        self.set_job("updating list")
        try:
            opkg.update()
            self.clear_job()
            return
        except opkg.OPKGUpdateException:
            raise
        except opkg.OPKGSignatureException:
            raise
        finally:
            self.clear_job()
