#!/bin/sh

mkdir -p /config/tmp
mkdir -p /binary
mkdir -p /default
mkdir -p /data/wireless
mkdir -p /var/www1
rm -f /var/www1/wireless.py #Fixes a possible problem in earlier installations

INSTDIR="/tmp/install/install_package/"
if [ -f "/data/install/install_package/install_arm.sh" ]
then
  INSTDIR="/data/install/install_package/"
fi

killall wireless
rm -f /tmp/wireless*
rm -f /config/tmp/wireless*
rm -f /var/www1/templates/wireless*
rm -f /var/www1/templates/images/wireless*

chown -R root:root ${INSTDIR}/*
chmod a+x ${INSTDIR}/binary/wireless
chmod a+x ${INSTDIR}/etc/init.d/S97wireless_init
chmod a+x ${INSTDIR}/etc/init.d/S98wireless
chmod a+rw ${INSTDIR}/config/*
cp ${INSTDIR}/sbin/* /sbin
cp ${INSTDIR}/binary/* /binary
cp ${INSTDIR}/config/wireless_default.ini /config/
cp ${INSTDIR}/config/wireless_include_default.csv /config/
cp ${INSTDIR}/config/wireless_exclude_default.csv /config/
cp ${INSTDIR}/config/wireless_default.ini /default/
cp ${INSTDIR}/config/wireless_include_default.csv /default/
cp ${INSTDIR}/config/wireless_exclude_default.csv /default/
cp -a ${INSTDIR}/etc  /
cp -a ${INSTDIR}/var/www1/* /var/www1/
#cp -a ${INSTDIR}/var/www/* /var/www/
#cp -a var/spool /var/
if [ ! -f /config/wireless_include_T1C.csv ]
then
  cp ${INSTDIR}/config/wireless_include_default.csv /config/wireless_include_T1C.csv
fi
if [ ! -f /config/wireless_exclude_T1C.csv ]
then
  cp ${INSTDIR}/config/wireless_exclude_default.csv /config/wireless_exclude_T1C.csv
fi

sync
/etc/init.d/S97wireless_init restart
/etc/init.d/S98wireless restart

