from flask import Blueprint, render_template, send_file
#from flask import Flask, render_template, request, send_file, render_template_string, after_this_request, make_response,jsonify
import sys

sys.path.append("..")
from weblib import *
import subprocess
import shutil

han2mbus_blueprint = Blueprint('han2mbus', __name__, url_prefix='/', template_folder='templates')

@han2mbus_blueprint.route("/han2mbus_config")
def han2mbus():
    sPortDict={'UDP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
           'TCP':{'ETHERNET1':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'ETHERNET2':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'ALL':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')]},
           'SER':{'RS232':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'RS485':[('MBUS','M-Bus'),('MBUSASCII','M-Bus Ascii'),('MODBUSRTU','Modbus RTU'),('MODBUSTCP','Modbus TCP')],
                  'MBSLAVE1':[('MBUS','M-Bus')],'MBSLAVE2':[('MBUS','M-Bus')]}}
    typeDict={'UDP':'UDP','TCP':'TCP','SER':'Serial'}
    portDict={'ALL':'ALL','ETHERNET1':'ETHERNET1','ETHERNET2':'ETHERNET2','RS485':'RS-485','RS232':'RS-232','MBSLAVE1':'M-Bus Slave 1','MBSLAVE2':'M-Bus Slave 2','MBMASTER':'M-Bus Master'}

    cnf=Configs("config","han2mbus")
    hanversion=""
    hanLicense=0
    try:
        mbv=os.popen("/binary/han2mbus -v")
        hanversion=mbv.read()
        mbv.close()
    except:
        pass
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        protocols=licensearray[2].split(',')
        hanLicense = protocols[6].strip()

        if hanLicense == "Han2MBus":
            hanLicense = 1
        else:
            hanLicense = 0
    except:
        pass
    meterTypeList=['Aidon','Kaifa','Kamstrup']
    info = {
        'typeDict' : typeDict, 
        'sPortDict' : sPortDict, 
        'portDict' : portDict, 
        'baudRateList' : baudRateList,
        'bitList' : bitList,
        'parityList' : parityList,
        'stopBitList' : stopBitList,
        'meterTypeList' : meterTypeList,
        'yesno' : yesno,
        'hanversion' : hanversion,
        'hanLicense'      : hanLicense,
        'H1metertype'     : cnf.getopt('HanPort1','metertype'),
        'H1enable'        : cnf.getopt('HanPort1','enable'),
        'H1timeout'       : cnf.getopt('HanPort1','timeout'),
        'H1porttype'      : cnf.getopt('HanPort1','porttype'),
        'H1hanlocalip'    : cnf.getopt('HanPort1','localip'),
        'H1hanlocalport'  : cnf.getopt('HanPort1','localport'),
        'H1mbuslocalip'   : cnf.getopt('HanPort1','localip'),
        'H1mbuslocalport' : cnf.getopt('HanPort1','localport'),
        'H1sercomport'    : cnf.getopt('HanPort1','sercomport'),
        'H1serbaudrate'   : cnf.getopt('HanPort1','serbaudrate'),
        'H1serbits'       : cnf.getopt('HanPort1','serbits'),
        'H1serparity'     : cnf.getopt('HanPort1','serparity'),
        'H1serstopbit'    : cnf.getopt('HanPort1','serstopbit'),
        'H1mbusprimaddr' : cnf.getopt('HanPort1','mbusprimaddr'),
        'H1mbusid' : cnf.getopt('HanPort1',  'mbusid'), 
        'H2metertype'     : cnf.getopt('HanPort2','metertype'),
        'H2enable'        : cnf.getopt('HanPort2','enable'),
        'H2timeout'       : cnf.getopt('HanPort2','timeout'),
        'H2porttype'      : cnf.getopt('HanPort2','porttype'),
        'H2hanlocalip'    : cnf.getopt('HanPort2','localip'),
        'H2hanlocalport'  : cnf.getopt('HanPort2','localport'),
        'H2mbuslocalip'   : cnf.getopt('HanPort2','localip'),
        'H2mbuslocalport' : cnf.getopt('HanPort2','localport'),
        'H2sercomport'    : cnf.getopt('HanPort2','sercomport'),
        'H2serbaudrate'   : cnf.getopt('HanPort2','serbaudrate'),
        'H2serbits'       : cnf.getopt('HanPort2','serbits'),
        'H2serparity'     : cnf.getopt('HanPort2','serparity'),
        'H2serstopbit'    : cnf.getopt('HanPort2','serstopbit'),
        'H2mbusprimaddr' : cnf.getopt('HanPort2','mbusprimaddr'), 
        'H2mbusid' : cnf.getopt('HanPort2',  'mbusid'),
        'MBporttype'     : cnf.getopt('MBusPort','porttype'), 
        'MBtimeout'     : cnf.getopt('MBusPort','timeout'), 
        'MBserver'     : cnf.getopt('MBusPort','server'), 
        'MBlocalip'     : cnf.getopt('MBusPort','localip'), 
        'MBlocalport'     : cnf.getopt('MBusPort','localport'), 
        'MBremoteip'     : cnf.getopt('MBusPort','remoteip'), 
        'MBremoteport'     : cnf.getopt('MBusPort','remoteport'), 
        'MBsercomport'     : cnf.getopt('MBusPort','sercomport'), 
        'MBserbaudrate'     : cnf.getopt('MBusPort','serbaudrate'), 
        'MBserbits'     : cnf.getopt('MBusPort','serbits'), 
        'MBserparity'     : cnf.getopt('MBusPort','serparity'), 
        'MBserstopbit'     : cnf.getopt('MBusPort','serstopbit')
    }
    return render_template('han2mbus.html', **info)

@han2mbus_blueprint.route("/han2mbus_results")
def han2mbus_results():
    def printData(data):
        tstr = ""
        for j in range(len(data)):
            if j&0x0f == 0 and j != 0:
                tstr += '\n'
            tstr += "%02X "%data[j]
        print(tstr)

    def getValues(module):
        meterlist=[]
        if os.path.isfile("/tmp/"+module):
            with open("/tmp/"+module,'r') as file:
                for l in file.readlines():
                    meterlist.append(l.split(';'))
        return meterlist

    cnf=Configs("config","han2mbus")
    context = { 
        'title': 'List of Wireless Meters',
        'header': ["Description", "Value", "Unit","Obis Code"],
        'H1metertype':cnf.getopt('HanPort1','metertype'),
        'H2metertype':cnf.getopt('HanPort2','metertype'),
        'meter1list1': getValues("hanmodule11"),
        'meter1list2': getValues("hanmodule12"),
        'meter1list3': getValues("hanmodule13"),
        'meter2list1': getValues("hanmodule21"),
        'meter2list2': getValues("hanmodule22"),
        'meter2list3': getValues("hanmodule23")
    }
    return render_template('han2mbus_results.html', **context)


@han2mbus_blueprint.route("/han2mbus_setconf",  methods=['GET',  'POST'])
def han2mbusSetConf():
    cnf=Configs("config","han2mbus")

    cnf.write_section('HanPort1','H1')
    cnf.write_section('HanPort2','H2')
    cnf.write_section('MBusPort')
    cnf.save_config()

    for f in glob.glob("/tmp/hanmodule??"):
        os.remove(f)
    subprocess.call(["/%s/etc/init.d/S98han2mbus"%PROOT,"restart"])

    time.sleep(1)

    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/han2mbus_config\">
        </HEAD>
    </HTML>""")

@han2mbus_blueprint.route("/han2mbus_addmeters",  methods=['GET',  'POST'])
def han2mbusAddMeters():
    cnf=Configs("config","han2mbus")
    H1enable       = cnf.getopt('HanPort1','enable')
    H1mbusprimaddr = cnf.getopt('HanPort1','mbusprimaddr')
    H1mbusid       = cnf.getopt('HanPort1','mbusid') 
    H2enable       = cnf.getopt('HanPort2','enable')
    H2mbusprimaddr = cnf.getopt('HanPort2','mbusprimaddr')
    H2mbusid       = cnf.getopt('HanPort2','mbusid')
    hanmeters = []
    if H1enable == 'YES':
        m = [H1mbusid,"4129","01","38","PII",'',H1mbusprimaddr,"Ver","H"]
        hanmeters.append(m)
    if H2enable == 'YES':
        m = [H2mbusid,"4129","01","38","PII",'',H2mbusprimaddr,"Ver","H"]
        hanmeters.append(m)
    if len(hanmeters) > 0:
        mlist = read_csv_file("/config/meterlist.csv",'r',  9)
        rmlist=[]
        for m in mlist:
            if m[1:4] == ["4129","01","38"]:
                rmlist.append(m)
        for r in rmlist:
            mlist.remove(r)
        mlist += hanmeters
        mlf = open("/config/meterlist.csv",'w', newline='')
        mlwriter = csv.writer(mlf, delimiter=',', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
        for meter in mlist:
            mlwriter.writerow(meter)
        mlf.close()    
    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/han2mbus_config\">
        </HEAD>
    </HTML>""")


@han2mbus_blueprint.route("/han2mbus_manual")
def han2mbus_manual():
    return render_template('han2mbus_manual.html')

@han2mbus_blueprint.route("/han2mbus_log", methods=['GET', 'POST'])
def han2mbus_log():
    fname = "/tmp/han2mbus"
    filename = fname+"_log.txt"
    if request.args.get("start"):
        if not os.path.exists(fname+".log"):
            with open("%s.log"%fname,'w') as f:
                f.write("")
            os.chmod("%s.log"%fname, 0o666)
            time.sleep(2)
        shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("clear"):
        f=open("%s.log"%fname,'w+')
        f.close()
        f=open("%s_log.txt"%fname,'w+')
        f.close()
        os.chmod("%s.log"%fname, 0o666)
        os.chmod("%s_log.txt"%fname, 0o666)
    elif request.args.get("show"):
        if os.path.exists("%s.log"%fname):
            shutil.copyfile("%s.log"%fname, "%s_log.txt"%fname)
            os.chmod("%s.log"%fname, 0o666)
    elif request.args.get("startup"):
        filename = fname+"_startup.log"

    logstring=""
    try:
        f=open(filename,'r')
        logstring=f.read()
        logstring.replace('\n','<br />')
        logstring = "\n"+logstring
        f.close()
    except:
        pass
    context = {'logstring': logstring}
    return render_template('han2mbus_log.html', **context)

@han2mbus_blueprint.route("/han2mbus_download_log", methods=['GET', 'POST'])
def han2mbus_download_log():
    try:
        return send_file('/tmp/han2mbus_log.txt', attachment_filename="han2mbus_log.txt", mimetype='application/octet-stream', as_attachment=True,  cache_timeout=0)
    except:
        return 'File not found'
    
