
import sys, os
import tempfile
import shlex
from flask import send_file
sys.path.append("..")
import weblib
from werkzeug.utils import secure_filename
import subprocess
import shutil
import configparser
from flask import Blueprint, request, render_template, render_template_string
from werkzeug.utils import secure_filename
import glob
quickpost_blueprint = Blueprint('quickpost', __name__, url_prefix='/', template_folder='templates')

@quickpost_blueprint.route("/quickpost_config",  methods=['GET',  'POST'])
def quickpost_config():
    cnf=weblib.Configs("config","quickpost")

    filename = cnf.getopt('Main','FILENAME')
    remote_port = cnf.getopt('Main','REMOTE_PORT')
    mbus_ascii_server_ip = cnf.getopt('Main','MBUS_ASCII_SERVER_IP')
    mbus_ascii_server_port = cnf.getopt('Main','MBUS_ASCII_SERVER_PORT')
    read_timeout = cnf.getopt('Main','READ_TIMEOUT')
    n_bad_reads = cnf.getopt('Main','N_BAD_READS')
    csvfile = cnf.getopt('Main','CSVFILE')
    upload_method = cnf.getopt('Main','UPLOAD_METHOD')
    upload_time = cnf.getopt('Main','UPLOAD_TIME')
    upload_period = cnf.getopt('Main','UPLOAD_PERIOD')
    read_period = cnf.getopt('Main','READ_PERIOD')
    read_offset = cnf.getopt('Main','READ_OFFSET')
    username = cnf.getopt('Main','USERNAME')
    password = cnf.getopt('Main','PASSWORD')
    file_keep_days = cnf.getopt('Main','FILE_KEEP_DAYS')
    file_format = cnf.getopt('Main','FILE_FORMAT')
    sftp_use_private_key = cnf.getopt('Main','SFTP_USE_PRIVATE_KEY')
    sftp_private_key = cnf.getopt('Main','SFTP_PRIVATE_KEY')
    use_ssl_cert = cnf.getopt('Main','USE_SSL_CERT')
    certificate = cnf.getopt('Main','CERTIFICATE')
    enable = cnf.getopt('Main','ENABLE')
    startup_read_and_upload = cnf.getopt('Main','STARTUP_READ_AND_UPLOAD')

    selectChoice = "ADVANCED"
    if read_offset == "0" and upload_time == "00:30" and read_period == upload_period:
        if read_period == "1440":
            selectChoice = "24h"
        elif read_period == "720":
            selectChoice = "12h"
        elif read_period == "360":
            selectChoice = "6h"
        elif read_period == "60":
            selectChoice = "1h"
        elif read_period == "15":
            selectChoice = "15min"

    mbusasciiSelector = "BASIC"
    if mbus_ascii_server_ip != "127.0.0.1":
        mbusasciiSelector = "ADVANCED"
    elif mbus_ascii_server_port != "9002":
        mbusasciiSelector = "ADVANCED"
    elif read_timeout != "20":
        mbusasciiSelector = "ADVANCED"
    elif n_bad_reads != "3":
        mbusasciiSelector = "ADVANCED"

    csvArray=glob.glob("/config/*.[cC][sS][vV]")
    for i in range(len(csvArray)):
        csvArray[i] = os.path.basename(csvArray[i])#[8:] #Error when doing strip("/config/")

    qpversion=""
    try:
        mbv=os.popen("/binary/quickpost.elf -v")
        qpversion=mbv.read()
        mbv.close()
    except Exception as e:
        print("error1:"+str(e))

    qpLicense=""
    tagLicense=-1
    try:
        mbl=os.popen("/binary/mbushub.elf -l")
        licensearray=mbl.readline().strip('\n').split(';')
        mbl.close()
        protocols=licensearray[2].split(',')
        qpLicense=protocols[12]

    except Exception as e:
        print("error2:"+str(e))

    numberOfTags=0
    csvFile = ""
    try:
        csvFile = cnf.getopt('Main',  'CSVFILE')
        print(csvFile)
        filePath="/config/%s"%csvFile
        with open(filePath) as cf:
            for line in cf:
                if line.startswith("[Tag]"):
                    numberOfTags+=1
    except Exception as e:
        print("error3:"+str(e))

    remote_ip   = cnf.getopt('Main','REMOTE_IP')
    remote_path = cnf.getopt('Main','REMOTE_PATH')
    try: # This is needed to use the obsolete parameter remote_url
        remote_url = cnf.getopt('Main','REMOTE_URL')
        r=remote_url.split('/')
        if len(r) > 2:
            remote_ip = r[2]
            remote_path = ""
        if len(r) > 3:
            remote_path = '/'.join(r[3:])
    except:
        pass

    sshKeyArray=glob.glob('/config/ssh/*.ppk')
    for i in range(len(sshKeyArray)):
        sshKeyArray[i] = os.path.basename(sshKeyArray[i])

    crtfArray=glob.glob("/config/ca-certificates/*.[cC][rR][tT]")
    for i in range(len(crtfArray)):
        crtfArray[i] = os.path.basename(crtfArray[i])

    info = {
        'mbusasciiSelector' : mbusasciiSelector,
        'selectChoice' : selectChoice,
        'tagLicense' : tagLicense,
        'numberOfTags' : numberOfTags,
        'qpLicense': qpLicense,
        'csvArray' : csvArray,
        'qpversion' : qpversion,
        'filename'       : filename,
        'remote_ip'      : remote_ip,
        'remote_path'    : remote_path,
        'remote_port'    : remote_port,
        'mbus_ascii_server_ip' : mbus_ascii_server_ip,
        'mbus_ascii_server_port' : mbus_ascii_server_port,
        'read_timeout'   : read_timeout,
        'n_bad_reads'    : n_bad_reads,
        'csvfile'        : csvfile,
        'upload_method'  : upload_method,
        'upload_time'    : upload_time,
        'upload_period'  : upload_period,
        'read_period'    : read_period,
        'read_offset'    : read_offset,
        'username'       : username,
        'password'       : password,
        'file_keep_days' : file_keep_days,
        'file_format'    : file_format,
        'sftp_use_private_key' : sftp_use_private_key,
        'sftp_private_key'     : sftp_private_key,
        'sshKeyArray'    : sshKeyArray,
        'crtfArray'      : crtfArray,
        'use_ssl_cert'   : use_ssl_cert,
        'certificate'    : certificate,
        'enable'         : enable,
        'startup_read_and_upload' : startup_read_and_upload
    }
    return render_template('quickpost_config.html', **info)


@quickpost_blueprint.route("/quickpost_show")
def quickpost_show():
    fname = secure_filename(request.args.get("filename")).replace("tmp_","tmp/")
    fn = os.path.join("/data/quickpost",fname)
    if os.path.isfile(fn):
        f = open(fn,'r',encoding="ISO-8859-1")
        file_read = f.read()
        f.close()
        a=file_read.split('\n')
        b=[]
        for i in a:
            j=i.split(';')
            if len(j) > 0:
                b.append(j)
        context = {
            'resultf': b,
            'fname': fname,
        }
        return render_template("quickpost_show.html",  **context)
    else:
        return quickpost_listfiles()
        

@quickpost_blueprint.route("/quickpost_download")
def quickpost_Download():
    fname = secure_filename(request.args.get("filename")).replace("tmp_","tmp/")
    fn = os.path.join('/data/quickpost',fname)
    if os.path.isfile(fn):
        return send_file(fn, attachment_filename=fname, mimetype='application/octet-stream', as_attachment=True)
    else:
        return quickpost_listfiles()
        
@quickpost_blueprint.route("/quickpost_restart", methods=['POST', 'GET'])
def quickpost_restart():
    subprocess.call(["%s/etc/init.d/S95quickpost"%weblib.PROOT,"restart"])
    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_config\">
        </HEAD>
    </HTML>""")


@quickpost_blueprint.route("/quickpost_log")
def quickpost_log():
    it = iter([['QuickPost logfile empty', '', '']])
    try:
        with open("/data/quickpost/quickpost_log.txt", 'r') as log:
            it = (line.strip('\n').split(';') for line in log)
            it = filter(lambda x: len(x) == 3, it)
            it = reversed(list(it))
    except:
        print("quickpost_log.txt not found.")
    return render_template('quickpost_log.html', log_table=it)

@quickpost_blueprint.route("/quickpost_listfiles")
def quickpost_listfiles():
    filedir = "/data/quickpost/"
    flist1=[]
    try:
        flist1=sorted(os.listdir(filedir+"tmp/"),reverse=True)
    except:
        pass
    flist2=[]
    try:
        for fname in sorted(os.listdir(filedir)):
            if fname != "tmp" and fname[:13] != "quickpost_log":
                flist2.append(fname)
    except:
        pass
    context = {'filelist1': flist1, 'filelist2': flist2}
    return render_template('quickpost_listfiles.html', **context)

@quickpost_blueprint.route("/quickpost_setconf", methods=['POST',  'GET'])
def quickpost_setconf():

    filename = request.form.get('filename',default='my_filename')
    filename = secure_filename(filename)
    
    cnf=weblib.Configs("config","quickpost")
    cnf.write_section('Main')
    cnf.conf['Main']['FILENAME'] = filename
    cnf.save_config()

    subprocess.call(["%s/etc/init.d/S95quickpost"%weblib.PROOT,"restart"])

    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_config\">
        </HEAD>
    </HTML>""")

@quickpost_blueprint.route("/quickpost_security")
def quickpost_Security():
    cnf=weblib.Configs("config","quickpost")
    upload_method = cnf.getopt('Main','UPLOAD_METHOD')
    remote_port = cnf.getopt('Main','REMOTE_PORT')
    if upload_method != "SFTP":
        remote_port = "22" # If configured as ftp, remoteport = 21
    sshKeyArray=glob.glob("/config/ssh/*")
    for i in range(len(sshKeyArray)):
        sshKeyArray[i] = os.path.basename(sshKeyArray[i])

    statusstr="No host configured"
    hostname=""
    fingerprint=""
    if os.path.isfile("/config/ssh/known_hosts"):
        f = open("/config/ssh/known_hosts",'r')
        lines = f.readlines()
        f.close()
        for l in lines:
            ls = l.split(';')
            if ls[0] == '#comment':
                hostname = ls[1]
                statusstr = ls[2]
    info = {
        'sshKeyArray': sshKeyArray,
        'hostname': hostname,
        'port': remote_port,
        'statusstr' : statusstr
    }
    return render_template('/quickpost_security.html',  **info)


@quickpost_blueprint.route("/quickpost_verifyfingerprints",  methods=['POST'])
def quickpost_VerifySshFingerprints():
    host = request.form["server_ip"]
    fingerprint = request.form["server_fingerprint"]
    port_ip = request.form.get('port_ip',default='22')
    if len(port_ip) == 0:
        port_ip = '22'
    fingerprinttype=""
    if len(fingerprint) > 0:
        if fingerprint.split(':')[0] == 'SHA256':
            fingerprinttype = 'sha256'
        else:
            fingerprint = 'MD5:' + fingerprint
            fingerprinttype = 'md5'

    
    #cmd = "ping -c 1 " + host
    #args = shlex.split(cmd)
    #rep = 0 # subprocess.call(args) Some hosts don't respond to ping but to sftp
    filename = "/config/ssh/known_hosts"
    fd, path = tempfile.mkstemp()
    out = ""
    retval = 0
    
    with open(path, 'w') as tmp:
        try:
            # FIXME SECURITY check sanity of host address
            out = subprocess.check_output(['ssh-keyscan','-p',port_ip,'-H',host],stderr=None).decode("utf-8")
            rsa_lines = []
            lines = []
            # we are placing rsa in the bottom to avoid a bug from azure ssh
            # read issue #159
            for line in out.splitlines():
                
                if 'ssh-rsa' in line:
                    rsa_lines.append(line + "\n") 
                else:
                    lines.append(line + "\n")
            lines.extend(rsa_lines)
            tmp.writelines(lines)
            tmp.close()
            out = ""
            for line in lines:
                out += line
    
        except Exception as e:
            retval = 1
            with open(filename,'w') as f:
                f.write("#comment;%s;Error: Unable to connect to host\n"%host)
            print("check output failed when verifying fingerpints ", str(e))
    if retval == 0 and out != '':
        if fingerprint != '':
            #print("%s"%fingerprint)
            out1 = ""
            if fingerprinttype == 'md5':
                #print("Server fingerprint:")
                out1 = subprocess.check_output(["ssh-keygen", "-l", "-E","md5", "-f","%s"%path],stderr=None).decode("utf-8")
                #print(out)
            elif fingerprinttype == 'sha256':
                #print("Server fingerprint:")
                out1 = subprocess.check_output(["ssh-keygen", "-l", "-E","sha256", "-f","%s"%path],stderr=None).decode("utf-8")
                #print(out)
            else:
                pass
                #print("No fingerprint to show")
            if out1 != "":
                correct=False
                sps = out1.split("\n")
                for s in sps:
                    if len(s.split(" ")) > 1:
                        server_fingerprint=s.split(" ")[1]
                        print("Server fingerprint = %s"%server_fingerprint)
                        if fingerprint == server_fingerprint:
                            #print("Server verified.")
                            with open(filename,'w') as f:
                                f.write("#comment;%s;Host Key OK, Verified\n"%host)
                                f.write(out)
                            correct = True
                            break
                if not correct:
                    #print("Server verification failed")
                    with open(filename,'w') as f:
                        f.write("#comment;%s;Host Key Not added, Verification Failed\n"%host)
        else:
            print("Host key added but not verified.")
            print(out)
            with open(filename,'w') as f:
                f.write("#comment;%s;Host Key OK, Warning! Unverified\n"%host)
                f.write(out)
    else:
        with open(filename,'w') as f:
            f.write("#comment;%s;No Host Key received nor added\n"%host)
            f.write(out)
    try:
        shutil.rmtree(path)
    except Exception as e:
        print("rmtree failed ", str(e))
    return render_template_string("""<HTML>
        <HEAD>
            Writing conf file
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
        </HEAD>
    </HTML>""")

@quickpost_blueprint.route("/quickpost_uploadsshkey", methods=['GET','POST'])
def quickpost_UploadSshKey():
    fil = request.files['uploadkeyfile']
    if fil:
        filename = secure_filename(fil.filename)
        fil.save(os.path.join("/config/ssh/", filename))
    return render_template_string("""<HTML><HEAD>
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
            </HEAD></HTML>""")

@quickpost_blueprint.route("/quickpost_generatesshkey", methods=['GET','POST'])
def quickpost_generatesshkey(): # Must be longer than 5 chars XXXXX Add error
    weblib.removefile("/config/ssh/mykey.ppk")
    weblib.removefile("/config/ssh/mykey.pub")
    passwd = request.form['ssh_key_passwd']
    if len('passwd') > 0:
        subprocess.call(["ssh-keygen","-N",passwd,"-t","ecdsa","-f","/config/ssh/mykey"])
    else:
        subprocess.call(["ssh-keygen","-t","ecdsa","-f","/config/ssh/mykey"])
    os.rename('/config/ssh/mykey','/config/ssh/mykey.ppk')
    return render_template_string("""<HTML><HEAD>
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
            </HEAD></HTML>""")

@quickpost_blueprint.route("/quickpost_removesshkey", methods=['GET','POST'])
def quickpost_RemoveSshKey():
    tmp = request.form['ssh_key_file']
    fname = secure_filename(os.path.basename(tmp))
    weblib.removefile("/config/ssh/%s"%fname)
    return render_template_string("""\n<HTML><HEAD>
    <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
    </HEAD></HTML>""")

@quickpost_blueprint.route("/quickpost_uploadcrt", methods=['GET','POST'])
def quickpost_UploadCrt():
    fil = request.files['certfile']
    if fil:
        filename = secure_filename(fil.filename)
        fil.save(os.path.join("/config/ca-certificates", filename))
    return render_template_string("""<HTML><HEAD>
            <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
            </HEAD></HTML>""")

@quickpost_blueprint.route("/quickpost_download_pubkey", methods=['GET','POST'])
def quickpost_download_pubkey():
    try:
        return send_file('/config/ssh/mykey.pub', attachment_filename='mykey.pub', mimetype='application/octet-stream', as_attachment=True,  cache_timeout=0)
    except:
        return 'File not found'
    return render_template_string("""\n<HTML><HEAD>
    <meta http-equiv=\"refresh\" content=\"0;url=/quickpost_security\">
    </HEAD></HTML>""")


@quickpost_blueprint.route("/quickpost_manual")
def quickpost_manual():
    return render_template('quickpost_manual.html')
