#!/bin/sh

mkdir -p /data/quickpost/tmp
mkdir -p /config/ssh
mkdir -p /config/ssl
mkdir -p /config/ca-certificates
mkdir -p /binary
mkdir -p /default
mkdir -p /var/www1
rm -f /var/www1/quickpost.py

INSTDIR="/tmp/install/install_package/"
if [ -f "/data/install/install_package/install_arm.sh" ]
then
  INSTDIR="/data/install/install_package/"
fi

chown -R root:root ${INSTDIR}/*

chmod a+x ${INSTDIR}/binary/quickpost.elf
chmod a+x ${INSTDIR}/etc/init.d/S95quickpost
chmod a+rw ${INSTDIR}/config/*

cp ${INSTDIR}/binary/quickpost.elf /binary
cp ${INSTDIR}/binary/quickpost_version.txt /binary
cp ${INSTDIR}/config/quickpost_default.ini /config
cp ${INSTDIR}/config/quickpost_default.ini /default
cp ${INSTDIR}/config/*.csv /config/
cp -a ${INSTDIR}/etc  /
cp -a ${INSTDIR}/var/www1/*  /var/www1/
chown -R root:root ${INSTDIR}/data

touch /data/quickpost/quickpost_log.txt

rm -f /install_arm.sh

sync
